/*     */ package org.apache.xml.resolver.apps;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Date;
/*     */ import java.util.Vector;
/*     */ import org.apache.xml.resolver.Catalog;
/*     */ import org.apache.xml.resolver.CatalogManager;
/*     */ import org.apache.xml.resolver.helpers.Debug;
/*     */ import org.apache.xml.resolver.tools.ResolvingParser;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class xparse
/*     */ {
/*  80 */   private static Debug debug = CatalogManager.getStaticManager().debug;
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/*  86 */     String xmlfile = null;
/*  87 */     int debuglevel = 0;
/*  88 */     int maxErrs = 10;
/*  89 */     boolean nsAware = true;
/*  90 */     boolean validating = true;
/*  91 */     boolean showWarnings = debuglevel > 2;
/*  92 */     boolean showErrors = true;
/*  93 */     Vector catalogFiles = new Vector();
/*     */ 
/*  95 */     for (int i = 0; i < args.length; i++) {
/*  96 */       if (args[i].equals("-c")) {
/*  97 */         i++;
/*  98 */         catalogFiles.add(args[i]);
/*     */       }
/* 102 */       else if (args[i].equals("-w")) {
/* 103 */         validating = false;
/*     */       }
/* 107 */       else if (args[i].equals("-v")) {
/* 108 */         validating = true;
/*     */       }
/* 112 */       else if (args[i].equals("-n")) {
/* 113 */         nsAware = false;
/*     */       }
/* 117 */       else if (args[i].equals("-N")) {
/* 118 */         nsAware = true;
/*     */       }
/* 122 */       else if (args[i].equals("-d")) {
/* 123 */         i++;
/* 124 */         String debugstr = args[i];
/*     */         try {
/* 126 */           debuglevel = Integer.parseInt(debugstr);
/* 127 */           if (debuglevel >= 0) {
/* 128 */             debug.setDebug(debuglevel);
/* 129 */             showWarnings = debuglevel > 2;
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */ 
/*     */       }
/* 137 */       else if (args[i].equals("-E")) {
/* 138 */         i++;
/* 139 */         String errstr = args[i];
/*     */         try {
/* 141 */           int errs = Integer.parseInt(errstr);
/* 142 */           if (errs >= 0)
/* 143 */             maxErrs = errs;
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 151 */         xmlfile = args[i];
/*     */       }
/*     */     }
/* 154 */     if (xmlfile == null) {
/* 155 */       System.out.println("Usage: org.apache.xml.resolver.apps.xparse [opts] xmlfile");
/* 156 */       System.exit(1);
/*     */     }
/*     */ 
/* 159 */     ResolvingParser.validating = validating;
/* 160 */     ResolvingParser.namespaceAware = nsAware;
/* 161 */     ResolvingParser reader = new ResolvingParser();
/* 162 */     Catalog catalog = reader.getCatalog();
/*     */ 
/* 164 */     for (int count = 0; count < catalogFiles.size(); count++) {
/* 165 */       String file = (String)catalogFiles.elementAt(count);
/* 166 */       catalog.parseCatalog(file);
/*     */     }
/*     */ 
/* 169 */     XParseError xpe = new XParseError(showErrors, showWarnings);
/* 170 */     xpe.setMaxMessages(maxErrs);
/* 171 */     reader.setErrorHandler(xpe);
/*     */ 
/* 173 */     String parseType = validating ? "validating" : "well-formed";
/* 174 */     String nsType = nsAware ? "namespace-aware" : "namespace-ignorant";
/* 175 */     if (maxErrs > 0) {
/* 176 */       System.out.println("Attempting " + parseType + ", " + nsType + " parse");
/*     */     }
/*     */ 
/* 183 */     Date startTime = new Date();
/*     */     try
/*     */     {
/* 186 */       reader.parse(xmlfile);
/*     */     } catch (SAXException sx) {
/* 188 */       System.out.println("SAX Exception: " + sx);
/*     */     } catch (Exception e) {
/* 190 */       e.printStackTrace();
/*     */     }
/*     */ 
/* 193 */     Date endTime = new Date();
/*     */ 
/* 195 */     long millisec = endTime.getTime() - startTime.getTime();
/* 196 */     long secs = 0L;
/* 197 */     long mins = 0L;
/* 198 */     long hours = 0L;
/*     */ 
/* 200 */     if (millisec > 1000L) {
/* 201 */       secs = millisec / 1000L;
/* 202 */       millisec %= 1000L;
/*     */     }
/*     */ 
/* 205 */     if (secs > 60L) {
/* 206 */       mins = secs / 60L;
/* 207 */       secs %= 60L;
/*     */     }
/*     */ 
/* 210 */     if (mins > 60L) {
/* 211 */       hours = mins / 60L;
/* 212 */       mins %= 60L;
/*     */     }
/*     */ 
/* 215 */     if (maxErrs > 0) {
/* 216 */       System.out.print("Parse ");
/* 217 */       if (xpe.getFatalCount() > 0) {
/* 218 */         System.out.print("failed ");
/*     */       } else {
/* 220 */         System.out.print("succeeded ");
/* 221 */         System.out.print("(");
/* 222 */         if (hours > 0L) {
/* 223 */           System.out.print(hours + ":");
/*     */         }
/* 225 */         if ((hours > 0L) || (mins > 0L)) {
/* 226 */           System.out.print(mins + ":");
/*     */         }
/* 228 */         System.out.print(secs + "." + millisec);
/* 229 */         System.out.print(") ");
/*     */       }
/* 231 */       System.out.print("with ");
/*     */ 
/* 233 */       int errCount = xpe.getErrorCount();
/* 234 */       int warnCount = xpe.getWarningCount();
/*     */ 
/* 236 */       if (errCount > 0) {
/* 237 */         System.out.print(errCount + " error");
/* 238 */         System.out.print(errCount > 1 ? "s" : "");
/* 239 */         System.out.print(" and ");
/*     */       } else {
/* 241 */         System.out.print("no errors and ");
/*     */       }
/*     */ 
/* 244 */       if (warnCount > 0) {
/* 245 */         System.out.print(warnCount + " warning");
/* 246 */         System.out.print(warnCount > 1 ? "s" : "");
/* 247 */         System.out.print(".");
/*     */       } else {
/* 249 */         System.out.print("no warnings.");
/*     */       }
/*     */ 
/* 252 */       System.out.println("");
/*     */     }
/*     */ 
/* 255 */     if (xpe.getErrorCount() > 0)
/* 256 */       System.exit(1);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.apps.xparse
 * JD-Core Version:    0.6.0
 */