/*      */ package org.apache.xml.resolver;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.FileNotFoundException;
/*      */ import java.io.FilterInputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.PrintStream;
/*      */ import java.io.UnsupportedEncodingException;
/*      */ import java.net.MalformedURLException;
/*      */ import java.net.URL;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Vector;
/*      */ import javax.xml.parsers.SAXParserFactory;
/*      */ import org.apache.xml.resolver.helpers.Debug;
/*      */ import org.apache.xml.resolver.helpers.FileURL;
/*      */ import org.apache.xml.resolver.helpers.PublicId;
/*      */ import org.apache.xml.resolver.readers.CatalogReader;
/*      */ import org.apache.xml.resolver.readers.SAXCatalogReader;
/*      */ import org.apache.xml.resolver.readers.TR9401CatalogReader;
/*      */ 
/*      */ public class Catalog
/*      */ {
/*  195 */   public static final int BASE = CatalogEntry.addEntryType("BASE", 1);
/*      */ 
/*  198 */   public static final int CATALOG = CatalogEntry.addEntryType("CATALOG", 1);
/*      */ 
/*  201 */   public static final int DOCUMENT = CatalogEntry.addEntryType("DOCUMENT", 1);
/*      */ 
/*  204 */   public static final int OVERRIDE = CatalogEntry.addEntryType("OVERRIDE", 1);
/*      */ 
/*  207 */   public static final int SGMLDECL = CatalogEntry.addEntryType("SGMLDECL", 1);
/*      */ 
/*  210 */   public static final int DELEGATE_PUBLIC = CatalogEntry.addEntryType("DELEGATE_PUBLIC", 2);
/*      */ 
/*  213 */   public static final int DELEGATE_SYSTEM = CatalogEntry.addEntryType("DELEGATE_SYSTEM", 2);
/*      */ 
/*  216 */   public static final int DELEGATE_URI = CatalogEntry.addEntryType("DELEGATE_URI", 2);
/*      */ 
/*  219 */   public static final int DOCTYPE = CatalogEntry.addEntryType("DOCTYPE", 2);
/*      */ 
/*  222 */   public static final int DTDDECL = CatalogEntry.addEntryType("DTDDECL", 2);
/*      */ 
/*  225 */   public static final int ENTITY = CatalogEntry.addEntryType("ENTITY", 2);
/*      */ 
/*  228 */   public static final int LINKTYPE = CatalogEntry.addEntryType("LINKTYPE", 2);
/*      */ 
/*  231 */   public static final int NOTATION = CatalogEntry.addEntryType("NOTATION", 2);
/*      */ 
/*  234 */   public static final int PUBLIC = CatalogEntry.addEntryType("PUBLIC", 2);
/*      */ 
/*  237 */   public static final int SYSTEM = CatalogEntry.addEntryType("SYSTEM", 2);
/*      */ 
/*  240 */   public static final int URI = CatalogEntry.addEntryType("URI", 2);
/*      */ 
/*  243 */   public static final int REWRITE_SYSTEM = CatalogEntry.addEntryType("REWRITE_SYSTEM", 2);
/*      */ 
/*  246 */   public static final int REWRITE_URI = CatalogEntry.addEntryType("REWRITE_URI", 2);
/*      */ 
/*  248 */   public static final int SYSTEM_SUFFIX = CatalogEntry.addEntryType("SYSTEM_SUFFIX", 2);
/*      */ 
/*  250 */   public static final int URI_SUFFIX = CatalogEntry.addEntryType("URI_SUFFIX", 2);
/*      */   protected URL base;
/*      */   protected URL catalogCwd;
/*  262 */   protected Vector catalogEntries = new Vector();
/*      */ 
/*  265 */   protected boolean default_override = true;
/*      */ 
/*  268 */   protected CatalogManager catalogManager = CatalogManager.getStaticManager();
/*      */ 
/*  281 */   protected Vector catalogFiles = new Vector();
/*      */ 
/*  300 */   protected Vector localCatalogFiles = new Vector();
/*      */ 
/*  319 */   protected Vector catalogs = new Vector();
/*      */ 
/*  336 */   protected Vector localDelegate = new Vector();
/*      */ 
/*  345 */   protected Hashtable readerMap = new Hashtable();
/*      */ 
/*  355 */   protected Vector readerArr = new Vector();
/*      */ 
/*      */   public Catalog()
/*      */   {
/*      */   }
/*      */ 
/*      */   public Catalog(CatalogManager manager)
/*      */   {
/*  376 */     this.catalogManager = manager;
/*      */   }
/*      */ 
/*      */   public CatalogManager getCatalogManager()
/*      */   {
/*  384 */     return this.catalogManager;
/*      */   }
/*      */ 
/*      */   public void setCatalogManager(CatalogManager manager)
/*      */   {
/*  392 */     this.catalogManager = manager;
/*      */   }
/*      */ 
/*      */   public void setupReaders()
/*      */   {
/*  399 */     SAXParserFactory spf = SAXParserFactory.newInstance();
/*  400 */     spf.setNamespaceAware(true);
/*  401 */     spf.setValidating(false);
/*      */ 
/*  403 */     SAXCatalogReader saxReader = new SAXCatalogReader(spf);
/*      */ 
/*  405 */     saxReader.setCatalogParser(null, "XCatalog", "org.apache.xml.resolver.readers.XCatalogReader");
/*      */ 
/*  408 */     saxReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "org.apache.xml.resolver.readers.OASISXMLCatalogReader");
/*      */ 
/*  412 */     addReader("application/xml", saxReader);
/*      */ 
/*  414 */     TR9401CatalogReader textReader = new TR9401CatalogReader();
/*  415 */     addReader("text/plain", textReader);
/*      */   }
/*      */ 
/*      */   public void addReader(String mimeType, CatalogReader reader)
/*      */   {
/*  439 */     if (this.readerMap.containsKey(mimeType)) {
/*  440 */       Integer pos = (Integer)this.readerMap.get(mimeType);
/*  441 */       this.readerArr.set(pos.intValue(), reader);
/*      */     } else {
/*  443 */       this.readerArr.add(reader);
/*  444 */       Integer pos = new Integer(this.readerArr.size() - 1);
/*  445 */       this.readerMap.put(mimeType, pos);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void copyReaders(Catalog newCatalog)
/*      */   {
/*  460 */     Vector mapArr = new Vector(this.readerMap.size());
/*      */ 
/*  463 */     for (int count = 0; count < this.readerMap.size(); count++) {
/*  464 */       mapArr.add(null);
/*      */     }
/*      */ 
/*  467 */     Enumeration en = this.readerMap.keys();
/*  468 */     while (en.hasMoreElements()) {
/*  469 */       String mimeType = (String)en.nextElement();
/*  470 */       Integer pos = (Integer)this.readerMap.get(mimeType);
/*  471 */       mapArr.set(pos.intValue(), mimeType);
/*      */     }
/*      */ 
/*  474 */     for (int count = 0; count < mapArr.size(); count++) {
/*  475 */       String mimeType = (String)mapArr.get(count);
/*  476 */       Integer pos = (Integer)this.readerMap.get(mimeType);
/*  477 */       newCatalog.addReader(mimeType, (CatalogReader)this.readerArr.get(pos.intValue()));
/*      */     }
/*      */   }
/*      */ 
/*      */   protected Catalog newCatalog()
/*      */   {
/*  496 */     String catalogClass = getClass().getName();
/*      */     try
/*      */     {
/*  499 */       Catalog c = (Catalog)Class.forName(catalogClass).newInstance();
/*  500 */       c.setCatalogManager(this.catalogManager);
/*  501 */       copyReaders(c);
/*  502 */       return c;
/*      */     } catch (ClassNotFoundException cnfe) {
/*  504 */       this.catalogManager.debug.message(1, "Class Not Found Exception: " + catalogClass);
/*      */     } catch (IllegalAccessException iae) {
/*  506 */       this.catalogManager.debug.message(1, "Illegal Access Exception: " + catalogClass);
/*      */     } catch (InstantiationException ie) {
/*  508 */       this.catalogManager.debug.message(1, "Instantiation Exception: " + catalogClass);
/*      */     } catch (ClassCastException cce) {
/*  510 */       this.catalogManager.debug.message(1, "Class Cast Exception: " + catalogClass);
/*      */     } catch (Exception e) {
/*  512 */       this.catalogManager.debug.message(1, "Other Exception: " + catalogClass);
/*      */     }
/*      */ 
/*  515 */     Catalog c = new Catalog();
/*  516 */     c.setCatalogManager(this.catalogManager);
/*  517 */     copyReaders(c);
/*  518 */     return c;
/*      */   }
/*      */ 
/*      */   public String getCurrentBase()
/*      */   {
/*  525 */     return this.base.toString();
/*      */   }
/*      */ 
/*      */   public String getDefaultOverride()
/*      */   {
/*  536 */     if (this.default_override) {
/*  537 */       return "yes";
/*      */     }
/*  539 */     return "no";
/*      */   }
/*      */ 
/*      */   public void loadSystemCatalogs()
/*      */     throws MalformedURLException, IOException
/*      */   {
/*  557 */     Vector catalogs = this.catalogManager.getCatalogFiles();
/*  558 */     if (catalogs != null) {
/*  559 */       for (int count = 0; count < catalogs.size(); count++) {
/*  560 */         this.catalogFiles.addElement(catalogs.elementAt(count));
/*      */       }
/*      */     }
/*      */ 
/*  564 */     if (this.catalogFiles.size() > 0)
/*      */     {
/*  577 */       String catfile = (String)this.catalogFiles.lastElement();
/*  578 */       this.catalogFiles.removeElement(catfile);
/*  579 */       parseCatalog(catfile);
/*      */     }
/*      */   }
/*      */ 
/*      */   public synchronized void parseCatalog(String fileName)
/*      */     throws MalformedURLException, IOException
/*      */   {
/*  595 */     this.default_override = this.catalogManager.getPreferPublic();
/*  596 */     this.catalogManager.debug.message(4, "Parse catalog: " + fileName);
/*      */ 
/*  601 */     this.catalogFiles.addElement(fileName);
/*      */ 
/*  604 */     parsePendingCatalogs();
/*      */   }
/*      */ 
/*      */   public synchronized void parseCatalog(String mimeType, InputStream is)
/*      */     throws IOException, CatalogException
/*      */   {
/*  623 */     this.default_override = this.catalogManager.getPreferPublic();
/*  624 */     this.catalogManager.debug.message(4, "Parse " + mimeType + " catalog on input stream");
/*      */ 
/*  626 */     CatalogReader reader = null;
/*      */ 
/*  628 */     if (this.readerMap.containsKey(mimeType)) {
/*  629 */       int arrayPos = ((Integer)this.readerMap.get(mimeType)).intValue();
/*  630 */       reader = (CatalogReader)this.readerArr.get(arrayPos);
/*      */     }
/*      */ 
/*  633 */     if (reader == null) {
/*  634 */       String msg = "No CatalogReader for MIME type: " + mimeType;
/*  635 */       this.catalogManager.debug.message(2, msg);
/*  636 */       throw new CatalogException(6, msg);
/*      */     }
/*      */ 
/*  639 */     reader.readCatalog(this, is);
/*      */ 
/*  642 */     parsePendingCatalogs();
/*      */   }
/*      */ 
/*      */   public synchronized void parseCatalog(URL aUrl)
/*      */     throws IOException
/*      */   {
/*  661 */     this.catalogCwd = aUrl;
/*  662 */     this.base = aUrl;
/*      */ 
/*  664 */     this.default_override = this.catalogManager.getPreferPublic();
/*  665 */     this.catalogManager.debug.message(4, "Parse catalog: " + aUrl.toString());
/*      */ 
/*  667 */     DataInputStream inStream = null;
/*  668 */     boolean parsed = false;
/*      */ 
/*  670 */     for (int count = 0; (!parsed) && (count < this.readerArr.size()); count++) {
/*  671 */       CatalogReader reader = (CatalogReader)this.readerArr.get(count);
/*      */       try
/*      */       {
/*  674 */         inStream = new DataInputStream(aUrl.openStream());
/*      */       }
/*      */       catch (FileNotFoundException fnfe) {
/*  677 */         break;
/*      */       }
/*      */       try
/*      */       {
/*  681 */         reader.readCatalog(this, inStream);
/*  682 */         parsed = true;
/*      */       } catch (CatalogException ce) {
/*  684 */         if (ce.getExceptionType() != 7) break label127; 
/*      */       }
/*  686 */       break;
/*      */       try
/*      */       {
/*  693 */         label127: inStream.close();
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*      */       }
/*      */     }
/*  699 */     if (parsed) parsePendingCatalogs();
/*      */   }
/*      */ 
/*      */   protected synchronized void parsePendingCatalogs()
/*      */     throws MalformedURLException, IOException
/*      */   {
/*  711 */     if (!this.localCatalogFiles.isEmpty())
/*      */     {
/*  714 */       Vector newQueue = new Vector();
/*  715 */       Enumeration q = this.localCatalogFiles.elements();
/*  716 */       while (q.hasMoreElements()) {
/*  717 */         newQueue.addElement(q.nextElement());
/*      */       }
/*      */ 
/*  721 */       for (int curCat = 0; curCat < this.catalogFiles.size(); curCat++) {
/*  722 */         String catfile = (String)this.catalogFiles.elementAt(curCat);
/*  723 */         newQueue.addElement(catfile);
/*      */       }
/*      */ 
/*  726 */       this.catalogFiles = newQueue;
/*  727 */       this.localCatalogFiles.clear();
/*      */     }
/*      */ 
/*  733 */     if ((this.catalogFiles.isEmpty()) && (!this.localDelegate.isEmpty())) {
/*  734 */       Enumeration e = this.localDelegate.elements();
/*  735 */       while (e.hasMoreElements()) {
/*  736 */         this.catalogEntries.addElement(e.nextElement());
/*      */       }
/*  738 */       this.localDelegate.clear();
/*      */     }
/*      */ 
/*  744 */     while (!this.catalogFiles.isEmpty()) {
/*  745 */       String catfile = (String)this.catalogFiles.elementAt(0);
/*      */       try {
/*  747 */         this.catalogFiles.remove(0);
/*      */       }
/*      */       catch (ArrayIndexOutOfBoundsException e)
/*      */       {
/*      */       }
/*  752 */       if ((this.catalogEntries.size() == 0) && (this.catalogs.size() == 0))
/*      */       {
/*      */         try
/*      */         {
/*  756 */           parseCatalogFile(catfile);
/*      */         } catch (CatalogException ce) {
/*  758 */           System.out.println("FIXME: " + ce.toString());
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  763 */         this.catalogs.addElement(catfile);
/*      */       }
/*      */ 
/*  766 */       if (!this.localCatalogFiles.isEmpty())
/*      */       {
/*  769 */         Vector newQueue = new Vector();
/*  770 */         Enumeration q = this.localCatalogFiles.elements();
/*  771 */         while (q.hasMoreElements()) {
/*  772 */           newQueue.addElement(q.nextElement());
/*      */         }
/*      */ 
/*  776 */         for (int curCat = 0; curCat < this.catalogFiles.size(); curCat++) {
/*  777 */           catfile = (String)this.catalogFiles.elementAt(curCat);
/*  778 */           newQueue.addElement(catfile);
/*      */         }
/*      */ 
/*  781 */         this.catalogFiles = newQueue;
/*  782 */         this.localCatalogFiles.clear();
/*      */       }
/*      */ 
/*  785 */       if (!this.localDelegate.isEmpty()) {
/*  786 */         Enumeration e = this.localDelegate.elements();
/*  787 */         while (e.hasMoreElements()) {
/*  788 */           this.catalogEntries.addElement(e.nextElement());
/*      */         }
/*  790 */         this.localDelegate.clear();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  795 */     this.catalogFiles.clear();
/*      */   }
/*      */ 
/*      */   protected synchronized void parseCatalogFile(String fileName)
/*      */     throws MalformedURLException, IOException, CatalogException
/*      */   {
/*      */     try
/*      */     {
/*  817 */       this.catalogCwd = FileURL.makeURL("basename");
/*      */     } catch (MalformedURLException e) {
/*  819 */       String userdir = System.getProperty("user.dir");
/*  820 */       userdir = userdir.replace('\\', '/');
/*  821 */       this.catalogManager.debug.message(1, "Malformed URL on cwd", userdir);
/*  822 */       this.catalogCwd = null;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  827 */       this.base = new URL(this.catalogCwd, fixSlashes(fileName));
/*      */     } catch (MalformedURLException e) {
/*      */       try {
/*  830 */         this.base = new URL("file:" + fixSlashes(fileName));
/*      */       } catch (MalformedURLException e2) {
/*  832 */         this.catalogManager.debug.message(1, "Malformed URL on catalog filename", fixSlashes(fileName));
/*      */ 
/*  834 */         this.base = null;
/*      */       }
/*      */     }
/*      */ 
/*  838 */     this.catalogManager.debug.message(2, "Loading catalog", fileName);
/*  839 */     this.catalogManager.debug.message(4, "Default BASE", this.base.toString());
/*      */ 
/*  841 */     fileName = this.base.toString();
/*      */ 
/*  843 */     DataInputStream inStream = null;
/*  844 */     boolean parsed = false;
/*  845 */     boolean notFound = false;
/*      */ 
/*  847 */     for (int count = 0; (!parsed) && (count < this.readerArr.size()); count++) {
/*  848 */       CatalogReader reader = (CatalogReader)this.readerArr.get(count);
/*      */       try
/*      */       {
/*  851 */         notFound = false;
/*  852 */         inStream = new DataInputStream(this.base.openStream());
/*      */       }
/*      */       catch (FileNotFoundException fnfe) {
/*  855 */         notFound = true;
/*  856 */         break;
/*      */       }
/*      */       try
/*      */       {
/*  860 */         reader.readCatalog(this, inStream);
/*  861 */         parsed = true;
/*      */       } catch (CatalogException ce) {
/*  863 */         if (ce.getExceptionType() != 7) break label266; 
/*      */       }
/*  865 */       break;
/*      */       try
/*      */       {
/*  872 */         label266: inStream.close();
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*      */       }
/*      */     }
/*  878 */     if (!parsed)
/*  879 */       if (notFound)
/*  880 */         this.catalogManager.debug.message(3, "Catalog does not exist", fileName);
/*      */       else
/*  882 */         this.catalogManager.debug.message(1, "Failed to parse catalog", fileName);
/*      */   }
/*      */ 
/*      */   public void addEntry(CatalogEntry entry)
/*      */   {
/*  898 */     int type = entry.getEntryType();
/*      */ 
/*  900 */     if (type == BASE) {
/*  901 */       String value = entry.getEntryArg(0);
/*  902 */       URL newbase = null;
/*      */ 
/*  904 */       if (this.base == null)
/*  905 */         this.catalogManager.debug.message(5, "BASE CUR", "null");
/*      */       else {
/*  907 */         this.catalogManager.debug.message(5, "BASE CUR", this.base.toString());
/*      */       }
/*  909 */       this.catalogManager.debug.message(4, "BASE STR", value);
/*      */       try
/*      */       {
/*  912 */         value = fixSlashes(value);
/*  913 */         newbase = new URL(this.base, value);
/*      */       } catch (MalformedURLException e) {
/*      */         try {
/*  916 */           newbase = new URL("file:" + value);
/*      */         } catch (MalformedURLException e2) {
/*  918 */           this.catalogManager.debug.message(1, "Malformed URL on base", value);
/*  919 */           newbase = null;
/*      */         }
/*      */       }
/*      */ 
/*  923 */       if (newbase != null) {
/*  924 */         this.base = newbase;
/*      */       }
/*      */ 
/*  927 */       this.catalogManager.debug.message(5, "BASE NEW", this.base.toString());
/*  928 */     } else if (type == CATALOG) {
/*  929 */       String fsi = makeAbsolute(entry.getEntryArg(0));
/*      */ 
/*  931 */       this.catalogManager.debug.message(4, "CATALOG", fsi);
/*      */ 
/*  933 */       this.localCatalogFiles.addElement(fsi);
/*  934 */     } else if (type == PUBLIC) {
/*  935 */       String publicid = PublicId.normalize(entry.getEntryArg(0));
/*  936 */       String systemid = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/*  938 */       entry.setEntryArg(0, publicid);
/*  939 */       entry.setEntryArg(1, systemid);
/*      */ 
/*  941 */       this.catalogManager.debug.message(4, "PUBLIC", publicid, systemid);
/*      */ 
/*  943 */       this.catalogEntries.addElement(entry);
/*  944 */     } else if (type == SYSTEM) {
/*  945 */       String systemid = normalizeURI(entry.getEntryArg(0));
/*  946 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/*  948 */       entry.setEntryArg(1, fsi);
/*      */ 
/*  950 */       this.catalogManager.debug.message(4, "SYSTEM", systemid, fsi);
/*      */ 
/*  952 */       this.catalogEntries.addElement(entry);
/*  953 */     } else if (type == URI) {
/*  954 */       String uri = normalizeURI(entry.getEntryArg(0));
/*  955 */       String altURI = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/*  957 */       entry.setEntryArg(1, altURI);
/*      */ 
/*  959 */       this.catalogManager.debug.message(4, "URI", uri, altURI);
/*      */ 
/*  961 */       this.catalogEntries.addElement(entry);
/*  962 */     } else if (type == DOCUMENT) {
/*  963 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(0)));
/*  964 */       entry.setEntryArg(0, fsi);
/*      */ 
/*  966 */       this.catalogManager.debug.message(4, "DOCUMENT", fsi);
/*      */ 
/*  968 */       this.catalogEntries.addElement(entry);
/*  969 */     } else if (type == OVERRIDE) {
/*  970 */       this.catalogManager.debug.message(4, "OVERRIDE", entry.getEntryArg(0));
/*      */ 
/*  972 */       this.catalogEntries.addElement(entry);
/*  973 */     } else if (type == SGMLDECL)
/*      */     {
/*  975 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(0)));
/*  976 */       entry.setEntryArg(0, fsi);
/*      */ 
/*  978 */       this.catalogManager.debug.message(4, "SGMLDECL", fsi);
/*      */ 
/*  980 */       this.catalogEntries.addElement(entry);
/*  981 */     } else if (type == DELEGATE_PUBLIC) {
/*  982 */       String ppi = PublicId.normalize(entry.getEntryArg(0));
/*  983 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/*  985 */       entry.setEntryArg(0, ppi);
/*  986 */       entry.setEntryArg(1, fsi);
/*      */ 
/*  988 */       this.catalogManager.debug.message(4, "DELEGATE_PUBLIC", ppi, fsi);
/*      */ 
/*  990 */       addDelegate(entry);
/*  991 */     } else if (type == DELEGATE_SYSTEM) {
/*  992 */       String psi = normalizeURI(entry.getEntryArg(0));
/*  993 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/*  995 */       entry.setEntryArg(0, psi);
/*  996 */       entry.setEntryArg(1, fsi);
/*      */ 
/*  998 */       this.catalogManager.debug.message(4, "DELEGATE_SYSTEM", psi, fsi);
/*      */ 
/* 1000 */       addDelegate(entry);
/* 1001 */     } else if (type == DELEGATE_URI) {
/* 1002 */       String pui = normalizeURI(entry.getEntryArg(0));
/* 1003 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1005 */       entry.setEntryArg(0, pui);
/* 1006 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1008 */       this.catalogManager.debug.message(4, "DELEGATE_URI", pui, fsi);
/*      */ 
/* 1010 */       addDelegate(entry);
/* 1011 */     } else if (type == REWRITE_SYSTEM) {
/* 1012 */       String psi = normalizeURI(entry.getEntryArg(0));
/* 1013 */       String rpx = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1015 */       entry.setEntryArg(0, psi);
/* 1016 */       entry.setEntryArg(1, rpx);
/*      */ 
/* 1018 */       this.catalogManager.debug.message(4, "REWRITE_SYSTEM", psi, rpx);
/*      */ 
/* 1020 */       this.catalogEntries.addElement(entry);
/* 1021 */     } else if (type == REWRITE_URI) {
/* 1022 */       String pui = normalizeURI(entry.getEntryArg(0));
/* 1023 */       String upx = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1025 */       entry.setEntryArg(0, pui);
/* 1026 */       entry.setEntryArg(1, upx);
/*      */ 
/* 1028 */       this.catalogManager.debug.message(4, "REWRITE_URI", pui, upx);
/*      */ 
/* 1030 */       this.catalogEntries.addElement(entry);
/* 1031 */     } else if (type == SYSTEM_SUFFIX) {
/* 1032 */       String pui = normalizeURI(entry.getEntryArg(0));
/* 1033 */       String upx = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1035 */       entry.setEntryArg(0, pui);
/* 1036 */       entry.setEntryArg(1, upx);
/*      */ 
/* 1038 */       this.catalogManager.debug.message(4, "SYSTEM_SUFFIX", pui, upx);
/*      */ 
/* 1040 */       this.catalogEntries.addElement(entry);
/* 1041 */     } else if (type == URI_SUFFIX) {
/* 1042 */       String pui = normalizeURI(entry.getEntryArg(0));
/* 1043 */       String upx = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/*      */ 
/* 1045 */       entry.setEntryArg(0, pui);
/* 1046 */       entry.setEntryArg(1, upx);
/*      */ 
/* 1048 */       this.catalogManager.debug.message(4, "URI_SUFFIX", pui, upx);
/*      */ 
/* 1050 */       this.catalogEntries.addElement(entry);
/* 1051 */     } else if (type == DOCTYPE) {
/* 1052 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1053 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1055 */       this.catalogManager.debug.message(4, "DOCTYPE", entry.getEntryArg(0), fsi);
/*      */ 
/* 1057 */       this.catalogEntries.addElement(entry);
/* 1058 */     } else if (type == DTDDECL)
/*      */     {
/* 1060 */       String fpi = PublicId.normalize(entry.getEntryArg(0));
/* 1061 */       entry.setEntryArg(0, fpi);
/* 1062 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1063 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1065 */       this.catalogManager.debug.message(4, "DTDDECL", fpi, fsi);
/*      */ 
/* 1067 */       this.catalogEntries.addElement(entry);
/* 1068 */     } else if (type == ENTITY) {
/* 1069 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1070 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1072 */       this.catalogManager.debug.message(4, "ENTITY", entry.getEntryArg(0), fsi);
/*      */ 
/* 1074 */       this.catalogEntries.addElement(entry);
/* 1075 */     } else if (type == LINKTYPE)
/*      */     {
/* 1077 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1078 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1080 */       this.catalogManager.debug.message(4, "LINKTYPE", entry.getEntryArg(0), fsi);
/*      */ 
/* 1082 */       this.catalogEntries.addElement(entry);
/* 1083 */     } else if (type == NOTATION) {
/* 1084 */       String fsi = makeAbsolute(normalizeURI(entry.getEntryArg(1)));
/* 1085 */       entry.setEntryArg(1, fsi);
/*      */ 
/* 1087 */       this.catalogManager.debug.message(4, "NOTATION", entry.getEntryArg(0), fsi);
/*      */ 
/* 1089 */       this.catalogEntries.addElement(entry);
/*      */     } else {
/* 1091 */       this.catalogEntries.addElement(entry);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void unknownEntry(Vector strings)
/*      */   {
/* 1102 */     if ((strings != null) && (strings.size() > 0)) {
/* 1103 */       String keyword = (String)strings.elementAt(0);
/* 1104 */       this.catalogManager.debug.message(2, "Unrecognized token parsing catalog", keyword);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void parseAllCatalogs()
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1141 */     for (int catPos = 0; catPos < this.catalogs.size(); catPos++) {
/* 1142 */       Catalog c = null;
/*      */       try
/*      */       {
/* 1145 */         c = (Catalog)this.catalogs.elementAt(catPos);
/*      */       } catch (ClassCastException e) {
/* 1147 */         String catfile = (String)this.catalogs.elementAt(catPos);
/* 1148 */         c = newCatalog();
/*      */ 
/* 1150 */         c.parseCatalog(catfile);
/* 1151 */         this.catalogs.setElementAt(c, catPos);
/* 1152 */         c.parseAllCatalogs();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1157 */     Enumeration en = this.catalogEntries.elements();
/* 1158 */     while (en.hasMoreElements()) {
/* 1159 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/* 1160 */       if ((e.getEntryType() != DELEGATE_PUBLIC) && (e.getEntryType() != DELEGATE_SYSTEM) && (e.getEntryType() != DELEGATE_URI)) {
/*      */         continue;
/*      */       }
/* 1163 */       Catalog dcat = newCatalog();
/* 1164 */       dcat.parseCatalog(e.getEntryArg(1));
/*      */     }
/*      */   }
/*      */ 
/*      */   public String resolveDoctype(String entityName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1190 */     String resolved = null;
/*      */ 
/* 1192 */     this.catalogManager.debug.message(3, "resolveDoctype(" + entityName + "," + publicId + "," + systemId + ")");
/*      */ 
/* 1195 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1197 */     if ((publicId != null) && (publicId.startsWith("urn:publicid:"))) {
/* 1198 */       publicId = PublicId.decodeURN(publicId);
/*      */     }
/*      */ 
/* 1201 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1202 */       systemId = PublicId.decodeURN(systemId);
/* 1203 */       if ((publicId != null) && (!publicId.equals(systemId))) {
/* 1204 */         this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
/* 1205 */         systemId = null;
/*      */       } else {
/* 1207 */         publicId = systemId;
/* 1208 */         systemId = null;
/*      */       }
/*      */     }
/*      */ 
/* 1212 */     if (systemId != null)
/*      */     {
/* 1214 */       resolved = resolveLocalSystem(systemId);
/* 1215 */       if (resolved != null) {
/* 1216 */         return resolved;
/*      */       }
/*      */     }
/*      */ 
/* 1220 */     if (publicId != null)
/*      */     {
/* 1222 */       resolved = resolveLocalPublic(DOCTYPE, entityName, publicId, systemId);
/*      */ 
/* 1226 */       if (resolved != null) {
/* 1227 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1232 */     boolean over = this.default_override;
/* 1233 */     Enumeration en = this.catalogEntries.elements();
/* 1234 */     while (en.hasMoreElements()) {
/* 1235 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/* 1236 */       if (e.getEntryType() == OVERRIDE) {
/* 1237 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/*      */       }
/*      */       else
/*      */       {
/* 1241 */         if ((e.getEntryType() != DOCTYPE) || (!e.getEntryArg(0).equals(entityName)))
/*      */           continue;
/* 1243 */         if ((over) || (systemId == null)) {
/* 1244 */           return e.getEntryArg(1);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1250 */     return resolveSubordinateCatalogs(DOCTYPE, entityName, publicId, systemId);
/*      */   }
/*      */ 
/*      */   public String resolveDocument()
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1269 */     this.catalogManager.debug.message(3, "resolveDocument");
/*      */ 
/* 1271 */     Enumeration en = this.catalogEntries.elements();
/* 1272 */     while (en.hasMoreElements()) {
/* 1273 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/* 1274 */       if (e.getEntryType() == DOCUMENT) {
/* 1275 */         return e.getEntryArg(0);
/*      */       }
/*      */     }
/*      */ 
/* 1279 */     return resolveSubordinateCatalogs(DOCUMENT, null, null, null);
/*      */   }
/*      */ 
/*      */   public String resolveEntity(String entityName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1303 */     String resolved = null;
/*      */ 
/* 1305 */     this.catalogManager.debug.message(3, "resolveEntity(" + entityName + "," + publicId + "," + systemId + ")");
/*      */ 
/* 1308 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1310 */     if ((publicId != null) && (publicId.startsWith("urn:publicid:"))) {
/* 1311 */       publicId = PublicId.decodeURN(publicId);
/*      */     }
/*      */ 
/* 1314 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1315 */       systemId = PublicId.decodeURN(systemId);
/* 1316 */       if ((publicId != null) && (!publicId.equals(systemId))) {
/* 1317 */         this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
/* 1318 */         systemId = null;
/*      */       } else {
/* 1320 */         publicId = systemId;
/* 1321 */         systemId = null;
/*      */       }
/*      */     }
/*      */ 
/* 1325 */     if (systemId != null)
/*      */     {
/* 1327 */       resolved = resolveLocalSystem(systemId);
/* 1328 */       if (resolved != null) {
/* 1329 */         return resolved;
/*      */       }
/*      */     }
/*      */ 
/* 1333 */     if (publicId != null)
/*      */     {
/* 1335 */       resolved = resolveLocalPublic(ENTITY, entityName, publicId, systemId);
/*      */ 
/* 1339 */       if (resolved != null) {
/* 1340 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1345 */     boolean over = this.default_override;
/* 1346 */     Enumeration en = this.catalogEntries.elements();
/* 1347 */     while (en.hasMoreElements()) {
/* 1348 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/* 1349 */       if (e.getEntryType() == OVERRIDE) {
/* 1350 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/*      */       }
/*      */       else
/*      */       {
/* 1354 */         if ((e.getEntryType() != ENTITY) || (!e.getEntryArg(0).equals(entityName)))
/*      */           continue;
/* 1356 */         if ((over) || (systemId == null)) {
/* 1357 */           return e.getEntryArg(1);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1363 */     return resolveSubordinateCatalogs(ENTITY, entityName, publicId, systemId);
/*      */   }
/*      */ 
/*      */   public String resolveNotation(String notationName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1389 */     String resolved = null;
/*      */ 
/* 1391 */     this.catalogManager.debug.message(3, "resolveNotation(" + notationName + "," + publicId + "," + systemId + ")");
/*      */ 
/* 1394 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1396 */     if ((publicId != null) && (publicId.startsWith("urn:publicid:"))) {
/* 1397 */       publicId = PublicId.decodeURN(publicId);
/*      */     }
/*      */ 
/* 1400 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1401 */       systemId = PublicId.decodeURN(systemId);
/* 1402 */       if ((publicId != null) && (!publicId.equals(systemId))) {
/* 1403 */         this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
/* 1404 */         systemId = null;
/*      */       } else {
/* 1406 */         publicId = systemId;
/* 1407 */         systemId = null;
/*      */       }
/*      */     }
/*      */ 
/* 1411 */     if (systemId != null)
/*      */     {
/* 1413 */       resolved = resolveLocalSystem(systemId);
/* 1414 */       if (resolved != null) {
/* 1415 */         return resolved;
/*      */       }
/*      */     }
/*      */ 
/* 1419 */     if (publicId != null)
/*      */     {
/* 1421 */       resolved = resolveLocalPublic(NOTATION, notationName, publicId, systemId);
/*      */ 
/* 1425 */       if (resolved != null) {
/* 1426 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1431 */     boolean over = this.default_override;
/* 1432 */     Enumeration en = this.catalogEntries.elements();
/* 1433 */     while (en.hasMoreElements()) {
/* 1434 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/* 1435 */       if (e.getEntryType() == OVERRIDE) {
/* 1436 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/*      */       }
/*      */       else
/*      */       {
/* 1440 */         if ((e.getEntryType() != NOTATION) || (!e.getEntryArg(0).equals(notationName)))
/*      */           continue;
/* 1442 */         if ((over) || (systemId == null)) {
/* 1443 */           return e.getEntryArg(1);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1449 */     return resolveSubordinateCatalogs(NOTATION, notationName, publicId, systemId);
/*      */   }
/*      */ 
/*      */   public String resolvePublic(String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1481 */     this.catalogManager.debug.message(3, "resolvePublic(" + publicId + "," + systemId + ")");
/*      */ 
/* 1483 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1485 */     if ((publicId != null) && (publicId.startsWith("urn:publicid:"))) {
/* 1486 */       publicId = PublicId.decodeURN(publicId);
/*      */     }
/*      */ 
/* 1489 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1490 */       systemId = PublicId.decodeURN(systemId);
/* 1491 */       if ((publicId != null) && (!publicId.equals(systemId))) {
/* 1492 */         this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
/* 1493 */         systemId = null;
/*      */       } else {
/* 1495 */         publicId = systemId;
/* 1496 */         systemId = null;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1501 */     if (systemId != null) {
/* 1502 */       String resolved = resolveLocalSystem(systemId);
/* 1503 */       if (resolved != null) {
/* 1504 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1509 */     String resolved = resolveLocalPublic(PUBLIC, null, publicId, systemId);
/*      */ 
/* 1513 */     if (resolved != null) {
/* 1514 */       return resolved;
/*      */     }
/*      */ 
/* 1518 */     return resolveSubordinateCatalogs(PUBLIC, null, publicId, systemId);
/*      */   }
/*      */ 
/*      */   protected synchronized String resolveLocalPublic(int entityType, String entityName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1579 */     publicId = PublicId.normalize(publicId);
/*      */ 
/* 1582 */     if (systemId != null) {
/* 1583 */       String resolved = resolveLocalSystem(systemId);
/* 1584 */       if (resolved != null) {
/* 1585 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1590 */     boolean over = this.default_override;
/* 1591 */     Enumeration en = this.catalogEntries.elements();
/* 1592 */     while (en.hasMoreElements()) {
/* 1593 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/* 1594 */       if (e.getEntryType() == OVERRIDE) {
/* 1595 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/*      */       }
/*      */       else
/*      */       {
/* 1599 */         if ((e.getEntryType() != PUBLIC) || (!e.getEntryArg(0).equals(publicId)))
/*      */           continue;
/* 1601 */         if ((over) || (systemId == null)) {
/* 1602 */           return e.getEntryArg(1);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1608 */     over = this.default_override;
/* 1609 */     en = this.catalogEntries.elements();
/* 1610 */     Vector delCats = new Vector();
/* 1611 */     while (en.hasMoreElements()) {
/* 1612 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/* 1613 */       if (e.getEntryType() == OVERRIDE) {
/* 1614 */         over = e.getEntryArg(0).equalsIgnoreCase("YES");
/*      */       }
/*      */       else
/*      */       {
/* 1618 */         if ((e.getEntryType() != DELEGATE_PUBLIC) || ((!over) && (systemId != null)))
/*      */           continue;
/* 1620 */         String p = e.getEntryArg(0);
/* 1621 */         if ((p.length() > publicId.length()) || (!p.equals(publicId.substring(0, p.length()))))
/*      */         {
/*      */           continue;
/*      */         }
/* 1625 */         delCats.addElement(e.getEntryArg(1));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1630 */     if (delCats.size() > 0) {
/* 1631 */       Enumeration enCats = delCats.elements();
/*      */ 
/* 1633 */       if (this.catalogManager.debug.getDebug() > 1) {
/* 1634 */         this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
/* 1635 */         while (enCats.hasMoreElements()) {
/* 1636 */           String delegatedCatalog = (String)enCats.nextElement();
/* 1637 */           this.catalogManager.debug.message(2, "\t" + delegatedCatalog);
/*      */         }
/*      */       }
/*      */ 
/* 1641 */       Catalog dcat = newCatalog();
/*      */ 
/* 1643 */       enCats = delCats.elements();
/* 1644 */       while (enCats.hasMoreElements()) {
/* 1645 */         String delegatedCatalog = (String)enCats.nextElement();
/* 1646 */         dcat.parseCatalog(delegatedCatalog);
/*      */       }
/*      */ 
/* 1649 */       return dcat.resolvePublic(publicId, null);
/*      */     }
/*      */ 
/* 1653 */     return null;
/*      */   }
/*      */ 
/*      */   public String resolveSystem(String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1677 */     this.catalogManager.debug.message(3, "resolveSystem(" + systemId + ")");
/*      */ 
/* 1679 */     systemId = normalizeURI(systemId);
/*      */ 
/* 1681 */     if ((systemId != null) && (systemId.startsWith("urn:publicid:"))) {
/* 1682 */       systemId = PublicId.decodeURN(systemId);
/* 1683 */       return resolvePublic(systemId, null);
/*      */     }
/*      */ 
/* 1687 */     if (systemId != null) {
/* 1688 */       String resolved = resolveLocalSystem(systemId);
/* 1689 */       if (resolved != null) {
/* 1690 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1695 */     return resolveSubordinateCatalogs(SYSTEM, null, null, systemId);
/*      */   }
/*      */ 
/*      */   protected String resolveLocalSystem(String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1715 */     String osname = System.getProperty("os.name");
/* 1716 */     boolean windows = osname.indexOf("Windows") >= 0;
/* 1717 */     Enumeration en = this.catalogEntries.elements();
/* 1718 */     while (en.hasMoreElements()) {
/* 1719 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/* 1720 */       if ((e.getEntryType() == SYSTEM) && ((e.getEntryArg(0).equals(systemId)) || ((windows) && (e.getEntryArg(0).equalsIgnoreCase(systemId)))))
/*      */       {
/* 1724 */         return e.getEntryArg(1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1729 */     en = this.catalogEntries.elements();
/* 1730 */     String startString = null;
/* 1731 */     String prefix = null;
/* 1732 */     while (en.hasMoreElements()) {
/* 1733 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/*      */ 
/* 1735 */       if (e.getEntryType() == REWRITE_SYSTEM) {
/* 1736 */         String p = e.getEntryArg(0);
/* 1737 */         if ((p.length() > systemId.length()) || (!p.equals(systemId.substring(0, p.length())))) {
/*      */           continue;
/*      */         }
/* 1740 */         if ((startString != null) && (p.length() <= startString.length()))
/*      */           continue;
/* 1742 */         startString = p;
/* 1743 */         prefix = e.getEntryArg(1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1749 */     if (prefix != null)
/*      */     {
/* 1751 */       return prefix + systemId.substring(startString.length());
/*      */     }
/*      */ 
/* 1755 */     en = this.catalogEntries.elements();
/* 1756 */     String suffixString = null;
/* 1757 */     String suffixURI = null;
/* 1758 */     while (en.hasMoreElements()) {
/* 1759 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/*      */ 
/* 1761 */       if (e.getEntryType() == SYSTEM_SUFFIX) {
/* 1762 */         String p = e.getEntryArg(0);
/* 1763 */         if ((p.length() > systemId.length()) || (!systemId.endsWith(p))) {
/*      */           continue;
/*      */         }
/* 1766 */         if ((suffixString != null) && (p.length() <= suffixString.length()))
/*      */           continue;
/* 1768 */         suffixString = p;
/* 1769 */         suffixURI = e.getEntryArg(1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1775 */     if (suffixURI != null)
/*      */     {
/* 1777 */       return suffixURI;
/*      */     }
/*      */ 
/* 1781 */     en = this.catalogEntries.elements();
/* 1782 */     Vector delCats = new Vector();
/* 1783 */     while (en.hasMoreElements()) {
/* 1784 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/*      */ 
/* 1786 */       if (e.getEntryType() == DELEGATE_SYSTEM) {
/* 1787 */         String p = e.getEntryArg(0);
/* 1788 */         if ((p.length() > systemId.length()) || (!p.equals(systemId.substring(0, p.length()))))
/*      */         {
/*      */           continue;
/*      */         }
/* 1792 */         delCats.addElement(e.getEntryArg(1));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1797 */     if (delCats.size() > 0) {
/* 1798 */       Enumeration enCats = delCats.elements();
/*      */ 
/* 1800 */       if (this.catalogManager.debug.getDebug() > 1) {
/* 1801 */         this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
/* 1802 */         while (enCats.hasMoreElements()) {
/* 1803 */           String delegatedCatalog = (String)enCats.nextElement();
/* 1804 */           this.catalogManager.debug.message(2, "\t" + delegatedCatalog);
/*      */         }
/*      */       }
/*      */ 
/* 1808 */       Catalog dcat = newCatalog();
/*      */ 
/* 1810 */       enCats = delCats.elements();
/* 1811 */       while (enCats.hasMoreElements()) {
/* 1812 */         String delegatedCatalog = (String)enCats.nextElement();
/* 1813 */         dcat.parseCatalog(delegatedCatalog);
/*      */       }
/*      */ 
/* 1816 */       return dcat.resolveSystem(systemId);
/*      */     }
/*      */ 
/* 1819 */     return null;
/*      */   }
/*      */ 
/*      */   public String resolveURI(String uri)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1841 */     this.catalogManager.debug.message(3, "resolveURI(" + uri + ")");
/*      */ 
/* 1843 */     uri = normalizeURI(uri);
/*      */ 
/* 1845 */     if ((uri != null) && (uri.startsWith("urn:publicid:"))) {
/* 1846 */       uri = PublicId.decodeURN(uri);
/* 1847 */       return resolvePublic(uri, null);
/*      */     }
/*      */ 
/* 1851 */     if (uri != null) {
/* 1852 */       String resolved = resolveLocalURI(uri);
/* 1853 */       if (resolved != null) {
/* 1854 */         return resolved;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1859 */     return resolveSubordinateCatalogs(URI, null, null, uri);
/*      */   }
/*      */ 
/*      */   protected String resolveLocalURI(String uri)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 1877 */     Enumeration en = this.catalogEntries.elements();
/* 1878 */     while (en.hasMoreElements()) {
/* 1879 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/* 1880 */       if ((e.getEntryType() == URI) && (e.getEntryArg(0).equals(uri)))
/*      */       {
/* 1882 */         return e.getEntryArg(1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1887 */     en = this.catalogEntries.elements();
/* 1888 */     String startString = null;
/* 1889 */     String prefix = null;
/* 1890 */     while (en.hasMoreElements()) {
/* 1891 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/*      */ 
/* 1893 */       if (e.getEntryType() == REWRITE_URI) {
/* 1894 */         String p = e.getEntryArg(0);
/* 1895 */         if ((p.length() > uri.length()) || (!p.equals(uri.substring(0, p.length())))) {
/*      */           continue;
/*      */         }
/* 1898 */         if ((startString != null) && (p.length() <= startString.length()))
/*      */           continue;
/* 1900 */         startString = p;
/* 1901 */         prefix = e.getEntryArg(1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1907 */     if (prefix != null)
/*      */     {
/* 1909 */       return prefix + uri.substring(startString.length());
/*      */     }
/*      */ 
/* 1913 */     en = this.catalogEntries.elements();
/* 1914 */     String suffixString = null;
/* 1915 */     String suffixURI = null;
/* 1916 */     while (en.hasMoreElements()) {
/* 1917 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/*      */ 
/* 1919 */       if (e.getEntryType() == URI_SUFFIX) {
/* 1920 */         String p = e.getEntryArg(0);
/* 1921 */         if ((p.length() > uri.length()) || (!uri.endsWith(p))) {
/*      */           continue;
/*      */         }
/* 1924 */         if ((suffixString != null) && (p.length() <= suffixString.length()))
/*      */           continue;
/* 1926 */         suffixString = p;
/* 1927 */         suffixURI = e.getEntryArg(1);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1933 */     if (suffixURI != null)
/*      */     {
/* 1935 */       return suffixURI;
/*      */     }
/*      */ 
/* 1939 */     en = this.catalogEntries.elements();
/* 1940 */     Vector delCats = new Vector();
/* 1941 */     while (en.hasMoreElements()) {
/* 1942 */       CatalogEntry e = (CatalogEntry)en.nextElement();
/*      */ 
/* 1944 */       if (e.getEntryType() == DELEGATE_URI) {
/* 1945 */         String p = e.getEntryArg(0);
/* 1946 */         if ((p.length() > uri.length()) || (!p.equals(uri.substring(0, p.length()))))
/*      */         {
/*      */           continue;
/*      */         }
/* 1950 */         delCats.addElement(e.getEntryArg(1));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1955 */     if (delCats.size() > 0) {
/* 1956 */       Enumeration enCats = delCats.elements();
/*      */ 
/* 1958 */       if (this.catalogManager.debug.getDebug() > 1) {
/* 1959 */         this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
/* 1960 */         while (enCats.hasMoreElements()) {
/* 1961 */           String delegatedCatalog = (String)enCats.nextElement();
/* 1962 */           this.catalogManager.debug.message(2, "\t" + delegatedCatalog);
/*      */         }
/*      */       }
/*      */ 
/* 1966 */       Catalog dcat = newCatalog();
/*      */ 
/* 1968 */       enCats = delCats.elements();
/* 1969 */       while (enCats.hasMoreElements()) {
/* 1970 */         String delegatedCatalog = (String)enCats.nextElement();
/* 1971 */         dcat.parseCatalog(delegatedCatalog);
/*      */       }
/*      */ 
/* 1974 */       return dcat.resolveURI(uri);
/*      */     }
/*      */ 
/* 1977 */     return null;
/*      */   }
/*      */ 
/*      */   protected synchronized String resolveSubordinateCatalogs(int entityType, String entityName, String publicId, String systemId)
/*      */     throws MalformedURLException, IOException
/*      */   {
/* 2014 */     for (int catPos = 0; catPos < this.catalogs.size(); catPos++) {
/* 2015 */       Catalog c = null;
/*      */       try
/*      */       {
/* 2018 */         c = (Catalog)this.catalogs.elementAt(catPos);
/*      */       } catch (ClassCastException e) {
/* 2020 */         String catfile = (String)this.catalogs.elementAt(catPos);
/* 2021 */         c = newCatalog();
/*      */         try
/*      */         {
/* 2024 */           c.parseCatalog(catfile);
/*      */         } catch (MalformedURLException mue) {
/* 2026 */           this.catalogManager.debug.message(1, "Malformed Catalog URL", catfile);
/*      */         } catch (FileNotFoundException fnfe) {
/* 2028 */           this.catalogManager.debug.message(1, "Failed to load catalog, file not found", catfile);
/*      */         }
/*      */         catch (IOException ioe) {
/* 2031 */           this.catalogManager.debug.message(1, "Failed to load catalog, I/O error", catfile);
/*      */         }
/*      */ 
/* 2034 */         this.catalogs.setElementAt(c, catPos);
/*      */       }
/*      */ 
/* 2037 */       String resolved = null;
/*      */ 
/* 2040 */       if (entityType == DOCTYPE) {
/* 2041 */         resolved = c.resolveDoctype(entityName, publicId, systemId);
/*      */       }
/* 2044 */       else if (entityType == DOCUMENT)
/* 2045 */         resolved = c.resolveDocument();
/* 2046 */       else if (entityType == ENTITY) {
/* 2047 */         resolved = c.resolveEntity(entityName, publicId, systemId);
/*      */       }
/* 2050 */       else if (entityType == NOTATION) {
/* 2051 */         resolved = c.resolveNotation(entityName, publicId, systemId);
/*      */       }
/* 2054 */       else if (entityType == PUBLIC)
/* 2055 */         resolved = c.resolvePublic(publicId, systemId);
/* 2056 */       else if (entityType == SYSTEM)
/* 2057 */         resolved = c.resolveSystem(systemId);
/* 2058 */       else if (entityType == URI) {
/* 2059 */         resolved = c.resolveURI(systemId);
/*      */       }
/*      */ 
/* 2062 */       if (resolved != null) {
/* 2063 */         return resolved;
/*      */       }
/*      */     }
/*      */ 
/* 2067 */     return null;
/*      */   }
/*      */ 
/*      */   protected String fixSlashes(String sysid)
/*      */   {
/* 2081 */     return sysid.replace('\\', '/');
/*      */   }
/*      */ 
/*      */   protected String makeAbsolute(String sysid)
/*      */   {
/* 2093 */     URL local = null;
/*      */ 
/* 2095 */     sysid = fixSlashes(sysid);
/*      */     try
/*      */     {
/* 2098 */       local = new URL(this.base, sysid);
/*      */     } catch (MalformedURLException e) {
/* 2100 */       this.catalogManager.debug.message(1, "Malformed URL on system identifier", sysid);
/*      */     }
/*      */ 
/* 2103 */     if (local != null) {
/* 2104 */       return local.toString();
/*      */     }
/* 2106 */     return sysid;
/*      */   }
/*      */ 
/*      */   protected String normalizeURI(String uriref)
/*      */   {
/* 2117 */     String newRef = "";
/*      */ 
/* 2120 */     if (uriref == null)
/* 2121 */       return null;
/*      */     byte[] bytes;
/*      */     try {
/* 2125 */       bytes = uriref.getBytes("UTF-8");
/*      */     }
/*      */     catch (UnsupportedEncodingException uee) {
/* 2128 */       this.catalogManager.debug.message(1, "UTF-8 is an unsupported encoding!?");
/* 2129 */       return uriref;
/*      */     }
/*      */ 
/* 2132 */     for (int count = 0; count < bytes.length; count++) {
/* 2133 */       int ch = bytes[count] & 0xFF;
/*      */ 
/* 2135 */       if ((ch <= 32) || (ch > 127) || (ch == 34) || (ch == 60) || (ch == 62) || (ch == 92) || (ch == 94) || (ch == 96) || (ch == 123) || (ch == 124) || (ch == 125) || (ch == 127))
/*      */       {
/* 2147 */         newRef = newRef + encodedByte(ch);
/*      */       }
/* 2149 */       else newRef = newRef + (char)bytes[count];
/*      */ 
/*      */     }
/*      */ 
/* 2153 */     return newRef;
/*      */   }
/*      */ 
/*      */   protected String encodedByte(int b)
/*      */   {
/* 2164 */     String hex = Integer.toHexString(b).toUpperCase();
/* 2165 */     if (hex.length() < 2) {
/* 2166 */       return "%0" + hex;
/*      */     }
/* 2168 */     return "%" + hex;
/*      */   }
/*      */ 
/*      */   protected void addDelegate(CatalogEntry entry)
/*      */   {
/* 2184 */     int pos = 0;
/* 2185 */     String partial = entry.getEntryArg(0);
/*      */ 
/* 2187 */     Enumeration local = this.localDelegate.elements();
/* 2188 */     while (local.hasMoreElements()) {
/* 2189 */       CatalogEntry dpe = (CatalogEntry)local.nextElement();
/* 2190 */       String dp = dpe.getEntryArg(0);
/* 2191 */       if (dp.equals(partial))
/*      */       {
/* 2193 */         return;
/*      */       }
/* 2195 */       if (dp.length() > partial.length()) {
/* 2196 */         pos++;
/*      */       }
/* 2198 */       if (dp.length() < partial.length())
/*      */       {
/*      */         break;
/*      */       }
/*      */     }
/*      */ 
/* 2204 */     if (this.localDelegate.size() == 0)
/* 2205 */       this.localDelegate.addElement(entry);
/*      */     else
/* 2207 */       this.localDelegate.insertElementAt(entry, pos);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.Catalog
 * JD-Core Version:    0.6.0
 */