package org.apache.xerces.parsers;

import java.io.IOException;
import java.util.Locale;
import org.apache.xerces.util.EntityResolver2Wrapper;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.SAXMessageFormatter;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.LocatorImpl;

public abstract class AbstractSAXParser extends AbstractXMLDocumentParser
  implements PSVIProvider, Parser, XMLReader
{
  protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
  protected static final String STRING_INTERNING = "http://xml.org/sax/features/string-interning";
  protected static final String ALLOW_UE_AND_NOTATION_EVENTS = "http://xml.org/sax/features/allow-dtd-events-after-endDTD";
  private static final String[] RECOGNIZED_FEATURES = { "http://xml.org/sax/features/namespaces", "http://xml.org/sax/features/string-interning" };
  protected static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
  protected static final String DECLARATION_HANDLER = "http://xml.org/sax/properties/declaration-handler";
  protected static final String DOM_NODE = "http://xml.org/sax/properties/dom-node";
  private static final String[] RECOGNIZED_PROPERTIES = { "http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/properties/declaration-handler", "http://xml.org/sax/properties/dom-node" };
  protected boolean fNamespaces;
  protected boolean fNamespacePrefixes = false;
  protected boolean fLexicalHandlerParameterEntities = true;
  protected boolean fStandalone;
  protected boolean fResolveDTDURIs = true;
  protected boolean fUseEntityResolver2 = true;
  protected boolean fXMLNSURIs = false;
  protected ContentHandler fContentHandler;
  protected DocumentHandler fDocumentHandler;
  protected NamespaceContext fNamespaceContext;
  protected DTDHandler fDTDHandler;
  protected DeclHandler fDeclHandler;
  protected LexicalHandler fLexicalHandler;
  protected QName fQName = new QName();
  protected boolean fParseInProgress = false;
  protected String fVersion;
  private final AttributesProxy fAttributesProxy = new AttributesProxy();
  private Augmentations fAugmentations = null;
  private static final int BUFFER_SIZE = 20;
  private char[] fCharBuffer = new char[20];
  protected SymbolHash fDeclaredAttrs = null;

  protected AbstractSAXParser(XMLParserConfiguration paramXMLParserConfiguration)
  {
    super(paramXMLParserConfiguration);
    paramXMLParserConfiguration.addRecognizedFeatures(RECOGNIZED_FEATURES);
    paramXMLParserConfiguration.addRecognizedProperties(RECOGNIZED_PROPERTIES);
    try
    {
      paramXMLParserConfiguration.setFeature("http://xml.org/sax/features/allow-dtd-events-after-endDTD", false);
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
    }
  }

  public void startDocument(XMLLocator paramXMLLocator, String paramString, NamespaceContext paramNamespaceContext, Augmentations paramAugmentations)
    throws XNIException
  {
    this.fNamespaceContext = paramNamespaceContext;
    try
    {
      if (this.fDocumentHandler != null)
      {
        if (paramXMLLocator != null)
          this.fDocumentHandler.setDocumentLocator(new LocatorProxy(paramXMLLocator));
        this.fDocumentHandler.startDocument();
      }
      if (this.fContentHandler != null)
      {
        if (paramXMLLocator != null)
          this.fContentHandler.setDocumentLocator(new LocatorProxy(paramXMLLocator));
        this.fContentHandler.startDocument();
      }
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void xmlDecl(String paramString1, String paramString2, String paramString3, Augmentations paramAugmentations)
    throws XNIException
  {
    this.fVersion = paramString1;
    this.fStandalone = "yes".equals(paramString3);
  }

  public void doctypeDecl(String paramString1, String paramString2, String paramString3, Augmentations paramAugmentations)
    throws XNIException
  {
    this.fInDTD = true;
    try
    {
      if (this.fLexicalHandler != null)
        this.fLexicalHandler.startDTD(paramString1, paramString2, paramString3);
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
    if (this.fDeclHandler != null)
      this.fDeclaredAttrs = new SymbolHash();
  }

  public void startGeneralEntity(String paramString1, XMLResourceIdentifier paramXMLResourceIdentifier, String paramString2, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if ((paramAugmentations != null) && (Boolean.TRUE.equals(paramAugmentations.getItem("ENTITY_SKIPPED"))))
      {
        if (this.fContentHandler != null)
          this.fContentHandler.skippedEntity(paramString1);
      }
      else if (this.fLexicalHandler != null)
        this.fLexicalHandler.startEntity(paramString1);
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void endGeneralEntity(String paramString, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (((paramAugmentations == null) || (!Boolean.TRUE.equals(paramAugmentations.getItem("ENTITY_SKIPPED")))) && (this.fLexicalHandler != null))
        this.fLexicalHandler.endEntity(paramString);
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void startElement(QName paramQName, XMLAttributes paramXMLAttributes, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDocumentHandler != null)
      {
        this.fAttributesProxy.setAttributes(paramXMLAttributes);
        this.fDocumentHandler.startElement(paramQName.rawname, this.fAttributesProxy);
      }
      if (this.fContentHandler != null)
      {
        if (this.fNamespaces)
        {
          startNamespaceMapping();
          int i = paramXMLAttributes.getLength();
          int j;
          if (!this.fNamespacePrefixes)
            for (j = i - 1; j >= 0; j--)
            {
              paramXMLAttributes.getName(j, this.fQName);
              if ((this.fQName.prefix != XMLSymbols.PREFIX_XMLNS) && (this.fQName.rawname != XMLSymbols.PREFIX_XMLNS))
                continue;
              paramXMLAttributes.removeAttributeAt(j);
            }
          else if (!this.fXMLNSURIs)
            for (j = i - 1; j >= 0; j--)
            {
              paramXMLAttributes.getName(j, this.fQName);
              if ((this.fQName.prefix != XMLSymbols.PREFIX_XMLNS) && (this.fQName.rawname != XMLSymbols.PREFIX_XMLNS))
                continue;
              this.fQName.prefix = "";
              this.fQName.uri = "";
              this.fQName.localpart = "";
              paramXMLAttributes.setName(j, this.fQName);
            }
        }
        this.fAugmentations = paramAugmentations;
        String str1 = paramQName.uri != null ? paramQName.uri : "";
        String str2 = this.fNamespaces ? paramQName.localpart : "";
        this.fAttributesProxy.setAttributes(paramXMLAttributes);
        this.fContentHandler.startElement(str1, str2, paramQName.rawname, this.fAttributesProxy);
      }
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void characters(XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
    if (paramXMLString.length == 0)
      return;
    try
    {
      if (this.fDocumentHandler != null)
        this.fDocumentHandler.characters(paramXMLString.ch, paramXMLString.offset, paramXMLString.length);
      if (this.fContentHandler != null)
        this.fContentHandler.characters(paramXMLString.ch, paramXMLString.offset, paramXMLString.length);
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void ignorableWhitespace(XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDocumentHandler != null)
        this.fDocumentHandler.ignorableWhitespace(paramXMLString.ch, paramXMLString.offset, paramXMLString.length);
      if (this.fContentHandler != null)
        this.fContentHandler.ignorableWhitespace(paramXMLString.ch, paramXMLString.offset, paramXMLString.length);
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void endElement(QName paramQName, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDocumentHandler != null)
        this.fDocumentHandler.endElement(paramQName.rawname);
      if (this.fContentHandler != null)
      {
        this.fAugmentations = paramAugmentations;
        String str1 = paramQName.uri != null ? paramQName.uri : "";
        String str2 = this.fNamespaces ? paramQName.localpart : "";
        this.fContentHandler.endElement(str1, str2, paramQName.rawname);
        if (this.fNamespaces)
          endNamespaceMapping();
      }
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void startCDATA(Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fLexicalHandler != null)
        this.fLexicalHandler.startCDATA();
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void endCDATA(Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fLexicalHandler != null)
        this.fLexicalHandler.endCDATA();
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void comment(XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fLexicalHandler != null)
        this.fLexicalHandler.comment(paramXMLString.ch, 0, paramXMLString.length);
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void processingInstruction(String paramString, XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDocumentHandler != null)
        this.fDocumentHandler.processingInstruction(paramString, paramXMLString.toString());
      if (this.fContentHandler != null)
        this.fContentHandler.processingInstruction(paramString, paramXMLString.toString());
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void endDocument(Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDocumentHandler != null)
        this.fDocumentHandler.endDocument();
      if (this.fContentHandler != null)
        this.fContentHandler.endDocument();
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void startExternalSubset(XMLResourceIdentifier paramXMLResourceIdentifier, Augmentations paramAugmentations)
    throws XNIException
  {
    startParameterEntity("[dtd]", null, null, paramAugmentations);
  }

  public void endExternalSubset(Augmentations paramAugmentations)
    throws XNIException
  {
    endParameterEntity("[dtd]", paramAugmentations);
  }

  public void startParameterEntity(String paramString1, XMLResourceIdentifier paramXMLResourceIdentifier, String paramString2, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if ((paramAugmentations != null) && (Boolean.TRUE.equals(paramAugmentations.getItem("ENTITY_SKIPPED"))))
      {
        if (this.fContentHandler != null)
          this.fContentHandler.skippedEntity(paramString1);
      }
      else if ((this.fLexicalHandler != null) && (this.fLexicalHandlerParameterEntities))
        this.fLexicalHandler.startEntity(paramString1);
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void endParameterEntity(String paramString, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (((paramAugmentations == null) || (!Boolean.TRUE.equals(paramAugmentations.getItem("ENTITY_SKIPPED")))) && (this.fLexicalHandler != null) && (this.fLexicalHandlerParameterEntities))
        this.fLexicalHandler.endEntity(paramString);
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void elementDecl(String paramString1, String paramString2, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDeclHandler != null)
        this.fDeclHandler.elementDecl(paramString1, paramString2);
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void attributeDecl(String paramString1, String paramString2, String paramString3, String[] paramArrayOfString, String paramString4, XMLString paramXMLString1, XMLString paramXMLString2, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDeclHandler != null)
      {
        String str = paramString1 + "<" + paramString2;
        if (this.fDeclaredAttrs.get(str) != null)
          return;
        this.fDeclaredAttrs.put(str, Boolean.TRUE);
        if ((paramString3.equals("NOTATION")) || (paramString3.equals("ENUMERATION")))
        {
          localObject = new StringBuffer();
          if (paramString3.equals("NOTATION"))
          {
            ((StringBuffer)localObject).append(paramString3);
            ((StringBuffer)localObject).append(" (");
          }
          else
          {
            ((StringBuffer)localObject).append("(");
          }
          for (int i = 0; i < paramArrayOfString.length; i++)
          {
            ((StringBuffer)localObject).append(paramArrayOfString[i]);
            if (i >= paramArrayOfString.length - 1)
              continue;
            ((StringBuffer)localObject).append('|');
          }
          ((StringBuffer)localObject).append(')');
          paramString3 = ((StringBuffer)localObject).toString();
        }
        Object localObject = paramXMLString1 == null ? null : paramXMLString1.toString();
        this.fDeclHandler.attributeDecl(paramString1, paramString2, paramString3, paramString4, (String)localObject);
      }
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void internalEntityDecl(String paramString, XMLString paramXMLString1, XMLString paramXMLString2, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDeclHandler != null)
        this.fDeclHandler.internalEntityDecl(paramString, paramXMLString1.toString());
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void externalEntityDecl(String paramString, XMLResourceIdentifier paramXMLResourceIdentifier, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDeclHandler != null)
      {
        String str1 = paramXMLResourceIdentifier.getPublicId();
        String str2 = this.fResolveDTDURIs ? paramXMLResourceIdentifier.getExpandedSystemId() : paramXMLResourceIdentifier.getLiteralSystemId();
        this.fDeclHandler.externalEntityDecl(paramString, str1, str2);
      }
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void unparsedEntityDecl(String paramString1, XMLResourceIdentifier paramXMLResourceIdentifier, String paramString2, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDTDHandler != null)
      {
        String str1 = paramXMLResourceIdentifier.getPublicId();
        String str2 = this.fResolveDTDURIs ? paramXMLResourceIdentifier.getExpandedSystemId() : paramXMLResourceIdentifier.getLiteralSystemId();
        this.fDTDHandler.unparsedEntityDecl(paramString1, str1, str2, paramString2);
      }
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void notationDecl(String paramString, XMLResourceIdentifier paramXMLResourceIdentifier, Augmentations paramAugmentations)
    throws XNIException
  {
    try
    {
      if (this.fDTDHandler != null)
      {
        String str1 = paramXMLResourceIdentifier.getPublicId();
        String str2 = this.fResolveDTDURIs ? paramXMLResourceIdentifier.getExpandedSystemId() : paramXMLResourceIdentifier.getLiteralSystemId();
        this.fDTDHandler.notationDecl(paramString, str1, str2);
      }
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
  }

  public void endDTD(Augmentations paramAugmentations)
    throws XNIException
  {
    this.fInDTD = false;
    try
    {
      if (this.fLexicalHandler != null)
        this.fLexicalHandler.endDTD();
    }
    catch (SAXException localSAXException)
    {
      throw new XNIException(localSAXException);
    }
    if (this.fDeclaredAttrs != null)
      this.fDeclaredAttrs.clear();
  }

  public void parse(String paramString)
    throws SAXException, IOException
  {
    XMLInputSource localXMLInputSource = new XMLInputSource(null, paramString, null);
    try
    {
      parse(localXMLInputSource);
    }
    catch (XMLParseException localXMLParseException)
    {
      Exception localException = localXMLParseException.getException();
      if (localException == null)
      {
        localObject = new LocatorImpl()
        {
          public String getXMLVersion()
          {
            return AbstractSAXParser.this.fVersion;
          }

          public String getEncoding()
          {
            return null;
          }
        };
        ((LocatorImpl)localObject).setPublicId(localXMLParseException.getPublicId());
        ((LocatorImpl)localObject).setSystemId(localXMLParseException.getExpandedSystemId());
        ((LocatorImpl)localObject).setLineNumber(localXMLParseException.getLineNumber());
        ((LocatorImpl)localObject).setColumnNumber(localXMLParseException.getColumnNumber());
        throw new SAXParseException(localXMLParseException.getMessage(), (Locator)localObject);
      }
      if ((localException instanceof SAXException))
        throw ((SAXException)localException);
      if ((localException instanceof IOException))
        throw ((IOException)localException);
      throw new SAXException(localException);
    }
    catch (XNIException localXNIException)
    {
      Object localObject = localXNIException.getException();
      if (localObject == null)
        throw new SAXException(localXNIException.getMessage());
      if ((localObject instanceof SAXException))
        throw ((SAXException)localObject);
      if ((localObject instanceof IOException))
        throw ((IOException)localObject);
      throw new SAXException((Exception)localObject);
    }
  }

  public void parse(InputSource paramInputSource)
    throws SAXException, IOException
  {
    try
    {
      XMLInputSource localXMLInputSource = new XMLInputSource(paramInputSource.getPublicId(), paramInputSource.getSystemId(), null);
      localXMLInputSource.setByteStream(paramInputSource.getByteStream());
      localXMLInputSource.setCharacterStream(paramInputSource.getCharacterStream());
      localXMLInputSource.setEncoding(paramInputSource.getEncoding());
      parse(localXMLInputSource);
    }
    catch (XMLParseException localXMLParseException)
    {
      Exception localException = localXMLParseException.getException();
      if (localException == null)
      {
        localObject = new LocatorImpl()
        {
          public String getXMLVersion()
          {
            return AbstractSAXParser.this.fVersion;
          }

          public String getEncoding()
          {
            return null;
          }
        };
        ((LocatorImpl)localObject).setPublicId(localXMLParseException.getPublicId());
        ((LocatorImpl)localObject).setSystemId(localXMLParseException.getExpandedSystemId());
        ((LocatorImpl)localObject).setLineNumber(localXMLParseException.getLineNumber());
        ((LocatorImpl)localObject).setColumnNumber(localXMLParseException.getColumnNumber());
        throw new SAXParseException(localXMLParseException.getMessage(), (Locator)localObject);
      }
      if ((localException instanceof SAXException))
        throw ((SAXException)localException);
      if ((localException instanceof IOException))
        throw ((IOException)localException);
      throw new SAXException(localException);
    }
    catch (XNIException localXNIException)
    {
      Object localObject = localXNIException.getException();
      if (localObject == null)
        throw new SAXException(localXNIException.getMessage());
      if ((localObject instanceof SAXException))
        throw ((SAXException)localObject);
      if ((localObject instanceof IOException))
        throw ((IOException)localObject);
      throw new SAXException((Exception)localObject);
    }
  }

  public void setEntityResolver(EntityResolver paramEntityResolver)
  {
    try
    {
      XMLEntityResolver localXMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
      Object localObject;
      if ((this.fUseEntityResolver2) && ((paramEntityResolver instanceof EntityResolver2)))
      {
        if ((localXMLEntityResolver instanceof EntityResolver2Wrapper))
        {
          localObject = (EntityResolver2Wrapper)localXMLEntityResolver;
          ((EntityResolver2Wrapper)localObject).setEntityResolver((EntityResolver2)paramEntityResolver);
        }
        else
        {
          this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolver2Wrapper((EntityResolver2)paramEntityResolver));
        }
      }
      else if ((localXMLEntityResolver instanceof EntityResolverWrapper))
      {
        localObject = (EntityResolverWrapper)localXMLEntityResolver;
        ((EntityResolverWrapper)localObject).setEntityResolver(paramEntityResolver);
      }
      else
      {
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolverWrapper(paramEntityResolver));
      }
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
    }
  }

  public EntityResolver getEntityResolver()
  {
    Object localObject = null;
    try
    {
      XMLEntityResolver localXMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
      if (localXMLEntityResolver != null)
        if ((localXMLEntityResolver instanceof EntityResolverWrapper))
          localObject = ((EntityResolverWrapper)localXMLEntityResolver).getEntityResolver();
        else if ((localXMLEntityResolver instanceof EntityResolver2Wrapper))
          localObject = ((EntityResolver2Wrapper)localXMLEntityResolver).getEntityResolver();
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
    }
    return (EntityResolver)localObject;
  }

  public void setErrorHandler(ErrorHandler paramErrorHandler)
  {
    try
    {
      XMLErrorHandler localXMLErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
      if ((localXMLErrorHandler instanceof ErrorHandlerWrapper))
      {
        ErrorHandlerWrapper localErrorHandlerWrapper = (ErrorHandlerWrapper)localXMLErrorHandler;
        localErrorHandlerWrapper.setErrorHandler(paramErrorHandler);
      }
      else
      {
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", new ErrorHandlerWrapper(paramErrorHandler));
      }
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
    }
  }

  public ErrorHandler getErrorHandler()
  {
    ErrorHandler localErrorHandler = null;
    try
    {
      XMLErrorHandler localXMLErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
      if ((localXMLErrorHandler != null) && ((localXMLErrorHandler instanceof ErrorHandlerWrapper)))
        localErrorHandler = ((ErrorHandlerWrapper)localXMLErrorHandler).getErrorHandler();
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
    }
    return localErrorHandler;
  }

  public void setLocale(Locale paramLocale)
    throws SAXException
  {
    this.fConfiguration.setLocale(paramLocale);
  }

  public void setDTDHandler(DTDHandler paramDTDHandler)
  {
    this.fDTDHandler = paramDTDHandler;
  }

  public void setDocumentHandler(DocumentHandler paramDocumentHandler)
  {
    this.fDocumentHandler = paramDocumentHandler;
  }

  public void setContentHandler(ContentHandler paramContentHandler)
  {
    this.fContentHandler = paramContentHandler;
  }

  public ContentHandler getContentHandler()
  {
    return this.fContentHandler;
  }

  public DTDHandler getDTDHandler()
  {
    return this.fDTDHandler;
  }

  public void setFeature(String paramString, boolean paramBoolean)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    try
    {
      if (paramString.startsWith("http://xml.org/sax/features/"))
      {
        int i = paramString.length() - "http://xml.org/sax/features/".length();
        if ((i == "namespaces".length()) && (paramString.endsWith("namespaces")))
        {
          this.fConfiguration.setFeature(paramString, paramBoolean);
          this.fNamespaces = paramBoolean;
          return;
        }
        if ((i == "namespace-prefixes".length()) && (paramString.endsWith("namespace-prefixes")))
        {
          this.fNamespacePrefixes = paramBoolean;
          return;
        }
        if ((i == "string-interning".length()) && (paramString.endsWith("string-interning")))
        {
          if (!paramBoolean)
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "false-not-supported", new Object[] { paramString }));
          return;
        }
        if ((i == "lexical-handler/parameter-entities".length()) && (paramString.endsWith("lexical-handler/parameter-entities")))
        {
          this.fLexicalHandlerParameterEntities = paramBoolean;
          return;
        }
        if ((i == "resolve-dtd-uris".length()) && (paramString.endsWith("resolve-dtd-uris")))
        {
          this.fResolveDTDURIs = paramBoolean;
          return;
        }
        if ((i == "unicode-normalization-checking".length()) && (paramString.endsWith("unicode-normalization-checking")))
        {
          if (paramBoolean)
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "true-not-supported", new Object[] { paramString }));
          return;
        }
        if ((i == "xmlns-uris".length()) && (paramString.endsWith("xmlns-uris")))
        {
          this.fXMLNSURIs = paramBoolean;
          return;
        }
        if ((i == "use-entity-resolver2".length()) && (paramString.endsWith("use-entity-resolver2")))
        {
          if (paramBoolean != this.fUseEntityResolver2)
          {
            this.fUseEntityResolver2 = paramBoolean;
            setEntityResolver(getEntityResolver());
          }
          return;
        }
        if (((i == "is-standalone".length()) && (paramString.endsWith("is-standalone"))) || ((i == "use-attributes2".length()) && (paramString.endsWith("use-attributes2"))) || ((i == "use-locator2".length()) && (paramString.endsWith("use-locator2"))) || ((i == "xml-1.1".length()) && (paramString.endsWith("xml-1.1"))))
          throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-read-only", new Object[] { paramString }));
      }
      this.fConfiguration.setFeature(paramString, paramBoolean);
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
      String str = localXMLConfigurationException.getIdentifier();
      if (localXMLConfigurationException.getType() == 0)
        throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-recognized", new Object[] { str }));
      throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-supported", new Object[] { str }));
    }
  }

  public boolean getFeature(String paramString)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    // Byte code:
    //   0: aload_1
    //   1: ldc 166
    //   3: invokevirtual 167	java/lang/String:startsWith	(Ljava/lang/String;)Z
    //   6: ifeq +256 -> 262
    //   9: aload_1
    //   10: invokevirtual 168	java/lang/String:length	()I
    //   13: ldc 166
    //   15: invokevirtual 168	java/lang/String:length	()I
    //   18: isub
    //   19: istore_2
    //   20: iload_2
    //   21: ldc 171
    //   23: invokevirtual 168	java/lang/String:length	()I
    //   26: if_icmpne +17 -> 43
    //   29: aload_1
    //   30: ldc 171
    //   32: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   35: ifeq +8 -> 43
    //   38: aload_0
    //   39: getfield 2	org/apache/xerces/parsers/AbstractSAXParser:fNamespacePrefixes	Z
    //   42: ireturn
    //   43: iload_2
    //   44: ldc 172
    //   46: invokevirtual 168	java/lang/String:length	()I
    //   49: if_icmpne +14 -> 63
    //   52: aload_1
    //   53: ldc 172
    //   55: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   58: ifeq +5 -> 63
    //   61: iconst_1
    //   62: ireturn
    //   63: iload_2
    //   64: ldc 187
    //   66: invokevirtual 168	java/lang/String:length	()I
    //   69: if_icmpne +17 -> 86
    //   72: aload_1
    //   73: ldc 187
    //   75: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   78: ifeq +8 -> 86
    //   81: aload_0
    //   82: getfield 39	org/apache/xerces/parsers/AbstractSAXParser:fStandalone	Z
    //   85: ireturn
    //   86: iload_2
    //   87: ldc 190
    //   89: invokevirtual 168	java/lang/String:length	()I
    //   92: if_icmpne +20 -> 112
    //   95: aload_1
    //   96: ldc 190
    //   98: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   101: ifeq +11 -> 112
    //   104: aload_0
    //   105: getfield 145	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   108: instanceof 198
    //   111: ireturn
    //   112: iload_2
    //   113: ldc 179
    //   115: invokevirtual 168	java/lang/String:length	()I
    //   118: if_icmpne +17 -> 135
    //   121: aload_1
    //   122: ldc 179
    //   124: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   127: ifeq +8 -> 135
    //   130: aload_0
    //   131: getfield 3	org/apache/xerces/parsers/AbstractSAXParser:fLexicalHandlerParameterEntities	Z
    //   134: ireturn
    //   135: iload_2
    //   136: ldc 180
    //   138: invokevirtual 168	java/lang/String:length	()I
    //   141: if_icmpne +17 -> 158
    //   144: aload_1
    //   145: ldc 180
    //   147: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   150: ifeq +8 -> 158
    //   153: aload_0
    //   154: getfield 4	org/apache/xerces/parsers/AbstractSAXParser:fResolveDTDURIs	Z
    //   157: ireturn
    //   158: iload_2
    //   159: ldc 183
    //   161: invokevirtual 168	java/lang/String:length	()I
    //   164: if_icmpne +17 -> 181
    //   167: aload_1
    //   168: ldc 183
    //   170: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   173: ifeq +8 -> 181
    //   176: aload_0
    //   177: getfield 6	org/apache/xerces/parsers/AbstractSAXParser:fXMLNSURIs	Z
    //   180: ireturn
    //   181: iload_2
    //   182: ldc 181
    //   184: invokevirtual 168	java/lang/String:length	()I
    //   187: if_icmpne +14 -> 201
    //   190: aload_1
    //   191: ldc 181
    //   193: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   196: ifeq +5 -> 201
    //   199: iconst_0
    //   200: ireturn
    //   201: iload_2
    //   202: ldc 184
    //   204: invokevirtual 168	java/lang/String:length	()I
    //   207: if_icmpne +17 -> 224
    //   210: aload_1
    //   211: ldc 184
    //   213: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   216: ifeq +8 -> 224
    //   219: aload_0
    //   220: getfield 5	org/apache/xerces/parsers/AbstractSAXParser:fUseEntityResolver2	Z
    //   223: ireturn
    //   224: iload_2
    //   225: ldc 188
    //   227: invokevirtual 168	java/lang/String:length	()I
    //   230: if_icmpne +12 -> 242
    //   233: aload_1
    //   234: ldc 188
    //   236: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   239: ifne +21 -> 260
    //   242: iload_2
    //   243: ldc 189
    //   245: invokevirtual 168	java/lang/String:length	()I
    //   248: if_icmpne +14 -> 262
    //   251: aload_1
    //   252: ldc 189
    //   254: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   257: ifeq +5 -> 262
    //   260: iconst_1
    //   261: ireturn
    //   262: aload_0
    //   263: getfield 145	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   266: aload_1
    //   267: invokeinterface 199 2 0
    //   272: ireturn
    //   273: astore_2
    //   274: aload_2
    //   275: invokevirtual 192	org/apache/xerces/xni/parser/XMLConfigurationException:getIdentifier	()Ljava/lang/String;
    //   278: astore_3
    //   279: aload_2
    //   280: invokevirtual 193	org/apache/xerces/xni/parser/XMLConfigurationException:getType	()S
    //   283: ifne +33 -> 316
    //   286: new 194	org/xml/sax/SAXNotRecognizedException
    //   289: dup
    //   290: aload_0
    //   291: getfield 145	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   294: invokeinterface 174 1 0
    //   299: ldc 195
    //   301: iconst_1
    //   302: anewarray 176	java/lang/Object
    //   305: dup
    //   306: iconst_0
    //   307: aload_3
    //   308: aastore
    //   309: invokestatic 177	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   312: invokespecial 196	org/xml/sax/SAXNotRecognizedException:<init>	(Ljava/lang/String;)V
    //   315: athrow
    //   316: new 173	org/xml/sax/SAXNotSupportedException
    //   319: dup
    //   320: aload_0
    //   321: getfield 145	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   324: invokeinterface 174 1 0
    //   329: ldc 197
    //   331: iconst_1
    //   332: anewarray 176	java/lang/Object
    //   335: dup
    //   336: iconst_0
    //   337: aload_3
    //   338: aastore
    //   339: invokestatic 177	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   342: invokespecial 178	org/xml/sax/SAXNotSupportedException:<init>	(Ljava/lang/String;)V
    //   345: athrow
    //
    // Exception table:
    //   from	to	target	type
    //   0	273	273	org/apache/xerces/xni/parser/XMLConfigurationException
  }

  public void setProperty(String paramString, Object paramObject)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    try
    {
      if (paramString.startsWith("http://xml.org/sax/properties/"))
      {
        int i = paramString.length() - "http://xml.org/sax/properties/".length();
        if ((i == "lexical-handler".length()) && (paramString.endsWith("lexical-handler")))
        {
          try
          {
            setLexicalHandler((LexicalHandler)paramObject);
          }
          catch (ClassCastException localClassCastException1)
          {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "incompatible-class", new Object[] { paramString, "org.xml.sax.ext.LexicalHandler" }));
          }
          return;
        }
        if ((i == "declaration-handler".length()) && (paramString.endsWith("declaration-handler")))
        {
          try
          {
            setDeclHandler((DeclHandler)paramObject);
          }
          catch (ClassCastException localClassCastException2)
          {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "incompatible-class", new Object[] { paramString, "org.xml.sax.ext.DeclHandler" }));
          }
          return;
        }
        if (((i == "dom-node".length()) && (paramString.endsWith("dom-node"))) || ((i == "document-xml-version".length()) && (paramString.endsWith("document-xml-version"))))
          throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-read-only", new Object[] { paramString }));
      }
      this.fConfiguration.setProperty(paramString, paramObject);
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
      String str = localXMLConfigurationException.getIdentifier();
      if (localXMLConfigurationException.getType() == 0)
        throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-recognized", new Object[] { str }));
      throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-supported", new Object[] { str }));
    }
  }

  public Object getProperty(String paramString)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    // Byte code:
    //   0: aload_1
    //   1: ldc 200
    //   3: invokevirtual 167	java/lang/String:startsWith	(Ljava/lang/String;)Z
    //   6: ifeq +124 -> 130
    //   9: aload_1
    //   10: invokevirtual 168	java/lang/String:length	()I
    //   13: ldc 200
    //   15: invokevirtual 168	java/lang/String:length	()I
    //   18: isub
    //   19: istore_2
    //   20: iload_2
    //   21: ldc 212
    //   23: invokevirtual 168	java/lang/String:length	()I
    //   26: if_icmpne +17 -> 43
    //   29: aload_1
    //   30: ldc 212
    //   32: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   35: ifeq +8 -> 43
    //   38: aload_0
    //   39: getfield 36	org/apache/xerces/parsers/AbstractSAXParser:fVersion	Ljava/lang/String;
    //   42: areturn
    //   43: iload_2
    //   44: ldc 201
    //   46: invokevirtual 168	java/lang/String:length	()I
    //   49: if_icmpne +17 -> 66
    //   52: aload_1
    //   53: ldc 201
    //   55: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   58: ifeq +8 -> 66
    //   61: aload_0
    //   62: invokevirtual 216	org/apache/xerces/parsers/AbstractSAXParser:getLexicalHandler	()Lorg/xml/sax/ext/LexicalHandler;
    //   65: areturn
    //   66: iload_2
    //   67: ldc 207
    //   69: invokevirtual 168	java/lang/String:length	()I
    //   72: if_icmpne +17 -> 89
    //   75: aload_1
    //   76: ldc 207
    //   78: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   81: ifeq +8 -> 89
    //   84: aload_0
    //   85: invokevirtual 217	org/apache/xerces/parsers/AbstractSAXParser:getDeclHandler	()Lorg/xml/sax/ext/DeclHandler;
    //   88: areturn
    //   89: iload_2
    //   90: ldc 211
    //   92: invokevirtual 168	java/lang/String:length	()I
    //   95: if_icmpne +35 -> 130
    //   98: aload_1
    //   99: ldc 211
    //   101: invokevirtual 170	java/lang/String:endsWith	(Ljava/lang/String;)Z
    //   104: ifeq +26 -> 130
    //   107: new 173	org/xml/sax/SAXNotSupportedException
    //   110: dup
    //   111: aload_0
    //   112: getfield 145	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   115: invokeinterface 174 1 0
    //   120: ldc 218
    //   122: aconst_null
    //   123: invokestatic 177	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   126: invokespecial 178	org/xml/sax/SAXNotSupportedException:<init>	(Ljava/lang/String;)V
    //   129: athrow
    //   130: aload_0
    //   131: getfield 145	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   134: aload_1
    //   135: invokeinterface 147 2 0
    //   140: areturn
    //   141: astore_2
    //   142: aload_2
    //   143: invokevirtual 192	org/apache/xerces/xni/parser/XMLConfigurationException:getIdentifier	()Ljava/lang/String;
    //   146: astore_3
    //   147: aload_2
    //   148: invokevirtual 193	org/apache/xerces/xni/parser/XMLConfigurationException:getType	()S
    //   151: ifne +33 -> 184
    //   154: new 194	org/xml/sax/SAXNotRecognizedException
    //   157: dup
    //   158: aload_0
    //   159: getfield 145	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   162: invokeinterface 174 1 0
    //   167: ldc 214
    //   169: iconst_1
    //   170: anewarray 176	java/lang/Object
    //   173: dup
    //   174: iconst_0
    //   175: aload_3
    //   176: aastore
    //   177: invokestatic 177	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   180: invokespecial 196	org/xml/sax/SAXNotRecognizedException:<init>	(Ljava/lang/String;)V
    //   183: athrow
    //   184: new 173	org/xml/sax/SAXNotSupportedException
    //   187: dup
    //   188: aload_0
    //   189: getfield 145	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   192: invokeinterface 174 1 0
    //   197: ldc 215
    //   199: iconst_1
    //   200: anewarray 176	java/lang/Object
    //   203: dup
    //   204: iconst_0
    //   205: aload_3
    //   206: aastore
    //   207: invokestatic 177	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   210: invokespecial 178	org/xml/sax/SAXNotSupportedException:<init>	(Ljava/lang/String;)V
    //   213: athrow
    //
    // Exception table:
    //   from	to	target	type
    //   0	141	141	org/apache/xerces/xni/parser/XMLConfigurationException
  }

  protected void setDeclHandler(DeclHandler paramDeclHandler)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    if (this.fParseInProgress)
      throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-parsing-supported", new Object[] { "http://xml.org/sax/properties/declaration-handler" }));
    this.fDeclHandler = paramDeclHandler;
  }

  protected DeclHandler getDeclHandler()
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    return this.fDeclHandler;
  }

  protected void setLexicalHandler(LexicalHandler paramLexicalHandler)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    if (this.fParseInProgress)
      throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-parsing-supported", new Object[] { "http://xml.org/sax/properties/lexical-handler" }));
    this.fLexicalHandler = paramLexicalHandler;
  }

  protected LexicalHandler getLexicalHandler()
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    return this.fLexicalHandler;
  }

  protected final void startNamespaceMapping()
    throws SAXException
  {
    int i = this.fNamespaceContext.getDeclaredPrefixCount();
    if (i > 0)
    {
      String str1 = null;
      String str2 = null;
      for (int j = 0; j < i; j++)
      {
        str1 = this.fNamespaceContext.getDeclaredPrefixAt(j);
        str2 = this.fNamespaceContext.getURI(str1);
        this.fContentHandler.startPrefixMapping(str1, str2 == null ? "" : str2);
      }
    }
  }

  protected final void endNamespaceMapping()
    throws SAXException
  {
    int i = this.fNamespaceContext.getDeclaredPrefixCount();
    if (i > 0)
      for (int j = 0; j < i; j++)
        this.fContentHandler.endPrefixMapping(this.fNamespaceContext.getDeclaredPrefixAt(j));
  }

  public void reset()
    throws XNIException
  {
    super.reset();
    this.fInDTD = false;
    this.fVersion = "1.0";
    this.fStandalone = false;
    this.fNamespaces = this.fConfiguration.getFeature("http://xml.org/sax/features/namespaces");
    this.fAugmentations = null;
    this.fDeclaredAttrs = null;
  }

  public ElementPSVI getElementPSVI()
  {
    return this.fAugmentations != null ? (ElementPSVI)this.fAugmentations.getItem("ELEMENT_PSVI") : null;
  }

  public AttributePSVI getAttributePSVI(int paramInt)
  {
    return (AttributePSVI)this.fAttributesProxy.fAttributes.getAugmentations(paramInt).getItem("ATTRIBUTE_PSVI");
  }

  public AttributePSVI getAttributePSVIByName(String paramString1, String paramString2)
  {
    return (AttributePSVI)this.fAttributesProxy.fAttributes.getAugmentations(paramString1, paramString2).getItem("ATTRIBUTE_PSVI");
  }

  protected static final class AttributesProxy
    implements AttributeList, Attributes2
  {
    protected XMLAttributes fAttributes;

    public void setAttributes(XMLAttributes paramXMLAttributes)
    {
      this.fAttributes = paramXMLAttributes;
    }

    public int getLength()
    {
      return this.fAttributes.getLength();
    }

    public String getName(int paramInt)
    {
      return this.fAttributes.getQName(paramInt);
    }

    public String getQName(int paramInt)
    {
      return this.fAttributes.getQName(paramInt);
    }

    public String getURI(int paramInt)
    {
      String str = this.fAttributes.getURI(paramInt);
      return str != null ? str : "";
    }

    public String getLocalName(int paramInt)
    {
      return this.fAttributes.getLocalName(paramInt);
    }

    public String getType(int paramInt)
    {
      return this.fAttributes.getType(paramInt);
    }

    public String getType(String paramString)
    {
      return this.fAttributes.getType(paramString);
    }

    public String getType(String paramString1, String paramString2)
    {
      return paramString1.equals("") ? this.fAttributes.getType(null, paramString2) : this.fAttributes.getType(paramString1, paramString2);
    }

    public String getValue(int paramInt)
    {
      return this.fAttributes.getValue(paramInt);
    }

    public String getValue(String paramString)
    {
      return this.fAttributes.getValue(paramString);
    }

    public String getValue(String paramString1, String paramString2)
    {
      return paramString1.equals("") ? this.fAttributes.getValue(null, paramString2) : this.fAttributes.getValue(paramString1, paramString2);
    }

    public int getIndex(String paramString)
    {
      return this.fAttributes.getIndex(paramString);
    }

    public int getIndex(String paramString1, String paramString2)
    {
      return paramString1.equals("") ? this.fAttributes.getIndex(null, paramString2) : this.fAttributes.getIndex(paramString1, paramString2);
    }

    public boolean isDeclared(int paramInt)
    {
      if ((paramInt < 0) || (paramInt >= this.fAttributes.getLength()))
        throw new ArrayIndexOutOfBoundsException(paramInt);
      return Boolean.TRUE.equals(this.fAttributes.getAugmentations(paramInt).getItem("ATTRIBUTE_DECLARED"));
    }

    public boolean isDeclared(String paramString)
    {
      int i = getIndex(paramString);
      if (i == -1)
        throw new IllegalArgumentException(paramString);
      return Boolean.TRUE.equals(this.fAttributes.getAugmentations(i).getItem("ATTRIBUTE_DECLARED"));
    }

    public boolean isDeclared(String paramString1, String paramString2)
    {
      int i = getIndex(paramString1, paramString2);
      if (i == -1)
        throw new IllegalArgumentException(paramString2);
      return Boolean.TRUE.equals(this.fAttributes.getAugmentations(i).getItem("ATTRIBUTE_DECLARED"));
    }

    public boolean isSpecified(int paramInt)
    {
      if ((paramInt < 0) || (paramInt >= this.fAttributes.getLength()))
        throw new ArrayIndexOutOfBoundsException(paramInt);
      return this.fAttributes.isSpecified(paramInt);
    }

    public boolean isSpecified(String paramString)
    {
      int i = getIndex(paramString);
      if (i == -1)
        throw new IllegalArgumentException(paramString);
      return this.fAttributes.isSpecified(i);
    }

    public boolean isSpecified(String paramString1, String paramString2)
    {
      int i = getIndex(paramString1, paramString2);
      if (i == -1)
        throw new IllegalArgumentException(paramString2);
      return this.fAttributes.isSpecified(i);
    }
  }

  protected class LocatorProxy
    implements Locator2
  {
    protected XMLLocator fLocator;

    public LocatorProxy(XMLLocator arg2)
    {
      Object localObject;
      this.fLocator = localObject;
    }

    public String getPublicId()
    {
      return this.fLocator.getPublicId();
    }

    public String getSystemId()
    {
      return this.fLocator.getExpandedSystemId();
    }

    public int getLineNumber()
    {
      return this.fLocator.getLineNumber();
    }

    public int getColumnNumber()
    {
      return this.fLocator.getColumnNumber();
    }

    public String getXMLVersion()
    {
      return this.fLocator.getXMLVersion();
    }

    public String getEncoding()
    {
      return this.fLocator.getEncoding();
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.parsers.AbstractSAXParser
 * JD-Core Version:    0.6.0
 */