package org.apache.xerces.jaxp.validation;

import java.io.IOException;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import org.apache.xerces.util.SAXMessageFormatter;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ElementPSVI;
import org.apache.xerces.xs.PSVIProvider;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

final class ValidatorImpl extends Validator
  implements PSVIProvider
{
  private static final String CURRENT_ELEMENT_NODE = "http://apache.org/xml/properties/dom/current-element-node";
  private XMLSchemaValidatorComponentManager fComponentManager;
  private ValidatorHandlerImpl fSAXValidatorHelper;
  private DOMValidatorHelper fDOMValidatorHelper;
  private StreamValidatorHelper fStreamValidatorHelper;
  private boolean fConfigurationChanged = false;
  private boolean fErrorHandlerChanged = false;
  private boolean fResourceResolverChanged = false;

  public ValidatorImpl(XSGrammarPoolContainer paramXSGrammarPoolContainer)
  {
    this.fComponentManager = new XMLSchemaValidatorComponentManager(paramXSGrammarPoolContainer);
    setErrorHandler(null);
    setResourceResolver(null);
  }

  public void validate(Source paramSource, Result paramResult)
    throws SAXException, IOException
  {
    if ((paramSource instanceof SAXSource))
    {
      if (this.fSAXValidatorHelper == null)
        this.fSAXValidatorHelper = new ValidatorHandlerImpl(this.fComponentManager);
      this.fSAXValidatorHelper.validate(paramSource, paramResult);
    }
    else if ((paramSource instanceof DOMSource))
    {
      if (this.fDOMValidatorHelper == null)
        this.fDOMValidatorHelper = new DOMValidatorHelper(this.fComponentManager);
      this.fDOMValidatorHelper.validate(paramSource, paramResult);
    }
    else if ((paramSource instanceof StreamSource))
    {
      if (this.fStreamValidatorHelper == null)
        this.fStreamValidatorHelper = new StreamValidatorHelper(this.fComponentManager);
      this.fStreamValidatorHelper.validate(paramSource, paramResult);
    }
    else
    {
      if (paramSource == null)
        throw new NullPointerException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "SourceParameterNull", null));
      throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(Locale.getDefault(), "SourceNotAccepted", new Object[] { paramSource.getClass().getName() }));
    }
  }

  public void setErrorHandler(ErrorHandler paramErrorHandler)
  {
    this.fErrorHandlerChanged = (paramErrorHandler != null);
    this.fComponentManager.setErrorHandler(paramErrorHandler);
  }

  public ErrorHandler getErrorHandler()
  {
    return this.fComponentManager.getErrorHandler();
  }

  public void setResourceResolver(LSResourceResolver paramLSResourceResolver)
  {
    this.fResourceResolverChanged = (paramLSResourceResolver != null);
    this.fComponentManager.setResourceResolver(paramLSResourceResolver);
  }

  public LSResourceResolver getResourceResolver()
  {
    return this.fComponentManager.getResourceResolver();
  }

  public boolean getFeature(String paramString)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    // Byte code:
    //   0: aload_1
    //   1: ifnonnull +11 -> 12
    //   4: new 25	java/lang/NullPointerException
    //   7: dup
    //   8: invokespecial 40	java/lang/NullPointerException:<init>	()V
    //   11: athrow
    //   12: aload_0
    //   13: getfield 7	org/apache/xerces/jaxp/validation/ValidatorImpl:fComponentManager	Lorg/apache/xerces/jaxp/validation/XMLSchemaValidatorComponentManager;
    //   16: aload_1
    //   17: invokevirtual 41	org/apache/xerces/jaxp/validation/XMLSchemaValidatorComponentManager:getFeature	(Ljava/lang/String;)Z
    //   20: ireturn
    //   21: astore_2
    //   22: aload_2
    //   23: invokevirtual 43	org/apache/xerces/xni/parser/XMLConfigurationException:getIdentifier	()Ljava/lang/String;
    //   26: astore_3
    //   27: aload_2
    //   28: invokevirtual 44	org/apache/xerces/xni/parser/XMLConfigurationException:getType	()S
    //   31: ifne +8 -> 39
    //   34: ldc 45
    //   36: goto +5 -> 41
    //   39: ldc 46
    //   41: astore 4
    //   43: new 47	org/xml/sax/SAXNotRecognizedException
    //   46: dup
    //   47: invokestatic 26	java/util/Locale:getDefault	()Ljava/util/Locale;
    //   50: aload 4
    //   52: iconst_1
    //   53: anewarray 32	java/lang/Object
    //   56: dup
    //   57: iconst_0
    //   58: aload_3
    //   59: aastore
    //   60: invokestatic 48	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   63: invokespecial 49	org/xml/sax/SAXNotRecognizedException:<init>	(Ljava/lang/String;)V
    //   66: athrow
    //
    // Exception table:
    //   from	to	target	type
    //   12	21	21	org/apache/xerces/xni/parser/XMLConfigurationException
  }

  public void setFeature(String paramString, boolean paramBoolean)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    if (paramString == null)
      throw new NullPointerException();
    try
    {
      this.fComponentManager.setFeature(paramString, paramBoolean);
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
      String str1 = localXMLConfigurationException.getIdentifier();
      String str2 = localXMLConfigurationException.getType() == 0 ? "feature-not-recognized" : "feature-not-supported";
      throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), str2, new Object[] { str1 }));
    }
    this.fConfigurationChanged = true;
  }

  public Object getProperty(String paramString)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    // Byte code:
    //   0: aload_1
    //   1: ifnonnull +11 -> 12
    //   4: new 25	java/lang/NullPointerException
    //   7: dup
    //   8: invokespecial 40	java/lang/NullPointerException:<init>	()V
    //   11: athrow
    //   12: ldc 51
    //   14: aload_1
    //   15: invokevirtual 52	java/lang/String:equals	(Ljava/lang/Object;)Z
    //   18: ifeq +22 -> 40
    //   21: aload_0
    //   22: getfield 16	org/apache/xerces/jaxp/validation/ValidatorImpl:fDOMValidatorHelper	Lorg/apache/xerces/jaxp/validation/DOMValidatorHelper;
    //   25: ifnull +13 -> 38
    //   28: aload_0
    //   29: getfield 16	org/apache/xerces/jaxp/validation/ValidatorImpl:fDOMValidatorHelper	Lorg/apache/xerces/jaxp/validation/DOMValidatorHelper;
    //   32: invokevirtual 53	org/apache/xerces/jaxp/validation/DOMValidatorHelper:getCurrentElement	()Lorg/w3c/dom/Node;
    //   35: goto +4 -> 39
    //   38: aconst_null
    //   39: areturn
    //   40: aload_0
    //   41: getfield 7	org/apache/xerces/jaxp/validation/ValidatorImpl:fComponentManager	Lorg/apache/xerces/jaxp/validation/XMLSchemaValidatorComponentManager;
    //   44: aload_1
    //   45: invokevirtual 54	org/apache/xerces/jaxp/validation/XMLSchemaValidatorComponentManager:getProperty	(Ljava/lang/String;)Ljava/lang/Object;
    //   48: areturn
    //   49: astore_2
    //   50: aload_2
    //   51: invokevirtual 43	org/apache/xerces/xni/parser/XMLConfigurationException:getIdentifier	()Ljava/lang/String;
    //   54: astore_3
    //   55: aload_2
    //   56: invokevirtual 44	org/apache/xerces/xni/parser/XMLConfigurationException:getType	()S
    //   59: ifne +8 -> 67
    //   62: ldc 55
    //   64: goto +5 -> 69
    //   67: ldc 56
    //   69: astore 4
    //   71: new 47	org/xml/sax/SAXNotRecognizedException
    //   74: dup
    //   75: invokestatic 26	java/util/Locale:getDefault	()Ljava/util/Locale;
    //   78: aload 4
    //   80: iconst_1
    //   81: anewarray 32	java/lang/Object
    //   84: dup
    //   85: iconst_0
    //   86: aload_3
    //   87: aastore
    //   88: invokestatic 48	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   91: invokespecial 49	org/xml/sax/SAXNotRecognizedException:<init>	(Ljava/lang/String;)V
    //   94: athrow
    //
    // Exception table:
    //   from	to	target	type
    //   40	49	49	org/apache/xerces/xni/parser/XMLConfigurationException
  }

  public void setProperty(String paramString, Object paramObject)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    if (paramString == null)
      throw new NullPointerException();
    if ("http://apache.org/xml/properties/dom/current-element-node".equals(paramString))
      throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), "property-read-only", new Object[] { paramString }));
    try
    {
      this.fComponentManager.setProperty(paramString, paramObject);
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
      String str1 = localXMLConfigurationException.getIdentifier();
      String str2 = localXMLConfigurationException.getType() == 0 ? "property-not-recognized" : "property-not-supported";
      throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(Locale.getDefault(), str2, new Object[] { str1 }));
    }
    this.fConfigurationChanged = true;
  }

  public void reset()
  {
    if (this.fConfigurationChanged)
    {
      this.fComponentManager.restoreInitialState();
      setErrorHandler(null);
      setResourceResolver(null);
      this.fConfigurationChanged = false;
      this.fErrorHandlerChanged = false;
      this.fResourceResolverChanged = false;
    }
    else
    {
      if (this.fErrorHandlerChanged)
      {
        setErrorHandler(null);
        this.fErrorHandlerChanged = false;
      }
      if (this.fResourceResolverChanged)
      {
        setResourceResolver(null);
        this.fResourceResolverChanged = false;
      }
    }
  }

  public ElementPSVI getElementPSVI()
  {
    return this.fSAXValidatorHelper != null ? this.fSAXValidatorHelper.getElementPSVI() : null;
  }

  public AttributePSVI getAttributePSVI(int paramInt)
  {
    return this.fSAXValidatorHelper != null ? this.fSAXValidatorHelper.getAttributePSVI(paramInt) : null;
  }

  public AttributePSVI getAttributePSVIByName(String paramString1, String paramString2)
  {
    return this.fSAXValidatorHelper != null ? this.fSAXValidatorHelper.getAttributePSVIByName(paramString1, paramString2) : null;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.jaxp.validation.ValidatorImpl
 * JD-Core Version:    0.6.0
 */