package org.apache.xerces.impl.xs;

import org.apache.xerces.util.XMLResourceIdentifierImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.grammars.XMLSchemaDescription;

public class XSDDescription extends XMLResourceIdentifierImpl
  implements XMLSchemaDescription
{
  public static final short CONTEXT_INITIALIZE = -1;
  public static final short CONTEXT_INCLUDE = 0;
  public static final short CONTEXT_REDEFINE = 1;
  public static final short CONTEXT_IMPORT = 2;
  public static final short CONTEXT_PREPARSE = 3;
  public static final short CONTEXT_INSTANCE = 4;
  public static final short CONTEXT_ELEMENT = 5;
  public static final short CONTEXT_ATTRIBUTE = 6;
  public static final short CONTEXT_XSITYPE = 7;
  protected short fContextType;
  protected String[] fLocationHints;
  protected QName fTriggeringComponent;
  protected QName fEnclosedElementName;
  protected XMLAttributes fAttributes;

  public String getGrammarType()
  {
    return "http://www.w3.org/2001/XMLSchema";
  }

  public short getContextType()
  {
    return this.fContextType;
  }

  public String getTargetNamespace()
  {
    return this.fNamespace;
  }

  public String[] getLocationHints()
  {
    return this.fLocationHints;
  }

  public QName getTriggeringComponent()
  {
    return this.fTriggeringComponent;
  }

  public QName getEnclosingElementName()
  {
    return this.fEnclosedElementName;
  }

  public XMLAttributes getAttributes()
  {
    return this.fAttributes;
  }

  public boolean fromInstance()
  {
    return (this.fContextType == 6) || (this.fContextType == 5) || (this.fContextType == 4) || (this.fContextType == 7);
  }

  public boolean equals(Object paramObject)
  {
    if (!(paramObject instanceof XMLSchemaDescription))
      return false;
    XMLSchemaDescription localXMLSchemaDescription = (XMLSchemaDescription)paramObject;
    if (this.fNamespace != null)
      return this.fNamespace.equals(localXMLSchemaDescription.getTargetNamespace());
    return localXMLSchemaDescription.getTargetNamespace() == null;
  }

  public int hashCode()
  {
    return this.fNamespace == null ? 0 : this.fNamespace.hashCode();
  }

  public void setContextType(short paramShort)
  {
    this.fContextType = paramShort;
  }

  public void setTargetNamespace(String paramString)
  {
    this.fNamespace = paramString;
  }

  public void setLocationHints(String[] paramArrayOfString)
  {
    int i = paramArrayOfString.length;
    this.fLocationHints = new String[i];
    System.arraycopy(paramArrayOfString, 0, this.fLocationHints, 0, i);
  }

  public void setTriggeringComponent(QName paramQName)
  {
    this.fTriggeringComponent = paramQName;
  }

  public void setEnclosingElementName(QName paramQName)
  {
    this.fEnclosedElementName = paramQName;
  }

  public void setAttributes(XMLAttributes paramXMLAttributes)
  {
    this.fAttributes = paramXMLAttributes;
  }

  public void reset()
  {
    super.clear();
    this.fContextType = -1;
    this.fLocationHints = null;
    this.fTriggeringComponent = null;
    this.fEnclosedElementName = null;
    this.fAttributes = null;
  }

  public XSDDescription makeClone()
  {
    XSDDescription localXSDDescription = new XSDDescription();
    localXSDDescription.fAttributes = this.fAttributes;
    localXSDDescription.fBaseSystemId = this.fBaseSystemId;
    localXSDDescription.fContextType = this.fContextType;
    localXSDDescription.fEnclosedElementName = this.fEnclosedElementName;
    localXSDDescription.fExpandedSystemId = this.fExpandedSystemId;
    localXSDDescription.fLiteralSystemId = this.fLiteralSystemId;
    localXSDDescription.fLocationHints = this.fLocationHints;
    localXSDDescription.fPublicId = this.fPublicId;
    localXSDDescription.fNamespace = this.fNamespace;
    localXSDDescription.fTriggeringComponent = this.fTriggeringComponent;
    return localXSDDescription;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.impl.xs.XSDDescription
 * JD-Core Version:    0.6.0
 */