package org.apache.xerces.impl.dtd;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.dtd.models.CMAny;
import org.apache.xerces.impl.dtd.models.CMBinOp;
import org.apache.xerces.impl.dtd.models.CMLeaf;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMUniOp;
import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.impl.dtd.models.DFAContentModel;
import org.apache.xerces.impl.dtd.models.MixedContentModel;
import org.apache.xerces.impl.dtd.models.SimpleContentModel;
import org.apache.xerces.impl.dv.DatatypeValidator;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.parser.XMLDTDContentModelSource;
import org.apache.xerces.xni.parser.XMLDTDSource;

public class DTDGrammar
  implements XMLDTDHandler, XMLDTDContentModelHandler, EntityState, Grammar
{
  public static final int TOP_LEVEL_SCOPE = -1;
  private static final int CHUNK_SHIFT = 8;
  private static final int CHUNK_SIZE = 256;
  private static final int CHUNK_MASK = 255;
  private static final int INITIAL_CHUNK_COUNT = 4;
  private static final short LIST_FLAG = 128;
  private static final short LIST_MASK = -129;
  private static final boolean DEBUG = false;
  protected XMLDTDSource fDTDSource = null;
  protected XMLDTDContentModelSource fDTDContentModelSource = null;
  protected int fCurrentElementIndex;
  protected int fCurrentAttributeIndex;
  protected boolean fReadingExternalDTD = false;
  private SymbolTable fSymbolTable;
  protected XMLDTDDescription fGrammarDescription = null;
  private int fElementDeclCount = 0;
  private QName[][] fElementDeclName = new QName[4][];
  private short[][] fElementDeclType = new short[4][];
  private int[][] fElementDeclContentSpecIndex = new int[4][];
  private ContentModelValidator[][] fElementDeclContentModelValidator = new ContentModelValidator[4][];
  private int[][] fElementDeclFirstAttributeDeclIndex = new int[4][];
  private int[][] fElementDeclLastAttributeDeclIndex = new int[4][];
  private int fAttributeDeclCount = 0;
  private QName[][] fAttributeDeclName = new QName[4][];
  private boolean fIsImmutable = false;
  private short[][] fAttributeDeclType = new short[4][];
  private String[][][] fAttributeDeclEnumeration = new String[4][][];
  private short[][] fAttributeDeclDefaultType = new short[4][];
  private DatatypeValidator[][] fAttributeDeclDatatypeValidator = new DatatypeValidator[4][];
  private String[][] fAttributeDeclDefaultValue = new String[4][];
  private String[][] fAttributeDeclNonNormalizedDefaultValue = new String[4][];
  private int[][] fAttributeDeclNextAttributeDeclIndex = new int[4][];
  private int fContentSpecCount = 0;
  private short[][] fContentSpecType = new short[4][];
  private Object[][] fContentSpecValue = new Object[4][];
  private Object[][] fContentSpecOtherValue = new Object[4][];
  private int fEntityCount = 0;
  private String[][] fEntityName = new String[4][];
  private String[][] fEntityValue = new String[4][];
  private String[][] fEntityPublicId = new String[4][];
  private String[][] fEntitySystemId = new String[4][];
  private String[][] fEntityBaseSystemId = new String[4][];
  private String[][] fEntityNotation = new String[4][];
  private byte[][] fEntityIsPE = new byte[4][];
  private byte[][] fEntityInExternal = new byte[4][];
  private int fNotationCount = 0;
  private String[][] fNotationName = new String[4][];
  private String[][] fNotationPublicId = new String[4][];
  private String[][] fNotationSystemId = new String[4][];
  private String[][] fNotationBaseSystemId = new String[4][];
  private QNameHashtable fElementIndexMap = new QNameHashtable();
  private QNameHashtable fEntityIndexMap = new QNameHashtable();
  private QNameHashtable fNotationIndexMap = new QNameHashtable();
  private boolean fMixed;
  private QName fQName = new QName();
  private QName fQName2 = new QName();
  protected XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
  private int fLeafCount = 0;
  private int fEpsilonIndex = -1;
  private XMLElementDecl fElementDecl = new XMLElementDecl();
  private XMLEntityDecl fEntityDecl = new XMLEntityDecl();
  private XMLSimpleType fSimpleType = new XMLSimpleType();
  private XMLContentSpec fContentSpec = new XMLContentSpec();
  Hashtable fElementDeclTab = new Hashtable();
  private short[] fOpStack = null;
  private int[] fNodeIndexStack = null;
  private int[] fPrevNodeIndexStack = null;
  private int fDepth = 0;
  private boolean[] fPEntityStack = new boolean[4];
  private int fPEDepth = 0;
  private int[][] fElementDeclIsExternal = new int[4][];
  private int[][] fAttributeDeclIsExternal = new int[4][];
  int valueIndex = -1;
  int prevNodeIndex = -1;
  int nodeIndex = -1;

  public DTDGrammar(SymbolTable paramSymbolTable, XMLDTDDescription paramXMLDTDDescription)
  {
    this.fSymbolTable = paramSymbolTable;
    this.fGrammarDescription = paramXMLDTDDescription;
  }

  public XMLGrammarDescription getGrammarDescription()
  {
    return this.fGrammarDescription;
  }

  public boolean getElementDeclIsExternal(int paramInt)
  {
    if (paramInt < 0)
      return false;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    return this.fElementDeclIsExternal[i][j] != 0;
  }

  public boolean getAttributeDeclIsExternal(int paramInt)
  {
    if (paramInt < 0)
      return false;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    return this.fAttributeDeclIsExternal[i][j] != 0;
  }

  public int getAttributeDeclIndex(int paramInt, String paramString)
  {
    if (paramInt == -1)
      return -1;
    for (int i = getFirstAttributeDeclIndex(paramInt); i != -1; i = getNextAttributeDeclIndex(i))
    {
      getAttributeDecl(i, this.fAttributeDecl);
      if ((this.fAttributeDecl.name.rawname == paramString) || (paramString.equals(this.fAttributeDecl.name.rawname)))
        return i;
    }
    return -1;
  }

  public void startDTD(XMLLocator paramXMLLocator, Augmentations paramAugmentations)
    throws XNIException
  {
    this.fOpStack = null;
    this.fNodeIndexStack = null;
    this.fPrevNodeIndexStack = null;
  }

  public void startParameterEntity(String paramString1, XMLResourceIdentifier paramXMLResourceIdentifier, String paramString2, Augmentations paramAugmentations)
    throws XNIException
  {
    if (this.fPEDepth == this.fPEntityStack.length)
    {
      boolean[] arrayOfBoolean = new boolean[this.fPEntityStack.length * 2];
      System.arraycopy(this.fPEntityStack, 0, arrayOfBoolean, 0, this.fPEntityStack.length);
      this.fPEntityStack = arrayOfBoolean;
    }
    this.fPEntityStack[this.fPEDepth] = this.fReadingExternalDTD;
    this.fPEDepth += 1;
  }

  public void startExternalSubset(XMLResourceIdentifier paramXMLResourceIdentifier, Augmentations paramAugmentations)
    throws XNIException
  {
    this.fReadingExternalDTD = true;
  }

  public void endParameterEntity(String paramString, Augmentations paramAugmentations)
    throws XNIException
  {
    this.fPEDepth -= 1;
    this.fReadingExternalDTD = this.fPEntityStack[this.fPEDepth];
  }

  public void endExternalSubset(Augmentations paramAugmentations)
    throws XNIException
  {
    this.fReadingExternalDTD = false;
  }

  public void elementDecl(String paramString1, String paramString2, Augmentations paramAugmentations)
    throws XNIException
  {
    XMLElementDecl localXMLElementDecl1 = (XMLElementDecl)this.fElementDeclTab.get(paramString1);
    if (localXMLElementDecl1 != null)
    {
      if (localXMLElementDecl1.type == -1)
        this.fCurrentElementIndex = getElementDeclIndex(paramString1);
      else
        return;
    }
    else
      this.fCurrentElementIndex = createElementDecl();
    XMLElementDecl localXMLElementDecl2 = new XMLElementDecl();
    this.fQName.setValues(null, paramString1, paramString1, null);
    localXMLElementDecl2.name.setValues(this.fQName);
    localXMLElementDecl2.contentModelValidator = null;
    localXMLElementDecl2.scope = -1;
    if (paramString2.equals("EMPTY"))
      localXMLElementDecl2.type = 1;
    else if (paramString2.equals("ANY"))
      localXMLElementDecl2.type = 0;
    else if (paramString2.startsWith("("))
      if (paramString2.indexOf("#PCDATA") > 0)
        localXMLElementDecl2.type = 2;
      else
        localXMLElementDecl2.type = 3;
    this.fElementDeclTab.put(paramString1, localXMLElementDecl2);
    this.fElementDecl = localXMLElementDecl2;
    addContentSpecToElement(localXMLElementDecl2);
    setElementDecl(this.fCurrentElementIndex, this.fElementDecl);
    int i = this.fCurrentElementIndex >> 8;
    int j = this.fCurrentElementIndex & 0xFF;
    ensureElementDeclCapacity(i);
    this.fElementDeclIsExternal[i][j] = (this.fReadingExternalDTD ? 1 : 0);
  }

  public void attributeDecl(String paramString1, String paramString2, String paramString3, String[] paramArrayOfString, String paramString4, XMLString paramXMLString1, XMLString paramXMLString2, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!this.fElementDeclTab.containsKey(paramString1))
    {
      this.fCurrentElementIndex = createElementDecl();
      XMLElementDecl localXMLElementDecl = new XMLElementDecl();
      localXMLElementDecl.name.setValues(null, paramString1, paramString1, null);
      localXMLElementDecl.scope = -1;
      this.fElementDeclTab.put(paramString1, localXMLElementDecl);
      setElementDecl(this.fCurrentElementIndex, localXMLElementDecl);
    }
    int i = getElementDeclIndex(paramString1);
    if (getAttributeDeclIndex(i, paramString2) != -1)
      return;
    this.fCurrentAttributeIndex = createAttributeDecl();
    this.fSimpleType.clear();
    if (paramString4 != null)
      if (paramString4.equals("#FIXED"))
        this.fSimpleType.defaultType = 1;
      else if (paramString4.equals("#IMPLIED"))
        this.fSimpleType.defaultType = 0;
      else if (paramString4.equals("#REQUIRED"))
        this.fSimpleType.defaultType = 2;
    this.fSimpleType.defaultValue = (paramXMLString1 != null ? paramXMLString1.toString() : null);
    this.fSimpleType.nonNormalizedDefaultValue = (paramXMLString2 != null ? paramXMLString2.toString() : null);
    this.fSimpleType.enumeration = paramArrayOfString;
    if (paramString3.equals("CDATA"))
    {
      this.fSimpleType.type = 0;
    }
    else if (paramString3.equals("ID"))
    {
      this.fSimpleType.type = 3;
    }
    else if (paramString3.startsWith("IDREF"))
    {
      this.fSimpleType.type = 4;
      if (paramString3.indexOf("S") > 0)
        this.fSimpleType.list = true;
    }
    else if (paramString3.equals("ENTITIES"))
    {
      this.fSimpleType.type = 1;
      this.fSimpleType.list = true;
    }
    else if (paramString3.equals("ENTITY"))
    {
      this.fSimpleType.type = 1;
    }
    else if (paramString3.equals("NMTOKENS"))
    {
      this.fSimpleType.type = 5;
      this.fSimpleType.list = true;
    }
    else if (paramString3.equals("NMTOKEN"))
    {
      this.fSimpleType.type = 5;
    }
    else if (paramString3.startsWith("NOTATION"))
    {
      this.fSimpleType.type = 6;
    }
    else if (paramString3.startsWith("ENUMERATION"))
    {
      this.fSimpleType.type = 2;
    }
    else
    {
      System.err.println("!!! unknown attribute type " + paramString3);
    }
    this.fQName.setValues(null, paramString2, paramString2, null);
    this.fAttributeDecl.setValues(this.fQName, this.fSimpleType, false);
    setAttributeDecl(i, this.fCurrentAttributeIndex, this.fAttributeDecl);
    int j = this.fCurrentAttributeIndex >> 8;
    int k = this.fCurrentAttributeIndex & 0xFF;
    ensureAttributeDeclCapacity(j);
    this.fAttributeDeclIsExternal[j][k] = (this.fReadingExternalDTD ? 1 : 0);
  }

  public void internalEntityDecl(String paramString, XMLString paramXMLString1, XMLString paramXMLString2, Augmentations paramAugmentations)
    throws XNIException
  {
    int i = getEntityDeclIndex(paramString);
    if (i == -1)
    {
      i = createEntityDecl();
      boolean bool1 = paramString.startsWith("%");
      boolean bool2 = this.fReadingExternalDTD;
      XMLEntityDecl localXMLEntityDecl = new XMLEntityDecl();
      localXMLEntityDecl.setValues(paramString, null, null, null, null, paramXMLString1.toString(), bool1, bool2);
      setEntityDecl(i, localXMLEntityDecl);
    }
  }

  public void externalEntityDecl(String paramString, XMLResourceIdentifier paramXMLResourceIdentifier, Augmentations paramAugmentations)
    throws XNIException
  {
    int i = getEntityDeclIndex(paramString);
    if (i == -1)
    {
      i = createEntityDecl();
      boolean bool1 = paramString.startsWith("%");
      boolean bool2 = this.fReadingExternalDTD;
      XMLEntityDecl localXMLEntityDecl = new XMLEntityDecl();
      localXMLEntityDecl.setValues(paramString, paramXMLResourceIdentifier.getPublicId(), paramXMLResourceIdentifier.getLiteralSystemId(), paramXMLResourceIdentifier.getBaseSystemId(), null, null, bool1, bool2);
      setEntityDecl(i, localXMLEntityDecl);
    }
  }

  public void unparsedEntityDecl(String paramString1, XMLResourceIdentifier paramXMLResourceIdentifier, String paramString2, Augmentations paramAugmentations)
    throws XNIException
  {
    XMLEntityDecl localXMLEntityDecl = new XMLEntityDecl();
    boolean bool1 = paramString1.startsWith("%");
    boolean bool2 = this.fReadingExternalDTD;
    localXMLEntityDecl.setValues(paramString1, paramXMLResourceIdentifier.getPublicId(), paramXMLResourceIdentifier.getLiteralSystemId(), paramXMLResourceIdentifier.getBaseSystemId(), paramString2, null, bool1, bool2);
    int i = getEntityDeclIndex(paramString1);
    if (i == -1)
    {
      i = createEntityDecl();
      setEntityDecl(i, localXMLEntityDecl);
    }
  }

  public void notationDecl(String paramString, XMLResourceIdentifier paramXMLResourceIdentifier, Augmentations paramAugmentations)
    throws XNIException
  {
    XMLNotationDecl localXMLNotationDecl = new XMLNotationDecl();
    localXMLNotationDecl.setValues(paramString, paramXMLResourceIdentifier.getPublicId(), paramXMLResourceIdentifier.getLiteralSystemId(), paramXMLResourceIdentifier.getBaseSystemId());
    int i = getNotationDeclIndex(paramString);
    if (i == -1)
    {
      i = createNotationDecl();
      setNotationDecl(i, localXMLNotationDecl);
    }
  }

  public void endDTD(Augmentations paramAugmentations)
    throws XNIException
  {
    this.fIsImmutable = true;
    if (this.fGrammarDescription.getRootName() == null)
    {
      int j = 0;
      String str = null;
      Vector localVector = new Vector();
      for (int k = 0; k < this.fElementDeclCount; k++)
      {
        int i = k >> 8;
        j = k & 0xFF;
        str = this.fElementDeclName[i][j].rawname;
        localVector.addElement(str);
      }
      this.fGrammarDescription.setPossibleRoots(localVector);
    }
  }

  public void setDTDSource(XMLDTDSource paramXMLDTDSource)
  {
    this.fDTDSource = paramXMLDTDSource;
  }

  public XMLDTDSource getDTDSource()
  {
    return this.fDTDSource;
  }

  public void textDecl(String paramString1, String paramString2, Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void comment(XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void processingInstruction(String paramString, XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void startAttlist(String paramString, Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void endAttlist(Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void startConditional(short paramShort, Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void ignoredCharacters(XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void endConditional(Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void setDTDContentModelSource(XMLDTDContentModelSource paramXMLDTDContentModelSource)
  {
    this.fDTDContentModelSource = paramXMLDTDContentModelSource;
  }

  public XMLDTDContentModelSource getDTDContentModelSource()
  {
    return this.fDTDContentModelSource;
  }

  public void startContentModel(String paramString, Augmentations paramAugmentations)
    throws XNIException
  {
    XMLElementDecl localXMLElementDecl = (XMLElementDecl)this.fElementDeclTab.get(paramString);
    if (localXMLElementDecl != null)
      this.fElementDecl = localXMLElementDecl;
    this.fDepth = 0;
    initializeContentModelStack();
  }

  public void startGroup(Augmentations paramAugmentations)
    throws XNIException
  {
    this.fDepth += 1;
    initializeContentModelStack();
    this.fMixed = false;
  }

  public void pcdata(Augmentations paramAugmentations)
    throws XNIException
  {
    this.fMixed = true;
  }

  public void element(String paramString, Augmentations paramAugmentations)
    throws XNIException
  {
    if (this.fMixed)
    {
      if (this.fNodeIndexStack[this.fDepth] == -1)
        this.fNodeIndexStack[this.fDepth] = addUniqueLeafNode(paramString);
      else
        this.fNodeIndexStack[this.fDepth] = addContentSpecNode(4, this.fNodeIndexStack[this.fDepth], addUniqueLeafNode(paramString));
    }
    else
      this.fNodeIndexStack[this.fDepth] = addContentSpecNode(0, paramString);
  }

  public void separator(short paramShort, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!this.fMixed)
      if ((this.fOpStack[this.fDepth] != 5) && (paramShort == 0))
      {
        if (this.fPrevNodeIndexStack[this.fDepth] != -1)
          this.fNodeIndexStack[this.fDepth] = addContentSpecNode(this.fOpStack[this.fDepth], this.fPrevNodeIndexStack[this.fDepth], this.fNodeIndexStack[this.fDepth]);
        this.fPrevNodeIndexStack[this.fDepth] = this.fNodeIndexStack[this.fDepth];
        this.fOpStack[this.fDepth] = 4;
      }
      else if ((this.fOpStack[this.fDepth] != 4) && (paramShort == 1))
      {
        if (this.fPrevNodeIndexStack[this.fDepth] != -1)
          this.fNodeIndexStack[this.fDepth] = addContentSpecNode(this.fOpStack[this.fDepth], this.fPrevNodeIndexStack[this.fDepth], this.fNodeIndexStack[this.fDepth]);
        this.fPrevNodeIndexStack[this.fDepth] = this.fNodeIndexStack[this.fDepth];
        this.fOpStack[this.fDepth] = 5;
      }
  }

  public void occurrence(short paramShort, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!this.fMixed)
      if (paramShort == 2)
        this.fNodeIndexStack[this.fDepth] = addContentSpecNode(1, this.fNodeIndexStack[this.fDepth], -1);
      else if (paramShort == 3)
        this.fNodeIndexStack[this.fDepth] = addContentSpecNode(2, this.fNodeIndexStack[this.fDepth], -1);
      else if (paramShort == 4)
        this.fNodeIndexStack[this.fDepth] = addContentSpecNode(3, this.fNodeIndexStack[this.fDepth], -1);
  }

  public void endGroup(Augmentations paramAugmentations)
    throws XNIException
  {
    if (!this.fMixed)
    {
      if (this.fPrevNodeIndexStack[this.fDepth] != -1)
        this.fNodeIndexStack[this.fDepth] = addContentSpecNode(this.fOpStack[this.fDepth], this.fPrevNodeIndexStack[this.fDepth], this.fNodeIndexStack[this.fDepth]);
      int i = this.fNodeIndexStack[(this.fDepth--)];
      this.fNodeIndexStack[this.fDepth] = i;
    }
  }

  public void any(Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void empty(Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public void endContentModel(Augmentations paramAugmentations)
    throws XNIException
  {
  }

  public boolean isNamespaceAware()
  {
    return false;
  }

  public SymbolTable getSymbolTable()
  {
    return this.fSymbolTable;
  }

  public int getFirstElementDeclIndex()
  {
    return this.fElementDeclCount >= 0 ? 0 : -1;
  }

  public int getNextElementDeclIndex(int paramInt)
  {
    return paramInt < this.fElementDeclCount - 1 ? paramInt + 1 : -1;
  }

  public int getElementDeclIndex(String paramString)
  {
    int i = this.fElementIndexMap.get(paramString);
    return i;
  }

  public int getElementDeclIndex(QName paramQName)
  {
    return getElementDeclIndex(paramQName.rawname);
  }

  public short getContentSpecType(int paramInt)
  {
    if ((paramInt < 0) || (paramInt >= this.fElementDeclCount))
      return -1;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    if (this.fElementDeclType[i][j] == -1)
      return -1;
    return (short)(this.fElementDeclType[i][j] & 0xFFFFFF7F);
  }

  public boolean getElementDecl(int paramInt, XMLElementDecl paramXMLElementDecl)
  {
    if ((paramInt < 0) || (paramInt >= this.fElementDeclCount))
      return false;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    paramXMLElementDecl.name.setValues(this.fElementDeclName[i][j]);
    if (this.fElementDeclType[i][j] == -1)
    {
      paramXMLElementDecl.type = -1;
      paramXMLElementDecl.simpleType.list = false;
    }
    else
    {
      paramXMLElementDecl.type = (short)(this.fElementDeclType[i][j] & 0xFFFFFF7F);
      paramXMLElementDecl.simpleType.list = ((this.fElementDeclType[i][j] & 0x80) != 0);
    }
    if ((paramXMLElementDecl.type == 3) || (paramXMLElementDecl.type == 2))
      paramXMLElementDecl.contentModelValidator = getElementContentModelValidator(paramInt);
    paramXMLElementDecl.simpleType.datatypeValidator = null;
    paramXMLElementDecl.simpleType.defaultType = -1;
    paramXMLElementDecl.simpleType.defaultValue = null;
    return true;
  }

  QName getElementDeclName(int paramInt)
  {
    if ((paramInt < 0) || (paramInt >= this.fElementDeclCount))
      return null;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    return this.fElementDeclName[i][j];
  }

  public int getFirstAttributeDeclIndex(int paramInt)
  {
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    return this.fElementDeclFirstAttributeDeclIndex[i][j];
  }

  public int getNextAttributeDeclIndex(int paramInt)
  {
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    return this.fAttributeDeclNextAttributeDeclIndex[i][j];
  }

  public boolean getAttributeDecl(int paramInt, XMLAttributeDecl paramXMLAttributeDecl)
  {
    if ((paramInt < 0) || (paramInt >= this.fAttributeDeclCount))
      return false;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    paramXMLAttributeDecl.name.setValues(this.fAttributeDeclName[i][j]);
    short s;
    boolean bool;
    if (this.fAttributeDeclType[i][j] == -1)
    {
      s = -1;
      bool = false;
    }
    else
    {
      s = (short)(this.fAttributeDeclType[i][j] & 0xFFFFFF7F);
      bool = (this.fAttributeDeclType[i][j] & 0x80) != 0;
    }
    paramXMLAttributeDecl.simpleType.setValues(s, this.fAttributeDeclName[i][j].localpart, this.fAttributeDeclEnumeration[i][j], bool, this.fAttributeDeclDefaultType[i][j], this.fAttributeDeclDefaultValue[i][j], this.fAttributeDeclNonNormalizedDefaultValue[i][j], this.fAttributeDeclDatatypeValidator[i][j]);
    return true;
  }

  public boolean isCDATAAttribute(QName paramQName1, QName paramQName2)
  {
    int i = getElementDeclIndex(paramQName1);
    return (!getAttributeDecl(i, this.fAttributeDecl)) || (this.fAttributeDecl.simpleType.type == 0);
  }

  public int getEntityDeclIndex(String paramString)
  {
    if (paramString == null)
      return -1;
    return this.fEntityIndexMap.get(paramString);
  }

  public boolean getEntityDecl(int paramInt, XMLEntityDecl paramXMLEntityDecl)
  {
    if ((paramInt < 0) || (paramInt >= this.fEntityCount))
      return false;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    paramXMLEntityDecl.setValues(this.fEntityName[i][j], this.fEntityPublicId[i][j], this.fEntitySystemId[i][j], this.fEntityBaseSystemId[i][j], this.fEntityNotation[i][j], this.fEntityValue[i][j], this.fEntityIsPE[i][j] != 0, this.fEntityInExternal[i][j] != 0);
    return true;
  }

  public int getNotationDeclIndex(String paramString)
  {
    if (paramString == null)
      return -1;
    return this.fNotationIndexMap.get(paramString);
  }

  public boolean getNotationDecl(int paramInt, XMLNotationDecl paramXMLNotationDecl)
  {
    if ((paramInt < 0) || (paramInt >= this.fNotationCount))
      return false;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    paramXMLNotationDecl.setValues(this.fNotationName[i][j], this.fNotationPublicId[i][j], this.fNotationSystemId[i][j], this.fNotationBaseSystemId[i][j]);
    return true;
  }

  public boolean getContentSpec(int paramInt, XMLContentSpec paramXMLContentSpec)
  {
    if ((paramInt < 0) || (paramInt >= this.fContentSpecCount))
      return false;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    paramXMLContentSpec.type = this.fContentSpecType[i][j];
    paramXMLContentSpec.value = this.fContentSpecValue[i][j];
    paramXMLContentSpec.otherValue = this.fContentSpecOtherValue[i][j];
    return true;
  }

  public int getContentSpecIndex(int paramInt)
  {
    if ((paramInt < 0) || (paramInt >= this.fElementDeclCount))
      return -1;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    return this.fElementDeclContentSpecIndex[i][j];
  }

  public String getContentSpecAsString(int paramInt)
  {
    if ((paramInt < 0) || (paramInt >= this.fElementDeclCount))
      return null;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    int k = this.fElementDeclContentSpecIndex[i][j];
    XMLContentSpec localXMLContentSpec = new XMLContentSpec();
    if (getContentSpec(k, localXMLContentSpec))
    {
      StringBuffer localStringBuffer = new StringBuffer();
      int m = localXMLContentSpec.type & 0xF;
      int n;
      switch (m)
      {
      case 0:
        localStringBuffer.append('(');
        if ((localXMLContentSpec.value == null) && (localXMLContentSpec.otherValue == null))
          localStringBuffer.append("#PCDATA");
        else
          localStringBuffer.append(localXMLContentSpec.value);
        localStringBuffer.append(')');
        break;
      case 1:
        getContentSpec(((int[])localXMLContentSpec.value)[0], localXMLContentSpec);
        n = localXMLContentSpec.type;
        if (n == 0)
        {
          localStringBuffer.append('(');
          localStringBuffer.append(localXMLContentSpec.value);
          localStringBuffer.append(')');
        }
        else if ((n == 3) || (n == 2) || (n == 1))
        {
          localStringBuffer.append('(');
          appendContentSpec(localXMLContentSpec, localStringBuffer, true, m);
          localStringBuffer.append(')');
        }
        else
        {
          appendContentSpec(localXMLContentSpec, localStringBuffer, true, m);
        }
        localStringBuffer.append('?');
        break;
      case 2:
        getContentSpec(((int[])localXMLContentSpec.value)[0], localXMLContentSpec);
        n = localXMLContentSpec.type;
        if (n == 0)
        {
          localStringBuffer.append('(');
          if ((localXMLContentSpec.value == null) && (localXMLContentSpec.otherValue == null))
            localStringBuffer.append("#PCDATA");
          else if (localXMLContentSpec.otherValue != null)
            localStringBuffer.append("##any:uri=").append(localXMLContentSpec.otherValue);
          else if (localXMLContentSpec.value == null)
            localStringBuffer.append("##any");
          else
            appendContentSpec(localXMLContentSpec, localStringBuffer, true, m);
          localStringBuffer.append(')');
        }
        else if ((n == 3) || (n == 2) || (n == 1))
        {
          localStringBuffer.append('(');
          appendContentSpec(localXMLContentSpec, localStringBuffer, true, m);
          localStringBuffer.append(')');
        }
        else
        {
          appendContentSpec(localXMLContentSpec, localStringBuffer, true, m);
        }
        localStringBuffer.append('*');
        break;
      case 3:
        getContentSpec(((int[])localXMLContentSpec.value)[0], localXMLContentSpec);
        n = localXMLContentSpec.type;
        if (n == 0)
        {
          localStringBuffer.append('(');
          if ((localXMLContentSpec.value == null) && (localXMLContentSpec.otherValue == null))
            localStringBuffer.append("#PCDATA");
          else if (localXMLContentSpec.otherValue != null)
            localStringBuffer.append("##any:uri=").append(localXMLContentSpec.otherValue);
          else if (localXMLContentSpec.value == null)
            localStringBuffer.append("##any");
          else
            localStringBuffer.append(localXMLContentSpec.value);
          localStringBuffer.append(')');
        }
        else if ((n == 3) || (n == 2) || (n == 1))
        {
          localStringBuffer.append('(');
          appendContentSpec(localXMLContentSpec, localStringBuffer, true, m);
          localStringBuffer.append(')');
        }
        else
        {
          appendContentSpec(localXMLContentSpec, localStringBuffer, true, m);
        }
        localStringBuffer.append('+');
        break;
      case 4:
      case 5:
        appendContentSpec(localXMLContentSpec, localStringBuffer, true, m);
        break;
      case 6:
        localStringBuffer.append("##any");
        if (localXMLContentSpec.otherValue == null)
          break;
        localStringBuffer.append(":uri=");
        localStringBuffer.append(localXMLContentSpec.otherValue);
        break;
      case 7:
        localStringBuffer.append("##other:uri=");
        localStringBuffer.append(localXMLContentSpec.otherValue);
        break;
      case 8:
        localStringBuffer.append("##local");
        break;
      default:
        localStringBuffer.append("???");
      }
      return localStringBuffer.toString();
    }
    return null;
  }

  public void printElements()
  {
    int i = 0;
    XMLElementDecl localXMLElementDecl = new XMLElementDecl();
    while (getElementDecl(i++, localXMLElementDecl))
      System.out.println("element decl: " + localXMLElementDecl.name + ", " + localXMLElementDecl.name.rawname);
  }

  public void printAttributes(int paramInt)
  {
    int i = getFirstAttributeDeclIndex(paramInt);
    System.out.print(paramInt);
    System.out.print(" [");
    while (i != -1)
    {
      System.out.print(' ');
      System.out.print(i);
      printAttribute(i);
      i = getNextAttributeDeclIndex(i);
      if (i == -1)
        continue;
      System.out.print(",");
    }
    System.out.println(" ]");
  }

  protected void addContentSpecToElement(XMLElementDecl paramXMLElementDecl)
  {
    if (((this.fDepth == 0) || ((this.fDepth == 1) && (paramXMLElementDecl.type == 2))) && (this.fNodeIndexStack != null))
    {
      if (paramXMLElementDecl.type == 2)
      {
        int i = addUniqueLeafNode(null);
        if (this.fNodeIndexStack[0] == -1)
          this.fNodeIndexStack[0] = i;
        else
          this.fNodeIndexStack[0] = addContentSpecNode(4, i, this.fNodeIndexStack[0]);
      }
      setContentSpecIndex(this.fCurrentElementIndex, this.fNodeIndexStack[this.fDepth]);
    }
  }

  protected ContentModelValidator getElementContentModelValidator(int paramInt)
  {
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    Object localObject = this.fElementDeclContentModelValidator[i][j];
    if (localObject != null)
      return localObject;
    int k = this.fElementDeclType[i][j];
    if (k == 4)
      return null;
    int m = this.fElementDeclContentSpecIndex[i][j];
    XMLContentSpec localXMLContentSpec = new XMLContentSpec();
    getContentSpec(m, localXMLContentSpec);
    if (k == 2)
    {
      ChildrenList localChildrenList = new ChildrenList();
      contentSpecTree(m, localXMLContentSpec, localChildrenList);
      localObject = new MixedContentModel(localChildrenList.qname, localChildrenList.type, 0, localChildrenList.length, false);
    }
    else if (k == 3)
    {
      localObject = createChildModel(m);
    }
    else
    {
      throw new RuntimeException("Unknown content type for a element decl in getElementContentModelValidator() in AbstractDTDGrammar class");
    }
    this.fElementDeclContentModelValidator[i][j] = localObject;
    return (ContentModelValidator)localObject;
  }

  protected int createElementDecl()
  {
    int i = this.fElementDeclCount >> 8;
    int j = this.fElementDeclCount & 0xFF;
    ensureElementDeclCapacity(i);
    this.fElementDeclName[i][j] = new QName();
    this.fElementDeclType[i][j] = -1;
    this.fElementDeclContentModelValidator[i][j] = null;
    this.fElementDeclFirstAttributeDeclIndex[i][j] = -1;
    this.fElementDeclLastAttributeDeclIndex[i][j] = -1;
    return this.fElementDeclCount++;
  }

  protected void setElementDecl(int paramInt, XMLElementDecl paramXMLElementDecl)
  {
    if ((paramInt < 0) || (paramInt >= this.fElementDeclCount))
      return;
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    this.fElementDeclName[i][j].setValues(paramXMLElementDecl.name);
    this.fElementDeclType[i][j] = paramXMLElementDecl.type;
    this.fElementDeclContentModelValidator[i][j] = paramXMLElementDecl.contentModelValidator;
    if (paramXMLElementDecl.simpleType.list == true)
    {
      int tmp86_84 = j;
      short[] tmp86_83 = this.fElementDeclType[i];
      tmp86_83[tmp86_84] = (short)(tmp86_83[tmp86_84] | 0x80);
    }
    this.fElementIndexMap.put(paramXMLElementDecl.name.rawname, paramInt);
  }

  protected void putElementNameMapping(QName paramQName, int paramInt1, int paramInt2)
  {
  }

  protected void setFirstAttributeDeclIndex(int paramInt1, int paramInt2)
  {
    if ((paramInt1 < 0) || (paramInt1 >= this.fElementDeclCount))
      return;
    int i = paramInt1 >> 8;
    int j = paramInt1 & 0xFF;
    this.fElementDeclFirstAttributeDeclIndex[i][j] = paramInt2;
  }

  protected void setContentSpecIndex(int paramInt1, int paramInt2)
  {
    if ((paramInt1 < 0) || (paramInt1 >= this.fElementDeclCount))
      return;
    int i = paramInt1 >> 8;
    int j = paramInt1 & 0xFF;
    this.fElementDeclContentSpecIndex[i][j] = paramInt2;
  }

  protected int createAttributeDecl()
  {
    int i = this.fAttributeDeclCount >> 8;
    int j = this.fAttributeDeclCount & 0xFF;
    ensureAttributeDeclCapacity(i);
    this.fAttributeDeclName[i][j] = new QName();
    this.fAttributeDeclType[i][j] = -1;
    this.fAttributeDeclDatatypeValidator[i][j] = null;
    this.fAttributeDeclEnumeration[i][j] = null;
    this.fAttributeDeclDefaultType[i][j] = 0;
    this.fAttributeDeclDefaultValue[i][j] = null;
    this.fAttributeDeclNonNormalizedDefaultValue[i][j] = null;
    this.fAttributeDeclNextAttributeDeclIndex[i][j] = -1;
    return this.fAttributeDeclCount++;
  }

  protected void setAttributeDecl(int paramInt1, int paramInt2, XMLAttributeDecl paramXMLAttributeDecl)
  {
    int i = paramInt2 >> 8;
    int j = paramInt2 & 0xFF;
    this.fAttributeDeclName[i][j].setValues(paramXMLAttributeDecl.name);
    this.fAttributeDeclType[i][j] = paramXMLAttributeDecl.simpleType.type;
    if (paramXMLAttributeDecl.simpleType.list)
    {
      int tmp66_64 = j;
      short[] tmp66_63 = this.fAttributeDeclType[i];
      tmp66_63[tmp66_64] = (short)(tmp66_63[tmp66_64] | 0x80);
    }
    this.fAttributeDeclEnumeration[i][j] = paramXMLAttributeDecl.simpleType.enumeration;
    this.fAttributeDeclDefaultType[i][j] = paramXMLAttributeDecl.simpleType.defaultType;
    this.fAttributeDeclDatatypeValidator[i][j] = paramXMLAttributeDecl.simpleType.datatypeValidator;
    this.fAttributeDeclDefaultValue[i][j] = paramXMLAttributeDecl.simpleType.defaultValue;
    this.fAttributeDeclNonNormalizedDefaultValue[i][j] = paramXMLAttributeDecl.simpleType.nonNormalizedDefaultValue;
    int k = paramInt1 >> 8;
    int m = paramInt1 & 0xFF;
    for (int n = this.fElementDeclFirstAttributeDeclIndex[k][m]; n != -1; n = this.fAttributeDeclNextAttributeDeclIndex[i][j])
    {
      if (n == paramInt2)
        break;
      i = n >> 8;
      j = n & 0xFF;
    }
    if (n == -1)
    {
      if (this.fElementDeclFirstAttributeDeclIndex[k][m] == -1)
      {
        this.fElementDeclFirstAttributeDeclIndex[k][m] = paramInt2;
      }
      else
      {
        n = this.fElementDeclLastAttributeDeclIndex[k][m];
        i = n >> 8;
        j = n & 0xFF;
        this.fAttributeDeclNextAttributeDeclIndex[i][j] = paramInt2;
      }
      this.fElementDeclLastAttributeDeclIndex[k][m] = paramInt2;
    }
  }

  protected int createContentSpec()
  {
    int i = this.fContentSpecCount >> 8;
    int j = this.fContentSpecCount & 0xFF;
    ensureContentSpecCapacity(i);
    this.fContentSpecType[i][j] = -1;
    this.fContentSpecValue[i][j] = null;
    this.fContentSpecOtherValue[i][j] = null;
    return this.fContentSpecCount++;
  }

  protected void setContentSpec(int paramInt, XMLContentSpec paramXMLContentSpec)
  {
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    this.fContentSpecType[i][j] = paramXMLContentSpec.type;
    this.fContentSpecValue[i][j] = paramXMLContentSpec.value;
    this.fContentSpecOtherValue[i][j] = paramXMLContentSpec.otherValue;
  }

  protected int createEntityDecl()
  {
    int i = this.fEntityCount >> 8;
    int j = this.fEntityCount & 0xFF;
    ensureEntityDeclCapacity(i);
    this.fEntityIsPE[i][j] = 0;
    this.fEntityInExternal[i][j] = 0;
    return this.fEntityCount++;
  }

  protected void setEntityDecl(int paramInt, XMLEntityDecl paramXMLEntityDecl)
  {
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    this.fEntityName[i][j] = paramXMLEntityDecl.name;
    this.fEntityValue[i][j] = paramXMLEntityDecl.value;
    this.fEntityPublicId[i][j] = paramXMLEntityDecl.publicId;
    this.fEntitySystemId[i][j] = paramXMLEntityDecl.systemId;
    this.fEntityBaseSystemId[i][j] = paramXMLEntityDecl.baseSystemId;
    this.fEntityNotation[i][j] = paramXMLEntityDecl.notation;
    this.fEntityIsPE[i][j] = (paramXMLEntityDecl.isPE ? 1 : 0);
    this.fEntityInExternal[i][j] = (paramXMLEntityDecl.inExternal ? 1 : 0);
    this.fEntityIndexMap.put(paramXMLEntityDecl.name, paramInt);
  }

  protected int createNotationDecl()
  {
    int i = this.fNotationCount >> 8;
    ensureNotationDeclCapacity(i);
    return this.fNotationCount++;
  }

  protected void setNotationDecl(int paramInt, XMLNotationDecl paramXMLNotationDecl)
  {
    int i = paramInt >> 8;
    int j = paramInt & 0xFF;
    this.fNotationName[i][j] = paramXMLNotationDecl.name;
    this.fNotationPublicId[i][j] = paramXMLNotationDecl.publicId;
    this.fNotationSystemId[i][j] = paramXMLNotationDecl.systemId;
    this.fNotationBaseSystemId[i][j] = paramXMLNotationDecl.baseSystemId;
    this.fNotationIndexMap.put(paramXMLNotationDecl.name, paramInt);
  }

  protected int addContentSpecNode(short paramShort, String paramString)
  {
    int i = createContentSpec();
    this.fContentSpec.setValues(paramShort, paramString, null);
    setContentSpec(i, this.fContentSpec);
    return i;
  }

  protected int addUniqueLeafNode(String paramString)
  {
    int i = createContentSpec();
    this.fContentSpec.setValues(0, paramString, null);
    setContentSpec(i, this.fContentSpec);
    return i;
  }

  protected int addContentSpecNode(short paramShort, int paramInt1, int paramInt2)
  {
    int i = createContentSpec();
    int[] arrayOfInt1 = new int[1];
    int[] arrayOfInt2 = new int[1];
    arrayOfInt1[0] = paramInt1;
    arrayOfInt2[0] = paramInt2;
    this.fContentSpec.setValues(paramShort, arrayOfInt1, arrayOfInt2);
    setContentSpec(i, this.fContentSpec);
    return i;
  }

  protected void initializeContentModelStack()
  {
    if (this.fOpStack == null)
    {
      this.fOpStack = new short[8];
      this.fNodeIndexStack = new int[8];
      this.fPrevNodeIndexStack = new int[8];
    }
    else if (this.fDepth == this.fOpStack.length)
    {
      short[] arrayOfShort = new short[this.fDepth * 2];
      System.arraycopy(this.fOpStack, 0, arrayOfShort, 0, this.fDepth);
      this.fOpStack = arrayOfShort;
      int[] arrayOfInt = new int[this.fDepth * 2];
      System.arraycopy(this.fNodeIndexStack, 0, arrayOfInt, 0, this.fDepth);
      this.fNodeIndexStack = arrayOfInt;
      arrayOfInt = new int[this.fDepth * 2];
      System.arraycopy(this.fPrevNodeIndexStack, 0, arrayOfInt, 0, this.fDepth);
      this.fPrevNodeIndexStack = arrayOfInt;
    }
    this.fOpStack[this.fDepth] = -1;
    this.fNodeIndexStack[this.fDepth] = -1;
    this.fPrevNodeIndexStack[this.fDepth] = -1;
  }

  boolean isImmutable()
  {
    return this.fIsImmutable;
  }

  private void appendContentSpec(XMLContentSpec paramXMLContentSpec, StringBuffer paramStringBuffer, boolean paramBoolean, int paramInt)
  {
    int i = paramXMLContentSpec.type & 0xF;
    switch (i)
    {
    case 0:
      if ((paramXMLContentSpec.value == null) && (paramXMLContentSpec.otherValue == null))
        paramStringBuffer.append("#PCDATA");
      else if ((paramXMLContentSpec.value == null) && (paramXMLContentSpec.otherValue != null))
        paramStringBuffer.append("##any:uri=").append(paramXMLContentSpec.otherValue);
      else if (paramXMLContentSpec.value == null)
        paramStringBuffer.append("##any");
      else
        paramStringBuffer.append(paramXMLContentSpec.value);
      break;
    case 1:
      if ((paramInt == 3) || (paramInt == 2) || (paramInt == 1))
      {
        getContentSpec(((int[])paramXMLContentSpec.value)[0], paramXMLContentSpec);
        paramStringBuffer.append('(');
        appendContentSpec(paramXMLContentSpec, paramStringBuffer, true, i);
        paramStringBuffer.append(')');
      }
      else
      {
        getContentSpec(((int[])paramXMLContentSpec.value)[0], paramXMLContentSpec);
        appendContentSpec(paramXMLContentSpec, paramStringBuffer, true, i);
      }
      paramStringBuffer.append('?');
      break;
    case 2:
      if ((paramInt == 3) || (paramInt == 2) || (paramInt == 1))
      {
        getContentSpec(((int[])paramXMLContentSpec.value)[0], paramXMLContentSpec);
        paramStringBuffer.append('(');
        appendContentSpec(paramXMLContentSpec, paramStringBuffer, true, i);
        paramStringBuffer.append(')');
      }
      else
      {
        getContentSpec(((int[])paramXMLContentSpec.value)[0], paramXMLContentSpec);
        appendContentSpec(paramXMLContentSpec, paramStringBuffer, true, i);
      }
      paramStringBuffer.append('*');
      break;
    case 3:
      if ((paramInt == 3) || (paramInt == 2) || (paramInt == 1))
      {
        paramStringBuffer.append('(');
        getContentSpec(((int[])paramXMLContentSpec.value)[0], paramXMLContentSpec);
        appendContentSpec(paramXMLContentSpec, paramStringBuffer, true, i);
        paramStringBuffer.append(')');
      }
      else
      {
        getContentSpec(((int[])paramXMLContentSpec.value)[0], paramXMLContentSpec);
        appendContentSpec(paramXMLContentSpec, paramStringBuffer, true, i);
      }
      paramStringBuffer.append('+');
      break;
    case 4:
    case 5:
      if (paramBoolean)
        paramStringBuffer.append('(');
      int j = paramXMLContentSpec.type;
      int k = ((int[])paramXMLContentSpec.otherValue)[0];
      getContentSpec(((int[])paramXMLContentSpec.value)[0], paramXMLContentSpec);
      appendContentSpec(paramXMLContentSpec, paramStringBuffer, paramXMLContentSpec.type != j, i);
      if (j == 4)
        paramStringBuffer.append('|');
      else
        paramStringBuffer.append(',');
      getContentSpec(k, paramXMLContentSpec);
      appendContentSpec(paramXMLContentSpec, paramStringBuffer, true, i);
      if (!paramBoolean)
        break;
      paramStringBuffer.append(')');
      break;
    case 6:
      paramStringBuffer.append("##any");
      if (paramXMLContentSpec.otherValue == null)
        break;
      paramStringBuffer.append(":uri=");
      paramStringBuffer.append(paramXMLContentSpec.otherValue);
      break;
    case 7:
      paramStringBuffer.append("##other:uri=");
      paramStringBuffer.append(paramXMLContentSpec.otherValue);
      break;
    case 8:
      paramStringBuffer.append("##local");
      break;
    default:
      paramStringBuffer.append("???");
    }
  }

  private void printAttribute(int paramInt)
  {
    XMLAttributeDecl localXMLAttributeDecl = new XMLAttributeDecl();
    if (getAttributeDecl(paramInt, localXMLAttributeDecl))
    {
      System.out.print(" { ");
      System.out.print(localXMLAttributeDecl.name.localpart);
      System.out.print(" }");
    }
  }

  private ContentModelValidator createChildModel(int paramInt)
  {
    XMLContentSpec localXMLContentSpec1 = new XMLContentSpec();
    getContentSpec(paramInt, localXMLContentSpec1);
    if (((localXMLContentSpec1.type & 0xF) != 6) && ((localXMLContentSpec1.type & 0xF) != 7) && ((localXMLContentSpec1.type & 0xF) != 8))
    {
      if (localXMLContentSpec1.type == 0)
      {
        if ((localXMLContentSpec1.value == null) && (localXMLContentSpec1.otherValue == null))
          throw new RuntimeException("ImplementationMessages.VAL_NPCD");
        this.fQName.setValues(null, (String)localXMLContentSpec1.value, (String)localXMLContentSpec1.value, (String)localXMLContentSpec1.otherValue);
        return new SimpleContentModel(localXMLContentSpec1.type, this.fQName, null);
      }
      if ((localXMLContentSpec1.type == 4) || (localXMLContentSpec1.type == 5))
      {
        localObject = new XMLContentSpec();
        XMLContentSpec localXMLContentSpec2 = new XMLContentSpec();
        getContentSpec(((int[])localXMLContentSpec1.value)[0], (XMLContentSpec)localObject);
        getContentSpec(((int[])localXMLContentSpec1.otherValue)[0], localXMLContentSpec2);
        if ((((XMLContentSpec)localObject).type == 0) && (localXMLContentSpec2.type == 0))
        {
          this.fQName.setValues(null, (String)((XMLContentSpec)localObject).value, (String)((XMLContentSpec)localObject).value, (String)((XMLContentSpec)localObject).otherValue);
          this.fQName2.setValues(null, (String)localXMLContentSpec2.value, (String)localXMLContentSpec2.value, (String)localXMLContentSpec2.otherValue);
          return new SimpleContentModel(localXMLContentSpec1.type, this.fQName, this.fQName2);
        }
      }
      else if ((localXMLContentSpec1.type == 1) || (localXMLContentSpec1.type == 2) || (localXMLContentSpec1.type == 3))
      {
        localObject = new XMLContentSpec();
        getContentSpec(((int[])localXMLContentSpec1.value)[0], (XMLContentSpec)localObject);
        if (((XMLContentSpec)localObject).type == 0)
        {
          this.fQName.setValues(null, (String)((XMLContentSpec)localObject).value, (String)((XMLContentSpec)localObject).value, (String)((XMLContentSpec)localObject).otherValue);
          return new SimpleContentModel(localXMLContentSpec1.type, this.fQName, null);
        }
      }
      else
      {
        throw new RuntimeException("ImplementationMessages.VAL_CST");
      }
    }
    this.fLeafCount = 0;
    this.fLeafCount = 0;
    Object localObject = buildSyntaxTree(paramInt, localXMLContentSpec1);
    return (ContentModelValidator)new DFAContentModel((CMNode)localObject, this.fLeafCount, false);
  }

  private final CMNode buildSyntaxTree(int paramInt, XMLContentSpec paramXMLContentSpec)
  {
    Object localObject = null;
    getContentSpec(paramInt, paramXMLContentSpec);
    if ((paramXMLContentSpec.type & 0xF) == 6)
    {
      localObject = new CMAny(paramXMLContentSpec.type, (String)paramXMLContentSpec.otherValue, this.fLeafCount++);
    }
    else if ((paramXMLContentSpec.type & 0xF) == 7)
    {
      localObject = new CMAny(paramXMLContentSpec.type, (String)paramXMLContentSpec.otherValue, this.fLeafCount++);
    }
    else if ((paramXMLContentSpec.type & 0xF) == 8)
    {
      localObject = new CMAny(paramXMLContentSpec.type, null, this.fLeafCount++);
    }
    else if (paramXMLContentSpec.type == 0)
    {
      this.fQName.setValues(null, (String)paramXMLContentSpec.value, (String)paramXMLContentSpec.value, (String)paramXMLContentSpec.otherValue);
      localObject = new CMLeaf(this.fQName, this.fLeafCount++);
    }
    else
    {
      int i = ((int[])paramXMLContentSpec.value)[0];
      int j = ((int[])paramXMLContentSpec.otherValue)[0];
      if ((paramXMLContentSpec.type == 4) || (paramXMLContentSpec.type == 5))
        localObject = new CMBinOp(paramXMLContentSpec.type, buildSyntaxTree(i, paramXMLContentSpec), buildSyntaxTree(j, paramXMLContentSpec));
      else if (paramXMLContentSpec.type == 2)
        localObject = new CMUniOp(paramXMLContentSpec.type, buildSyntaxTree(i, paramXMLContentSpec));
      else if ((paramXMLContentSpec.type == 2) || (paramXMLContentSpec.type == 1) || (paramXMLContentSpec.type == 3))
        localObject = new CMUniOp(paramXMLContentSpec.type, buildSyntaxTree(i, paramXMLContentSpec));
      else
        throw new RuntimeException("ImplementationMessages.VAL_CST");
    }
    return (CMNode)localObject;
  }

  private void contentSpecTree(int paramInt, XMLContentSpec paramXMLContentSpec, ChildrenList paramChildrenList)
  {
    getContentSpec(paramInt, paramXMLContentSpec);
    if ((paramXMLContentSpec.type == 0) || ((paramXMLContentSpec.type & 0xF) == 6) || ((paramXMLContentSpec.type & 0xF) == 8) || ((paramXMLContentSpec.type & 0xF) == 7))
    {
      if (paramChildrenList.length == paramChildrenList.qname.length)
      {
        QName[] arrayOfQName = new QName[paramChildrenList.length * 2];
        System.arraycopy(paramChildrenList.qname, 0, arrayOfQName, 0, paramChildrenList.length);
        paramChildrenList.qname = arrayOfQName;
        int[] arrayOfInt = new int[paramChildrenList.length * 2];
        System.arraycopy(paramChildrenList.type, 0, arrayOfInt, 0, paramChildrenList.length);
        paramChildrenList.type = arrayOfInt;
      }
      paramChildrenList.qname[paramChildrenList.length] = new QName(null, (String)paramXMLContentSpec.value, (String)paramXMLContentSpec.value, (String)paramXMLContentSpec.otherValue);
      paramChildrenList.type[paramChildrenList.length] = paramXMLContentSpec.type;
      paramChildrenList.length += 1;
      return;
    }
    int i = paramXMLContentSpec.value != null ? ((int[])paramXMLContentSpec.value)[0] : -1;
    int j = -1;
    if (paramXMLContentSpec.otherValue != null)
      j = ((int[])paramXMLContentSpec.otherValue)[0];
    else
      return;
    if ((paramXMLContentSpec.type == 4) || (paramXMLContentSpec.type == 5))
    {
      contentSpecTree(i, paramXMLContentSpec, paramChildrenList);
      contentSpecTree(j, paramXMLContentSpec, paramChildrenList);
      return;
    }
    if ((paramXMLContentSpec.type == 1) || (paramXMLContentSpec.type == 2) || (paramXMLContentSpec.type == 3))
    {
      contentSpecTree(i, paramXMLContentSpec, paramChildrenList);
      return;
    }
    throw new RuntimeException("Invalid content spec type seen in contentSpecTree() method of AbstractDTDGrammar class : " + paramXMLContentSpec.type);
  }

  private void ensureElementDeclCapacity(int paramInt)
  {
    if (paramInt >= this.fElementDeclName.length)
    {
      this.fElementDeclIsExternal = resize(this.fElementDeclIsExternal, this.fElementDeclIsExternal.length * 2);
      this.fElementDeclName = resize(this.fElementDeclName, this.fElementDeclName.length * 2);
      this.fElementDeclType = resize(this.fElementDeclType, this.fElementDeclType.length * 2);
      this.fElementDeclContentModelValidator = resize(this.fElementDeclContentModelValidator, this.fElementDeclContentModelValidator.length * 2);
      this.fElementDeclContentSpecIndex = resize(this.fElementDeclContentSpecIndex, this.fElementDeclContentSpecIndex.length * 2);
      this.fElementDeclFirstAttributeDeclIndex = resize(this.fElementDeclFirstAttributeDeclIndex, this.fElementDeclFirstAttributeDeclIndex.length * 2);
      this.fElementDeclLastAttributeDeclIndex = resize(this.fElementDeclLastAttributeDeclIndex, this.fElementDeclLastAttributeDeclIndex.length * 2);
    }
    else if (this.fElementDeclName[paramInt] != null)
    {
      return;
    }
    this.fElementDeclIsExternal[paramInt] = new int[256];
    this.fElementDeclName[paramInt] = new QName[256];
    this.fElementDeclType[paramInt] = new short[256];
    this.fElementDeclContentModelValidator[paramInt] = new ContentModelValidator[256];
    this.fElementDeclContentSpecIndex[paramInt] = new int[256];
    this.fElementDeclFirstAttributeDeclIndex[paramInt] = new int[256];
    this.fElementDeclLastAttributeDeclIndex[paramInt] = new int[256];
  }

  private void ensureAttributeDeclCapacity(int paramInt)
  {
    if (paramInt >= this.fAttributeDeclName.length)
    {
      this.fAttributeDeclIsExternal = resize(this.fAttributeDeclIsExternal, this.fAttributeDeclIsExternal.length * 2);
      this.fAttributeDeclName = resize(this.fAttributeDeclName, this.fAttributeDeclName.length * 2);
      this.fAttributeDeclType = resize(this.fAttributeDeclType, this.fAttributeDeclType.length * 2);
      this.fAttributeDeclEnumeration = resize(this.fAttributeDeclEnumeration, this.fAttributeDeclEnumeration.length * 2);
      this.fAttributeDeclDefaultType = resize(this.fAttributeDeclDefaultType, this.fAttributeDeclDefaultType.length * 2);
      this.fAttributeDeclDatatypeValidator = resize(this.fAttributeDeclDatatypeValidator, this.fAttributeDeclDatatypeValidator.length * 2);
      this.fAttributeDeclDefaultValue = resize(this.fAttributeDeclDefaultValue, this.fAttributeDeclDefaultValue.length * 2);
      this.fAttributeDeclNonNormalizedDefaultValue = resize(this.fAttributeDeclNonNormalizedDefaultValue, this.fAttributeDeclNonNormalizedDefaultValue.length * 2);
      this.fAttributeDeclNextAttributeDeclIndex = resize(this.fAttributeDeclNextAttributeDeclIndex, this.fAttributeDeclNextAttributeDeclIndex.length * 2);
    }
    else if (this.fAttributeDeclName[paramInt] != null)
    {
      return;
    }
    this.fAttributeDeclIsExternal[paramInt] = new int[256];
    this.fAttributeDeclName[paramInt] = new QName[256];
    this.fAttributeDeclType[paramInt] = new short[256];
    this.fAttributeDeclEnumeration[paramInt] = new String[256][];
    this.fAttributeDeclDefaultType[paramInt] = new short[256];
    this.fAttributeDeclDatatypeValidator[paramInt] = new DatatypeValidator[256];
    this.fAttributeDeclDefaultValue[paramInt] = new String[256];
    this.fAttributeDeclNonNormalizedDefaultValue[paramInt] = new String[256];
    this.fAttributeDeclNextAttributeDeclIndex[paramInt] = new int[256];
  }

  private void ensureEntityDeclCapacity(int paramInt)
  {
    if (paramInt >= this.fEntityName.length)
    {
      this.fEntityName = resize(this.fEntityName, this.fEntityName.length * 2);
      this.fEntityValue = resize(this.fEntityValue, this.fEntityValue.length * 2);
      this.fEntityPublicId = resize(this.fEntityPublicId, this.fEntityPublicId.length * 2);
      this.fEntitySystemId = resize(this.fEntitySystemId, this.fEntitySystemId.length * 2);
      this.fEntityBaseSystemId = resize(this.fEntityBaseSystemId, this.fEntityBaseSystemId.length * 2);
      this.fEntityNotation = resize(this.fEntityNotation, this.fEntityNotation.length * 2);
      this.fEntityIsPE = resize(this.fEntityIsPE, this.fEntityIsPE.length * 2);
      this.fEntityInExternal = resize(this.fEntityInExternal, this.fEntityInExternal.length * 2);
    }
    else if (this.fEntityName[paramInt] != null)
    {
      return;
    }
    this.fEntityName[paramInt] = new String[256];
    this.fEntityValue[paramInt] = new String[256];
    this.fEntityPublicId[paramInt] = new String[256];
    this.fEntitySystemId[paramInt] = new String[256];
    this.fEntityBaseSystemId[paramInt] = new String[256];
    this.fEntityNotation[paramInt] = new String[256];
    this.fEntityIsPE[paramInt] = new byte[256];
    this.fEntityInExternal[paramInt] = new byte[256];
  }

  private void ensureNotationDeclCapacity(int paramInt)
  {
    if (paramInt >= this.fNotationName.length)
    {
      this.fNotationName = resize(this.fNotationName, this.fNotationName.length * 2);
      this.fNotationPublicId = resize(this.fNotationPublicId, this.fNotationPublicId.length * 2);
      this.fNotationSystemId = resize(this.fNotationSystemId, this.fNotationSystemId.length * 2);
      this.fNotationBaseSystemId = resize(this.fNotationBaseSystemId, this.fNotationBaseSystemId.length * 2);
    }
    else if (this.fNotationName[paramInt] != null)
    {
      return;
    }
    this.fNotationName[paramInt] = new String[256];
    this.fNotationPublicId[paramInt] = new String[256];
    this.fNotationSystemId[paramInt] = new String[256];
    this.fNotationBaseSystemId[paramInt] = new String[256];
  }

  private void ensureContentSpecCapacity(int paramInt)
  {
    if (paramInt >= this.fContentSpecType.length)
    {
      this.fContentSpecType = resize(this.fContentSpecType, this.fContentSpecType.length * 2);
      this.fContentSpecValue = resize(this.fContentSpecValue, this.fContentSpecValue.length * 2);
      this.fContentSpecOtherValue = resize(this.fContentSpecOtherValue, this.fContentSpecOtherValue.length * 2);
    }
    else if (this.fContentSpecType[paramInt] != null)
    {
      return;
    }
    this.fContentSpecType[paramInt] = new short[256];
    this.fContentSpecValue[paramInt] = new Object[256];
    this.fContentSpecOtherValue[paramInt] = new Object[256];
  }

  private static byte[][] resize(byte[][] paramArrayOfByte, int paramInt)
  {
    byte[][] arrayOfByte = new byte[paramInt][];
    System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, paramArrayOfByte.length);
    return arrayOfByte;
  }

  private static short[][] resize(short[][] paramArrayOfShort, int paramInt)
  {
    short[][] arrayOfShort = new short[paramInt][];
    System.arraycopy(paramArrayOfShort, 0, arrayOfShort, 0, paramArrayOfShort.length);
    return arrayOfShort;
  }

  private static int[][] resize(int[][] paramArrayOfInt, int paramInt)
  {
    int[][] arrayOfInt = new int[paramInt][];
    System.arraycopy(paramArrayOfInt, 0, arrayOfInt, 0, paramArrayOfInt.length);
    return arrayOfInt;
  }

  private static DatatypeValidator[][] resize(DatatypeValidator[][] paramArrayOfDatatypeValidator, int paramInt)
  {
    DatatypeValidator[][] arrayOfDatatypeValidator; = new DatatypeValidator[paramInt][];
    System.arraycopy(paramArrayOfDatatypeValidator, 0, arrayOfDatatypeValidator;, 0, paramArrayOfDatatypeValidator.length);
    return arrayOfDatatypeValidator;;
  }

  private static ContentModelValidator[][] resize(ContentModelValidator[][] paramArrayOfContentModelValidator, int paramInt)
  {
    ContentModelValidator[][] arrayOfContentModelValidator; = new ContentModelValidator[paramInt][];
    System.arraycopy(paramArrayOfContentModelValidator, 0, arrayOfContentModelValidator;, 0, paramArrayOfContentModelValidator.length);
    return arrayOfContentModelValidator;;
  }

  private static Object[][] resize(Object[][] paramArrayOfObject, int paramInt)
  {
    Object[][] arrayOfObject; = new Object[paramInt][];
    System.arraycopy(paramArrayOfObject, 0, arrayOfObject;, 0, paramArrayOfObject.length);
    return arrayOfObject;;
  }

  private static QName[][] resize(QName[][] paramArrayOfQName, int paramInt)
  {
    QName[][] arrayOfQName; = new QName[paramInt][];
    System.arraycopy(paramArrayOfQName, 0, arrayOfQName;, 0, paramArrayOfQName.length);
    return arrayOfQName;;
  }

  private static String[][] resize(String[][] paramArrayOfString, int paramInt)
  {
    String[][] arrayOfString; = new String[paramInt][];
    System.arraycopy(paramArrayOfString, 0, arrayOfString;, 0, paramArrayOfString.length);
    return arrayOfString;;
  }

  private static String[][][] resize(String[][][] paramArrayOfString, int paramInt)
  {
    String[][][] arrayOfString; = new String[paramInt][][];
    System.arraycopy(paramArrayOfString, 0, arrayOfString;, 0, paramArrayOfString.length);
    return arrayOfString;;
  }

  public boolean isEntityDeclared(String paramString)
  {
    return getEntityDeclIndex(paramString) != -1;
  }

  public boolean isEntityUnparsed(String paramString)
  {
    int i = getEntityDeclIndex(paramString);
    if (i > -1)
    {
      int j = i >> 8;
      int k = i & 0xFF;
      return this.fEntityNotation[j][k] != null;
    }
    return false;
  }

  protected static final class QNameHashtable
  {
    private static final int INITIAL_BUCKET_SIZE = 4;
    private static final int HASHTABLE_SIZE = 101;
    private Object[][] fHashTable = new Object[101][];

    public void put(String paramString, int paramInt)
    {
      int i = (paramString.hashCode() & 0x7FFFFFFF) % 101;
      Object localObject = this.fHashTable[i];
      if (localObject == null)
      {
        localObject = new Object[9];
        localObject[0] = { 1 };
        localObject[1] = paramString;
        localObject[2] = { paramInt };
        this.fHashTable[i] = localObject;
      }
      else
      {
        int j = ((int[])localObject[0])[0];
        int k = 1 + 2 * j;
        if (k == localObject.length)
        {
          m = j + 4;
          Object[] arrayOfObject = new Object[1 + 2 * m];
          System.arraycopy(localObject, 0, arrayOfObject, 0, k);
          localObject = arrayOfObject;
          this.fHashTable[i] = localObject;
        }
        int m = 0;
        int n = 1;
        for (int i1 = 0; i1 < j; i1++)
        {
          if ((String)localObject[n] == paramString)
          {
            ((int[])localObject[(n + 1)])[0] = paramInt;
            m = 1;
            break;
          }
          n += 2;
        }
        if (m == 0)
        {
          localObject[(k++)] = paramString;
          localObject[k] = { paramInt };
          j++;
          ((int[])localObject[0])[0] = j;
        }
      }
    }

    public int get(String paramString)
    {
      int i = (paramString.hashCode() & 0x7FFFFFFF) % 101;
      Object[] arrayOfObject = this.fHashTable[i];
      if (arrayOfObject == null)
        return -1;
      int j = ((int[])arrayOfObject[0])[0];
      int k = 1;
      for (int m = 0; m < j; m++)
      {
        if ((String)arrayOfObject[k] == paramString)
          return ((int[])arrayOfObject[(k + 1)])[0];
        k += 2;
      }
      return -1;
    }
  }

  private static class ChildrenList
  {
    public int length = 0;
    public QName[] qname = new QName[2];
    public int[] type = new int[2];
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.impl.dtd.DTDGrammar
 * JD-Core Version:    0.6.0
 */