/*     */ package org.apache.commons.logging.impl;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import javax.servlet.ServletContextEvent;
/*     */ import javax.servlet.ServletContextListener;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ 
/*     */ public class ServletContextCleaner
/*     */   implements ServletContextListener
/*     */ {
/*  53 */   private Class[] RELEASE_SIGNATURE = { ClassLoader.class };
/*     */ 
/*     */   public void contextDestroyed(ServletContextEvent sce)
/*     */   {
/*  61 */     ClassLoader tccl = Thread.currentThread().getContextClassLoader();
/*     */ 
/*  63 */     Object[] params = new Object[1];
/*  64 */     params[0] = tccl;
/*     */ 
/*  96 */     ClassLoader loader = tccl;
/*  97 */     while (loader != null)
/*     */     {
/*     */       try
/*     */       {
/* 102 */         Class logFactoryClass = loader.loadClass("org.apache.commons.logging.LogFactory");
/* 103 */         Method releaseMethod = logFactoryClass.getMethod("release", this.RELEASE_SIGNATURE);
/* 104 */         releaseMethod.invoke(null, params);
/* 105 */         loader = logFactoryClass.getClassLoader().getParent();
/*     */       }
/*     */       catch (ClassNotFoundException ex)
/*     */       {
/* 109 */         loader = null;
/*     */       }
/*     */       catch (NoSuchMethodException ex) {
/* 112 */         System.err.println("LogFactory instance found which does not support release method!");
/* 113 */         loader = null;
/*     */       }
/*     */       catch (IllegalAccessException ex) {
/* 116 */         System.err.println("LogFactory instance found which is not accessable!");
/* 117 */         loader = null;
/*     */       }
/*     */       catch (InvocationTargetException ex) {
/* 120 */         System.err.println("LogFactory instance release method failed!");
/* 121 */         loader = null;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 128 */     LogFactory.release(tccl);
/*     */   }
/*     */ 
/*     */   public void contextInitialized(ServletContextEvent sce)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.logging.impl.ServletContextCleaner
 * JD-Core Version:    0.6.0
 */