/*     */ package org.apache.commons.logging.impl;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.UndeclaredThrowableException;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.CodeSource;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import org.apache.commons.logging.Log;
/*     */ 
/*     */ public class Log4jProxy
/*     */   implements Log, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private static final String PROXY_FQCN = "org.apache.commons.logging.impl.Log4JLogger";
/*     */   private Object FATAL;
/*     */   private Object ERROR;
/*     */   private Object WARN;
/*     */   private Object INFO;
/*     */   private Object DEBUG;
/*     */   private Object TRACE;
/*  52 */   private transient Object logger = null;
/*     */   private Method isEnabledFor;
/*     */   private Method log;
/*     */ 
/*     */   static ClassLoader threadContextClassLoader()
/*     */   {
/*  60 */     PrivilegedAction action = new PrivilegedAction()
/*     */     {
/*     */       public Object run()
/*     */       {
/*  64 */         ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */         try
/*     */         {
/*  68 */           Class levelClass = loader.loadClass("org.apache.log4j.Level");
/*  69 */           Class loggerClass = loader.loadClass("org.apache.log4j.Logger");
/*  70 */           Class categoryClass = loader.loadClass("org.apache.log4j.Category");
/*  71 */           Class priorityClass = loader.loadClass("org.apache.log4j.Priority");
/*     */ 
/*  73 */           ClassLoader testCL = levelClass.getClassLoader();
/*  74 */           if ((testCL != loggerClass.getClassLoader()) || (testCL != categoryClass.getClassLoader()) || (testCL != loggerClass.getClassLoader()) || (testCL != priorityClass.getClassLoader()))
/*     */           {
/*  79 */             loader = Log4jProxy.class.getClassLoader();
/*     */           }
/*     */ 
/*     */         }
/*     */         catch (ClassNotFoundException e)
/*     */         {
/*  85 */           loader = Log4jProxy.class.getClassLoader();
/*     */         }
/*  87 */         return loader;
/*     */       }
/*     */     };
/*  90 */     ClassLoader tcl = (ClassLoader)AccessController.doPrivileged(action);
/*  91 */     return tcl;
/*     */   }
/*     */ 
/*     */   Log4jProxy(String name)
/*     */   {
/*  96 */     ClassLoader tcl = threadContextClassLoader();
/*  97 */     Class levelClass = null;
/*  98 */     Class priorityClass = null;
/*  99 */     Class loggerClass = null;
/*     */     try
/*     */     {
/* 103 */       levelClass = tcl.loadClass("org.apache.log4j.Level");
/* 104 */       Class[] sig = { String.class };
/* 105 */       Method toLevel = levelClass.getMethod("toLevel", sig);
/* 106 */       String[] level = { "FATAL" };
/* 107 */       this.FATAL = toLevel.invoke(null, level);
/* 108 */       level[0] = "ERROR";
/* 109 */       this.ERROR = toLevel.invoke(null, level);
/* 110 */       level[0] = "WARN";
/* 111 */       this.WARN = toLevel.invoke(null, level);
/* 112 */       level[0] = "INFO";
/* 113 */       this.INFO = toLevel.invoke(null, level);
/* 114 */       level[0] = "DEBUG";
/* 115 */       this.DEBUG = toLevel.invoke(null, level);
/* 116 */       this.TRACE = this.DEBUG;
/*     */       try
/*     */       {
/*     */         try
/*     */         {
/* 124 */           this.TRACE = levelClass.getDeclaredField("TRACE").get(null);
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 129 */           levelClass = tcl.loadClass("org.jboss.logging.XLevel");
/* 130 */           Class[] toLevelSig = { String.class, this.DEBUG.getClass() };
/* 131 */           toLevel = levelClass.getMethod("toLevel", toLevelSig);
/* 132 */           Object[] args = { "TRACE", this.DEBUG };
/* 133 */           this.TRACE = toLevel.invoke(null, args);
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Throwable ignore)
/*     */       {
/*     */       }
/*     */ 
/* 142 */       loggerClass = tcl.loadClass("org.apache.log4j.Logger");
/* 143 */       Method getLogger = loggerClass.getMethod("getLogger", sig);
/* 144 */       Object[] args = { name };
/* 145 */       this.logger = getLogger.invoke(null, args);
/*     */ 
/* 147 */       priorityClass = tcl.loadClass("org.apache.log4j.Priority");
/* 148 */       Class[] isEnabledForSig = { priorityClass };
/* 149 */       this.isEnabledFor = loggerClass.getMethod("isEnabledFor", isEnabledForSig);
/*     */ 
/* 151 */       Class[] logSig = { String.class, priorityClass, Object.class, Throwable.class };
/* 152 */       this.log = loggerClass.getMethod("log", logSig);
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 156 */       StringBuffer msg = new StringBuffer();
/* 157 */       msg.append("[levelClass, ");
/* 158 */       if (levelClass != null)
/*     */       {
/* 160 */         displayClassInfo(levelClass, msg);
/*     */       }
/*     */       else
/*     */       {
/* 164 */         msg.append("null");
/*     */       }
/* 166 */       msg.append("]; ");
/* 167 */       msg.append("[priorityClass, ");
/* 168 */       if (priorityClass != null)
/*     */       {
/* 170 */         displayClassInfo(priorityClass, msg);
/*     */       }
/*     */       else
/*     */       {
/* 174 */         msg.append("null");
/*     */       }
/* 176 */       msg.append("]");
/* 177 */       msg.append("]; ");
/* 178 */       msg.append("[loggerClass, ");
/* 179 */       if (loggerClass != null)
/*     */       {
/* 181 */         displayClassInfo(loggerClass, msg);
/* 182 */         msg.append(", Methods:\n");
/* 183 */         Method[] methods = loggerClass.getMethods();
/* 184 */         for (int n = 0; n < methods.length; n++)
/*     */         {
/* 186 */           Method m = methods[n];
/* 187 */           msg.append(m);
/* 188 */           msg.append('\n');
/* 189 */           if (!m.getName().equals("isEnabledFor"))
/*     */             continue;
/* 191 */           Class[] sig = m.getParameterTypes();
/* 192 */           displayClassInfo(sig[0], msg);
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 198 */         msg.append("null");
/*     */       }
/* 200 */       msg.append("]");
/*     */ 
/* 202 */       throw new UndeclaredThrowableException(t, msg.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 208 */     return isEnabledFor(this.DEBUG);
/*     */   }
/*     */ 
/*     */   public boolean isErrorEnabled()
/*     */   {
/* 213 */     return isEnabledFor(this.ERROR);
/*     */   }
/*     */ 
/*     */   public boolean isFatalEnabled()
/*     */   {
/* 218 */     return isEnabledFor(this.FATAL);
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 223 */     return isEnabledFor(this.INFO);
/*     */   }
/*     */ 
/*     */   public boolean isTraceEnabled()
/*     */   {
/* 228 */     return isEnabledFor(this.TRACE);
/*     */   }
/*     */ 
/*     */   public boolean isWarnEnabled()
/*     */   {
/* 233 */     return isEnabledFor(this.WARN);
/*     */   }
/*     */ 
/*     */   public void trace(Object message)
/*     */   {
/* 238 */     log(this.TRACE, message, null);
/*     */   }
/*     */ 
/*     */   public void trace(Object message, Throwable t)
/*     */   {
/* 243 */     log(this.TRACE, message, t);
/*     */   }
/*     */ 
/*     */   public void debug(Object message)
/*     */   {
/* 248 */     log(this.DEBUG, message, null);
/*     */   }
/*     */ 
/*     */   public void debug(Object message, Throwable t)
/*     */   {
/* 253 */     log(this.DEBUG, message, t);
/*     */   }
/*     */ 
/*     */   public void info(Object message)
/*     */   {
/* 258 */     log(this.INFO, message, null);
/*     */   }
/*     */ 
/*     */   public void info(Object message, Throwable t)
/*     */   {
/* 263 */     log(this.INFO, message, t);
/*     */   }
/*     */ 
/*     */   public void warn(Object message)
/*     */   {
/* 268 */     log(this.WARN, message, null);
/*     */   }
/*     */ 
/*     */   public void warn(Object message, Throwable t)
/*     */   {
/* 273 */     log(this.WARN, message, t);
/*     */   }
/*     */ 
/*     */   public void error(Object message)
/*     */   {
/* 278 */     log(this.ERROR, message, null);
/*     */   }
/*     */ 
/*     */   public void error(Object message, Throwable t)
/*     */   {
/* 283 */     log(this.ERROR, message, t);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message)
/*     */   {
/* 288 */     log(this.FATAL, message, null);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message, Throwable t)
/*     */   {
/* 293 */     log(this.FATAL, message, t);
/*     */   }
/*     */ 
/*     */   private void log(Object level, Object message, Throwable t)
/*     */   {
/* 298 */     Object[] args = { "org.apache.commons.logging.impl.Log4JLogger", level, message, t };
/*     */     try
/*     */     {
/* 301 */       this.log.invoke(this.logger, args);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 305 */       throw new UndeclaredThrowableException(e);
/*     */     }
/*     */     catch (InvocationTargetException e)
/*     */     {
/* 309 */       throw new UndeclaredThrowableException(e.getTargetException());
/*     */     }
/*     */   }
/*     */ 
/*     */   private boolean isEnabledFor(Object level)
/*     */   {
/* 315 */     Object[] args = { level };
/*     */     try
/*     */     {
/* 318 */       Boolean flag = (Boolean)this.isEnabledFor.invoke(this.logger, args);
/* 319 */       return flag.booleanValue();
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 323 */       throw new UndeclaredThrowableException(e);
/*     */     }
/*     */     catch (InvocationTargetException e) {
/*     */     }
/* 327 */     throw new UndeclaredThrowableException(e.getTargetException());
/*     */   }
/*     */ 
/*     */   public static void displayClassInfo(Class clazz, StringBuffer results)
/*     */   {
/* 334 */     ClassLoader cl = clazz.getClassLoader();
/* 335 */     results.append("\n" + clazz.getName() + "(" + Integer.toHexString(clazz.hashCode()) + ").ClassLoader=" + cl);
/* 336 */     ClassLoader parent = cl;
/* 337 */     while (parent != null)
/*     */     {
/* 339 */       results.append("\n.." + parent);
/* 340 */       URL[] urls = getClassLoaderURLs(parent);
/* 341 */       int length = urls != null ? urls.length : 0;
/* 342 */       for (int u = 0; u < length; u++)
/*     */       {
/* 344 */         results.append("\n...." + urls[u]);
/*     */       }
/* 346 */       if (parent != null)
/* 347 */         parent = parent.getParent();
/*     */     }
/* 349 */     CodeSource clazzCS = clazz.getProtectionDomain().getCodeSource();
/* 350 */     if (clazzCS != null)
/* 351 */       results.append("\n++++CodeSource: " + clazzCS);
/*     */     else {
/* 353 */       results.append("\n++++Null CodeSource");
/*     */     }
/* 355 */     results.append("\nImplemented Interfaces:");
/* 356 */     Class[] ifaces = clazz.getInterfaces();
/* 357 */     for (int i = 0; i < ifaces.length; i++)
/*     */     {
/* 359 */       Class iface = ifaces[i];
/* 360 */       results.append("\n++" + iface + "(" + Integer.toHexString(iface.hashCode()) + ")");
/* 361 */       ClassLoader loader = ifaces[i].getClassLoader();
/* 362 */       results.append("\n++++ClassLoader: " + loader);
/* 363 */       ProtectionDomain pd = ifaces[i].getProtectionDomain();
/* 364 */       CodeSource cs = pd.getCodeSource();
/* 365 */       if (cs != null)
/* 366 */         results.append("\n++++CodeSource: " + cs);
/*     */       else
/* 368 */         results.append("\n++++Null CodeSource");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static URL[] getClassLoaderURLs(ClassLoader cl)
/*     */   {
/* 377 */     URL[] urls = new URL[0];
/*     */     try
/*     */     {
/* 380 */       Class returnType = urls.getClass();
/* 381 */       Class[] parameterTypes = new Class[0];
/* 382 */       Class clClass = cl.getClass();
/* 383 */       Method getURLs = clClass.getMethod("getURLs", parameterTypes);
/* 384 */       if (returnType.isAssignableFrom(getURLs.getReturnType()))
/*     */       {
/* 386 */         Object[] args = new Object[0];
/* 387 */         urls = (URL[])(URL[])getURLs.invoke(cl, args);
/*     */       }
/* 389 */       if ((urls == null) || (urls.length == 0))
/*     */       {
/* 391 */         Method getCp = clClass.getMethod("getClasspath", parameterTypes);
/* 392 */         if (returnType.isAssignableFrom(getCp.getReturnType()))
/*     */         {
/* 394 */           Object[] args = new Object[0];
/* 395 */           urls = (URL[])(URL[])getCp.invoke(cl, args);
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/* 402 */     return urls;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.logging.impl.Log4jProxy
 * JD-Core Version:    0.6.0
 */