/*     */ package org.apache.commons.logging.impl;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.apache.commons.logging.Log;
/*     */ 
/*     */ public class Log4JLogger
/*     */   implements Log, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  56 */   private String name = null;
/*     */   private transient Log theLogger;
/*     */ 
/*     */   public Log4JLogger()
/*     */   {
/*  63 */     this(null);
/*     */   }
/*     */ 
/*     */   public Log4JLogger(String name)
/*     */   {
/*  72 */     this.name = name;
/*     */     try
/*     */     {
/*  78 */       ClassLoader loader = Log4jProxy.threadContextClassLoader();
/*  79 */       Class priorityClass = Class.forName("org.apache.log4j.Priority", false, loader);
/*  80 */       Class levelClass = Class.forName("org.apache.log4j.Level", false, loader);
/*  81 */       if (!priorityClass.isAssignableFrom(levelClass))
/*     */       {
/*  84 */         throw new InstantiationError("Log4J 1.2 not available");
/*     */       }
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  89 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*  91 */     getLogger();
/*     */   }
/*     */ 
/*     */   public void trace(Object message)
/*     */   {
/* 103 */     getLogger().trace(message);
/*     */   }
/*     */ 
/*     */   public void trace(Object message, Throwable t)
/*     */   {
/* 117 */     getLogger().trace(message, t);
/*     */   }
/*     */ 
/*     */   public void debug(Object message)
/*     */   {
/* 128 */     getLogger().debug(message, null);
/*     */   }
/*     */ 
/*     */   public void debug(Object message, Throwable t)
/*     */   {
/* 139 */     getLogger().debug(message, t);
/*     */   }
/*     */ 
/*     */   public void info(Object message)
/*     */   {
/* 150 */     getLogger().info(message, null);
/*     */   }
/*     */ 
/*     */   public void info(Object message, Throwable t)
/*     */   {
/* 162 */     getLogger().info(message, t);
/*     */   }
/*     */ 
/*     */   public void warn(Object message)
/*     */   {
/* 173 */     getLogger().warn(message, null);
/*     */   }
/*     */ 
/*     */   public void warn(Object message, Throwable t)
/*     */   {
/* 185 */     getLogger().warn(message, t);
/*     */   }
/*     */ 
/*     */   public void error(Object message)
/*     */   {
/* 196 */     getLogger().error(message, null);
/*     */   }
/*     */ 
/*     */   public void error(Object message, Throwable t)
/*     */   {
/* 208 */     getLogger().error(message, t);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message)
/*     */   {
/* 219 */     getLogger().fatal(message, null);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message, Throwable t)
/*     */   {
/* 231 */     getLogger().fatal(message, t);
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 239 */     return getLogger().isDebugEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isErrorEnabled()
/*     */   {
/* 247 */     return getLogger().isErrorEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isFatalEnabled()
/*     */   {
/* 255 */     return getLogger().isFatalEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 263 */     return getLogger().isInfoEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isTraceEnabled()
/*     */   {
/* 273 */     return getLogger().isTraceEnabled();
/*     */   }
/*     */ 
/*     */   public boolean isWarnEnabled()
/*     */   {
/* 280 */     return getLogger().isWarnEnabled();
/*     */   }
/*     */ 
/*     */   Log getLogger()
/*     */   {
/* 287 */     if (this.theLogger == null)
/* 288 */       this.theLogger = new Log4jProxy(this.name);
/* 289 */     return this.theLogger;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.logging.impl.Log4JLogger
 * JD-Core Version:    0.6.0
 */