/*     */ package org.apache.commons.logging.impl;
/*     */ 
/*     */ import java.io.PrintWriter;
/*     */ import java.io.Serializable;
/*     */ import java.io.StringWriter;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.logging.Level;
/*     */ import java.util.logging.LogRecord;
/*     */ import java.util.logging.Logger;
/*     */ import org.apache.commons.logging.Log;
/*     */ 
/*     */ public class Jdk13LumberjackLogger
/*     */   implements Log, Serializable
/*     */ {
/*  54 */   protected transient Logger logger = null;
/*  55 */   protected String name = null;
/*  56 */   private String sourceClassName = "unknown";
/*  57 */   private String sourceMethodName = "unknown";
/*  58 */   private boolean classAndMethodFound = false;
/*     */ 
/*  67 */   protected static final Level dummyLevel = Level.FINE;
/*     */ 
/*     */   public Jdk13LumberjackLogger(String name)
/*     */   {
/*  79 */     this.name = name;
/*  80 */     this.logger = getLogger();
/*     */   }
/*     */ 
/*     */   private void log(Level level, String msg, Throwable ex)
/*     */   {
/*  89 */     if (getLogger().isLoggable(level)) {
/*  90 */       LogRecord record = new LogRecord(level, msg);
/*  91 */       if (!this.classAndMethodFound) {
/*  92 */         getClassAndMethod();
/*     */       }
/*  94 */       record.setSourceClassName(this.sourceClassName);
/*  95 */       record.setSourceMethodName(this.sourceMethodName);
/*  96 */       if (ex != null) {
/*  97 */         record.setThrown(ex);
/*     */       }
/*  99 */       getLogger().log(record);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void getClassAndMethod()
/*     */   {
/*     */     try
/*     */     {
/* 109 */       Throwable throwable = new Throwable();
/* 110 */       throwable.fillInStackTrace();
/* 111 */       StringWriter stringWriter = new StringWriter();
/* 112 */       PrintWriter printWriter = new PrintWriter(stringWriter);
/* 113 */       throwable.printStackTrace(printWriter);
/* 114 */       String traceString = stringWriter.getBuffer().toString();
/* 115 */       StringTokenizer tokenizer = new StringTokenizer(traceString, "\n");
/*     */ 
/* 117 */       tokenizer.nextToken();
/* 118 */       String line = tokenizer.nextToken();
/* 119 */       while (line.indexOf(getClass().getName()) == -1) {
/* 120 */         line = tokenizer.nextToken();
/*     */       }
/* 122 */       while (line.indexOf(getClass().getName()) >= 0) {
/* 123 */         line = tokenizer.nextToken();
/*     */       }
/* 125 */       int start = line.indexOf("at ") + 3;
/* 126 */       int end = line.indexOf('(');
/* 127 */       String temp = line.substring(start, end);
/* 128 */       int lastPeriod = temp.lastIndexOf('.');
/* 129 */       this.sourceClassName = temp.substring(0, lastPeriod);
/* 130 */       this.sourceMethodName = temp.substring(lastPeriod + 1);
/*     */     }
/*     */     catch (Exception ex) {
/*     */     }
/* 134 */     this.classAndMethodFound = true;
/*     */   }
/*     */ 
/*     */   public void debug(Object message)
/*     */   {
/* 144 */     log(Level.FINE, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void debug(Object message, Throwable exception)
/*     */   {
/* 156 */     log(Level.FINE, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public void error(Object message)
/*     */   {
/* 167 */     log(Level.SEVERE, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void error(Object message, Throwable exception)
/*     */   {
/* 179 */     log(Level.SEVERE, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message)
/*     */   {
/* 190 */     log(Level.SEVERE, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message, Throwable exception)
/*     */   {
/* 202 */     log(Level.SEVERE, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public Logger getLogger()
/*     */   {
/* 210 */     if (this.logger == null) {
/* 211 */       this.logger = Logger.getLogger(this.name);
/*     */     }
/* 213 */     return this.logger;
/*     */   }
/*     */ 
/*     */   public void info(Object message)
/*     */   {
/* 224 */     log(Level.INFO, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void info(Object message, Throwable exception)
/*     */   {
/* 236 */     log(Level.INFO, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 244 */     return getLogger().isLoggable(Level.FINE);
/*     */   }
/*     */ 
/*     */   public boolean isErrorEnabled()
/*     */   {
/* 252 */     return getLogger().isLoggable(Level.SEVERE);
/*     */   }
/*     */ 
/*     */   public boolean isFatalEnabled()
/*     */   {
/* 260 */     return getLogger().isLoggable(Level.SEVERE);
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 268 */     return getLogger().isLoggable(Level.INFO);
/*     */   }
/*     */ 
/*     */   public boolean isTraceEnabled()
/*     */   {
/* 276 */     return getLogger().isLoggable(Level.FINEST);
/*     */   }
/*     */ 
/*     */   public boolean isWarnEnabled()
/*     */   {
/* 284 */     return getLogger().isLoggable(Level.WARNING);
/*     */   }
/*     */ 
/*     */   public void trace(Object message)
/*     */   {
/* 295 */     log(Level.FINEST, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void trace(Object message, Throwable exception)
/*     */   {
/* 307 */     log(Level.FINEST, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public void warn(Object message)
/*     */   {
/* 318 */     log(Level.WARNING, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void warn(Object message, Throwable exception)
/*     */   {
/* 330 */     log(Level.WARNING, String.valueOf(message), exception);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.logging.impl.Jdk13LumberjackLogger
 * JD-Core Version:    0.6.0
 */