/*     */ package org.apache.commons.collections.iterators;
/*     */ 
/*     */ import java.util.Iterator;
/*     */ import org.apache.commons.collections.Transformer;
/*     */ 
/*     */ public class TransformIterator
/*     */   implements Iterator
/*     */ {
/*     */   private Iterator iterator;
/*     */   private Transformer transformer;
/*     */ 
/*     */   public TransformIterator()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TransformIterator(Iterator iterator)
/*     */   {
/*  56 */     this.iterator = iterator;
/*     */   }
/*     */ 
/*     */   public TransformIterator(Iterator iterator, Transformer transformer)
/*     */   {
/*  69 */     this.iterator = iterator;
/*  70 */     this.transformer = transformer;
/*     */   }
/*     */ 
/*     */   public boolean hasNext()
/*     */   {
/*  75 */     return this.iterator.hasNext();
/*     */   }
/*     */ 
/*     */   public Object next()
/*     */   {
/*  87 */     return transform(this.iterator.next());
/*     */   }
/*     */ 
/*     */   public void remove() {
/*  91 */     this.iterator.remove();
/*     */   }
/*     */ 
/*     */   public Iterator getIterator()
/*     */   {
/* 101 */     return this.iterator;
/*     */   }
/*     */ 
/*     */   public void setIterator(Iterator iterator)
/*     */   {
/* 111 */     this.iterator = iterator;
/*     */   }
/*     */ 
/*     */   public Transformer getTransformer()
/*     */   {
/* 121 */     return this.transformer;
/*     */   }
/*     */ 
/*     */   public void setTransformer(Transformer transformer)
/*     */   {
/* 131 */     this.transformer = transformer;
/*     */   }
/*     */ 
/*     */   protected Object transform(Object source)
/*     */   {
/* 143 */     if (this.transformer != null) {
/* 144 */       return this.transformer.transform(source);
/*     */     }
/* 146 */     return source;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.iterators.TransformIterator
 * JD-Core Version:    0.6.0
 */