/*     */ package org.apache.commons.collections.iterators;
/*     */ 
/*     */ import java.util.ListIterator;
/*     */ import java.util.NoSuchElementException;
/*     */ import org.apache.commons.collections.ResettableListIterator;
/*     */ 
/*     */ public class ObjectArrayListIterator extends ObjectArrayIterator
/*     */   implements ListIterator, ResettableListIterator
/*     */ {
/*  52 */   protected int lastItemIndex = -1;
/*     */ 
/*     */   public ObjectArrayListIterator()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ObjectArrayListIterator(Object[] array)
/*     */   {
/*  72 */     super(array);
/*     */   }
/*     */ 
/*     */   public ObjectArrayListIterator(Object[] array, int start)
/*     */   {
/*  85 */     super(array, start);
/*     */   }
/*     */ 
/*     */   public ObjectArrayListIterator(Object[] array, int start, int end)
/*     */   {
/* 100 */     super(array, start, end);
/*     */   }
/*     */ 
/*     */   public boolean hasPrevious()
/*     */   {
/* 112 */     return this.index > this.startIndex;
/*     */   }
/*     */ 
/*     */   public Object previous()
/*     */   {
/* 122 */     if (!hasPrevious()) {
/* 123 */       throw new NoSuchElementException();
/*     */     }
/* 125 */     this.lastItemIndex = (--this.index);
/* 126 */     return this.array[this.index];
/*     */   }
/*     */ 
/*     */   public Object next()
/*     */   {
/* 136 */     if (!hasNext()) {
/* 137 */       throw new NoSuchElementException();
/*     */     }
/* 139 */     this.lastItemIndex = this.index;
/* 140 */     return this.array[(this.index++)];
/*     */   }
/*     */ 
/*     */   public int nextIndex()
/*     */   {
/* 149 */     return this.index - this.startIndex;
/*     */   }
/*     */ 
/*     */   public int previousIndex()
/*     */   {
/* 158 */     return this.index - this.startIndex - 1;
/*     */   }
/*     */ 
/*     */   public void add(Object obj)
/*     */   {
/* 169 */     throw new UnsupportedOperationException("add() method is not supported");
/*     */   }
/*     */ 
/*     */   public void set(Object obj)
/*     */   {
/* 190 */     if (this.lastItemIndex == -1) {
/* 191 */       throw new IllegalStateException("must call next() or previous() before a call to set()");
/*     */     }
/*     */ 
/* 194 */     this.array[this.lastItemIndex] = obj;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 201 */     super.reset();
/* 202 */     this.lastItemIndex = -1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.iterators.ObjectArrayListIterator
 * JD-Core Version:    0.6.0
 */