/*     */ package org.apache.commons.collections.iterators;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.NoSuchElementException;
/*     */ import org.apache.commons.collections.ResettableIterator;
/*     */ 
/*     */ public class LoopingIterator
/*     */   implements ResettableIterator
/*     */ {
/*     */   private Collection collection;
/*     */   private Iterator iterator;
/*     */ 
/*     */   public LoopingIterator(Collection coll)
/*     */   {
/*  57 */     if (coll == null) {
/*  58 */       throw new NullPointerException("The collection must not be null");
/*     */     }
/*  60 */     this.collection = coll;
/*  61 */     reset();
/*     */   }
/*     */ 
/*     */   public boolean hasNext()
/*     */   {
/*  73 */     return this.collection.size() > 0;
/*     */   }
/*     */ 
/*     */   public Object next()
/*     */   {
/*  85 */     if (this.collection.size() == 0) {
/*  86 */       throw new NoSuchElementException("There are no elements for this iterator to loop on");
/*     */     }
/*  88 */     if (!this.iterator.hasNext()) {
/*  89 */       reset();
/*     */     }
/*  91 */     return this.iterator.next();
/*     */   }
/*     */ 
/*     */   public void remove()
/*     */   {
/* 107 */     this.iterator.remove();
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 114 */     this.iterator = this.collection.iterator();
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 123 */     return this.collection.size();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.iterators.LoopingIterator
 * JD-Core Version:    0.6.0
 */