/*    */ package org.apache.commons.collections.iterators;
/*    */ 
/*    */ import java.util.NoSuchElementException;
/*    */ 
/*    */ abstract class AbstractEmptyIterator
/*    */ {
/*    */   public boolean hasNext()
/*    */   {
/* 38 */     return false;
/*    */   }
/*    */ 
/*    */   public Object next() {
/* 42 */     throw new NoSuchElementException("Iterator contains no elements");
/*    */   }
/*    */ 
/*    */   public boolean hasPrevious() {
/* 46 */     return false;
/*    */   }
/*    */ 
/*    */   public Object previous() {
/* 50 */     throw new NoSuchElementException("Iterator contains no elements");
/*    */   }
/*    */ 
/*    */   public int nextIndex() {
/* 54 */     return 0;
/*    */   }
/*    */ 
/*    */   public int previousIndex() {
/* 58 */     return -1;
/*    */   }
/*    */ 
/*    */   public void add(Object obj) {
/* 62 */     throw new UnsupportedOperationException("add() not supported for empty Iterator");
/*    */   }
/*    */ 
/*    */   public void set(Object obj) {
/* 66 */     throw new IllegalStateException("Iterator contains no elements");
/*    */   }
/*    */ 
/*    */   public void remove() {
/* 70 */     throw new IllegalStateException("Iterator contains no elements");
/*    */   }
/*    */ 
/*    */   public Object getKey() {
/* 74 */     throw new IllegalStateException("Iterator contains no elements");
/*    */   }
/*    */ 
/*    */   public Object getValue() {
/* 78 */     throw new IllegalStateException("Iterator contains no elements");
/*    */   }
/*    */ 
/*    */   public Object setValue(Object value) {
/* 82 */     throw new IllegalStateException("Iterator contains no elements");
/*    */   }
/*    */ 
/*    */   public void reset()
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.iterators.AbstractEmptyIterator
 * JD-Core Version:    0.6.0
 */