/*     */ package org.apache.commons.collections.functors;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import org.apache.commons.collections.Predicate;
/*     */ import org.apache.commons.collections.Transformer;
/*     */ 
/*     */ public final class TransformedPredicate
/*     */   implements Predicate, PredicateDecorator, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -5596090919668315834L;
/*     */   private final Transformer iTransformer;
/*     */   private final Predicate iPredicate;
/*     */ 
/*     */   public static Predicate getInstance(Transformer transformer, Predicate predicate)
/*     */   {
/*  51 */     if (transformer == null) {
/*  52 */       throw new IllegalArgumentException("The transformer to call must not be null");
/*     */     }
/*  54 */     if (predicate == null) {
/*  55 */       throw new IllegalArgumentException("The predicate to call must not be null");
/*     */     }
/*  57 */     return new TransformedPredicate(transformer, predicate);
/*     */   }
/*     */ 
/*     */   public TransformedPredicate(Transformer transformer, Predicate predicate)
/*     */   {
/*  68 */     this.iTransformer = transformer;
/*  69 */     this.iPredicate = predicate;
/*     */   }
/*     */ 
/*     */   public boolean evaluate(Object object)
/*     */   {
/*  80 */     Object result = this.iTransformer.transform(object);
/*  81 */     return this.iPredicate.evaluate(result);
/*     */   }
/*     */ 
/*     */   public Predicate[] getPredicates()
/*     */   {
/*  91 */     return new Serializable[] { this.iPredicate };
/*     */   }
/*     */ 
/*     */   public Transformer getTransformer()
/*     */   {
/* 100 */     return this.iTransformer;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.TransformedPredicate
 * JD-Core Version:    0.6.0
 */