/*    */ package org.apache.commons.collections.functors;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.apache.commons.collections.FunctorException;
/*    */ import org.apache.commons.collections.Predicate;
/*    */ 
/*    */ public final class NullIsExceptionPredicate
/*    */   implements Predicate, PredicateDecorator, Serializable
/*    */ {
/*    */   static final long serialVersionUID = 3243449850504576071L;
/*    */   private final Predicate iPredicate;
/*    */ 
/*    */   public static Predicate getInstance(Predicate predicate)
/*    */   {
/* 47 */     if (predicate == null) {
/* 48 */       throw new IllegalArgumentException("Predicate must not be null");
/*    */     }
/* 50 */     return new NullIsExceptionPredicate(predicate);
/*    */   }
/*    */ 
/*    */   public NullIsExceptionPredicate(Predicate predicate)
/*    */   {
/* 61 */     this.iPredicate = predicate;
/*    */   }
/*    */ 
/*    */   public boolean evaluate(Object object)
/*    */   {
/* 73 */     if (object == null) {
/* 74 */       throw new FunctorException("Input Object must not be null");
/*    */     }
/* 76 */     return this.iPredicate.evaluate(object);
/*    */   }
/*    */ 
/*    */   public Predicate[] getPredicates()
/*    */   {
/* 86 */     return new Serializable[] { this.iPredicate };
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.NullIsExceptionPredicate
 * JD-Core Version:    0.6.0
 */