/*     */ package org.apache.commons.collections.functors;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import org.apache.commons.collections.Predicate;
/*     */ 
/*     */ public final class NonePredicate
/*     */   implements Predicate, PredicateDecorator, Serializable
/*     */ {
/*     */   static final long serialVersionUID = 2007613066565892961L;
/*     */   private final Predicate[] iPredicates;
/*     */ 
/*     */   public static Predicate getInstance(Predicate[] predicates)
/*     */   {
/*  49 */     FunctorUtils.validateMin2(predicates);
/*  50 */     predicates = FunctorUtils.copy(predicates);
/*  51 */     return new NonePredicate(predicates);
/*     */   }
/*     */ 
/*     */   public static Predicate getInstance(Collection predicates)
/*     */   {
/*  64 */     Predicate[] preds = FunctorUtils.validate(predicates);
/*  65 */     return new NonePredicate(preds);
/*     */   }
/*     */ 
/*     */   public NonePredicate(Predicate[] predicates)
/*     */   {
/*  76 */     this.iPredicates = predicates;
/*     */   }
/*     */ 
/*     */   public boolean evaluate(Object object)
/*     */   {
/*  86 */     for (int i = 0; i < this.iPredicates.length; i++) {
/*  87 */       if (this.iPredicates[i].evaluate(object)) {
/*  88 */         return false;
/*     */       }
/*     */     }
/*  91 */     return true;
/*     */   }
/*     */ 
/*     */   public Predicate[] getPredicates()
/*     */   {
/* 101 */     return this.iPredicates;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.NonePredicate
 * JD-Core Version:    0.6.0
 */