/*    */ package org.apache.commons.collections.buffer;
/*    */ 
/*    */ import org.apache.commons.collections.Buffer;
/*    */ import org.apache.commons.collections.collection.SynchronizedCollection;
/*    */ 
/*    */ public class SynchronizedBuffer extends SynchronizedCollection
/*    */   implements Buffer
/*    */ {
/*    */   private static final long serialVersionUID = -6859936183953626253L;
/*    */ 
/*    */   public static Buffer decorate(Buffer buffer)
/*    */   {
/* 47 */     return new SynchronizedBuffer(buffer);
/*    */   }
/*    */ 
/*    */   protected SynchronizedBuffer(Buffer buffer)
/*    */   {
/* 58 */     super(buffer);
/*    */   }
/*    */ 
/*    */   protected SynchronizedBuffer(Buffer buffer, Object lock)
/*    */   {
/* 69 */     super(buffer, lock);
/*    */   }
/*    */ 
/*    */   protected Buffer getBuffer()
/*    */   {
/* 78 */     return (Buffer)this.collection;
/*    */   }
/*    */ 
/*    */   public Object get()
/*    */   {
/* 83 */     synchronized (this.lock) {
/* 84 */       return getBuffer().get();
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object remove() {
/* 89 */     synchronized (this.lock) {
/* 90 */       return getBuffer().remove();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.buffer.SynchronizedBuffer
 * JD-Core Version:    0.6.0
 */