/*     */ package org.apache.commons.collections.bidimap;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.apache.commons.collections.BidiMap;
/*     */ import org.apache.commons.collections.MapIterator;
/*     */ import org.apache.commons.collections.ResettableIterator;
/*     */ import org.apache.commons.collections.collection.AbstractCollectionDecorator;
/*     */ import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
/*     */ import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;
/*     */ 
/*     */ public abstract class AbstractDualBidiMap
/*     */   implements BidiMap
/*     */ {
/*  50 */   protected final transient Map[] maps = new Map[2];
/*     */ 
/*  54 */   protected transient BidiMap inverseBidiMap = null;
/*     */ 
/*  58 */   protected transient Set keySet = null;
/*     */ 
/*  62 */   protected transient Collection values = null;
/*     */ 
/*  66 */   protected transient Set entrySet = null;
/*     */ 
/*     */   protected AbstractDualBidiMap()
/*     */   {
/*  77 */     this.maps[0] = createMap();
/*  78 */     this.maps[1] = createMap();
/*     */   }
/*     */ 
/*     */   protected AbstractDualBidiMap(Map normalMap, Map reverseMap)
/*     */   {
/*  97 */     this.maps[0] = normalMap;
/*  98 */     this.maps[1] = reverseMap;
/*     */   }
/*     */ 
/*     */   protected AbstractDualBidiMap(Map normalMap, Map reverseMap, BidiMap inverseBidiMap)
/*     */   {
/* 111 */     this.maps[0] = normalMap;
/* 112 */     this.maps[1] = reverseMap;
/* 113 */     this.inverseBidiMap = inverseBidiMap;
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   protected Map createMap()
/*     */   {
/* 127 */     return null;
/*     */   }
/*     */ 
/*     */   protected abstract BidiMap createBidiMap(Map paramMap1, Map paramMap2, BidiMap paramBidiMap);
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 143 */     return this.maps[0].get(key);
/*     */   }
/*     */ 
/*     */   public int size() {
/* 147 */     return this.maps[0].size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty() {
/* 151 */     return this.maps[0].isEmpty();
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key) {
/* 155 */     return this.maps[0].containsKey(key);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj) {
/* 159 */     return this.maps[0].equals(obj);
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 163 */     return this.maps[0].hashCode();
/*     */   }
/*     */ 
/*     */   public String toString() {
/* 167 */     return this.maps[0].toString();
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/* 173 */     if (this.maps[0].containsKey(key)) {
/* 174 */       this.maps[1].remove(this.maps[0].get(key));
/*     */     }
/* 176 */     if (this.maps[1].containsKey(value)) {
/* 177 */       this.maps[0].remove(this.maps[1].get(value));
/*     */     }
/* 179 */     Object obj = this.maps[0].put(key, value);
/* 180 */     this.maps[1].put(value, key);
/* 181 */     return obj;
/*     */   }
/*     */ 
/*     */   public void putAll(Map map) {
/* 185 */     for (Iterator it = map.entrySet().iterator(); it.hasNext(); ) {
/* 186 */       Map.Entry entry = (Map.Entry)it.next();
/* 187 */       put(entry.getKey(), entry.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object remove(Object key) {
/* 192 */     Object value = null;
/* 193 */     if (this.maps[0].containsKey(key)) {
/* 194 */       value = this.maps[0].remove(key);
/* 195 */       this.maps[1].remove(value);
/*     */     }
/* 197 */     return value;
/*     */   }
/*     */ 
/*     */   public void clear() {
/* 201 */     this.maps[0].clear();
/* 202 */     this.maps[1].clear();
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object value) {
/* 206 */     return this.maps[1].containsKey(value);
/*     */   }
/*     */ 
/*     */   public MapIterator mapIterator()
/*     */   {
/* 223 */     return new BidiMapIterator(this);
/*     */   }
/*     */ 
/*     */   public Object getKey(Object value) {
/* 227 */     return this.maps[1].get(value);
/*     */   }
/*     */ 
/*     */   public Object removeValue(Object value) {
/* 231 */     Object key = null;
/* 232 */     if (this.maps[1].containsKey(value)) {
/* 233 */       key = this.maps[1].remove(value);
/* 234 */       this.maps[0].remove(key);
/*     */     }
/* 236 */     return key;
/*     */   }
/*     */ 
/*     */   public BidiMap inverseBidiMap() {
/* 240 */     if (this.inverseBidiMap == null) {
/* 241 */       this.inverseBidiMap = createBidiMap(this.maps[1], this.maps[0], this);
/*     */     }
/* 243 */     return this.inverseBidiMap;
/*     */   }
/*     */ 
/*     */   public Set keySet()
/*     */   {
/* 256 */     if (this.keySet == null) {
/* 257 */       this.keySet = new KeySet(this);
/*     */     }
/* 259 */     return this.keySet;
/*     */   }
/*     */ 
/*     */   protected Iterator createKeySetIterator(Iterator iterator)
/*     */   {
/* 270 */     return new KeySetIterator(iterator, this);
/*     */   }
/*     */ 
/*     */   public Collection values()
/*     */   {
/* 281 */     if (this.values == null) {
/* 282 */       this.values = new Values(this);
/*     */     }
/* 284 */     return this.values;
/*     */   }
/*     */ 
/*     */   protected Iterator createValuesIterator(Iterator iterator)
/*     */   {
/* 295 */     return new ValuesIterator(iterator, this);
/*     */   }
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/* 310 */     if (this.entrySet == null) {
/* 311 */       this.entrySet = new EntrySet(this);
/*     */     }
/* 313 */     return this.entrySet;
/*     */   }
/*     */ 
/*     */   protected Iterator createEntrySetIterator(Iterator iterator)
/*     */   {
/* 324 */     return new EntrySetIterator(iterator, this);
/*     */   }
/*     */ 
/*     */   protected static class BidiMapIterator
/*     */     implements MapIterator, ResettableIterator
/*     */   {
/*     */     protected final AbstractDualBidiMap parent;
/*     */     protected Iterator iterator;
/* 649 */     protected Map.Entry last = null;
/*     */ 
/* 651 */     protected boolean canRemove = false;
/*     */ 
/*     */     protected BidiMapIterator(AbstractDualBidiMap parent)
/*     */     {
/* 659 */       this.parent = parent;
/* 660 */       this.iterator = parent.maps[0].entrySet().iterator();
/*     */     }
/*     */ 
/*     */     public boolean hasNext() {
/* 664 */       return this.iterator.hasNext();
/*     */     }
/*     */ 
/*     */     public Object next() {
/* 668 */       this.last = ((Map.Entry)this.iterator.next());
/* 669 */       this.canRemove = true;
/* 670 */       return this.last.getKey();
/*     */     }
/*     */ 
/*     */     public void remove() {
/* 674 */       if (!this.canRemove) {
/* 675 */         throw new IllegalStateException("Iterator remove() can only be called once after next()");
/*     */       }
/*     */ 
/* 678 */       Object value = this.last.getValue();
/* 679 */       this.iterator.remove();
/* 680 */       this.parent.maps[1].remove(value);
/* 681 */       this.last = null;
/* 682 */       this.canRemove = false;
/*     */     }
/*     */ 
/*     */     public Object getKey() {
/* 686 */       if (this.last == null) {
/* 687 */         throw new IllegalStateException("Iterator getKey() can only be called after next() and before remove()");
/*     */       }
/* 689 */       return this.last.getKey();
/*     */     }
/*     */ 
/*     */     public Object getValue() {
/* 693 */       if (this.last == null) {
/* 694 */         throw new IllegalStateException("Iterator getValue() can only be called after next() and before remove()");
/*     */       }
/* 696 */       return this.last.getValue();
/*     */     }
/*     */ 
/*     */     public Object setValue(Object value) {
/* 700 */       if (this.last == null) {
/* 701 */         throw new IllegalStateException("Iterator setValue() can only be called after next() and before remove()");
/*     */       }
/* 703 */       if ((this.parent.maps[1].containsKey(value)) && (this.parent.maps[1].get(value) != this.last.getKey()))
/*     */       {
/* 705 */         throw new IllegalArgumentException("Cannot use setValue() when the object being set is already in the map");
/*     */       }
/* 707 */       return this.parent.put(this.last.getKey(), value);
/*     */     }
/*     */ 
/*     */     public void reset() {
/* 711 */       this.iterator = this.parent.maps[0].entrySet().iterator();
/* 712 */       this.last = null;
/* 713 */       this.canRemove = false;
/*     */     }
/*     */ 
/*     */     public String toString() {
/* 717 */       if (this.last != null) {
/* 718 */         return "MapIterator[" + getKey() + "=" + getValue() + "]";
/*     */       }
/* 720 */       return "MapIterator[]";
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class MapEntry extends AbstractMapEntryDecorator
/*     */   {
/*     */     protected final AbstractDualBidiMap parent;
/*     */ 
/*     */     protected MapEntry(Map.Entry entry, AbstractDualBidiMap parent)
/*     */     {
/* 623 */       super();
/* 624 */       this.parent = parent;
/*     */     }
/*     */ 
/*     */     public Object setValue(Object value) {
/* 628 */       Object key = getKey();
/* 629 */       if ((this.parent.maps[1].containsKey(value)) && (this.parent.maps[1].get(value) != key))
/*     */       {
/* 631 */         throw new IllegalArgumentException("Cannot use setValue() when the object being set is already in the map");
/*     */       }
/* 633 */       this.parent.put(key, value);
/* 634 */       Object oldValue = super.setValue(value);
/* 635 */       return oldValue;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class EntrySetIterator extends AbstractIteratorDecorator
/*     */   {
/*     */     protected final AbstractDualBidiMap parent;
/* 576 */     protected Map.Entry last = null;
/*     */ 
/* 578 */     protected boolean canRemove = false;
/*     */ 
/*     */     protected EntrySetIterator(Iterator iterator, AbstractDualBidiMap parent)
/*     */     {
/* 586 */       super();
/* 587 */       this.parent = parent;
/*     */     }
/*     */ 
/*     */     public Object next() {
/* 591 */       this.last = new AbstractDualBidiMap.MapEntry((Map.Entry)super.next(), this.parent);
/* 592 */       this.canRemove = true;
/* 593 */       return this.last;
/*     */     }
/*     */ 
/*     */     public void remove() {
/* 597 */       if (!this.canRemove) {
/* 598 */         throw new IllegalStateException("Iterator remove() can only be called once after next()");
/*     */       }
/*     */ 
/* 601 */       Object value = this.last.getValue();
/* 602 */       super.remove();
/* 603 */       this.parent.maps[1].remove(value);
/* 604 */       this.last = null;
/* 605 */       this.canRemove = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class EntrySet extends AbstractDualBidiMap.View
/*     */     implements Set
/*     */   {
/*     */     protected EntrySet(AbstractDualBidiMap parent)
/*     */     {
/* 543 */       super(parent);
/*     */     }
/*     */ 
/*     */     public Iterator iterator() {
/* 547 */       return this.parent.createEntrySetIterator(super.iterator());
/*     */     }
/*     */ 
/*     */     public boolean remove(Object obj) {
/* 551 */       if (!(obj instanceof Map.Entry)) {
/* 552 */         return false;
/*     */       }
/* 554 */       Map.Entry entry = (Map.Entry)obj;
/* 555 */       Object key = entry.getKey();
/* 556 */       if (this.parent.containsKey(key)) {
/* 557 */         Object value = this.parent.maps[0].get(key);
/* 558 */         if (value == null ? entry.getValue() == null : value.equals(entry.getValue())) {
/* 559 */           this.parent.maps[0].remove(key);
/* 560 */           this.parent.maps[1].remove(value);
/* 561 */           return true;
/*     */         }
/*     */       }
/* 564 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class ValuesIterator extends AbstractIteratorDecorator
/*     */   {
/*     */     protected final AbstractDualBidiMap parent;
/* 500 */     protected Object lastValue = null;
/*     */ 
/* 502 */     protected boolean canRemove = false;
/*     */ 
/*     */     protected ValuesIterator(Iterator iterator, AbstractDualBidiMap parent)
/*     */     {
/* 510 */       super();
/* 511 */       this.parent = parent;
/*     */     }
/*     */ 
/*     */     public Object next() {
/* 515 */       this.lastValue = super.next();
/* 516 */       this.canRemove = true;
/* 517 */       return this.lastValue;
/*     */     }
/*     */ 
/*     */     public void remove() {
/* 521 */       if (!this.canRemove) {
/* 522 */         throw new IllegalStateException("Iterator remove() can only be called once after next()");
/*     */       }
/* 524 */       super.remove();
/* 525 */       this.parent.maps[1].remove(this.lastValue);
/* 526 */       this.lastValue = null;
/* 527 */       this.canRemove = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class Values extends AbstractDualBidiMap.View
/*     */     implements Set
/*     */   {
/*     */     protected Values(AbstractDualBidiMap parent)
/*     */     {
/* 471 */       super(parent);
/*     */     }
/*     */ 
/*     */     public Iterator iterator() {
/* 475 */       return this.parent.createValuesIterator(super.iterator());
/*     */     }
/*     */ 
/*     */     public boolean contains(Object value) {
/* 479 */       return this.parent.maps[1].containsKey(value);
/*     */     }
/*     */ 
/*     */     public boolean remove(Object value) {
/* 483 */       if (this.parent.maps[1].containsKey(value)) {
/* 484 */         Object key = this.parent.maps[1].remove(value);
/* 485 */         this.parent.maps[0].remove(key);
/* 486 */         return true;
/*     */       }
/* 488 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class KeySetIterator extends AbstractIteratorDecorator
/*     */   {
/*     */     protected final AbstractDualBidiMap parent;
/* 427 */     protected Object lastKey = null;
/*     */ 
/* 429 */     protected boolean canRemove = false;
/*     */ 
/*     */     protected KeySetIterator(Iterator iterator, AbstractDualBidiMap parent)
/*     */     {
/* 437 */       super();
/* 438 */       this.parent = parent;
/*     */     }
/*     */ 
/*     */     public Object next() {
/* 442 */       this.lastKey = super.next();
/* 443 */       this.canRemove = true;
/* 444 */       return this.lastKey;
/*     */     }
/*     */ 
/*     */     public void remove() {
/* 448 */       if (!this.canRemove) {
/* 449 */         throw new IllegalStateException("Iterator remove() can only be called once after next()");
/*     */       }
/* 451 */       Object value = this.parent.maps[0].get(this.lastKey);
/* 452 */       super.remove();
/* 453 */       this.parent.maps[1].remove(value);
/* 454 */       this.lastKey = null;
/* 455 */       this.canRemove = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class KeySet extends AbstractDualBidiMap.View
/*     */     implements Set
/*     */   {
/*     */     protected KeySet(AbstractDualBidiMap parent)
/*     */     {
/* 398 */       super(parent);
/*     */     }
/*     */ 
/*     */     public Iterator iterator() {
/* 402 */       return this.parent.createKeySetIterator(super.iterator());
/*     */     }
/*     */ 
/*     */     public boolean contains(Object key) {
/* 406 */       return this.parent.maps[0].containsKey(key);
/*     */     }
/*     */ 
/*     */     public boolean remove(Object key) {
/* 410 */       if (this.parent.maps[0].containsKey(key)) {
/* 411 */         Object value = this.parent.maps[0].remove(key);
/* 412 */         this.parent.maps[1].remove(value);
/* 413 */         return true;
/*     */       }
/* 415 */       return false;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static abstract class View extends AbstractCollectionDecorator
/*     */   {
/*     */     protected final AbstractDualBidiMap parent;
/*     */ 
/*     */     protected View(Collection coll, AbstractDualBidiMap parent)
/*     */     {
/* 343 */       super();
/* 344 */       this.parent = parent;
/*     */     }
/*     */ 
/*     */     public boolean removeAll(Collection coll) {
/* 348 */       if ((this.parent.isEmpty()) || (coll.isEmpty())) {
/* 349 */         return false;
/*     */       }
/* 351 */       boolean modified = false;
/* 352 */       Iterator it = iterator();
/* 353 */       while (it.hasNext()) {
/* 354 */         if (coll.contains(it.next())) {
/* 355 */           it.remove();
/* 356 */           modified = true;
/*     */         }
/*     */       }
/* 359 */       return modified;
/*     */     }
/*     */ 
/*     */     public boolean retainAll(Collection coll) {
/* 363 */       if (this.parent.isEmpty()) {
/* 364 */         return false;
/*     */       }
/* 366 */       if (coll.isEmpty()) {
/* 367 */         this.parent.clear();
/* 368 */         return true;
/*     */       }
/* 370 */       boolean modified = false;
/* 371 */       Iterator it = iterator();
/* 372 */       while (it.hasNext()) {
/* 373 */         if (!coll.contains(it.next())) {
/* 374 */           it.remove();
/* 375 */           modified = true;
/*     */         }
/*     */       }
/* 378 */       return modified;
/*     */     }
/*     */ 
/*     */     public void clear() {
/* 382 */       this.parent.clear();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.bidimap.AbstractDualBidiMap
 * JD-Core Version:    0.6.0
 */