/*     */ package org.apache.commons.collections.bag;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import org.apache.commons.collections.Bag;
/*     */ import org.apache.commons.collections.Unmodifiable;
/*     */ import org.apache.commons.collections.iterators.UnmodifiableIterator;
/*     */ import org.apache.commons.collections.set.UnmodifiableSet;
/*     */ 
/*     */ public final class UnmodifiableBag extends AbstractBagDecorator
/*     */   implements Unmodifiable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -1873799975157099624L;
/*     */ 
/*     */   public static Bag decorate(Bag bag)
/*     */   {
/*  57 */     if ((bag instanceof Serializable)) {
/*  58 */       return bag;
/*     */     }
/*  60 */     return new UnmodifiableBag(bag);
/*     */   }
/*     */ 
/*     */   private UnmodifiableBag(Bag bag)
/*     */   {
/*  71 */     super(bag);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/*  82 */     out.defaultWriteObject();
/*  83 */     out.writeObject(this.collection);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  94 */     in.defaultReadObject();
/*  95 */     this.collection = ((Collection)in.readObject());
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 100 */     return UnmodifiableIterator.decorate(getCollection().iterator());
/*     */   }
/*     */ 
/*     */   public boolean add(Object object) {
/* 104 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection coll) {
/* 108 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void clear() {
/* 112 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object object) {
/* 116 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection coll) {
/* 120 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection coll) {
/* 124 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean add(Object object, int count)
/*     */   {
/* 129 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object object, int count) {
/* 133 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Set uniqueSet() {
/* 137 */     Set set = getBag().uniqueSet();
/* 138 */     return UnmodifiableSet.decorate(set);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.bag.UnmodifiableBag
 * JD-Core Version:    0.6.0
 */