/*      */ package org.apache.commons.collections;
/*      */ 
/*      */ import java.io.File;
/*      */ import java.io.FileInputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.InputStreamReader;
/*      */ import java.io.LineNumberReader;
/*      */ import java.io.OutputStream;
/*      */ import java.io.PrintStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.io.Reader;
/*      */ import java.io.UnsupportedEncodingException;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.NoSuchElementException;
/*      */ import java.util.Properties;
/*      */ import java.util.StringTokenizer;
/*      */ import java.util.Vector;
/*      */ 
/*      */ public class ExtendedProperties extends Hashtable
/*      */ {
/*      */   private ExtendedProperties defaults;
/*      */   protected String file;
/*      */   protected String basePath;
/*  165 */   protected String fileSeparator = System.getProperty("file.separator");
/*      */ 
/*  170 */   protected boolean isInitialized = false;
/*      */ 
/*  176 */   protected static String include = "include";
/*      */ 
/*  184 */   protected ArrayList keysAsListed = new ArrayList();
/*      */   protected static final String START_TOKEN = "${";
/*      */   protected static final String END_TOKEN = "}";
/*      */ 
/*      */   protected String interpolate(String base)
/*      */   {
/*  198 */     return interpolateHelper(base, null);
/*      */   }
/*      */ 
/*      */   protected String interpolateHelper(String base, List priorVariables)
/*      */   {
/*  217 */     if (base == null) {
/*  218 */       return null;
/*      */     }
/*      */ 
/*  223 */     if (priorVariables == null) {
/*  224 */       priorVariables = new ArrayList();
/*  225 */       priorVariables.add(base);
/*      */     }
/*      */ 
/*  228 */     int begin = -1;
/*  229 */     int end = -1;
/*  230 */     int prec = 0 - "}".length();
/*  231 */     String variable = null;
/*  232 */     StringBuffer result = new StringBuffer();
/*      */ 
/*  236 */     while (((begin = base.indexOf("${", prec + "}".length())) > -1) && ((end = base.indexOf("}", begin)) > -1)) {
/*  237 */       result.append(base.substring(prec + "}".length(), begin));
/*  238 */       variable = base.substring(begin + "${".length(), end);
/*      */ 
/*  241 */       if (priorVariables.contains(variable)) {
/*  242 */         String initialBase = priorVariables.remove(0).toString();
/*  243 */         priorVariables.add(variable);
/*  244 */         StringBuffer priorVariableSb = new StringBuffer();
/*      */ 
/*  248 */         for (Iterator it = priorVariables.iterator(); it.hasNext(); ) {
/*  249 */           priorVariableSb.append(it.next());
/*  250 */           if (it.hasNext()) {
/*  251 */             priorVariableSb.append("->");
/*      */           }
/*      */         }
/*      */ 
/*  255 */         throw new IllegalStateException("infinite loop in property interpolation of " + initialBase + ": " + priorVariableSb.toString());
/*      */       }
/*      */ 
/*  260 */       priorVariables.add(variable);
/*      */ 
/*  264 */       Object value = getProperty(variable);
/*  265 */       if (value != null) {
/*  266 */         result.append(interpolateHelper(value.toString(), priorVariables));
/*      */ 
/*  272 */         priorVariables.remove(priorVariables.size() - 1);
/*  273 */       } else if ((this.defaults != null) && (this.defaults.getString(variable, null) != null)) {
/*  274 */         result.append(this.defaults.getString(variable));
/*      */       }
/*      */       else {
/*  277 */         result.append("${").append(variable).append("}");
/*      */       }
/*  279 */       prec = end;
/*      */     }
/*  281 */     result.append(base.substring(prec + "}".length(), base.length()));
/*      */ 
/*  283 */     return result.toString();
/*      */   }
/*      */ 
/*      */   private static String escape(String s)
/*      */   {
/*  290 */     StringBuffer buf = new StringBuffer(s);
/*  291 */     for (int i = 0; i < buf.length(); i++) {
/*  292 */       char c = buf.charAt(i);
/*  293 */       if ((c == ',') || (c == '\\')) {
/*  294 */         buf.insert(i, '\\');
/*  295 */         i++;
/*      */       }
/*      */     }
/*  298 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   private static String unescape(String s)
/*      */   {
/*  305 */     StringBuffer buf = new StringBuffer(s);
/*  306 */     for (int i = 0; i < buf.length() - 1; i++) {
/*  307 */       char c1 = buf.charAt(i);
/*  308 */       char c2 = buf.charAt(i + 1);
/*  309 */       if ((c1 == '\\') && (c2 == '\\')) {
/*  310 */         buf.deleteCharAt(i);
/*      */       }
/*      */     }
/*  313 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   private static int countPreceding(String line, int index, char ch)
/*      */   {
/*  322 */     for (int i = index - 1; (i >= 0) && 
/*  323 */       (line.charAt(i) == ch); i--);
/*  327 */     return index - 1 - i;
/*      */   }
/*      */ 
/*      */   private static boolean endsWithSlash(String line)
/*      */   {
/*  334 */     if (!line.endsWith("\\")) {
/*  335 */       return false;
/*      */     }
/*  337 */     return countPreceding(line, line.length() - 1, '\\') % 2 == 0;
/*      */   }
/*      */ 
/*      */   public ExtendedProperties()
/*      */   {
/*      */   }
/*      */ 
/*      */   public ExtendedProperties(String file)
/*      */     throws IOException
/*      */   {
/*  452 */     this(file, null);
/*      */   }
/*      */ 
/*      */   public ExtendedProperties(String file, String defaultFile)
/*      */     throws IOException
/*      */   {
/*  463 */     this.file = file;
/*      */ 
/*  465 */     this.basePath = new File(file).getAbsolutePath();
/*  466 */     this.basePath = this.basePath.substring(0, this.basePath.lastIndexOf(this.fileSeparator) + 1);
/*      */ 
/*  468 */     FileInputStream in = null;
/*      */     try {
/*  470 */       in = new FileInputStream(file);
/*  471 */       load(in);
/*      */     } finally {
/*      */       try {
/*  474 */         if (in != null)
/*  475 */           in.close();
/*      */       }
/*      */       catch (IOException ex) {
/*      */       }
/*      */     }
/*  480 */     if (defaultFile != null)
/*  481 */       this.defaults = new ExtendedProperties(defaultFile);
/*      */   }
/*      */ 
/*      */   public boolean isInitialized()
/*      */   {
/*  490 */     return this.isInitialized;
/*      */   }
/*      */ 
/*      */   public String getInclude()
/*      */   {
/*  500 */     return include;
/*      */   }
/*      */ 
/*      */   public void setInclude(String inc)
/*      */   {
/*  510 */     include = inc;
/*      */   }
/*      */ 
/*      */   public void load(InputStream input)
/*      */     throws IOException
/*      */   {
/*  520 */     load(input, null);
/*      */   }
/*      */ 
/*      */   public synchronized void load(InputStream input, String enc)
/*      */     throws IOException
/*      */   {
/*  532 */     PropertiesReader reader = null;
/*  533 */     if (enc != null) {
/*      */       try {
/*  535 */         reader = new PropertiesReader(new InputStreamReader(input, enc));
/*      */       }
/*      */       catch (UnsupportedEncodingException ex)
/*      */       {
/*      */       }
/*      */     }
/*      */ 
/*  542 */     if (reader == null)
/*      */       try {
/*  544 */         reader = new PropertiesReader(new InputStreamReader(input, "8859_1"));
/*      */       }
/*      */       catch (UnsupportedEncodingException ex)
/*      */       {
/*  549 */         reader = new PropertiesReader(new InputStreamReader(input));
/*      */       }
/*      */     try
/*      */     {
/*      */       while (true)
/*      */       {
/*  555 */         String line = reader.readProperty();
/*  556 */         int equalSign = line.indexOf('=');
/*      */ 
/*  558 */         if (equalSign > 0) {
/*  559 */           String key = line.substring(0, equalSign).trim();
/*  560 */           String value = line.substring(equalSign + 1).trim();
/*      */ 
/*  563 */           if ("".equals(value))
/*      */           {
/*      */             continue;
/*      */           }
/*  567 */           if ((getInclude() != null) && (key.equalsIgnoreCase(getInclude())))
/*      */           {
/*  569 */             File file = null;
/*      */ 
/*  571 */             if (value.startsWith(this.fileSeparator))
/*      */             {
/*  573 */               file = new File(value);
/*      */             }
/*      */             else
/*      */             {
/*  579 */               if (value.startsWith("." + this.fileSeparator)) {
/*  580 */                 value = value.substring(2);
/*      */               }
/*      */ 
/*  583 */               file = new File(this.basePath + value);
/*      */             }
/*      */ 
/*  586 */             if ((file != null) && (file.exists()) && (file.canRead()))
/*  587 */               load(new FileInputStream(file));
/*      */           }
/*      */           else {
/*  590 */             addProperty(key, value);
/*      */           }
/*      */         }
/*      */       }
/*      */     } catch (NullPointerException ex) {
/*      */       return;
/*      */     }
/*      */     finally {
/*  599 */       this.isInitialized = true; } throw localObject;
/*      */   }
/*      */ 
/*      */   public Object getProperty(String key)
/*      */   {
/*  612 */     Object obj = get(key);
/*      */ 
/*  614 */     if (obj == null)
/*      */     {
/*  617 */       if (this.defaults != null) {
/*  618 */         obj = this.defaults.get(key);
/*      */       }
/*      */     }
/*      */ 
/*  622 */     return obj;
/*      */   }
/*      */ 
/*      */   public void addProperty(String key, Object value)
/*      */   {
/*  645 */     if ((value instanceof String)) {
/*  646 */       String str = (String)value;
/*  647 */       if (str.indexOf(",") > 0)
/*      */       {
/*  649 */         PropertiesTokenizer tokenizer = new PropertiesTokenizer(str);
/*  650 */         while (tokenizer.hasMoreTokens()) {
/*  651 */           String token = tokenizer.nextToken();
/*  652 */           addPropertyInternal(key, unescape(token));
/*      */         }
/*      */       }
/*      */       else {
/*  656 */         addPropertyInternal(key, unescape(str));
/*      */       }
/*      */     } else {
/*  659 */       addPropertyInternal(key, value);
/*      */     }
/*      */ 
/*  663 */     this.isInitialized = true;
/*      */   }
/*      */ 
/*      */   private void addPropertyDirect(String key, Object value)
/*      */   {
/*  675 */     if (!containsKey(key)) {
/*  676 */       this.keysAsListed.add(key);
/*      */     }
/*  678 */     put(key, value);
/*      */   }
/*      */ 
/*      */   private void addPropertyInternal(String key, Object value)
/*      */   {
/*  693 */     Object current = get(key);
/*      */ 
/*  695 */     if ((current instanceof String))
/*      */     {
/*  697 */       Vector v = new Vector(2);
/*  698 */       v.addElement(current);
/*  699 */       v.addElement(value);
/*  700 */       put(key, v);
/*      */     }
/*  702 */     else if ((current instanceof Vector))
/*      */     {
/*  704 */       ((Vector)current).addElement(value);
/*      */     }
/*      */     else
/*      */     {
/*  708 */       if (!containsKey(key)) {
/*  709 */         this.keysAsListed.add(key);
/*      */       }
/*  711 */       put(key, value);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setProperty(String key, Object value)
/*      */   {
/*  724 */     clearProperty(key);
/*  725 */     addProperty(key, value);
/*      */   }
/*      */ 
/*      */   public synchronized void save(OutputStream output, String header)
/*      */     throws IOException
/*      */   {
/*  738 */     if (output == null) {
/*  739 */       return;
/*      */     }
/*  741 */     PrintWriter theWrtr = new PrintWriter(output);
/*  742 */     if (header != null) {
/*  743 */       theWrtr.println(header);
/*      */     }
/*      */ 
/*  746 */     Enumeration theKeys = keys();
/*  747 */     while (theKeys.hasMoreElements()) {
/*  748 */       String key = (String)theKeys.nextElement();
/*  749 */       Object value = get(key);
/*  750 */       if (value != null) {
/*  751 */         if ((value instanceof String)) {
/*  752 */           StringBuffer currentOutput = new StringBuffer();
/*  753 */           currentOutput.append(key);
/*  754 */           currentOutput.append("=");
/*  755 */           currentOutput.append(escape((String)value));
/*  756 */           theWrtr.println(currentOutput.toString());
/*      */         }
/*  758 */         else if ((value instanceof Vector)) {
/*  759 */           Vector values = (Vector)value;
/*  760 */           Enumeration valuesEnum = values.elements();
/*  761 */           while (valuesEnum.hasMoreElements()) {
/*  762 */             String currentElement = (String)valuesEnum.nextElement();
/*  763 */             StringBuffer currentOutput = new StringBuffer();
/*  764 */             currentOutput.append(key);
/*  765 */             currentOutput.append("=");
/*  766 */             currentOutput.append(escape(currentElement));
/*  767 */             theWrtr.println(currentOutput.toString());
/*      */           }
/*      */         }
/*      */       }
/*  771 */       theWrtr.println();
/*  772 */       theWrtr.flush();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void combine(ExtendedProperties props)
/*      */   {
/*  784 */     for (Iterator it = props.getKeys(); it.hasNext(); ) {
/*  785 */       String key = (String)it.next();
/*  786 */       setProperty(key, props.get(key));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void clearProperty(String key)
/*      */   {
/*  796 */     if (containsKey(key))
/*      */     {
/*  799 */       for (int i = 0; i < this.keysAsListed.size(); i++) {
/*  800 */         if (this.keysAsListed.get(i).equals(key)) {
/*  801 */           this.keysAsListed.remove(i);
/*  802 */           break;
/*      */         }
/*      */       }
/*  805 */       remove(key);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Iterator getKeys()
/*      */   {
/*  816 */     return this.keysAsListed.iterator();
/*      */   }
/*      */ 
/*      */   public Iterator getKeys(String prefix)
/*      */   {
/*  827 */     Iterator keys = getKeys();
/*  828 */     ArrayList matchingKeys = new ArrayList();
/*      */ 
/*  830 */     while (keys.hasNext()) {
/*  831 */       Object key = keys.next();
/*      */ 
/*  833 */       if (((key instanceof String)) && (((String)key).startsWith(prefix))) {
/*  834 */         matchingKeys.add(key);
/*      */       }
/*      */     }
/*  837 */     return matchingKeys.iterator();
/*      */   }
/*      */ 
/*      */   public ExtendedProperties subset(String prefix)
/*      */   {
/*  849 */     ExtendedProperties c = new ExtendedProperties();
/*  850 */     Iterator keys = getKeys();
/*  851 */     boolean validSubset = false;
/*      */ 
/*  853 */     while (keys.hasNext()) {
/*  854 */       Object key = keys.next();
/*      */ 
/*  856 */       if (((key instanceof String)) && (((String)key).startsWith(prefix))) {
/*  857 */         if (!validSubset) {
/*  858 */           validSubset = true;
/*      */         }
/*      */ 
/*  867 */         String newKey = null;
/*  868 */         if (((String)key).length() == prefix.length())
/*  869 */           newKey = prefix;
/*      */         else {
/*  871 */           newKey = ((String)key).substring(prefix.length() + 1);
/*      */         }
/*      */ 
/*  879 */         c.addPropertyDirect(newKey, get(key));
/*      */       }
/*      */     }
/*      */ 
/*  883 */     if (validSubset) {
/*  884 */       return c;
/*      */     }
/*  886 */     return null;
/*      */   }
/*      */ 
/*      */   public void display()
/*      */   {
/*  894 */     Iterator i = getKeys();
/*      */ 
/*  896 */     while (i.hasNext()) {
/*  897 */       String key = (String)i.next();
/*  898 */       Object value = get(key);
/*  899 */       System.out.println(key + " => " + value);
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getString(String key)
/*      */   {
/*  912 */     return getString(key, null);
/*      */   }
/*      */ 
/*      */   public String getString(String key, String defaultValue)
/*      */   {
/*  926 */     Object value = get(key);
/*      */ 
/*  928 */     if ((value instanceof String)) {
/*  929 */       return interpolate((String)value);
/*      */     }
/*  931 */     if (value == null) {
/*  932 */       if (this.defaults != null) {
/*  933 */         return interpolate(this.defaults.getString(key, defaultValue));
/*      */       }
/*  935 */       return interpolate(defaultValue);
/*      */     }
/*  937 */     if ((value instanceof Vector)) {
/*  938 */       return interpolate((String)((Vector)value).get(0));
/*      */     }
/*  940 */     throw new ClassCastException('\'' + key + "' doesn't map to a String object");
/*      */   }
/*      */ 
/*      */   public Properties getProperties(String key)
/*      */   {
/*  956 */     return getProperties(key, new Properties());
/*      */   }
/*      */ 
/*      */   public Properties getProperties(String key, Properties defaults)
/*      */   {
/*  974 */     String[] tokens = getStringArray(key);
/*      */ 
/*  977 */     Properties props = new Properties(defaults);
/*  978 */     for (int i = 0; i < tokens.length; i++) {
/*  979 */       String token = tokens[i];
/*  980 */       int equalSign = token.indexOf('=');
/*  981 */       if (equalSign > 0) {
/*  982 */         String pkey = token.substring(0, equalSign).trim();
/*  983 */         String pvalue = token.substring(equalSign + 1).trim();
/*  984 */         props.put(pkey, pvalue);
/*      */       } else {
/*  986 */         throw new IllegalArgumentException('\'' + token + "' does not contain " + "an equals sign");
/*      */       }
/*      */     }
/*  989 */     return props;
/*      */   }
/*      */ 
/*      */   public String[] getStringArray(String key)
/*      */   {
/* 1002 */     Object value = get(key);
/*      */     Vector vector;
/* 1006 */     if ((value instanceof String)) {
/* 1007 */       Vector vector = new Vector(1);
/* 1008 */       vector.addElement(value);
/*      */     }
/* 1010 */     else if ((value instanceof Vector)) {
/* 1011 */       vector = (Vector)value;
/*      */     } else {
/* 1013 */       if (value == null) {
/* 1014 */         if (this.defaults != null) {
/* 1015 */           return this.defaults.getStringArray(key);
/*      */         }
/* 1017 */         return new String[0];
/*      */       }
/*      */ 
/* 1020 */       throw new ClassCastException('\'' + key + "' doesn't map to a String/Vector object");
/*      */     }
/*      */ 
/* 1023 */     String[] tokens = new String[vector.size()];
/* 1024 */     for (int i = 0; i < tokens.length; i++) {
/* 1025 */       tokens[i] = ((String)vector.elementAt(i));
/*      */     }
/*      */ 
/* 1028 */     return tokens;
/*      */   }
/*      */ 
/*      */   public Vector getVector(String key)
/*      */   {
/* 1041 */     return getVector(key, null);
/*      */   }
/*      */ 
/*      */   public Vector getVector(String key, Vector defaultValue)
/*      */   {
/* 1055 */     Object value = get(key);
/*      */ 
/* 1057 */     if ((value instanceof Vector)) {
/* 1058 */       return (Vector)value;
/*      */     }
/* 1060 */     if ((value instanceof String)) {
/* 1061 */       Vector v = new Vector(1);
/* 1062 */       v.addElement(value);
/* 1063 */       put(key, v);
/* 1064 */       return v;
/*      */     }
/* 1066 */     if (value == null) {
/* 1067 */       if (this.defaults != null) {
/* 1068 */         return this.defaults.getVector(key, defaultValue);
/*      */       }
/* 1070 */       return defaultValue == null ? new Vector() : defaultValue;
/*      */     }
/*      */ 
/* 1073 */     throw new ClassCastException('\'' + key + "' doesn't map to a Vector object");
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(String key)
/*      */   {
/* 1088 */     Boolean b = getBoolean(key, null);
/* 1089 */     if (b != null) {
/* 1090 */       return b.booleanValue();
/*      */     }
/* 1092 */     throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
/*      */   }
/*      */ 
/*      */   public boolean getBoolean(String key, boolean defaultValue)
/*      */   {
/* 1106 */     return getBoolean(key, new Boolean(defaultValue)).booleanValue();
/*      */   }
/*      */ 
/*      */   public Boolean getBoolean(String key, Boolean defaultValue)
/*      */   {
/* 1121 */     Object value = get(key);
/*      */ 
/* 1123 */     if ((value instanceof Boolean)) {
/* 1124 */       return (Boolean)value;
/*      */     }
/* 1126 */     if ((value instanceof String)) {
/* 1127 */       String s = testBoolean((String)value);
/* 1128 */       Boolean b = new Boolean(s);
/* 1129 */       put(key, b);
/* 1130 */       return b;
/*      */     }
/* 1132 */     if (value == null) {
/* 1133 */       if (this.defaults != null) {
/* 1134 */         return this.defaults.getBoolean(key, defaultValue);
/*      */       }
/* 1136 */       return defaultValue;
/*      */     }
/*      */ 
/* 1139 */     throw new ClassCastException('\'' + key + "' doesn't map to a Boolean object");
/*      */   }
/*      */ 
/*      */   public String testBoolean(String value)
/*      */   {
/* 1156 */     String s = value.toLowerCase();
/*      */ 
/* 1158 */     if ((s.equals("true")) || (s.equals("on")) || (s.equals("yes")))
/* 1159 */       return "true";
/* 1160 */     if ((s.equals("false")) || (s.equals("off")) || (s.equals("no"))) {
/* 1161 */       return "false";
/*      */     }
/* 1163 */     return null;
/*      */   }
/*      */ 
/*      */   public byte getByte(String key)
/*      */   {
/* 1180 */     Byte b = getByte(key, null);
/* 1181 */     if (b != null) {
/* 1182 */       return b.byteValue();
/*      */     }
/* 1184 */     throw new NoSuchElementException('\'' + key + " doesn't map to an existing object");
/*      */   }
/*      */ 
/*      */   public byte getByte(String key, byte defaultValue)
/*      */   {
/* 1200 */     return getByte(key, new Byte(defaultValue)).byteValue();
/*      */   }
/*      */ 
/*      */   public Byte getByte(String key, Byte defaultValue)
/*      */   {
/* 1216 */     Object value = get(key);
/*      */ 
/* 1218 */     if ((value instanceof Byte)) {
/* 1219 */       return (Byte)value;
/*      */     }
/* 1221 */     if ((value instanceof String)) {
/* 1222 */       Byte b = new Byte((String)value);
/* 1223 */       put(key, b);
/* 1224 */       return b;
/*      */     }
/* 1226 */     if (value == null) {
/* 1227 */       if (this.defaults != null) {
/* 1228 */         return this.defaults.getByte(key, defaultValue);
/*      */       }
/* 1230 */       return defaultValue;
/*      */     }
/*      */ 
/* 1233 */     throw new ClassCastException('\'' + key + "' doesn't map to a Byte object");
/*      */   }
/*      */ 
/*      */   public short getShort(String key)
/*      */   {
/* 1250 */     Short s = getShort(key, null);
/* 1251 */     if (s != null) {
/* 1252 */       return s.shortValue();
/*      */     }
/* 1254 */     throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
/*      */   }
/*      */ 
/*      */   public short getShort(String key, short defaultValue)
/*      */   {
/* 1270 */     return getShort(key, new Short(defaultValue)).shortValue();
/*      */   }
/*      */ 
/*      */   public Short getShort(String key, Short defaultValue)
/*      */   {
/* 1286 */     Object value = get(key);
/*      */ 
/* 1288 */     if ((value instanceof Short)) {
/* 1289 */       return (Short)value;
/*      */     }
/* 1291 */     if ((value instanceof String)) {
/* 1292 */       Short s = new Short((String)value);
/* 1293 */       put(key, s);
/* 1294 */       return s;
/*      */     }
/* 1296 */     if (value == null) {
/* 1297 */       if (this.defaults != null) {
/* 1298 */         return this.defaults.getShort(key, defaultValue);
/*      */       }
/* 1300 */       return defaultValue;
/*      */     }
/*      */ 
/* 1303 */     throw new ClassCastException('\'' + key + "' doesn't map to a Short object");
/*      */   }
/*      */ 
/*      */   public int getInt(String name)
/*      */   {
/* 1315 */     return getInteger(name);
/*      */   }
/*      */ 
/*      */   public int getInt(String name, int def)
/*      */   {
/* 1327 */     return getInteger(name, def);
/*      */   }
/*      */ 
/*      */   public int getInteger(String key)
/*      */   {
/* 1343 */     Integer i = getInteger(key, null);
/* 1344 */     if (i != null) {
/* 1345 */       return i.intValue();
/*      */     }
/* 1347 */     throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
/*      */   }
/*      */ 
/*      */   public int getInteger(String key, int defaultValue)
/*      */   {
/* 1363 */     Integer i = getInteger(key, null);
/*      */ 
/* 1365 */     if (i == null) {
/* 1366 */       return defaultValue;
/*      */     }
/* 1368 */     return i.intValue();
/*      */   }
/*      */ 
/*      */   public Integer getInteger(String key, Integer defaultValue)
/*      */   {
/* 1384 */     Object value = get(key);
/*      */ 
/* 1386 */     if ((value instanceof Integer)) {
/* 1387 */       return (Integer)value;
/*      */     }
/* 1389 */     if ((value instanceof String)) {
/* 1390 */       Integer i = new Integer((String)value);
/* 1391 */       put(key, i);
/* 1392 */       return i;
/*      */     }
/* 1394 */     if (value == null) {
/* 1395 */       if (this.defaults != null) {
/* 1396 */         return this.defaults.getInteger(key, defaultValue);
/*      */       }
/* 1398 */       return defaultValue;
/*      */     }
/*      */ 
/* 1401 */     throw new ClassCastException('\'' + key + "' doesn't map to a Integer object");
/*      */   }
/*      */ 
/*      */   public long getLong(String key)
/*      */   {
/* 1418 */     Long l = getLong(key, null);
/* 1419 */     if (l != null) {
/* 1420 */       return l.longValue();
/*      */     }
/* 1422 */     throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
/*      */   }
/*      */ 
/*      */   public long getLong(String key, long defaultValue)
/*      */   {
/* 1438 */     return getLong(key, new Long(defaultValue)).longValue();
/*      */   }
/*      */ 
/*      */   public Long getLong(String key, Long defaultValue)
/*      */   {
/* 1454 */     Object value = get(key);
/*      */ 
/* 1456 */     if ((value instanceof Long)) {
/* 1457 */       return (Long)value;
/*      */     }
/* 1459 */     if ((value instanceof String)) {
/* 1460 */       Long l = new Long((String)value);
/* 1461 */       put(key, l);
/* 1462 */       return l;
/*      */     }
/* 1464 */     if (value == null) {
/* 1465 */       if (this.defaults != null) {
/* 1466 */         return this.defaults.getLong(key, defaultValue);
/*      */       }
/* 1468 */       return defaultValue;
/*      */     }
/*      */ 
/* 1471 */     throw new ClassCastException('\'' + key + "' doesn't map to a Long object");
/*      */   }
/*      */ 
/*      */   public float getFloat(String key)
/*      */   {
/* 1488 */     Float f = getFloat(key, null);
/* 1489 */     if (f != null) {
/* 1490 */       return f.floatValue();
/*      */     }
/* 1492 */     throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
/*      */   }
/*      */ 
/*      */   public float getFloat(String key, float defaultValue)
/*      */   {
/* 1508 */     return getFloat(key, new Float(defaultValue)).floatValue();
/*      */   }
/*      */ 
/*      */   public Float getFloat(String key, Float defaultValue)
/*      */   {
/* 1524 */     Object value = get(key);
/*      */ 
/* 1526 */     if ((value instanceof Float)) {
/* 1527 */       return (Float)value;
/*      */     }
/* 1529 */     if ((value instanceof String)) {
/* 1530 */       Float f = new Float((String)value);
/* 1531 */       put(key, f);
/* 1532 */       return f;
/*      */     }
/* 1534 */     if (value == null) {
/* 1535 */       if (this.defaults != null) {
/* 1536 */         return this.defaults.getFloat(key, defaultValue);
/*      */       }
/* 1538 */       return defaultValue;
/*      */     }
/*      */ 
/* 1541 */     throw new ClassCastException('\'' + key + "' doesn't map to a Float object");
/*      */   }
/*      */ 
/*      */   public double getDouble(String key)
/*      */   {
/* 1558 */     Double d = getDouble(key, null);
/* 1559 */     if (d != null) {
/* 1560 */       return d.doubleValue();
/*      */     }
/* 1562 */     throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
/*      */   }
/*      */ 
/*      */   public double getDouble(String key, double defaultValue)
/*      */   {
/* 1578 */     return getDouble(key, new Double(defaultValue)).doubleValue();
/*      */   }
/*      */ 
/*      */   public Double getDouble(String key, Double defaultValue)
/*      */   {
/* 1594 */     Object value = get(key);
/*      */ 
/* 1596 */     if ((value instanceof Double)) {
/* 1597 */       return (Double)value;
/*      */     }
/* 1599 */     if ((value instanceof String)) {
/* 1600 */       Double d = new Double((String)value);
/* 1601 */       put(key, d);
/* 1602 */       return d;
/*      */     }
/* 1604 */     if (value == null) {
/* 1605 */       if (this.defaults != null) {
/* 1606 */         return this.defaults.getDouble(key, defaultValue);
/*      */       }
/* 1608 */       return defaultValue;
/*      */     }
/*      */ 
/* 1611 */     throw new ClassCastException('\'' + key + "' doesn't map to a Double object");
/*      */   }
/*      */ 
/*      */   public static ExtendedProperties convertProperties(Properties props)
/*      */   {
/* 1622 */     ExtendedProperties c = new ExtendedProperties();
/*      */ 
/* 1624 */     for (Enumeration e = props.keys(); e.hasMoreElements(); ) {
/* 1625 */       String s = (String)e.nextElement();
/* 1626 */       c.setProperty(s, props.getProperty(s));
/*      */     }
/*      */ 
/* 1629 */     return c;
/*      */   }
/*      */ 
/*      */   static class PropertiesTokenizer extends StringTokenizer
/*      */   {
/*      */     static final String DELIMITER = ",";
/*      */ 
/*      */     public PropertiesTokenizer(String string)
/*      */     {
/*  403 */       super(",");
/*      */     }
/*      */ 
/*      */     public boolean hasMoreTokens()
/*      */     {
/*  412 */       return super.hasMoreTokens();
/*      */     }
/*      */ 
/*      */     public String nextToken()
/*      */     {
/*  421 */       StringBuffer buffer = new StringBuffer();
/*      */ 
/*  423 */       while (hasMoreTokens()) {
/*  424 */         String token = super.nextToken();
/*  425 */         if (ExtendedProperties.access$000(token)) {
/*  426 */           buffer.append(token.substring(0, token.length() - 1));
/*  427 */           buffer.append(",");
/*      */         } else {
/*  429 */           buffer.append(token);
/*  430 */           break;
/*      */         }
/*      */       }
/*      */ 
/*  434 */       return buffer.toString().trim();
/*      */     }
/*      */   }
/*      */ 
/*      */   static class PropertiesReader extends LineNumberReader
/*      */   {
/*      */     public PropertiesReader(Reader reader)
/*      */     {
/*  353 */       super();
/*      */     }
/*      */ 
/*      */     public String readProperty()
/*      */       throws IOException
/*      */     {
/*  363 */       StringBuffer buffer = new StringBuffer();
/*      */       try
/*      */       {
/*      */         while (true) {
/*  367 */           String line = readLine().trim();
/*  368 */           if ((line.length() != 0) && (line.charAt(0) != '#'))
/*  369 */             if (ExtendedProperties.access$000(line)) {
/*  370 */               line = line.substring(0, line.length() - 1);
/*  371 */               buffer.append(line);
/*      */             } else {
/*  373 */               buffer.append(line);
/*  374 */               break;
/*      */             }
/*      */         }
/*      */       }
/*      */       catch (NullPointerException ex) {
/*  379 */         return null;
/*      */       }
/*      */ 
/*  382 */       return buffer.toString();
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.ExtendedProperties
 * JD-Core Version:    0.6.0
 */