/*     */ package net.sf.cglib.util;
/*     */ 
/*     */ import java.util.Arrays;
/*     */ import java.util.List;
/*     */ import net.sf.cglib.asm.ClassVisitor;
/*     */ import net.sf.cglib.asm.Type;
/*     */ import net.sf.cglib.core.AbstractClassGenerator;
/*     */ import net.sf.cglib.core.AbstractClassGenerator.Source;
/*     */ import net.sf.cglib.core.ClassEmitter;
/*     */ import net.sf.cglib.core.CodeEmitter;
/*     */ import net.sf.cglib.core.EmitUtils;
/*     */ import net.sf.cglib.core.KeyFactory;
/*     */ import net.sf.cglib.core.ReflectUtils;
/*     */ import net.sf.cglib.core.Signature;
/*     */ import net.sf.cglib.core.TypeUtils;
/*     */ 
/*     */ public abstract class StringSwitcher
/*     */ {
/*  28 */   private static final Type STRING_SWITCHER = TypeUtils.parseType("net.sf.cglib.util.StringSwitcher");
/*     */ 
/*  30 */   private static final Signature INT_VALUE = TypeUtils.parseSignature("int intValue(String)");
/*     */ 
/*  32 */   private static final StringSwitcherKey KEY_FACTORY = (StringSwitcherKey)KeyFactory.create(StringSwitcherKey.class);
/*     */ 
/*     */   public static StringSwitcher create(String[] strings, int[] ints, boolean fixedInput)
/*     */   {
/*  49 */     Generator gen = new Generator();
/*  50 */     gen.setStrings(strings);
/*  51 */     gen.setInts(ints);
/*  52 */     gen.setFixedInput(fixedInput);
/*  53 */     return gen.create();
/*     */   }
/*     */   public abstract int intValue(String paramString);
/*     */ 
/*     */   public static class Generator extends AbstractClassGenerator {
/*  69 */     private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(StringSwitcher.class.getName());
/*     */     private String[] strings;
/*     */     private int[] ints;
/*     */     private boolean fixedInput;
/*     */ 
/*  76 */     public Generator() { super();
/*     */     }
/*     */ 
/*     */     public void setStrings(String[] strings)
/*     */     {
/*  85 */       this.strings = strings;
/*     */     }
/*     */ 
/*     */     public void setInts(int[] ints)
/*     */     {
/*  94 */       this.ints = ints;
/*     */     }
/*     */ 
/*     */     public void setFixedInput(boolean fixedInput)
/*     */     {
/* 103 */       this.fixedInput = fixedInput;
/*     */     }
/*     */ 
/*     */     protected ClassLoader getDefaultClassLoader() {
/* 107 */       return getClass().getClassLoader();
/*     */     }
/*     */ 
/*     */     public StringSwitcher create()
/*     */     {
/* 114 */       setNamePrefix(StringSwitcher.class.getName());
/* 115 */       Object key = StringSwitcher.KEY_FACTORY.newInstance(this.strings, this.ints, this.fixedInput);
/* 116 */       return (StringSwitcher)super.create(key);
/*     */     }
/*     */ 
/*     */     public void generateClass(ClassVisitor v) throws Exception {
/* 120 */       ClassEmitter ce = new ClassEmitter(v);
/* 121 */       ce.begin_class(46, 1, getClassName(), StringSwitcher.STRING_SWITCHER, null, "<generated>");
/*     */ 
/* 127 */       EmitUtils.null_constructor(ce);
/* 128 */       CodeEmitter e = ce.begin_method(1, StringSwitcher.INT_VALUE, null, null);
/* 129 */       e.load_arg(0);
/* 130 */       List stringList = Arrays.asList(this.strings);
/* 131 */       int style = this.fixedInput ? 2 : 1;
/* 132 */       EmitUtils.string_switch(e, this.strings, style, new StringSwitcher.1(this, e, stringList));
/*     */ 
/* 142 */       e.end_method();
/* 143 */       ce.end_class();
/*     */     }
/*     */ 
/*     */     protected Object firstInstance(Class type) {
/* 147 */       return (StringSwitcher)ReflectUtils.newInstance(type);
/*     */     }
/*     */ 
/*     */     protected Object nextInstance(Object instance) {
/* 151 */       return instance;
/*     */     }
/*     */   }
/*     */ 
/*     */   static abstract interface StringSwitcherKey
/*     */   {
/*     */     public abstract Object newInstance(String[] paramArrayOfString, int[] paramArrayOfInt, boolean paramBoolean);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     net.sf.cglib.util.StringSwitcher
 * JD-Core Version:    0.6.0
 */