/*    */ package net.sf.cglib.transform.impl;
/*    */ 
/*    */ import net.sf.cglib.asm.Attribute;
/*    */ import net.sf.cglib.core.ClassGenerator;
/*    */ import net.sf.cglib.core.DefaultGeneratorStrategy;
/*    */ import net.sf.cglib.core.TypeUtils;
/*    */ import net.sf.cglib.transform.ClassTransformer;
/*    */ import net.sf.cglib.transform.MethodFilter;
/*    */ import net.sf.cglib.transform.MethodFilterTransformer;
/*    */ import net.sf.cglib.transform.TransformingClassGenerator;
/*    */ 
/*    */ public class UndeclaredThrowableStrategy extends DefaultGeneratorStrategy
/*    */ {
/*    */   private ClassTransformer t;
/* 43 */   private static final MethodFilter TRANSFORM_FILTER = new MethodFilter() {
/*    */     public boolean accept(int access, String name, String desc, String[] exceptions, Attribute attrs) {
/* 45 */       return (!TypeUtils.isPrivate(access)) && (name.indexOf('$') < 0);
/*    */     }
/* 43 */   };
/*    */ 
/*    */   public UndeclaredThrowableStrategy(Class wrapper)
/*    */   {
/* 39 */     this.t = new UndeclaredThrowableTransformer(wrapper);
/* 40 */     this.t = new MethodFilterTransformer(TRANSFORM_FILTER, this.t);
/*    */   }
/*    */ 
/*    */   protected ClassGenerator transform(ClassGenerator cg)
/*    */     throws Exception
/*    */   {
/* 50 */     return new TransformingClassGenerator(cg, this.t);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     net.sf.cglib.transform.impl.UndeclaredThrowableStrategy
 * JD-Core Version:    0.6.0
 */