/*    */ package net.sf.cglib.proxy;
/*    */ 
/*    */ import java.util.Iterator;
/*    */ import java.util.List;
/*    */ import net.sf.cglib.asm.Type;
/*    */ import net.sf.cglib.core.ClassEmitter;
/*    */ import net.sf.cglib.core.CodeEmitter;
/*    */ import net.sf.cglib.core.MethodInfo;
/*    */ import net.sf.cglib.core.Signature;
/*    */ import net.sf.cglib.core.TypeUtils;
/*    */ 
/*    */ class FixedValueGenerator
/*    */   implements CallbackGenerator
/*    */ {
/* 23 */   public static final FixedValueGenerator INSTANCE = new FixedValueGenerator();
/* 24 */   private static final Type FIXED_VALUE = TypeUtils.parseType("net.sf.cglib.proxy.FixedValue");
/*    */ 
/* 26 */   private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
/*    */ 
/*    */   public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods)
/*    */   {
/* 30 */     for (Iterator it = methods.iterator(); it.hasNext(); ) {
/* 31 */       MethodInfo method = (MethodInfo)it.next();
/* 32 */       CodeEmitter e = context.beginMethod(ce, method);
/* 33 */       context.emitCallback(e, context.getIndex(method));
/* 34 */       e.invoke_interface(FIXED_VALUE, LOAD_OBJECT);
/* 35 */       e.unbox_or_zero(e.getReturnType());
/* 36 */       e.return_value();
/* 37 */       e.end_method();
/*    */     }
/*    */   }
/*    */ 
/*    */   public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List methods)
/*    */   {
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     net.sf.cglib.proxy.FixedValueGenerator
 * JD-Core Version:    0.6.0
 */