/*     */ package javassist.expr;
/*     */ 
/*     */ import javassist.CannotCompileException;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtBehavior;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.bytecode.BadBytecode;
/*     */ import javassist.bytecode.Bytecode;
/*     */ import javassist.bytecode.CodeAttribute;
/*     */ import javassist.bytecode.CodeIterator;
/*     */ import javassist.bytecode.ConstPool;
/*     */ import javassist.bytecode.MethodInfo;
/*     */ import javassist.compiler.CompileError;
/*     */ import javassist.compiler.Javac;
/*     */ import javassist.compiler.JvstCodeGen;
/*     */ import javassist.compiler.JvstTypeChecker;
/*     */ import javassist.compiler.ProceedHandler;
/*     */ import javassist.compiler.ast.ASTList;
/*     */ 
/*     */ public class Instanceof extends Expr
/*     */ {
/*     */   protected Instanceof(int pos, CodeIterator i, CtClass declaring, MethodInfo m)
/*     */   {
/*  32 */     super(pos, i, declaring, m);
/*     */   }
/*     */ 
/*     */   public CtBehavior where()
/*     */   {
/*  39 */     return super.where();
/*     */   }
/*     */ 
/*     */   public int getLineNumber()
/*     */   {
/*  48 */     return super.getLineNumber();
/*     */   }
/*     */ 
/*     */   public String getFileName()
/*     */   {
/*  58 */     return super.getFileName();
/*     */   }
/*     */ 
/*     */   public CtClass getType()
/*     */     throws NotFoundException
/*     */   {
/*  67 */     ConstPool cp = getConstPool();
/*  68 */     int pos = this.currentPos;
/*  69 */     int index = this.iterator.u16bitAt(pos + 1);
/*  70 */     String name = cp.getClassInfo(index);
/*  71 */     return this.thisClass.getClassPool().getCtClass(name);
/*     */   }
/*     */ 
/*     */   public CtClass[] mayThrow()
/*     */   {
/*  81 */     return super.mayThrow();
/*     */   }
/*     */ 
/*     */   public void replace(String statement)
/*     */     throws CannotCompileException
/*     */   {
/*  93 */     this.thisClass.getClassFile();
/*  94 */     ConstPool constPool = getConstPool();
/*  95 */     int pos = this.currentPos;
/*  96 */     int index = this.iterator.u16bitAt(pos + 1);
/*     */ 
/*  98 */     Javac jc = new Javac(this.thisClass);
/*  99 */     ClassPool cp = this.thisClass.getClassPool();
/* 100 */     CodeAttribute ca = this.iterator.get();
/*     */     try
/*     */     {
/* 103 */       CtClass[] params = { cp.get("java.lang.Object") };
/*     */ 
/* 105 */       CtClass retType = CtClass.booleanType;
/*     */ 
/* 107 */       int paramVar = ca.getMaxLocals();
/* 108 */       jc.recordParams("java.lang.Object", params, true, paramVar, withinStatic());
/*     */ 
/* 110 */       int retVar = jc.recordReturnType(retType, true);
/* 111 */       jc.recordProceed(new ProceedForInstanceof(index));
/*     */ 
/* 114 */       jc.recordType(getType());
/*     */ 
/* 118 */       checkResultValue(retType, statement);
/*     */ 
/* 120 */       Bytecode bytecode = jc.getBytecode();
/* 121 */       storeStack(params, true, paramVar, bytecode);
/* 122 */       jc.recordLocalVariables(ca, pos);
/*     */ 
/* 124 */       bytecode.addConstZero(retType);
/* 125 */       bytecode.addStore(retVar, retType);
/*     */ 
/* 127 */       jc.compileStmnt(statement);
/* 128 */       bytecode.addLoad(retVar, retType);
/*     */ 
/* 130 */       replace0(pos, bytecode, 3);
/*     */     } catch (CompileError e) {
/* 132 */       throw new CannotCompileException(e); } catch (NotFoundException e) {
/* 133 */       throw new CannotCompileException(e);
/*     */     } catch (BadBytecode e) {
/* 135 */       throw new CannotCompileException("broken method");
/*     */     }
/*     */   }
/*     */ 
/*     */   static class ProceedForInstanceof implements ProceedHandler
/*     */   {
/*     */     int index;
/*     */ 
/*     */     ProceedForInstanceof(int i) {
/* 145 */       this.index = i;
/*     */     }
/*     */ 
/*     */     public void doit(JvstCodeGen gen, Bytecode bytecode, ASTList args)
/*     */       throws CompileError
/*     */     {
/* 151 */       if (gen.getMethodArgsLength(args) != 1) {
/* 152 */         throw new CompileError("$proceed() cannot take more than one parameter for instanceof");
/*     */       }
/*     */ 
/* 156 */       gen.atMethodArgs(args, new int[1], new int[1], new String[1]);
/* 157 */       bytecode.addOpcode(193);
/* 158 */       bytecode.addIndex(this.index);
/* 159 */       gen.setType(CtClass.booleanType);
/*     */     }
/*     */ 
/*     */     public void setReturnType(JvstTypeChecker c, ASTList args)
/*     */       throws CompileError
/*     */     {
/* 165 */       c.atMethodArgs(args, new int[1], new int[1], new String[1]);
/* 166 */       c.setType(CtClass.booleanType);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.expr.Instanceof
 * JD-Core Version:    0.6.0
 */