/*     */ package javassist.bytecode.annotation;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.ClassPool;
/*     */ import javassist.bytecode.ConstPool;
/*     */ 
/*     */ public class ShortMemberValue extends MemberValue
/*     */ {
/*     */   int valueIndex;
/*     */ 
/*     */   public ShortMemberValue(int index, ConstPool cp)
/*     */   {
/*  39 */     super('S', cp);
/*  40 */     this.valueIndex = index;
/*     */   }
/*     */ 
/*     */   public ShortMemberValue(short s, ConstPool cp)
/*     */   {
/*  49 */     super('S', cp);
/*  50 */     setValue(s);
/*     */   }
/*     */ 
/*     */   public ShortMemberValue(ConstPool cp)
/*     */   {
/*  57 */     super('S', cp);
/*  58 */     setValue(0);
/*     */   }
/*     */ 
/*     */   Object getValue(ClassLoader cl, ClassPool cp, Method m) {
/*  62 */     return new Short(getValue());
/*     */   }
/*     */ 
/*     */   Class getType(ClassLoader cl) {
/*  66 */     return Short.TYPE;
/*     */   }
/*     */ 
/*     */   public short getValue()
/*     */   {
/*  73 */     return (short)this.cp.getIntegerInfo(this.valueIndex);
/*     */   }
/*     */ 
/*     */   public void setValue(short newValue)
/*     */   {
/*  80 */     this.valueIndex = this.cp.addIntegerInfo(newValue);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  87 */     return Short.toString(getValue());
/*     */   }
/*     */ 
/*     */   public void write(AnnotationsWriter writer)
/*     */     throws IOException
/*     */   {
/*  94 */     writer.constValueIndex(getValue());
/*     */   }
/*     */ 
/*     */   public void accept(MemberValueVisitor visitor)
/*     */   {
/* 101 */     visitor.visitShortMemberValue(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.annotation.ShortMemberValue
 * JD-Core Version:    0.6.0
 */