/*     */ package javassist.bytecode.annotation;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.ClassPool;
/*     */ import javassist.bytecode.ConstPool;
/*     */ 
/*     */ public class FloatMemberValue extends MemberValue
/*     */ {
/*     */   int valueIndex;
/*     */ 
/*     */   public FloatMemberValue(int index, ConstPool cp)
/*     */   {
/*  40 */     super('F', cp);
/*  41 */     this.valueIndex = index;
/*     */   }
/*     */ 
/*     */   public FloatMemberValue(float f, ConstPool cp)
/*     */   {
/*  50 */     super('F', cp);
/*  51 */     setValue(f);
/*     */   }
/*     */ 
/*     */   public FloatMemberValue(ConstPool cp)
/*     */   {
/*  58 */     super('F', cp);
/*  59 */     setValue(0.0F);
/*     */   }
/*     */ 
/*     */   Object getValue(ClassLoader cl, ClassPool cp, Method m) {
/*  63 */     return new Float(getValue());
/*     */   }
/*     */ 
/*     */   Class getType(ClassLoader cl) {
/*  67 */     return Float.TYPE;
/*     */   }
/*     */ 
/*     */   public float getValue()
/*     */   {
/*  74 */     return this.cp.getFloatInfo(this.valueIndex);
/*     */   }
/*     */ 
/*     */   public void setValue(float newValue)
/*     */   {
/*  81 */     this.valueIndex = this.cp.addFloatInfo(newValue);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  88 */     return Float.toString(getValue());
/*     */   }
/*     */ 
/*     */   public void write(AnnotationsWriter writer)
/*     */     throws IOException
/*     */   {
/*  95 */     writer.constValueIndex(getValue());
/*     */   }
/*     */ 
/*     */   public void accept(MemberValueVisitor visitor)
/*     */   {
/* 102 */     visitor.visitFloatMemberValue(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.annotation.FloatMemberValue
 * JD-Core Version:    0.6.0
 */