/*     */ package javassist.bytecode.annotation;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.ClassPool;
/*     */ import javassist.bytecode.ConstPool;
/*     */ 
/*     */ public class ByteMemberValue extends MemberValue
/*     */ {
/*     */   int valueIndex;
/*     */ 
/*     */   public ByteMemberValue(int index, ConstPool cp)
/*     */   {
/*  38 */     super('B', cp);
/*  39 */     this.valueIndex = index;
/*     */   }
/*     */ 
/*     */   public ByteMemberValue(byte b, ConstPool cp)
/*     */   {
/*  48 */     super('B', cp);
/*  49 */     setValue(b);
/*     */   }
/*     */ 
/*     */   public ByteMemberValue(ConstPool cp)
/*     */   {
/*  56 */     super('B', cp);
/*  57 */     setValue(0);
/*     */   }
/*     */ 
/*     */   Object getValue(ClassLoader cl, ClassPool cp, Method m) {
/*  61 */     return new Byte(getValue());
/*     */   }
/*     */ 
/*     */   Class getType(ClassLoader cl) {
/*  65 */     return Byte.TYPE;
/*     */   }
/*     */ 
/*     */   public byte getValue()
/*     */   {
/*  72 */     return (byte)this.cp.getIntegerInfo(this.valueIndex);
/*     */   }
/*     */ 
/*     */   public void setValue(byte newValue)
/*     */   {
/*  79 */     this.valueIndex = this.cp.addIntegerInfo(newValue);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  86 */     return Byte.toString(getValue());
/*     */   }
/*     */ 
/*     */   public void write(AnnotationsWriter writer)
/*     */     throws IOException
/*     */   {
/*  93 */     writer.constValueIndex(getValue());
/*     */   }
/*     */ 
/*     */   public void accept(MemberValueVisitor visitor)
/*     */   {
/* 100 */     visitor.visitByteMemberValue(this);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.annotation.ByteMemberValue
 * JD-Core Version:    0.6.0
 */