/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Map;
/*      */ 
/*      */ class StringInfo extends ConstInfo
/*      */ {
/*      */   static final int tag = 8;
/*      */   int string;
/*      */ 
/*      */   public StringInfo(int str)
/*      */   {
/* 1332 */     this.string = str;
/*      */   }
/*      */ 
/*      */   public StringInfo(DataInputStream in) throws IOException {
/* 1336 */     this.string = in.readUnsignedShort();
/*      */   }
/*      */   public int getTag() {
/* 1339 */     return 8;
/*      */   }
/*      */   public int copy(ConstPool src, ConstPool dest, Map map) {
/* 1342 */     return dest.addStringInfo(src.getUtf8Info(this.string));
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out) throws IOException {
/* 1346 */     out.writeByte(8);
/* 1347 */     out.writeShort(this.string);
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out) {
/* 1351 */     out.print("String #");
/* 1352 */     out.println(this.string);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.StringInfo
 * JD-Core Version:    0.6.0
 */