/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Map;
/*      */ 
/*      */ class IntegerInfo extends ConstInfo
/*      */ {
/*      */   static final int tag = 3;
/*      */   int value;
/*      */ 
/*      */   public IntegerInfo(int i)
/*      */   {
/* 1361 */     this.value = i;
/*      */   }
/*      */ 
/*      */   public IntegerInfo(DataInputStream in) throws IOException {
/* 1365 */     this.value = in.readInt();
/*      */   }
/*      */   public int getTag() {
/* 1368 */     return 3;
/*      */   }
/*      */   public int copy(ConstPool src, ConstPool dest, Map map) {
/* 1371 */     return dest.addIntegerInfo(this.value);
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out) throws IOException {
/* 1375 */     out.writeByte(3);
/* 1376 */     out.writeInt(this.value);
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out) {
/* 1380 */     out.print("Integer ");
/* 1381 */     out.println(this.value);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.IntegerInfo
 * JD-Core Version:    0.6.0
 */