/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Map;
/*      */ 
/*      */ class FloatInfo extends ConstInfo
/*      */ {
/*      */   static final int tag = 4;
/*      */   float value;
/*      */ 
/*      */   public FloatInfo(float f)
/*      */   {
/* 1390 */     this.value = f;
/*      */   }
/*      */ 
/*      */   public FloatInfo(DataInputStream in) throws IOException {
/* 1394 */     this.value = in.readFloat();
/*      */   }
/*      */   public int getTag() {
/* 1397 */     return 4;
/*      */   }
/*      */   public int copy(ConstPool src, ConstPool dest, Map map) {
/* 1400 */     return dest.addFloatInfo(this.value);
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out) throws IOException {
/* 1404 */     out.writeByte(4);
/* 1405 */     out.writeFloat(this.value);
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out) {
/* 1409 */     out.print("Float ");
/* 1410 */     out.println(this.value);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.FloatInfo
 * JD-Core Version:    0.6.0
 */