/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.HashMap;
/*      */ import java.util.HashSet;
/*      */ import java.util.Map;
/*      */ import java.util.Set;
/*      */ import javassist.CtClass;
/*      */ 
/*      */ public final class ConstPool
/*      */ {
/*      */   LongVector items;
/*      */   int numOfItems;
/*      */   HashMap classes;
/*      */   HashMap strings;
/*      */   int thisClassInfo;
/*      */   public static final int CONST_Class = 7;
/*      */   public static final int CONST_Fieldref = 9;
/*      */   public static final int CONST_Methodref = 10;
/*      */   public static final int CONST_InterfaceMethodref = 11;
/*      */   public static final int CONST_String = 8;
/*      */   public static final int CONST_Integer = 3;
/*      */   public static final int CONST_Float = 4;
/*      */   public static final int CONST_Long = 5;
/*      */   public static final int CONST_Double = 6;
/*      */   public static final int CONST_NameAndType = 12;
/*      */   public static final int CONST_Utf8 = 1;
/*   99 */   public static final CtClass THIS = null;
/*      */ 
/*      */   public ConstPool(String thisclass)
/*      */   {
/*  108 */     this.items = new LongVector();
/*  109 */     this.numOfItems = 0;
/*  110 */     addItem(null);
/*  111 */     this.classes = new HashMap();
/*  112 */     this.strings = new HashMap();
/*  113 */     this.thisClassInfo = addClassInfo(thisclass);
/*      */   }
/*      */ 
/*      */   public ConstPool(DataInputStream in)
/*      */     throws IOException
/*      */   {
/*  122 */     this.classes = new HashMap();
/*  123 */     this.strings = new HashMap();
/*  124 */     this.thisClassInfo = 0;
/*      */ 
/*  127 */     read(in);
/*      */   }
/*      */ 
/*      */   void prune() {
/*  131 */     this.classes = new HashMap();
/*  132 */     this.strings = new HashMap();
/*      */   }
/*      */ 
/*      */   public int getSize()
/*      */   {
/*  139 */     return this.numOfItems;
/*      */   }
/*      */ 
/*      */   public String getClassName()
/*      */   {
/*  146 */     return getClassInfo(this.thisClassInfo);
/*      */   }
/*      */ 
/*      */   public int getThisClassInfo()
/*      */   {
/*  154 */     return this.thisClassInfo;
/*      */   }
/*      */ 
/*      */   void setThisClassInfo(int i) {
/*  158 */     this.thisClassInfo = i;
/*      */   }
/*      */ 
/*      */   ConstInfo getItem(int n) {
/*  162 */     return (ConstInfo)this.items.elementAt(n);
/*      */   }
/*      */ 
/*      */   public int getTag(int index)
/*      */   {
/*  170 */     return getItem(index).getTag();
/*      */   }
/*      */ 
/*      */   public String getClassInfo(int index)
/*      */   {
/*  185 */     ClassInfo c = (ClassInfo)getItem(index);
/*  186 */     if (c == null) {
/*  187 */       return null;
/*      */     }
/*  189 */     return Descriptor.toJavaName(getUtf8Info(c.name));
/*      */   }
/*      */ 
/*      */   public int getNameAndTypeName(int index)
/*      */   {
/*  198 */     NameAndTypeInfo ntinfo = (NameAndTypeInfo)getItem(index);
/*  199 */     return ntinfo.memberName;
/*      */   }
/*      */ 
/*      */   public int getNameAndTypeDescriptor(int index)
/*      */   {
/*  208 */     NameAndTypeInfo ntinfo = (NameAndTypeInfo)getItem(index);
/*  209 */     return ntinfo.typeDescriptor;
/*      */   }
/*      */ 
/*      */   public int getMemberClass(int index)
/*      */   {
/*  222 */     MemberrefInfo minfo = (MemberrefInfo)getItem(index);
/*  223 */     return minfo.classIndex;
/*      */   }
/*      */ 
/*      */   public int getMemberNameAndType(int index)
/*      */   {
/*  236 */     MemberrefInfo minfo = (MemberrefInfo)getItem(index);
/*  237 */     return minfo.nameAndTypeIndex;
/*      */   }
/*      */ 
/*      */   public int getFieldrefClass(int index)
/*      */   {
/*  246 */     FieldrefInfo finfo = (FieldrefInfo)getItem(index);
/*  247 */     return finfo.classIndex;
/*      */   }
/*      */ 
/*      */   public String getFieldrefClassName(int index)
/*      */   {
/*  258 */     FieldrefInfo f = (FieldrefInfo)getItem(index);
/*  259 */     if (f == null) {
/*  260 */       return null;
/*      */     }
/*  262 */     return getClassInfo(f.classIndex);
/*      */   }
/*      */ 
/*      */   public int getFieldrefNameAndType(int index)
/*      */   {
/*  271 */     FieldrefInfo finfo = (FieldrefInfo)getItem(index);
/*  272 */     return finfo.nameAndTypeIndex;
/*      */   }
/*      */ 
/*      */   public String getFieldrefName(int index)
/*      */   {
/*  284 */     FieldrefInfo f = (FieldrefInfo)getItem(index);
/*  285 */     if (f == null) {
/*  286 */       return null;
/*      */     }
/*  288 */     NameAndTypeInfo n = (NameAndTypeInfo)getItem(f.nameAndTypeIndex);
/*  289 */     if (n == null) {
/*  290 */       return null;
/*      */     }
/*  292 */     return getUtf8Info(n.memberName);
/*      */   }
/*      */ 
/*      */   public String getFieldrefType(int index)
/*      */   {
/*  305 */     FieldrefInfo f = (FieldrefInfo)getItem(index);
/*  306 */     if (f == null) {
/*  307 */       return null;
/*      */     }
/*  309 */     NameAndTypeInfo n = (NameAndTypeInfo)getItem(f.nameAndTypeIndex);
/*  310 */     if (n == null) {
/*  311 */       return null;
/*      */     }
/*  313 */     return getUtf8Info(n.typeDescriptor);
/*      */   }
/*      */ 
/*      */   public int getMethodrefClass(int index)
/*      */   {
/*  323 */     MethodrefInfo minfo = (MethodrefInfo)getItem(index);
/*  324 */     return minfo.classIndex;
/*      */   }
/*      */ 
/*      */   public String getMethodrefClassName(int index)
/*      */   {
/*  335 */     MethodrefInfo minfo = (MethodrefInfo)getItem(index);
/*  336 */     if (minfo == null) {
/*  337 */       return null;
/*      */     }
/*  339 */     return getClassInfo(minfo.classIndex);
/*      */   }
/*      */ 
/*      */   public int getMethodrefNameAndType(int index)
/*      */   {
/*  348 */     MethodrefInfo minfo = (MethodrefInfo)getItem(index);
/*  349 */     return minfo.nameAndTypeIndex;
/*      */   }
/*      */ 
/*      */   public String getMethodrefName(int index)
/*      */   {
/*  361 */     MethodrefInfo minfo = (MethodrefInfo)getItem(index);
/*  362 */     if (minfo == null) {
/*  363 */       return null;
/*      */     }
/*  365 */     NameAndTypeInfo n = (NameAndTypeInfo)getItem(minfo.nameAndTypeIndex);
/*      */ 
/*  367 */     if (n == null) {
/*  368 */       return null;
/*      */     }
/*  370 */     return getUtf8Info(n.memberName);
/*      */   }
/*      */ 
/*      */   public String getMethodrefType(int index)
/*      */   {
/*  383 */     MethodrefInfo minfo = (MethodrefInfo)getItem(index);
/*  384 */     if (minfo == null) {
/*  385 */       return null;
/*      */     }
/*  387 */     NameAndTypeInfo n = (NameAndTypeInfo)getItem(minfo.nameAndTypeIndex);
/*      */ 
/*  389 */     if (n == null) {
/*  390 */       return null;
/*      */     }
/*  392 */     return getUtf8Info(n.typeDescriptor);
/*      */   }
/*      */ 
/*      */   public int getInterfaceMethodrefClass(int index)
/*      */   {
/*  402 */     InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)getItem(index);
/*      */ 
/*  404 */     return minfo.classIndex;
/*      */   }
/*      */ 
/*      */   public String getInterfaceMethodrefClassName(int index)
/*      */   {
/*  415 */     InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)getItem(index);
/*      */ 
/*  417 */     return getClassInfo(minfo.classIndex);
/*      */   }
/*      */ 
/*      */   public int getInterfaceMethodrefNameAndType(int index)
/*      */   {
/*  426 */     InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)getItem(index);
/*      */ 
/*  428 */     return minfo.nameAndTypeIndex;
/*      */   }
/*      */ 
/*      */   public String getInterfaceMethodrefName(int index)
/*      */   {
/*  441 */     InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)getItem(index);
/*      */ 
/*  443 */     if (minfo == null) {
/*  444 */       return null;
/*      */     }
/*  446 */     NameAndTypeInfo n = (NameAndTypeInfo)getItem(minfo.nameAndTypeIndex);
/*      */ 
/*  448 */     if (n == null) {
/*  449 */       return null;
/*      */     }
/*  451 */     return getUtf8Info(n.memberName);
/*      */   }
/*      */ 
/*      */   public String getInterfaceMethodrefType(int index)
/*      */   {
/*  465 */     InterfaceMethodrefInfo minfo = (InterfaceMethodrefInfo)getItem(index);
/*      */ 
/*  467 */     if (minfo == null) {
/*  468 */       return null;
/*      */     }
/*  470 */     NameAndTypeInfo n = (NameAndTypeInfo)getItem(minfo.nameAndTypeIndex);
/*      */ 
/*  472 */     if (n == null) {
/*  473 */       return null;
/*      */     }
/*  475 */     return getUtf8Info(n.typeDescriptor);
/*      */   }
/*      */ 
/*      */   public Object getLdcValue(int index)
/*      */   {
/*  488 */     ConstInfo constInfo = getItem(index);
/*  489 */     Object value = null;
/*  490 */     if ((constInfo instanceof StringInfo))
/*  491 */       value = getStringInfo(index);
/*  492 */     else if ((constInfo instanceof FloatInfo))
/*  493 */       value = new Float(getFloatInfo(index));
/*  494 */     else if ((constInfo instanceof IntegerInfo))
/*  495 */       value = new Integer(getIntegerInfo(index));
/*  496 */     else if ((constInfo instanceof LongInfo))
/*  497 */       value = new Long(getLongInfo(index));
/*  498 */     else if ((constInfo instanceof DoubleInfo))
/*  499 */       value = new Double(getDoubleInfo(index));
/*      */     else {
/*  501 */       value = null;
/*      */     }
/*  503 */     return value;
/*      */   }
/*      */ 
/*      */   public int getIntegerInfo(int index)
/*      */   {
/*  513 */     IntegerInfo i = (IntegerInfo)getItem(index);
/*  514 */     return i.value;
/*      */   }
/*      */ 
/*      */   public float getFloatInfo(int index)
/*      */   {
/*  524 */     FloatInfo i = (FloatInfo)getItem(index);
/*  525 */     return i.value;
/*      */   }
/*      */ 
/*      */   public long getLongInfo(int index)
/*      */   {
/*  535 */     LongInfo i = (LongInfo)getItem(index);
/*  536 */     return i.value;
/*      */   }
/*      */ 
/*      */   public double getDoubleInfo(int index)
/*      */   {
/*  546 */     DoubleInfo i = (DoubleInfo)getItem(index);
/*  547 */     return i.value;
/*      */   }
/*      */ 
/*      */   public String getStringInfo(int index)
/*      */   {
/*  557 */     StringInfo si = (StringInfo)getItem(index);
/*  558 */     return getUtf8Info(si.string);
/*      */   }
/*      */ 
/*      */   public String getUtf8Info(int index)
/*      */   {
/*  568 */     Utf8Info utf = (Utf8Info)getItem(index);
/*  569 */     return utf.string;
/*      */   }
/*      */ 
/*      */   public int isConstructor(String classname, int index)
/*      */   {
/*  583 */     return isMember(classname, "<init>", index);
/*      */   }
/*      */ 
/*      */   public int isMember(String classname, String membername, int index)
/*      */   {
/*  603 */     MemberrefInfo minfo = (MemberrefInfo)getItem(index);
/*  604 */     if (getClassInfo(minfo.classIndex).equals(classname)) {
/*  605 */       NameAndTypeInfo ntinfo = (NameAndTypeInfo)getItem(minfo.nameAndTypeIndex);
/*      */ 
/*  607 */       if (getUtf8Info(ntinfo.memberName).equals(membername)) {
/*  608 */         return ntinfo.typeDescriptor;
/*      */       }
/*      */     }
/*  611 */     return 0;
/*      */   }
/*      */ 
/*      */   public String eqMember(String membername, String desc, int index)
/*      */   {
/*  632 */     MemberrefInfo minfo = (MemberrefInfo)getItem(index);
/*  633 */     NameAndTypeInfo ntinfo = (NameAndTypeInfo)getItem(minfo.nameAndTypeIndex);
/*      */ 
/*  635 */     if ((getUtf8Info(ntinfo.memberName).equals(membername)) && (getUtf8Info(ntinfo.typeDescriptor).equals(desc)))
/*      */     {
/*  637 */       return getClassInfo(minfo.classIndex);
/*      */     }
/*  639 */     return null;
/*      */   }
/*      */ 
/*      */   private int addItem(ConstInfo info) {
/*  643 */     this.items.addElement(info);
/*  644 */     return this.numOfItems++;
/*      */   }
/*      */ 
/*      */   public int copy(int n, ConstPool dest, Map classnames)
/*      */   {
/*  659 */     if (n == 0) {
/*  660 */       return 0;
/*      */     }
/*  662 */     ConstInfo info = getItem(n);
/*  663 */     return info.copy(this, dest, classnames);
/*      */   }
/*      */ 
/*      */   int addConstInfoPadding() {
/*  667 */     return addItem(new ConstInfoPadding());
/*      */   }
/*      */ 
/*      */   public int addClassInfo(CtClass c)
/*      */   {
/*  679 */     if (c == THIS)
/*  680 */       return this.thisClassInfo;
/*  681 */     if (!c.isArray()) {
/*  682 */       return addClassInfo(c.getName());
/*      */     }
/*      */ 
/*  689 */     return addClassInfo(Descriptor.toJvmName(c));
/*      */   }
/*      */ 
/*      */   public int addClassInfo(String qname)
/*      */   {
/*  704 */     ClassInfo info = (ClassInfo)this.classes.get(qname);
/*  705 */     if (info != null) {
/*  706 */       return info.index;
/*      */     }
/*  708 */     int utf8 = addUtf8Info(Descriptor.toJvmName(qname));
/*  709 */     info = new ClassInfo(utf8, this.numOfItems);
/*  710 */     this.classes.put(qname, info);
/*  711 */     return addItem(info);
/*      */   }
/*      */ 
/*      */   public int addNameAndTypeInfo(String name, String type)
/*      */   {
/*  725 */     return addNameAndTypeInfo(addUtf8Info(name), addUtf8Info(type));
/*      */   }
/*      */ 
/*      */   public int addNameAndTypeInfo(int name, int type)
/*      */   {
/*  736 */     return addItem(new NameAndTypeInfo(name, type));
/*      */   }
/*      */ 
/*      */   public int addFieldrefInfo(int classInfo, String name, String type)
/*      */   {
/*  753 */     int nt = addNameAndTypeInfo(name, type);
/*  754 */     return addFieldrefInfo(classInfo, nt);
/*      */   }
/*      */ 
/*      */   public int addFieldrefInfo(int classInfo, int nameAndTypeInfo)
/*      */   {
/*  765 */     return addItem(new FieldrefInfo(classInfo, nameAndTypeInfo));
/*      */   }
/*      */ 
/*      */   public int addMethodrefInfo(int classInfo, String name, String type)
/*      */   {
/*  782 */     int nt = addNameAndTypeInfo(name, type);
/*  783 */     return addMethodrefInfo(classInfo, nt);
/*      */   }
/*      */ 
/*      */   public int addMethodrefInfo(int classInfo, int nameAndTypeInfo)
/*      */   {
/*  794 */     return addItem(new MethodrefInfo(classInfo, nameAndTypeInfo));
/*      */   }
/*      */ 
/*      */   public int addInterfaceMethodrefInfo(int classInfo, String name, String type)
/*      */   {
/*  813 */     int nt = addNameAndTypeInfo(name, type);
/*  814 */     return addInterfaceMethodrefInfo(classInfo, nt);
/*      */   }
/*      */ 
/*      */   public int addInterfaceMethodrefInfo(int classInfo, int nameAndTypeInfo)
/*      */   {
/*  827 */     return addItem(new InterfaceMethodrefInfo(classInfo, nameAndTypeInfo));
/*      */   }
/*      */ 
/*      */   public int addStringInfo(String str)
/*      */   {
/*  841 */     return addItem(new StringInfo(addUtf8Info(str)));
/*      */   }
/*      */ 
/*      */   public int addIntegerInfo(int i)
/*      */   {
/*  851 */     return addItem(new IntegerInfo(i));
/*      */   }
/*      */ 
/*      */   public int addFloatInfo(float f)
/*      */   {
/*  861 */     return addItem(new FloatInfo(f));
/*      */   }
/*      */ 
/*      */   public int addLongInfo(long l)
/*      */   {
/*  871 */     int i = addItem(new LongInfo(l));
/*  872 */     addItem(new ConstInfoPadding());
/*  873 */     return i;
/*      */   }
/*      */ 
/*      */   public int addDoubleInfo(double d)
/*      */   {
/*  883 */     int i = addItem(new DoubleInfo(d));
/*  884 */     addItem(new ConstInfoPadding());
/*  885 */     return i;
/*      */   }
/*      */ 
/*      */   public int addUtf8Info(String utf8)
/*      */   {
/*  900 */     Utf8Info info = (Utf8Info)this.strings.get(utf8);
/*  901 */     if (info != null) {
/*  902 */       return info.index;
/*      */     }
/*  904 */     info = new Utf8Info(utf8, this.numOfItems);
/*  905 */     this.strings.put(utf8, info);
/*  906 */     return addItem(info);
/*      */   }
/*      */ 
/*      */   public Set getClassNames()
/*      */   {
/*  917 */     HashSet result = new HashSet();
/*  918 */     LongVector v = this.items;
/*  919 */     int size = this.numOfItems;
/*  920 */     for (int i = 1; i < size; i++) {
/*  921 */       String className = ((ConstInfo)v.elementAt(i)).getClassName(this);
/*  922 */       if (className != null)
/*  923 */         result.add(className);
/*      */     }
/*  925 */     return result;
/*      */   }
/*      */ 
/*      */   public void renameClass(String oldName, String newName)
/*      */   {
/*  935 */     LongVector v = this.items;
/*  936 */     int size = this.numOfItems;
/*  937 */     this.classes = new HashMap(this.classes.size() * 2);
/*  938 */     for (int i = 1; i < size; i++) {
/*  939 */       ConstInfo ci = (ConstInfo)v.elementAt(i);
/*  940 */       ci.renameClass(this, oldName, newName);
/*  941 */       ci.makeHashtable(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void renameClass(Map classnames)
/*      */   {
/*  952 */     LongVector v = this.items;
/*  953 */     int size = this.numOfItems;
/*  954 */     this.classes = new HashMap(this.classes.size() * 2);
/*  955 */     for (int i = 1; i < size; i++) {
/*  956 */       ConstInfo ci = (ConstInfo)v.elementAt(i);
/*  957 */       ci.renameClass(this, classnames);
/*  958 */       ci.makeHashtable(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void read(DataInputStream in) throws IOException {
/*  963 */     int n = in.readUnsignedShort();
/*      */ 
/*  965 */     this.items = new LongVector(n);
/*  966 */     this.numOfItems = 0;
/*  967 */     addItem(null);
/*      */     while (true) {
/*  969 */       n--; if (n <= 0) break;
/*  970 */       int tag = readOne(in);
/*  971 */       if ((tag == 5) || (tag == 6)) {
/*  972 */         addItem(new ConstInfoPadding());
/*  973 */         n--;
/*      */       }
/*      */     }
/*      */ 
/*  977 */     int i = 1;
/*      */     while (true) {
/*  979 */       ConstInfo info = (ConstInfo)this.items.elementAt(i++);
/*  980 */       if (info == null) {
/*      */         break;
/*      */       }
/*  983 */       info.makeHashtable(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   private int readOne(DataInputStream in) throws IOException
/*      */   {
/*  989 */     int tag = in.readUnsignedByte();
/*      */     ConstInfo info;
/*  990 */     switch (tag) {
/*      */     case 1:
/*  992 */       info = new Utf8Info(in, this.numOfItems);
/*  993 */       this.strings.put(((Utf8Info)info).string, info);
/*  994 */       break;
/*      */     case 3:
/*  996 */       info = new IntegerInfo(in);
/*  997 */       break;
/*      */     case 4:
/*  999 */       info = new FloatInfo(in);
/* 1000 */       break;
/*      */     case 5:
/* 1002 */       info = new LongInfo(in);
/* 1003 */       break;
/*      */     case 6:
/* 1005 */       info = new DoubleInfo(in);
/* 1006 */       break;
/*      */     case 7:
/* 1008 */       info = new ClassInfo(in, this.numOfItems);
/*      */ 
/* 1010 */       break;
/*      */     case 8:
/* 1012 */       info = new StringInfo(in);
/* 1013 */       break;
/*      */     case 9:
/* 1015 */       info = new FieldrefInfo(in);
/* 1016 */       break;
/*      */     case 10:
/* 1018 */       info = new MethodrefInfo(in);
/* 1019 */       break;
/*      */     case 11:
/* 1021 */       info = new InterfaceMethodrefInfo(in);
/* 1022 */       break;
/*      */     case 12:
/* 1024 */       info = new NameAndTypeInfo(in);
/* 1025 */       break;
/*      */     case 2:
/*      */     default:
/* 1027 */       throw new IOException("invalid constant type: " + tag);
/*      */     }
/*      */ 
/* 1030 */     addItem(info);
/* 1031 */     return tag;
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out)
/*      */     throws IOException
/*      */   {
/* 1038 */     out.writeShort(this.numOfItems);
/* 1039 */     LongVector v = this.items;
/* 1040 */     int size = this.numOfItems;
/* 1041 */     for (int i = 1; i < size; i++)
/* 1042 */       ((ConstInfo)v.elementAt(i)).write(out);
/*      */   }
/*      */ 
/*      */   public void print()
/*      */   {
/* 1049 */     print(new PrintWriter(System.out, true));
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out)
/*      */   {
/* 1056 */     int size = this.numOfItems;
/* 1057 */     for (int i = 1; i < size; i++) {
/* 1058 */       out.print(i);
/* 1059 */       out.print(" ");
/* 1060 */       ((ConstInfo)this.items.elementAt(i)).print(out);
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.ConstPool
 * JD-Core Version:    0.6.0
 */