/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.HashMap;
/*      */ import java.util.Map;
/*      */ 
/*      */ class ClassInfo extends ConstInfo
/*      */ {
/*      */   static final int tag = 7;
/*      */   int name;
/*      */   int index;
/*      */ 
/*      */   public ClassInfo(int className, int i)
/*      */   {
/* 1109 */     this.name = className;
/* 1110 */     this.index = i;
/*      */   }
/*      */ 
/*      */   public ClassInfo(DataInputStream in, int i) throws IOException {
/* 1114 */     this.name = in.readUnsignedShort();
/* 1115 */     this.index = i;
/*      */   }
/*      */   public int getTag() {
/* 1118 */     return 7;
/*      */   }
/*      */   public String getClassName(ConstPool cp) {
/* 1121 */     return cp.getUtf8Info(this.name);
/*      */   }
/*      */ 
/*      */   public void renameClass(ConstPool cp, String oldName, String newName) {
/* 1125 */     String nameStr = cp.getUtf8Info(this.name);
/* 1126 */     if (nameStr.equals(oldName)) {
/* 1127 */       this.name = cp.addUtf8Info(newName);
/* 1128 */     } else if (nameStr.charAt(0) == '[') {
/* 1129 */       String nameStr2 = Descriptor.rename(nameStr, oldName, newName);
/* 1130 */       if (nameStr != nameStr2)
/* 1131 */         this.name = cp.addUtf8Info(nameStr2);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void renameClass(ConstPool cp, Map map) {
/* 1136 */     String oldName = cp.getUtf8Info(this.name);
/* 1137 */     if (oldName.charAt(0) == '[') {
/* 1138 */       String newName = Descriptor.rename(oldName, map);
/* 1139 */       if (oldName != newName)
/* 1140 */         this.name = cp.addUtf8Info(newName);
/*      */     }
/*      */     else {
/* 1143 */       String newName = (String)map.get(oldName);
/* 1144 */       if ((newName != null) && (!newName.equals(oldName)))
/* 1145 */         this.name = cp.addUtf8Info(newName);
/*      */     }
/*      */   }
/*      */ 
/*      */   public int copy(ConstPool src, ConstPool dest, Map map) {
/* 1150 */     String classname = src.getUtf8Info(this.name);
/* 1151 */     if (map != null) {
/* 1152 */       String newname = (String)map.get(classname);
/* 1153 */       if (newname != null) {
/* 1154 */         classname = newname;
/*      */       }
/*      */     }
/* 1157 */     return dest.addClassInfo(classname);
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out) throws IOException {
/* 1161 */     out.writeByte(7);
/* 1162 */     out.writeShort(this.name);
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out) {
/* 1166 */     out.print("Class #");
/* 1167 */     out.println(this.name);
/*      */   }
/*      */ 
/*      */   void makeHashtable(ConstPool cp) {
/* 1171 */     String name = Descriptor.toJavaName(getClassName(cp));
/* 1172 */     cp.classes.put(name, this);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.ClassInfo
 * JD-Core Version:    0.6.0
 */