/*    */ package javassist.bytecode;
/*    */ 
/*    */ class ByteVector
/*    */   implements Cloneable
/*    */ {
/*    */   private byte[] buffer;
/*    */   private int size;
/*    */ 
/*    */   public ByteVector()
/*    */   {
/* 26 */     this.buffer = new byte[64];
/* 27 */     this.size = 0;
/*    */   }
/*    */ 
/*    */   public Object clone() throws CloneNotSupportedException {
/* 31 */     ByteVector bv = (ByteVector)super.clone();
/* 32 */     bv.buffer = ((byte[])(byte[])this.buffer.clone());
/* 33 */     return bv;
/*    */   }
/*    */   public final int getSize() {
/* 36 */     return this.size;
/*    */   }
/*    */   public final byte[] copy() {
/* 39 */     byte[] b = new byte[this.size];
/* 40 */     arraycopy(this.buffer, b, this.size);
/* 41 */     return b;
/*    */   }
/*    */ 
/*    */   public int read(int offset) {
/* 45 */     if ((offset < 0) || (this.size <= offset)) {
/* 46 */       throw new ArrayIndexOutOfBoundsException(offset);
/*    */     }
/* 48 */     return this.buffer[offset];
/*    */   }
/*    */ 
/*    */   public void write(int offset, int value) {
/* 52 */     if ((offset < 0) || (this.size <= offset)) {
/* 53 */       throw new ArrayIndexOutOfBoundsException(offset);
/*    */     }
/* 55 */     this.buffer[offset] = (byte)value;
/*    */   }
/*    */ 
/*    */   public void add(int code) {
/* 59 */     addGap(1);
/* 60 */     this.buffer[(this.size - 1)] = (byte)code;
/*    */   }
/*    */ 
/*    */   public void addGap(int length) {
/* 64 */     if (this.size + length > this.buffer.length) {
/* 65 */       int newSize = this.size << 1;
/* 66 */       if (newSize < this.size + length) {
/* 67 */         newSize = this.size + length;
/*    */       }
/* 69 */       byte[] newBuf = new byte[newSize];
/* 70 */       arraycopy(this.buffer, newBuf, this.size);
/* 71 */       this.buffer = newBuf;
/*    */     }
/*    */ 
/* 74 */     this.size += length;
/*    */   }
/*    */ 
/*    */   private static void arraycopy(byte[] src, byte[] dest, int size) {
/* 78 */     for (int i = 0; i < size; i++)
/* 79 */       dest[i] = src[i];
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.ByteVector
 * JD-Core Version:    0.6.0
 */