/*    */ package gnu.trove.benchmark;
/*    */ 
/*    */ import java.io.OutputStreamWriter;
/*    */ import java.io.PrintWriter;
/*    */ 
/*    */ class XMLReporter
/*    */   implements Reporter
/*    */ {
/*    */   PrintWriter out;
/*    */ 
/*    */   XMLReporter()
/*    */   {
/* 35 */     this.out = new PrintWriter(new OutputStreamWriter(System.out), true);
/*    */   }
/*    */ 
/*    */   XMLReporter(PrintWriter out)
/*    */   {
/* 40 */     this.out = out;
/*    */   }
/*    */ 
/*    */   public void report(Result result) {
/* 44 */     this.out.println("<result>");
/* 45 */     this.out.print("<desc>");
/* 46 */     this.out.print(result.getDescription());
/* 47 */     this.out.println("</desc>");
/*    */ 
/* 49 */     this.out.print("<iterations>");
/* 50 */     this.out.print(result.getIterations());
/* 51 */     this.out.println("</iterations>");
/*    */ 
/* 53 */     this.out.print("<theirTotal>");
/* 54 */     this.out.print(result.getTheirs());
/* 55 */     this.out.println("</theirTotal>");
/*    */ 
/* 57 */     this.out.print("<theirAvg>");
/* 58 */     this.out.print(result.getTheirAvg());
/* 59 */     this.out.println("</theirAvg>");
/*    */ 
/* 61 */     this.out.print("<ourTotal>");
/* 62 */     this.out.print(result.getOurs());
/* 63 */     this.out.println("</ourTotal>");
/*    */ 
/* 65 */     this.out.print("<ourAvg>");
/* 66 */     this.out.print(result.getOurAvg());
/* 67 */     this.out.println("</ourAvg>");
/*    */ 
/* 69 */     this.out.println("</result>");
/*    */   }
/*    */ 
/*    */   public void start() {
/* 73 */     this.out.println("<?xml version=\"1.0\" encoding=\"ASCII\" ?>");
/* 74 */     this.out.println("<benchmark>");
/* 75 */     this.out.print("<env>");
/* 76 */     for (int i = 0; i < Reporter.ENV_PROPS.length; i++) {
/* 77 */       String key = Reporter.ENV_PROPS[i];
/* 78 */       this.out.print(System.getProperty(key));
/* 79 */       this.out.print(" ");
/*    */     }
/* 81 */     this.out.println("</env>");
/*    */   }
/*    */ 
/*    */   public void finish() {
/* 85 */     this.out.println("</benchmark>");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.benchmark.XMLReporter
 * JD-Core Version:    0.6.0
 */