/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public abstract class TObjectHash extends THash
/*     */   implements Serializable, TObjectHashingStrategy
/*     */ {
/*     */   protected transient Object[] _set;
/*     */   protected TObjectHashingStrategy _hashingStrategy;
/*  42 */   protected static final Object REMOVED = new Object();
/*     */ 
/*     */   public TObjectHash()
/*     */   {
/*  50 */     this._hashingStrategy = this;
/*     */   }
/*     */ 
/*     */   public TObjectHash(TObjectHashingStrategy strategy)
/*     */   {
/*  61 */     this._hashingStrategy = strategy;
/*     */   }
/*     */ 
/*     */   public TObjectHash(int initialCapacity)
/*     */   {
/*  72 */     super(initialCapacity);
/*  73 */     this._hashingStrategy = this;
/*     */   }
/*     */ 
/*     */   public TObjectHash(int initialCapacity, TObjectHashingStrategy strategy)
/*     */   {
/*  86 */     super(initialCapacity);
/*  87 */     this._hashingStrategy = strategy;
/*     */   }
/*     */ 
/*     */   public TObjectHash(int initialCapacity, float loadFactor)
/*     */   {
/*  99 */     super(initialCapacity, loadFactor);
/* 100 */     this._hashingStrategy = this;
/*     */   }
/*     */ 
/*     */   public TObjectHash(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy)
/*     */   {
/* 114 */     super(initialCapacity, loadFactor);
/* 115 */     this._hashingStrategy = strategy;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 122 */     TObjectHash h = (TObjectHash)super.clone();
/* 123 */     h._set = ((Object[])this._set.clone());
/* 124 */     return h;
/*     */   }
/*     */ 
/*     */   protected int capacity() {
/* 128 */     return this._set.length;
/*     */   }
/*     */ 
/*     */   protected void removeAt(int index) {
/* 132 */     super.removeAt(index);
/* 133 */     this._set[index] = REMOVED;
/*     */   }
/*     */ 
/*     */   protected int setUp(int initialCapacity)
/*     */   {
/* 145 */     int capacity = super.setUp(initialCapacity);
/* 146 */     this._set = new Object[capacity];
/* 147 */     return capacity;
/*     */   }
/*     */ 
/*     */   public boolean forEach(TObjectProcedure procedure)
/*     */   {
/* 158 */     Object[] set = this._set;
/* 159 */     for (int i = set.length; i-- > 0; ) {
/* 160 */       if ((set[i] != null) && (set[i] != REMOVED) && (!procedure.execute(set[i])))
/*     */       {
/* 163 */         return false;
/*     */       }
/*     */     }
/* 166 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean contains(Object obj)
/*     */   {
/* 176 */     return index(obj) >= 0;
/*     */   }
/*     */ 
/*     */   protected int index(Object obj)
/*     */   {
/* 190 */     Object[] set = this._set;
/* 191 */     int length = set.length;
/* 192 */     int hash = this._hashingStrategy.computeHashCode(obj) & 0x7FFFFFFF;
/* 193 */     int index = hash % length;
/* 194 */     Object cur = set[index];
/*     */ 
/* 196 */     if ((cur != null) && ((cur == REMOVED) || (!this._hashingStrategy.equals(cur, obj))))
/*     */     {
/* 199 */       int probe = 1 + hash % (length - 2);
/*     */       do
/*     */       {
/* 202 */         index -= probe;
/* 203 */         if (index < 0) {
/* 204 */           index += length;
/*     */         }
/* 206 */         cur = set[index];
/*     */       }
/* 208 */       while ((cur != null) && ((cur == REMOVED) || (!this._hashingStrategy.equals(cur, obj))));
/*     */     }
/*     */ 
/* 211 */     return cur == null ? -1 : index;
/*     */   }
/*     */ 
/*     */   protected int insertionIndex(Object obj)
/*     */   {
/* 229 */     Object[] set = this._set;
/* 230 */     int length = set.length;
/* 231 */     int hash = this._hashingStrategy.computeHashCode(obj) & 0x7FFFFFFF;
/* 232 */     int index = hash % length;
/* 233 */     Object cur = set[index];
/*     */ 
/* 235 */     if (cur == null)
/* 236 */       return index;
/* 237 */     if (this._hashingStrategy.equals(cur, obj)) {
/* 238 */       return -index - 1;
/*     */     }
/*     */ 
/* 241 */     int probe = 1 + hash % (length - 2);
/*     */     do
/*     */     {
/* 245 */       index -= probe;
/* 246 */       if (index < 0) {
/* 247 */         index += length;
/*     */       }
/* 249 */       cur = set[index];
/*     */     }
/*     */ 
/* 252 */     while ((cur != null) && (cur != REMOVED) && (!this._hashingStrategy.equals(cur, obj)));
/*     */ 
/* 257 */     if (cur == REMOVED) {
/* 258 */       int firstRemoved = index;
/*     */ 
/* 260 */       while ((cur != null) && ((cur == REMOVED) || (!this._hashingStrategy.equals(cur, obj)))) {
/* 261 */         index -= probe;
/* 262 */         if (index < 0) {
/* 263 */           index += length;
/*     */         }
/* 265 */         cur = set[index];
/*     */       }
/* 267 */       return (cur != null) && (cur != REMOVED) ? -index - 1 : firstRemoved;
/*     */     }
/*     */ 
/* 271 */     return (cur != null) && (cur != REMOVED) ? -index - 1 : index;
/*     */   }
/*     */ 
/*     */   public final int computeHashCode(Object o)
/*     */   {
/* 285 */     return o.hashCode();
/*     */   }
/*     */ 
/*     */   public final boolean equals(Object o1, Object o2)
/*     */   {
/* 299 */     return o1.equals(o2);
/*     */   }
/*     */ 
/*     */   protected final void throwObjectContractViolation(Object o1, Object o2)
/*     */     throws IllegalArgumentException
/*     */   {
/* 315 */     throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + "; object #2 =" + o2);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TObjectHash
 * JD-Core Version:    0.6.0
 */