/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Array;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class THashSet extends TObjectHash
/*     */   implements Set, Serializable
/*     */ {
/*     */   public THashSet()
/*     */   {
/*     */   }
/*     */ 
/*     */   public THashSet(TObjectHashingStrategy strategy)
/*     */   {
/*  57 */     super(strategy);
/*     */   }
/*     */ 
/*     */   public THashSet(int initialCapacity)
/*     */   {
/*  68 */     super(initialCapacity);
/*     */   }
/*     */ 
/*     */   public THashSet(int initialCapacity, TObjectHashingStrategy strategy)
/*     */   {
/*  80 */     super(initialCapacity, strategy);
/*     */   }
/*     */ 
/*     */   public THashSet(int initialCapacity, float loadFactor)
/*     */   {
/*  92 */     super(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public THashSet(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy)
/*     */   {
/* 105 */     super(initialCapacity, loadFactor, strategy);
/*     */   }
/*     */ 
/*     */   public THashSet(Collection collection)
/*     */   {
/* 115 */     this(collection.size());
/* 116 */     addAll(collection);
/*     */   }
/*     */ 
/*     */   public THashSet(Collection collection, TObjectHashingStrategy strategy)
/*     */   {
/* 127 */     this(collection.size(), strategy);
/* 128 */     addAll(collection);
/*     */   }
/*     */ 
/*     */   public boolean add(Object obj)
/*     */   {
/* 138 */     int index = insertionIndex(obj);
/*     */ 
/* 140 */     if (index < 0) {
/* 141 */       return false;
/*     */     }
/*     */ 
/* 144 */     Object old = this._set[index];
/* 145 */     this._set[index] = obj;
/*     */ 
/* 147 */     postInsertHook(old == null);
/* 148 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other) {
/* 152 */     if (!(other instanceof Serializable)) {
/* 153 */       return false;
/*     */     }
/* 155 */     Set that = (Serializable)other;
/* 156 */     if (that.size() != size()) {
/* 157 */       return false;
/*     */     }
/* 159 */     return containsAll(that);
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 163 */     HashProcedure p = new HashProcedure(null);
/* 164 */     forEach(p);
/* 165 */     return p.getHashCode();
/*     */   }
/*     */ 
/*     */   protected void rehash(int newCapacity)
/*     */   {
/* 187 */     int oldCapacity = this._set.length;
/* 188 */     Object[] oldSet = this._set;
/*     */ 
/* 190 */     this._set = new Object[newCapacity];
/*     */ 
/* 192 */     for (int i = oldCapacity; i-- > 0; )
/* 193 */       if ((oldSet[i] != null) && (oldSet[i] != REMOVED)) {
/* 194 */         Object o = oldSet[i];
/* 195 */         int index = insertionIndex(o);
/* 196 */         if (index < 0) {
/* 197 */           throwObjectContractViolation(this._set[(-index - 1)], o);
/*     */         }
/* 199 */         this._set[index] = o;
/*     */       }
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 210 */     Object[] result = new Object[size()];
/* 211 */     forEach(new ToObjectArrayProcedure(result));
/* 212 */     return result;
/*     */   }
/*     */ 
/*     */   public Object[] toArray(Object[] a)
/*     */   {
/* 222 */     int size = size();
/* 223 */     if (a.length < size) {
/* 224 */       a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
/*     */     }
/* 226 */     forEach(new ToObjectArrayProcedure(a));
/*     */ 
/* 228 */     Iterator it = iterator();
/* 229 */     for (int i = 0; i < size; i++) {
/* 230 */       a[i] = it.next();
/*     */     }
/*     */ 
/* 233 */     if (a.length > size) {
/* 234 */       a[size] = null;
/*     */     }
/*     */ 
/* 237 */     return a;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 244 */     super.clear();
/* 245 */     Object[] set = this._set;
/*     */ 
/* 247 */     for (int i = set.length; i-- > 0; )
/* 248 */       set[i] = null;
/*     */   }
/*     */ 
/*     */   public boolean remove(Object obj)
/*     */   {
/* 259 */     int index = index(obj);
/* 260 */     if (index >= 0) {
/* 261 */       removeAt(index);
/* 262 */       return true;
/*     */     }
/* 264 */     return false;
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 274 */     return new TObjectHashIterator(this);
/*     */   }
/*     */ 
/*     */   public boolean containsAll(Collection collection)
/*     */   {
/* 285 */     for (Iterator i = collection.iterator(); i.hasNext(); ) {
/* 286 */       if (!contains(i.next())) {
/* 287 */         return false;
/*     */       }
/*     */     }
/* 290 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection collection)
/*     */   {
/* 300 */     boolean changed = false;
/* 301 */     int size = collection.size();
/*     */ 
/* 304 */     ensureCapacity(size);
/* 305 */     Iterator it = collection.iterator();
/* 306 */     while (size-- > 0) {
/* 307 */       if (add(it.next())) {
/* 308 */         changed = true;
/*     */       }
/*     */     }
/* 311 */     return changed;
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection collection)
/*     */   {
/* 321 */     boolean changed = false;
/* 322 */     int size = collection.size();
/*     */ 
/* 325 */     Iterator it = collection.iterator();
/* 326 */     while (size-- > 0) {
/* 327 */       if (remove(it.next())) {
/* 328 */         changed = true;
/*     */       }
/*     */     }
/* 331 */     return changed;
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection collection)
/*     */   {
/* 342 */     boolean changed = false;
/* 343 */     int size = size();
/*     */ 
/* 346 */     Iterator it = iterator();
/* 347 */     while (size-- > 0) {
/* 348 */       if (!collection.contains(it.next())) {
/* 349 */         it.remove();
/* 350 */         changed = true;
/*     */       }
/*     */     }
/* 353 */     return changed;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream stream) throws IOException
/*     */   {
/* 358 */     stream.defaultWriteObject();
/*     */ 
/* 361 */     stream.writeInt(this._size);
/*     */ 
/* 363 */     SerializationProcedure writeProcedure = new SerializationProcedure(stream);
/* 364 */     if (!forEach(writeProcedure))
/* 365 */       throw writeProcedure.exception;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream stream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 371 */     stream.defaultReadObject();
/*     */ 
/* 373 */     int size = stream.readInt();
/* 374 */     setUp(size);
/* 375 */     while (size-- > 0) {
/* 376 */       Object val = stream.readObject();
/* 377 */       add(val);
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class HashProcedure
/*     */     implements TObjectProcedure
/*     */   {
/*     */     private int h;
/*     */     private final THashSet this$0;
/*     */ 
/*     */     private HashProcedure()
/*     */     {
/* 168 */       this.this$0 = this$0;
/* 169 */       this.h = 0;
/*     */     }
/*     */     public int getHashCode() {
/* 172 */       return this.h;
/*     */     }
/*     */ 
/*     */     public final boolean execute(Object key) {
/* 176 */       this.h += this.this$0._hashingStrategy.computeHashCode(key);
/* 177 */       return true;
/*     */     }
/*     */ 
/*     */     HashProcedure(THashSet.1 x1)
/*     */     {
/* 168 */       this();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.THashSet
 * JD-Core Version:    0.6.0
 */