/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Array;
/*     */ import java.util.Collection;
/*     */ import java.util.ConcurrentModificationException;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class THashMap extends TObjectHash
/*     */   implements Map, Serializable
/*     */ {
/*     */   protected transient Object[] _values;
/*     */ 
/*     */   public THashMap()
/*     */   {
/*     */   }
/*     */ 
/*     */   public THashMap(TObjectHashingStrategy strategy)
/*     */   {
/*  61 */     super(strategy);
/*     */   }
/*     */ 
/*     */   public THashMap(int initialCapacity)
/*     */   {
/*  72 */     super(initialCapacity);
/*     */   }
/*     */ 
/*     */   public THashMap(int initialCapacity, TObjectHashingStrategy strategy)
/*     */   {
/*  84 */     super(initialCapacity, strategy);
/*     */   }
/*     */ 
/*     */   public THashMap(int initialCapacity, float loadFactor)
/*     */   {
/*  96 */     super(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public THashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy)
/*     */   {
/* 109 */     super(initialCapacity, loadFactor, strategy);
/*     */   }
/*     */ 
/*     */   public THashMap(Map map)
/*     */   {
/* 119 */     this(map.size());
/* 120 */     putAll(map);
/*     */   }
/*     */ 
/*     */   public THashMap(Map map, TObjectHashingStrategy strategy)
/*     */   {
/* 131 */     this(map.size(), strategy);
/* 132 */     putAll(map);
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 139 */     THashMap m = (THashMap)super.clone();
/* 140 */     m._values = ((Object[])this._values.clone());
/* 141 */     return m;
/*     */   }
/*     */ 
/*     */   protected int setUp(int initialCapacity)
/*     */   {
/* 153 */     int capacity = super.setUp(initialCapacity);
/* 154 */     this._values = new Object[capacity];
/* 155 */     return capacity;
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/* 167 */     if (null == key) {
/* 168 */       throw new NullPointerException("null keys not supported");
/*     */     }
/* 170 */     Object previous = null;
/* 171 */     Object oldKey = null;
/* 172 */     int index = insertionIndex(key);
/* 173 */     if (index < 0) {
/* 174 */       index = -index - 1;
/* 175 */       previous = this._values[index];
/*     */     }
/* 177 */     oldKey = this._set[index];
/* 178 */     this._set[index] = key;
/* 179 */     this._values[index] = value;
/* 180 */     if (null == previous) {
/* 181 */       postInsertHook(oldKey == null);
/*     */     }
/*     */ 
/* 184 */     return previous;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 195 */     if (!(other instanceof Serializable)) {
/* 196 */       return false;
/*     */     }
/* 198 */     Map that = (Serializable)other;
/* 199 */     if (that.size() != size()) {
/* 200 */       return false;
/*     */     }
/* 202 */     return forEachEntry(new EqProcedure(that));
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 206 */     HashProcedure p = new HashProcedure(null);
/* 207 */     forEachEntry(p);
/* 208 */     return p.getHashCode();
/*     */   }
/*     */ 
/*     */   public boolean forEachKey(TObjectProcedure procedure)
/*     */   {
/* 248 */     return forEach(procedure);
/*     */   }
/*     */ 
/*     */   public boolean forEachValue(TObjectProcedure procedure)
/*     */   {
/* 259 */     Object[] values = this._values;
/* 260 */     Object[] set = this._set;
/* 261 */     for (int i = values.length; i-- > 0; ) {
/* 262 */       if ((set[i] != null) && (set[i] != REMOVED) && (!procedure.execute(values[i])))
/*     */       {
/* 265 */         return false;
/*     */       }
/*     */     }
/* 268 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean forEachEntry(TObjectObjectProcedure procedure)
/*     */   {
/* 280 */     Object[] keys = this._set;
/* 281 */     Object[] values = this._values;
/* 282 */     for (int i = keys.length; i-- > 0; ) {
/* 283 */       if ((keys[i] != null) && (keys[i] != REMOVED) && (!procedure.execute(keys[i], values[i])))
/*     */       {
/* 286 */         return false;
/*     */       }
/*     */     }
/* 289 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean retainEntries(TObjectObjectProcedure procedure)
/*     */   {
/* 300 */     boolean modified = false;
/* 301 */     Object[] keys = this._set;
/* 302 */     Object[] values = this._values;
/* 303 */     for (int i = keys.length; i-- > 0; ) {
/* 304 */       if ((keys[i] == null) || (keys[i] == REMOVED) || (procedure.execute(keys[i], values[i]))) {
/*     */         continue;
/*     */       }
/* 307 */       removeAt(i);
/* 308 */       modified = true;
/*     */     }
/*     */ 
/* 311 */     return modified;
/*     */   }
/*     */ 
/*     */   public void transformValues(TObjectFunction function)
/*     */   {
/* 320 */     Object[] values = this._values;
/* 321 */     Object[] set = this._set;
/* 322 */     for (int i = values.length; i-- > 0; )
/* 323 */       if ((set[i] != null) && (set[i] != REMOVED))
/* 324 */         values[i] = function.execute(values[i]);
/*     */   }
/*     */ 
/*     */   protected void rehash(int newCapacity)
/*     */   {
/* 335 */     int oldCapacity = this._set.length;
/* 336 */     Object[] oldKeys = this._set;
/* 337 */     Object[] oldVals = this._values;
/*     */ 
/* 339 */     this._set = new Object[newCapacity];
/* 340 */     this._values = new Object[newCapacity];
/*     */ 
/* 342 */     for (int i = oldCapacity; i-- > 0; )
/* 343 */       if ((oldKeys[i] != null) && (oldKeys[i] != REMOVED)) {
/* 344 */         Object o = oldKeys[i];
/* 345 */         int index = insertionIndex(o);
/* 346 */         if (index < 0) {
/* 347 */           throwObjectContractViolation(this._set[(-index - 1)], o);
/*     */         }
/* 349 */         this._set[index] = o;
/* 350 */         this._values[index] = oldVals[i];
/*     */       }
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 362 */     int index = index(key);
/* 363 */     return index < 0 ? null : this._values[index];
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 371 */     super.clear();
/* 372 */     Object[] keys = this._set;
/* 373 */     Object[] vals = this._values;
/*     */ 
/* 375 */     for (int i = keys.length; i-- > 0; ) {
/* 376 */       keys[i] = null;
/* 377 */       vals[i] = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/* 388 */     Object prev = null;
/* 389 */     int index = index(key);
/* 390 */     if (index >= 0) {
/* 391 */       prev = this._values[index];
/* 392 */       removeAt(index);
/*     */     }
/* 394 */     return prev;
/*     */   }
/*     */ 
/*     */   protected void removeAt(int index)
/*     */   {
/* 403 */     super.removeAt(index);
/* 404 */     this._values[index] = null;
/*     */   }
/*     */ 
/*     */   public Collection values()
/*     */   {
/* 413 */     return new ValueView();
/*     */   }
/*     */ 
/*     */   public Set keySet()
/*     */   {
/* 422 */     return new KeyView();
/*     */   }
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/* 431 */     return new EntryView();
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object val)
/*     */   {
/* 441 */     Object[] set = this._set;
/* 442 */     Object[] vals = this._values;
/*     */     int i;
/*     */     int i;
/* 446 */     if (null == val) {
/* 447 */       for (i = vals.length; i-- > 0; )
/* 448 */         if ((set[i] != null) && (set[i] != REMOVED) && (val == vals[i]))
/*     */         {
/* 450 */           return true;
/*     */         }
/*     */     }
/*     */     else {
/* 454 */       for (i = vals.length; i-- > 0; ) {
/* 455 */         if ((set[i] != null) && (set[i] != REMOVED) && ((val == vals[i]) || (val.equals(vals[i]))))
/*     */         {
/* 457 */           return true;
/*     */         }
/*     */       }
/*     */     }
/* 461 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 471 */     return contains(key);
/*     */   }
/*     */ 
/*     */   public void putAll(Map map)
/*     */   {
/* 480 */     ensureCapacity(map.size());
/*     */ 
/* 482 */     for (Iterator i = map.entrySet().iterator(); i.hasNext(); ) {
/* 483 */       Map.Entry e = (Map.Entry)i.next();
/* 484 */       put(e.getKey(), e.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream stream)
/*     */     throws IOException
/*     */   {
/* 710 */     stream.defaultWriteObject();
/*     */ 
/* 713 */     stream.writeInt(this._size);
/*     */ 
/* 715 */     SerializationProcedure writeProcedure = new SerializationProcedure(stream);
/* 716 */     if (!forEachEntry(writeProcedure))
/* 717 */       throw writeProcedure.exception;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream stream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 723 */     stream.defaultReadObject();
/*     */ 
/* 725 */     int size = stream.readInt();
/* 726 */     setUp(size);
/* 727 */     while (size-- > 0) {
/* 728 */       Object key = stream.readObject();
/* 729 */       Object val = stream.readObject();
/* 730 */       put(key, val);
/*     */     }
/*     */   }
/*     */ 
/*     */   final class Entry
/*     */     implements Map.Entry
/*     */   {
/*     */     private final Object key;
/*     */     private Object val;
/*     */     private final int index;
/*     */ 
/*     */     Entry(Object key, Object value, int index)
/*     */     {
/* 683 */       this.key = key;
/* 684 */       this.val = value;
/* 685 */       this.index = index;
/*     */     }
/*     */ 
/*     */     public Object getKey() {
/* 689 */       return this.key;
/*     */     }
/*     */ 
/*     */     public Object getValue() {
/* 693 */       return this.val;
/*     */     }
/*     */ 
/*     */     public Object setValue(Object o) {
/* 697 */       if (THashMap.this._values[this.index] != this.val) {
/* 698 */         throw new ConcurrentModificationException();
/*     */       }
/* 700 */       THashMap.this._values[this.index] = o;
/* 701 */       o = this.val;
/* 702 */       this.val = o;
/*     */ 
/* 704 */       return o;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class KeyView
/*     */     implements Set
/*     */   {
/*     */     protected KeyView()
/*     */     {
/*     */     }
/*     */ 
/*     */     public Iterator iterator()
/*     */     {
/* 578 */       return new TObjectHashIterator(THashMap.this);
/*     */     }
/*     */ 
/*     */     public boolean remove(Object key) {
/* 582 */       return null != THashMap.this.remove(key);
/*     */     }
/*     */ 
/*     */     public boolean contains(Object key) {
/* 586 */       return THashMap.this.contains(key);
/*     */     }
/*     */ 
/*     */     public boolean containsAll(Collection collection)
/*     */     {
/* 591 */       for (Iterator i = collection.iterator(); i.hasNext(); ) {
/* 592 */         if (!contains(i.next())) {
/* 593 */           return false;
/*     */         }
/*     */       }
/* 596 */       return true;
/*     */     }
/*     */ 
/*     */     public boolean removeAll(Collection collection) {
/* 600 */       boolean changed = false;
/* 601 */       for (Iterator i = collection.iterator(); i.hasNext(); ) {
/* 602 */         if (remove(i.next())) {
/* 603 */           changed = true;
/*     */         }
/*     */       }
/* 606 */       return changed;
/*     */     }
/*     */ 
/*     */     public void clear() {
/* 610 */       THashMap.this.clear();
/*     */     }
/*     */ 
/*     */     public boolean add(Object obj) {
/* 614 */       throw new UnsupportedOperationException();
/*     */     }
/*     */ 
/*     */     public int size() {
/* 618 */       return THashMap.this.size();
/*     */     }
/*     */ 
/*     */     public Object[] toArray() {
/* 622 */       Object[] result = new Object[size()];
/* 623 */       Iterator e = iterator();
/* 624 */       for (int i = 0; e.hasNext(); i++)
/* 625 */         result[i] = e.next();
/* 626 */       return result;
/*     */     }
/*     */ 
/*     */     public Object[] toArray(Object[] a) {
/* 630 */       int size = size();
/* 631 */       if (a.length < size) {
/* 632 */         a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
/*     */       }
/* 634 */       Iterator it = iterator();
/* 635 */       for (int i = 0; i < size; i++) {
/* 636 */         a[i] = it.next();
/*     */       }
/*     */ 
/* 639 */       if (a.length > size) {
/* 640 */         a[size] = null;
/*     */       }
/*     */ 
/* 643 */       return a;
/*     */     }
/*     */ 
/*     */     public boolean isEmpty() {
/* 647 */       return THashMap.this.isEmpty();
/*     */     }
/*     */ 
/*     */     public boolean addAll(Collection collection) {
/* 651 */       throw new UnsupportedOperationException();
/*     */     }
/*     */ 
/*     */     public boolean retainAll(Collection collection) {
/* 655 */       boolean changed = false;
/* 656 */       Iterator i = iterator();
/* 657 */       while (i.hasNext()) {
/* 658 */         if (!collection.contains(i.next())) {
/* 659 */           i.remove();
/* 660 */           changed = true;
/*     */         }
/*     */       }
/* 663 */       return changed;
/*     */     }
/*     */ 
/*     */     protected final class EntryIterator extends THashIterator {
/*     */       EntryIterator(THashMap map) {
/* 668 */         super();
/*     */       }
/*     */ 
/*     */       public Object objectAtIndex(int index) {
/* 672 */         return new THashMap.Entry(THashMap.this, THashMap.this._set[index], THashMap.this._values[index], index);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class EntryView extends THashMap.KeyView
/*     */   {
/*     */     protected EntryView()
/*     */     {
/* 526 */       super();
/*     */     }
/* 528 */     public Iterator iterator() { return new THashMap.KeyView.EntryIterator(this, THashMap.this);
/*     */     }
/*     */ 
/*     */     public boolean remove(Object entry)
/*     */     {
/* 544 */       Object key = keyForEntry(entry);
/* 545 */       int index = THashMap.this.index(key);
/* 546 */       if (index >= 0) {
/* 547 */         Object val = valueForEntry(entry);
/* 548 */         if ((val == THashMap.this._values[index]) || ((null != val) && (val.equals(THashMap.this._values[index]))))
/*     */         {
/* 550 */           THashMap.this.removeAt(index);
/* 551 */           return true;
/*     */         }
/*     */       }
/* 554 */       return false;
/*     */     }
/*     */ 
/*     */     public boolean contains(Object entry) {
/* 558 */       Object val = THashMap.this.get(keyForEntry(entry));
/* 559 */       Object entryValue = ((Map.Entry)entry).getValue();
/* 560 */       return (entryValue == val) || ((null != val) && (val.equals(entryValue)));
/*     */     }
/*     */ 
/*     */     protected Object valueForEntry(Object entry)
/*     */     {
/* 565 */       return ((Map.Entry)entry).getValue();
/*     */     }
/*     */ 
/*     */     protected Object keyForEntry(Object entry) {
/* 569 */       return ((Map.Entry)entry).getKey();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected class ValueView extends THashMap.KeyView
/*     */   {
/*     */     protected ValueView()
/*     */     {
/* 492 */       super();
/*     */     }
/* 494 */     public Iterator iterator() { return new THashMap.1(this, THashMap.this);
/*     */     }
/*     */ 
/*     */     public boolean contains(Object value)
/*     */     {
/* 502 */       return THashMap.this.containsValue(value);
/*     */     }
/*     */ 
/*     */     public boolean remove(Object value) {
/* 506 */       boolean changed = false;
/* 507 */       Object[] values = THashMap.this._values;
/* 508 */       Object[] set = THashMap.this._set;
/*     */ 
/* 510 */       for (int i = values.length; i-- > 0; ) {
/* 511 */         if (((set[i] == null) || (set[i] == TObjectHash.REMOVED) || (value != values[i])) && ((null == values[i]) || (!values[i].equals(value)))) {
/*     */           continue;
/*     */         }
/* 514 */         THashMap.this.removeAt(i);
/* 515 */         changed = true;
/*     */       }
/*     */ 
/* 518 */       return changed;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class EqProcedure
/*     */     implements TObjectObjectProcedure
/*     */   {
/*     */     private final Map _otherMap;
/*     */ 
/*     */     EqProcedure(Map otherMap)
/*     */     {
/* 228 */       this._otherMap = otherMap;
/*     */     }
/*     */ 
/*     */     public final boolean execute(Object key, Object value) {
/* 232 */       Object oValue = this._otherMap.get(key);
/*     */ 
/* 234 */       return (oValue == value) || ((oValue != null) && (oValue.equals(value)));
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class HashProcedure
/*     */     implements TObjectObjectProcedure
/*     */   {
/*     */     private int h;
/*     */     private final THashMap this$0;
/*     */ 
/*     */     private HashProcedure()
/*     */     {
/* 211 */       this.this$0 = this$0;
/* 212 */       this.h = 0;
/*     */     }
/*     */     public int getHashCode() {
/* 215 */       return this.h;
/*     */     }
/*     */ 
/*     */     public final boolean execute(Object key, Object value) {
/* 219 */       this.h += (this.this$0._hashingStrategy.computeHashCode(key) ^ (value == null ? 0 : value.hashCode()));
/* 220 */       return true;
/*     */     }
/*     */ 
/*     */     HashProcedure(THashMap.1 x1)
/*     */     {
/* 211 */       this();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.THashMap
 * JD-Core Version:    0.6.0
 */