/*     */ package gnu.trove;
/*     */ 
/*     */ public abstract class THash
/*     */   implements Cloneable
/*     */ {
/*     */   protected transient int _size;
/*     */   protected transient int _free;
/*     */   protected static final float DEFAULT_LOAD_FACTOR = 0.5F;
/*     */   protected static final int DEFAULT_INITIAL_CAPACITY = 10;
/*     */   protected float _loadFactor;
/*     */   protected int _maxSize;
/*     */ 
/*     */   public THash()
/*     */   {
/*  67 */     this(10, 0.5F);
/*     */   }
/*     */ 
/*     */   public THash(int initialCapacity)
/*     */   {
/*  78 */     this(initialCapacity, 0.5F);
/*     */   }
/*     */ 
/*     */   public THash(int initialCapacity, float loadFactor)
/*     */   {
/*  92 */     this._loadFactor = loadFactor;
/*  93 */     setUp((int)Math.ceil(initialCapacity / loadFactor));
/*     */   }
/*     */ 
/*     */   public Object clone() {
/*     */     try {
/*  98 */       return super.clone(); } catch (CloneNotSupportedException cnse) {
/*     */     }
/* 100 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 110 */     return 0 == this._size;
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 119 */     return this._size;
/*     */   }
/*     */ 
/*     */   protected abstract int capacity();
/*     */ 
/*     */   public void ensureCapacity(int desiredCapacity)
/*     */   {
/* 136 */     if (desiredCapacity > this._maxSize - size()) {
/* 137 */       rehash(PrimeFinder.nextPrime((int)Math.ceil(desiredCapacity + size() / this._loadFactor) + 1));
/*     */ 
/* 139 */       computeMaxSize(capacity());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void compact()
/*     */   {
/* 162 */     rehash(PrimeFinder.nextPrime((int)Math.ceil(size() / this._loadFactor) + 1));
/* 163 */     computeMaxSize(capacity());
/*     */   }
/*     */ 
/*     */   public final void trimToSize()
/*     */   {
/* 176 */     compact();
/*     */   }
/*     */ 
/*     */   protected void removeAt(int index)
/*     */   {
/* 186 */     this._size -= 1;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 193 */     this._size = 0;
/* 194 */     this._free = capacity();
/*     */   }
/*     */ 
/*     */   protected int setUp(int initialCapacity)
/*     */   {
/* 207 */     int capacity = PrimeFinder.nextPrime(initialCapacity);
/* 208 */     computeMaxSize(capacity);
/* 209 */     return capacity;
/*     */   }
/*     */ 
/*     */   protected abstract void rehash(int paramInt);
/*     */ 
/*     */   private final void computeMaxSize(int capacity)
/*     */   {
/* 227 */     this._maxSize = Math.min(capacity - 1, (int)Math.floor(capacity * this._loadFactor));
/*     */ 
/* 229 */     this._free = (capacity - this._size);
/*     */   }
/*     */ 
/*     */   protected final void postInsertHook(boolean usedFreeSlot)
/*     */   {
/* 237 */     if (usedFreeSlot) {
/* 238 */       this._free -= 1;
/*     */     }
/*     */ 
/* 242 */     if ((++this._size > this._maxSize) || (this._free == 0)) {
/* 243 */       rehash(PrimeFinder.nextPrime(capacity() << 1));
/* 244 */       computeMaxSize(capacity());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.THash
 * JD-Core Version:    0.6.0
 */