/*     */ package com.sun.xml.txw2;
/*     */ 
/*     */ import java.util.EmptyStackException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Vector;
/*     */ 
/*     */ final class NamespaceSupport
/*     */ {
/*     */   public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
/*     */   public static final String NSDECL = "http://www.w3.org/xmlns/2000/";
/* 136 */   private static final Enumeration EMPTY_ENUMERATION = new Vector().elements();
/*     */   private Context[] contexts;
/*     */   private Context currentContext;
/*     */   private int contextPos;
/*     */   private boolean namespaceDeclUris;
/*     */ 
/*     */   public NamespaceSupport()
/*     */   {
/* 150 */     reset();
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 173 */     this.contexts = new Context[32];
/* 174 */     this.namespaceDeclUris = false;
/* 175 */     this.contextPos = 0;
/*     */      tmp36_33 = new Context(); this.currentContext = tmp36_33; this.contexts[this.contextPos] = tmp36_33;
/* 177 */     this.currentContext.declarePrefix("xml", "http://www.w3.org/XML/1998/namespace");
/*     */   }
/*     */ 
/*     */   public void pushContext()
/*     */   {
/* 219 */     int max = this.contexts.length;
/*     */ 
/* 221 */     this.contextPos += 1;
/*     */ 
/* 224 */     if (this.contextPos >= max) {
/* 225 */       Context[] newContexts = new Context[max * 2];
/* 226 */       System.arraycopy(this.contexts, 0, newContexts, 0, max);
/* 227 */       max *= 2;
/* 228 */       this.contexts = newContexts;
/*     */     }
/*     */ 
/* 232 */     this.currentContext = this.contexts[this.contextPos];
/* 233 */     if (this.currentContext == null)
/*     */     {
/*     */        tmp88_85 = new Context(); this.currentContext = tmp88_85; this.contexts[this.contextPos] = tmp88_85;
/*     */     }
/*     */ 
/* 238 */     if (this.contextPos > 0)
/* 239 */       this.currentContext.setParent(this.contexts[(this.contextPos - 1)]);
/*     */   }
/*     */ 
/*     */   public void popContext()
/*     */   {
/* 259 */     this.contexts[this.contextPos].clear();
/* 260 */     this.contextPos -= 1;
/* 261 */     if (this.contextPos < 0) {
/* 262 */       throw new EmptyStackException();
/*     */     }
/* 264 */     this.currentContext = this.contexts[this.contextPos];
/*     */   }
/*     */ 
/*     */   public boolean declarePrefix(String prefix, String uri)
/*     */   {
/* 309 */     if ((prefix.equals("xml")) || (prefix.equals("xmlns"))) {
/* 310 */       return false;
/*     */     }
/* 312 */     this.currentContext.declarePrefix(prefix, uri);
/* 313 */     return true;
/*     */   }
/*     */ 
/*     */   public String[] processName(String qName, String[] parts, boolean isAttribute)
/*     */   {
/* 361 */     String[] myParts = this.currentContext.processName(qName, isAttribute);
/* 362 */     if (myParts == null) {
/* 363 */       return null;
/*     */     }
/* 365 */     parts[0] = myParts[0];
/* 366 */     parts[1] = myParts[1];
/* 367 */     parts[2] = myParts[2];
/* 368 */     return parts;
/*     */   }
/*     */ 
/*     */   public String getURI(String prefix)
/*     */   {
/* 387 */     return this.currentContext.getURI(prefix);
/*     */   }
/*     */ 
/*     */   public Enumeration getPrefixes()
/*     */   {
/* 407 */     return this.currentContext.getPrefixes();
/*     */   }
/*     */ 
/*     */   public String getPrefix(String uri)
/*     */   {
/* 432 */     return this.currentContext.getPrefix(uri);
/*     */   }
/*     */ 
/*     */   public Enumeration getPrefixes(String uri)
/*     */   {
/* 461 */     Vector prefixes = new Vector();
/* 462 */     Enumeration allPrefixes = getPrefixes();
/* 463 */     while (allPrefixes.hasMoreElements()) {
/* 464 */       String prefix = (String)allPrefixes.nextElement();
/* 465 */       if (uri.equals(getURI(prefix))) {
/* 466 */         prefixes.addElement(prefix);
/*     */       }
/*     */     }
/* 469 */     return prefixes.elements();
/*     */   }
/*     */ 
/*     */   public Enumeration getDeclaredPrefixes()
/*     */   {
/* 487 */     return this.currentContext.getDeclaredPrefixes();
/*     */   }
/*     */ 
/*     */   public void setNamespaceDeclUris(boolean value)
/*     */   {
/* 503 */     if (this.contextPos != 0)
/* 504 */       throw new IllegalStateException();
/* 505 */     if (value == this.namespaceDeclUris)
/* 506 */       return;
/* 507 */     this.namespaceDeclUris = value;
/* 508 */     if (value) {
/* 509 */       this.currentContext.declarePrefix("xmlns", "http://www.w3.org/xmlns/2000/");
/*     */     }
/*     */     else
/*     */     {
/*     */        tmp64_61 = new Context(); this.currentContext = tmp64_61; this.contexts[this.contextPos] = tmp64_61;
/* 512 */       this.currentContext.declarePrefix("xml", "http://www.w3.org/XML/1998/namespace");
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isNamespaceDeclUris()
/*     */   {
/* 523 */     return this.namespaceDeclUris;
/*     */   }
/*     */ 
/*     */   final class Context
/*     */   {
/*     */     Hashtable prefixTable;
/*     */     Hashtable uriTable;
/*     */     Hashtable elementNameTable;
/*     */     Hashtable attributeNameTable;
/* 824 */     String defaultNS = "";
/*     */ 
/* 832 */     private Vector declarations = null;
/* 833 */     private boolean declSeen = false;
/* 834 */     private Context parent = null;
/*     */ 
/*     */     Context()
/*     */     {
/* 560 */       copyTables();
/*     */     }
/*     */ 
/*     */     void setParent(Context parent)
/*     */     {
/* 573 */       this.parent = parent;
/* 574 */       this.declarations = null;
/* 575 */       this.prefixTable = parent.prefixTable;
/* 576 */       this.uriTable = parent.uriTable;
/* 577 */       this.elementNameTable = parent.elementNameTable;
/* 578 */       this.attributeNameTable = parent.attributeNameTable;
/* 579 */       this.defaultNS = parent.defaultNS;
/* 580 */       this.declSeen = false;
/*     */     }
/*     */ 
/*     */     void clear()
/*     */     {
/* 591 */       this.parent = null;
/* 592 */       this.prefixTable = null;
/* 593 */       this.uriTable = null;
/* 594 */       this.elementNameTable = null;
/* 595 */       this.attributeNameTable = null;
/* 596 */       this.defaultNS = "";
/*     */     }
/*     */ 
/*     */     void declarePrefix(String prefix, String uri)
/*     */     {
/* 613 */       if (!this.declSeen) {
/* 614 */         copyTables();
/*     */       }
/* 616 */       if (this.declarations == null) {
/* 617 */         this.declarations = new Vector();
/*     */       }
/*     */ 
/* 620 */       prefix = prefix.intern();
/* 621 */       uri = uri.intern();
/* 622 */       if ("".equals(prefix)) {
/* 623 */         this.defaultNS = uri;
/*     */       } else {
/* 625 */         this.prefixTable.put(prefix, uri);
/* 626 */         this.uriTable.put(uri, prefix);
/*     */       }
/* 628 */       this.declarations.addElement(prefix);
/*     */     }
/*     */ 
/*     */     String[] processName(String qName, boolean isAttribute)
/*     */     {
/*     */       Hashtable table;
/*     */       Hashtable table;
/* 649 */       if (isAttribute)
/* 650 */         table = this.attributeNameTable;
/*     */       else {
/* 652 */         table = this.elementNameTable;
/*     */       }
/*     */ 
/* 658 */       String[] name = (String[])(String[])table.get(qName);
/* 659 */       if (name != null) {
/* 660 */         return name;
/*     */       }
/*     */ 
/* 667 */       name = new String[3];
/* 668 */       name[2] = qName.intern();
/* 669 */       int index = qName.indexOf(':');
/*     */ 
/* 673 */       if (index == -1) {
/* 674 */         if (isAttribute) {
/* 675 */           if ((qName == "xmlns") && (NamespaceSupport.this.namespaceDeclUris))
/* 676 */             name[0] = "http://www.w3.org/xmlns/2000/";
/*     */           else
/* 678 */             name[0] = "";
/*     */         }
/* 680 */         else name[0] = this.defaultNS;
/*     */ 
/* 682 */         name[1] = name[2];
/*     */       }
/*     */       else
/*     */       {
/* 687 */         String prefix = qName.substring(0, index);
/* 688 */         String local = qName.substring(index + 1);
/*     */         String uri;
/*     */         String uri;
/* 690 */         if ("".equals(prefix))
/* 691 */           uri = this.defaultNS;
/*     */         else {
/* 693 */           uri = (String)this.prefixTable.get(prefix);
/*     */         }
/* 695 */         if ((uri == null) || ((!isAttribute) && ("xmlns".equals(prefix))))
/*     */         {
/* 697 */           return null;
/*     */         }
/* 699 */         name[0] = uri;
/* 700 */         name[1] = local.intern();
/*     */       }
/*     */ 
/* 705 */       table.put(name[2], name);
/* 706 */       return name;
/*     */     }
/*     */ 
/*     */     String getURI(String prefix)
/*     */     {
/* 720 */       if ("".equals(prefix))
/* 721 */         return this.defaultNS;
/* 722 */       if (this.prefixTable == null) {
/* 723 */         return null;
/*     */       }
/* 725 */       return (String)this.prefixTable.get(prefix);
/*     */     }
/*     */ 
/*     */     String getPrefix(String uri)
/*     */     {
/* 742 */       if (this.uriTable == null) {
/* 743 */         return null;
/*     */       }
/* 745 */       return (String)this.uriTable.get(uri);
/*     */     }
/*     */ 
/*     */     Enumeration getDeclaredPrefixes()
/*     */     {
/* 758 */       if (this.declarations == null) {
/* 759 */         return NamespaceSupport.EMPTY_ENUMERATION;
/*     */       }
/* 761 */       return this.declarations.elements();
/*     */     }
/*     */ 
/*     */     Enumeration getPrefixes()
/*     */     {
/* 777 */       if (this.prefixTable == null) {
/* 778 */         return NamespaceSupport.EMPTY_ENUMERATION;
/*     */       }
/* 780 */       return this.prefixTable.keys();
/*     */     }
/*     */ 
/*     */     private void copyTables()
/*     */     {
/* 799 */       if (this.prefixTable != null)
/* 800 */         this.prefixTable = ((Hashtable)this.prefixTable.clone());
/*     */       else {
/* 802 */         this.prefixTable = new Hashtable();
/*     */       }
/* 804 */       if (this.uriTable != null)
/* 805 */         this.uriTable = ((Hashtable)this.uriTable.clone());
/*     */       else {
/* 807 */         this.uriTable = new Hashtable();
/*     */       }
/* 809 */       this.elementNameTable = new Hashtable();
/* 810 */       this.attributeNameTable = new Hashtable();
/* 811 */       this.declSeen = true;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.txw2.NamespaceSupport
 * JD-Core Version:    0.6.0
 */