/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import java.util.Map;
/*     */ 
/*     */ final class PrimitiveArrayListerFloat<BeanT> extends Lister<BeanT, float[], Float, FloatArrayPack>
/*     */ {
/*     */   static void register()
/*     */   {
/*  55 */     Lister.primitiveArrayListers.put(Float.TYPE, new PrimitiveArrayListerFloat());
/*     */   }
/*     */ 
/*     */   public ListIterator<Float> iterator(float[] objects, XMLSerializer context) {
/*  59 */     return new ListIterator(objects) {
/*  60 */       int idx = 0;
/*     */ 
/*  62 */       public boolean hasNext() { return this.idx < this.val$objects.length; }
/*     */ 
/*     */       public Float next()
/*     */       {
/*  66 */         return Float.valueOf(this.val$objects[(this.idx++)]);
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   public FloatArrayPack startPacking(BeanT current, Accessor<BeanT, float[]> acc) {
/*  72 */     return new FloatArrayPack();
/*     */   }
/*     */ 
/*     */   public void addToPack(FloatArrayPack objects, Float o) {
/*  76 */     objects.add(o);
/*     */   }
/*     */ 
/*     */   public void endPacking(FloatArrayPack pack, BeanT bean, Accessor<BeanT, float[]> acc) throws AccessorException {
/*  80 */     acc.set(bean, pack.build());
/*     */   }
/*     */ 
/*     */   public void reset(BeanT o, Accessor<BeanT, float[]> acc) throws AccessorException {
/*  84 */     acc.set(o, new float[0]);
/*     */   }
/*  88 */   static final class FloatArrayPack { float[] buf = new float[16];
/*     */     int size;
/*     */ 
/*     */     void add(Float b) {
/*  92 */       if (this.buf.length == this.size)
/*     */       {
/*  94 */         float[] nb = new float[this.buf.length * 2];
/*  95 */         System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
/*  96 */         this.buf = nb;
/*     */       }
/*  98 */       this.buf[(this.size++)] = b.floatValue();
/*     */     }
/*     */ 
/*     */     float[] build() {
/* 102 */       if (this.buf.length == this.size)
/*     */       {
/* 104 */         return this.buf;
/*     */       }
/* 106 */       float[] r = new float[this.size];
/* 107 */       System.arraycopy(this.buf, 0, r, 0, this.size);
/* 108 */       return r;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerFloat
 * JD-Core Version:    0.6.0
 */