/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.ClassFactory;
/*     */ import com.sun.xml.bind.v2.runtime.Coordinator;
/*     */ import javax.xml.bind.annotation.adapters.XmlAdapter;
/*     */ 
/*     */ final class AdaptedAccessor<BeanT, InMemValueT, OnWireValueT> extends Accessor<BeanT, OnWireValueT>
/*     */ {
/*     */   private final Accessor<BeanT, InMemValueT> core;
/*     */   private final Class<? extends XmlAdapter<OnWireValueT, InMemValueT>> adapter;
/*     */   private XmlAdapter<OnWireValueT, InMemValueT> staticAdapter;
/*     */ 
/*     */   AdaptedAccessor(Class<OnWireValueT> targetType, Accessor<BeanT, InMemValueT> extThis, Class<? extends XmlAdapter<OnWireValueT, InMemValueT>> adapter)
/*     */   {
/*  57 */     super(targetType);
/*  58 */     this.core = extThis;
/*  59 */     this.adapter = adapter;
/*     */   }
/*     */ 
/*     */   public boolean isAdapted()
/*     */   {
/*  64 */     return true;
/*     */   }
/*     */ 
/*     */   public OnWireValueT get(BeanT bean) throws AccessorException {
/*  68 */     Object v = this.core.get(bean);
/*     */ 
/*  70 */     XmlAdapter a = getAdapter();
/*     */     try {
/*  72 */       return a.marshal(v); } catch (Exception e) {
/*     */     }
/*  74 */     throw new AccessorException(e);
/*     */   }
/*     */ 
/*     */   public void set(BeanT bean, OnWireValueT o) throws AccessorException
/*     */   {
/*  79 */     XmlAdapter a = getAdapter();
/*     */     try {
/*  81 */       this.core.set(bean, a.unmarshal(o));
/*     */     } catch (Exception e) {
/*  83 */       throw new AccessorException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getUnadapted(BeanT bean) throws AccessorException {
/*  88 */     return this.core.getUnadapted(bean);
/*     */   }
/*     */ 
/*     */   public void setUnadapted(BeanT bean, Object value) throws AccessorException {
/*  92 */     this.core.setUnadapted(bean, value);
/*     */   }
/*     */ 
/*     */   private XmlAdapter<OnWireValueT, InMemValueT> getAdapter()
/*     */   {
/* 103 */     Coordinator coordinator = Coordinator._getInstance();
/* 104 */     if (coordinator != null) {
/* 105 */       return coordinator.getAdapter(this.adapter);
/*     */     }
/* 107 */     synchronized (this) {
/* 108 */       if (this.staticAdapter == null)
/* 109 */         this.staticAdapter = ((XmlAdapter)ClassFactory.create(this.adapter));
/*     */     }
/* 111 */     return this.staticAdapter;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.AdaptedAccessor
 * JD-Core Version:    0.6.0
 */