/*     */ package com.sun.xml.bind.v2.runtime.property;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.ClassFactory;
/*     */ import com.sun.xml.bind.v2.model.core.PropertyKind;
/*     */ import com.sun.xml.bind.v2.model.nav.ReflectionNavigator;
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimeMapPropertyInfo;
/*     */ import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
/*     */ import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
/*     */ import com.sun.xml.bind.v2.runtime.Name;
/*     */ import com.sun.xml.bind.v2.runtime.NameBuilder;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import com.sun.xml.bind.v2.runtime.reflect.Accessor;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.ChildLoader;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.Receiver;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.TagName;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext.State;
/*     */ import com.sun.xml.bind.v2.util.QNameMap;
/*     */ import java.io.IOException;
/*     */ import java.util.Arrays;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.TreeMap;
/*     */ import javax.xml.namespace.QName;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ final class SingleMapNodeProperty<BeanT, ValueT extends Map> extends PropertyImpl<BeanT>
/*     */ {
/*     */   private final Accessor<BeanT, ValueT> acc;
/*     */   private final Name tagName;
/*     */   private final Name entryTag;
/*     */   private final Name keyTag;
/*     */   private final Name valueTag;
/*     */   private final boolean nillable;
/*     */   private JaxBeanInfo keyBeanInfo;
/*     */   private JaxBeanInfo valueBeanInfo;
/*     */   private final Class<? extends ValueT> mapImplClass;
/* 117 */   private static final Class[] knownImplClasses = { HashMap.class, TreeMap.class, LinkedHashMap.class };
/*     */   private Loader keyLoader;
/*     */   private Loader valueLoader;
/* 151 */   private final Loader itemsLoader = new Loader(false)
/*     */   {
/*     */     public void startElement(UnmarshallingContext.State state, TagName ea) throws SAXException
/*     */     {
/*     */       try {
/* 156 */         Object target = state.prev.target;
/* 157 */         Map map = (Map)SingleMapNodeProperty.this.acc.get(target);
/* 158 */         if (map == null) {
/* 159 */           map = (Map)ClassFactory.create(SingleMapNodeProperty.this.mapImplClass);
/* 160 */           SingleMapNodeProperty.this.acc.set(target, map);
/*     */         }
/* 162 */         map.clear();
/* 163 */         state.target = map;
/*     */       }
/*     */       catch (AccessorException e) {
/* 166 */         handleGenericException(e, true);
/* 167 */         state.target = new HashMap();
/*     */       }
/*     */     }
/*     */ 
/*     */     public void childElement(UnmarshallingContext.State state, TagName ea) throws SAXException
/*     */     {
/* 173 */       if (ea.matches(SingleMapNodeProperty.this.entryTag))
/* 174 */         state.loader = SingleMapNodeProperty.this.entryLoader;
/*     */       else
/* 176 */         super.childElement(state, ea);
/*     */     }
/*     */ 
/*     */     public Collection<QName> getExpectedChildElements()
/*     */     {
/* 182 */       return Collections.singleton(SingleMapNodeProperty.this.entryTag.toQName());
/*     */     }
/* 151 */   };
/*     */ 
/* 191 */   private final Loader entryLoader = new Loader(false)
/*     */   {
/*     */     public void startElement(UnmarshallingContext.State state, TagName ea) {
/* 194 */       state.target = new Object[2];
/*     */     }
/*     */ 
/*     */     public void leaveElement(UnmarshallingContext.State state, TagName ea)
/*     */     {
/* 199 */       Object[] keyValue = (Object[])(Object[])state.target;
/* 200 */       Map map = (Map)state.prev.target;
/* 201 */       map.put(keyValue[0], keyValue[1]);
/*     */     }
/*     */ 
/*     */     public void childElement(UnmarshallingContext.State state, TagName ea) throws SAXException
/*     */     {
/* 206 */       if (ea.matches(SingleMapNodeProperty.this.keyTag)) {
/* 207 */         state.loader = SingleMapNodeProperty.this.keyLoader;
/* 208 */         state.receiver = SingleMapNodeProperty.keyReceiver;
/* 209 */         return;
/*     */       }
/* 211 */       if (ea.matches(SingleMapNodeProperty.this.valueTag)) {
/* 212 */         state.loader = SingleMapNodeProperty.this.valueLoader;
/* 213 */         state.receiver = SingleMapNodeProperty.valueReceiver;
/* 214 */         return;
/*     */       }
/* 216 */       super.childElement(state, ea);
/*     */     }
/*     */ 
/*     */     public Collection<QName> getExpectedChildElements()
/*     */     {
/* 221 */       return Arrays.asList(new QName[] { SingleMapNodeProperty.access$400(SingleMapNodeProperty.this).toQName(), SingleMapNodeProperty.access$700(SingleMapNodeProperty.this).toQName() });
/*     */     }
/* 191 */   };
/*     */ 
/* 235 */   private static final Receiver keyReceiver = new ReceiverImpl(0);
/* 236 */   private static final Receiver valueReceiver = new ReceiverImpl(1);
/*     */ 
/*     */   public SingleMapNodeProperty(JAXBContextImpl context, RuntimeMapPropertyInfo prop)
/*     */   {
/* 100 */     super(context, prop);
/* 101 */     this.acc = prop.getAccessor().optimize(context);
/* 102 */     this.tagName = context.nameBuilder.createElementName(prop.getXmlName());
/* 103 */     this.entryTag = context.nameBuilder.createElementName("", "entry");
/* 104 */     this.keyTag = context.nameBuilder.createElementName("", "key");
/* 105 */     this.valueTag = context.nameBuilder.createElementName("", "value");
/* 106 */     this.nillable = prop.isCollectionNillable();
/* 107 */     this.keyBeanInfo = context.getOrCreate(prop.getKeyType());
/* 108 */     this.valueBeanInfo = context.getOrCreate(prop.getValueType());
/*     */ 
/* 111 */     Class sig = ReflectionNavigator.REFLECTION.erasure(prop.getRawType());
/* 112 */     this.mapImplClass = ClassFactory.inferImplClass(sig, knownImplClasses);
/*     */   }
/*     */ 
/*     */   public void reset(BeanT bean)
/*     */     throws AccessorException
/*     */   {
/* 122 */     this.acc.set(bean, null);
/*     */   }
/*     */ 
/*     */   public String getIdValue(BeanT bean)
/*     */   {
/* 130 */     return null;
/*     */   }
/*     */ 
/*     */   public PropertyKind getKind() {
/* 134 */     return PropertyKind.MAP;
/*     */   }
/*     */ 
/*     */   public void buildChildElementUnmarshallers(UnmarshallerChain chain, QNameMap<ChildLoader> handlers) {
/* 138 */     this.keyLoader = this.keyBeanInfo.getLoader(chain.context, true);
/* 139 */     this.valueLoader = this.valueBeanInfo.getLoader(chain.context, true);
/* 140 */     handlers.put(this.tagName, new ChildLoader(this.itemsLoader, null));
/*     */   }
/*     */ 
/*     */   public void serializeBody(BeanT o, XMLSerializer w, Object outerPeer)
/*     */     throws SAXException, AccessorException, IOException, XMLStreamException
/*     */   {
/* 242 */     Map v = (Map)this.acc.get(o);
/* 243 */     if (v != null) {
/* 244 */       bareStartTag(w, this.tagName, v);
/* 245 */       for (Map.Entry e : v.entrySet()) {
/* 246 */         bareStartTag(w, this.entryTag, null);
/*     */ 
/* 248 */         Object key = e.getKey();
/* 249 */         if (key != null) {
/* 250 */           w.startElement(this.keyTag, key);
/* 251 */           w.childAsXsiType(key, this.fieldName, this.keyBeanInfo);
/* 252 */           w.endElement();
/*     */         }
/*     */ 
/* 255 */         Object value = e.getValue();
/* 256 */         if (value != null) {
/* 257 */           w.startElement(this.valueTag, value);
/* 258 */           w.childAsXsiType(value, this.fieldName, this.valueBeanInfo);
/* 259 */           w.endElement();
/*     */         }
/*     */ 
/* 262 */         w.endElement();
/*     */       }
/* 264 */       w.endElement();
/*     */     }
/* 266 */     else if (this.nillable) {
/* 267 */       w.startElement(this.tagName, null);
/* 268 */       w.writeXsiNilTrue();
/* 269 */       w.endElement();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void bareStartTag(XMLSerializer w, Name tagName, Object peer) throws IOException, XMLStreamException, SAXException {
/* 274 */     w.startElement(tagName, peer);
/* 275 */     w.endNamespaceDecls(peer);
/* 276 */     w.endAttributes();
/*     */   }
/*     */ 
/*     */   public Accessor getElementPropertyAccessor(String nsUri, String localName)
/*     */   {
/* 281 */     if (this.tagName.equals(nsUri, localName))
/* 282 */       return this.acc;
/* 283 */     return null;
/*     */   }
/*     */ 
/*     */   private static final class ReceiverImpl
/*     */     implements Receiver
/*     */   {
/*     */     private final int index;
/*     */ 
/*     */     public ReceiverImpl(int index)
/*     */     {
/* 228 */       this.index = index;
/*     */     }
/*     */     public void receive(UnmarshallingContext.State state, Object o) {
/* 231 */       ((Object[])(Object[])state.target)[this.index] = o;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.property.SingleMapNodeProperty
 * JD-Core Version:    0.6.0
 */