/*     */ package com.sun.xml.bind.v2.runtime.property;
/*     */ 
/*     */ import com.sun.xml.bind.v2.model.core.ID;
/*     */ import com.sun.xml.bind.v2.model.core.PropertyKind;
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimeAttributePropertyInfo;
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimeElementPropertyInfo;
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimeNonElement;
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimePropertyInfo;
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimeTypeInfo;
/*     */ import com.sun.xml.bind.v2.model.runtime.RuntimeValuePropertyInfo;
/*     */ import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ 
/*     */ public abstract class PropertyFactory
/*     */ {
/*     */   private static final Constructor<? extends Property>[] propImpls;
/*     */ 
/*     */   public static Property create(JAXBContextImpl grammar, RuntimePropertyInfo info)
/*     */   {
/* 100 */     PropertyKind kind = info.kind();
/*     */ 
/* 102 */     switch (1.$SwitchMap$com$sun$xml$bind$v2$model$core$PropertyKind[kind.ordinal()]) {
/*     */     case 1:
/* 104 */       return new AttributeProperty(grammar, (RuntimeAttributePropertyInfo)info);
/*     */     case 2:
/* 106 */       return new ValueProperty(grammar, (RuntimeValuePropertyInfo)info);
/*     */     case 3:
/* 108 */       if (!((RuntimeElementPropertyInfo)info).isValueList()) break;
/* 109 */       return new ListElementProperty(grammar, (RuntimeElementPropertyInfo)info);
/*     */     case 4:
/*     */     case 5:
/* 113 */       break;
/*     */     default:
/* 115 */       if ($assertionsDisabled) break; throw new AssertionError(); } 
/*     */ boolean isCollection = info.isCollection();
/* 120 */     boolean isLeaf = isLeaf(info);
/*     */ 
/* 122 */     Constructor c = propImpls[(6 + 0 + kind.propertyIndex)];
/*     */     Throwable t;
/*     */     try { return (Property)c.newInstance(new Object[] { grammar, info });
/*     */     } catch (InstantiationException e) {
/* 126 */       throw new InstantiationError(e.getMessage());
/*     */     } catch (IllegalAccessException e) {
/* 128 */       throw new IllegalAccessError(e.getMessage());
/*     */     } catch (InvocationTargetException e) {
/* 130 */       t = e.getCause();
/* 131 */       if ((t instanceof Error))
/* 132 */         throw ((Error)t);
/* 133 */       if ((t instanceof RuntimeException))
/* 134 */         throw ((RuntimeException)t);
/*     */     }
/* 136 */     throw new AssertionError(t);
/*     */   }
/*     */ 
/*     */   static boolean isLeaf(RuntimePropertyInfo info)
/*     */   {
/* 145 */     Collection types = info.ref();
/* 146 */     if (types.size() != 1) return false;
/*     */ 
/* 148 */     RuntimeTypeInfo rti = (RuntimeTypeInfo)types.iterator().next();
/* 149 */     if (!(rti instanceof RuntimeNonElement)) return false;
/*     */ 
/* 151 */     if (info.id() == ID.IDREF)
/*     */     {
/* 153 */       return true;
/*     */     }
/* 155 */     if (((RuntimeNonElement)rti).getTransducer() == null)
/*     */     {
/* 159 */       return false;
/*     */     }
/*     */ 
/* 162 */     return info.getIndividualType().equals(rti.getType());
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  68 */     Class[] implClasses = { SingleElementLeafProperty.class, null, null, ArrayElementLeafProperty.class, null, null, SingleElementNodeProperty.class, SingleReferenceNodeProperty.class, SingleMapNodeProperty.class, ArrayElementNodeProperty.class, ArrayReferenceNodeProperty.class, null };
/*     */ 
/*  86 */     propImpls = new Constructor[implClasses.length];
/*  87 */     for (int i = 0; i < propImpls.length; i++) {
/*  88 */       if (implClasses[i] == null)
/*     */         continue;
/*  90 */       propImpls[i] = implClasses[i].getConstructors()[0];
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.property.PropertyFactory
 * JD-Core Version:    0.6.0
 */