/*     */ package com.sun.xml.bind.v2.model.impl;
/*     */ 
/*     */ import com.sun.xml.bind.util.Which;
/*     */ import com.sun.xml.bind.v2.model.annotation.AnnotationReader;
/*     */ import com.sun.xml.bind.v2.model.annotation.ClassLocatable;
/*     */ import com.sun.xml.bind.v2.model.annotation.Locatable;
/*     */ import com.sun.xml.bind.v2.model.core.ErrorHandler;
/*     */ import com.sun.xml.bind.v2.model.core.NonElement;
/*     */ import com.sun.xml.bind.v2.model.core.PropertyInfo;
/*     */ import com.sun.xml.bind.v2.model.core.PropertyKind;
/*     */ import com.sun.xml.bind.v2.model.core.Ref;
/*     */ import com.sun.xml.bind.v2.model.core.RegistryInfo;
/*     */ import com.sun.xml.bind.v2.model.core.TypeInfo;
/*     */ import com.sun.xml.bind.v2.model.core.TypeInfoSet;
/*     */ import com.sun.xml.bind.v2.model.nav.Navigator;
/*     */ import com.sun.xml.bind.v2.runtime.IllegalAnnotationException;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import javax.xml.bind.annotation.XmlRegistry;
/*     */ import javax.xml.bind.annotation.XmlSchema;
/*     */ import javax.xml.bind.annotation.XmlSeeAlso;
/*     */ import javax.xml.bind.annotation.XmlTransient;
/*     */ import javax.xml.namespace.QName;
/*     */ 
/*     */ public class ModelBuilder<T, C, F, M>
/*     */ {
/*     */   final TypeInfoSetImpl<T, C, F, M> typeInfoSet;
/*     */   public final AnnotationReader<T, C, F, M> reader;
/*     */   public final Navigator<T, C, F, M> nav;
/*  93 */   private final Map<QName, TypeInfo> typeNames = new HashMap();
/*     */   public final String defaultNsUri;
/* 114 */   final Map<String, RegistryInfoImpl<T, C, F, M>> registries = new HashMap();
/*     */   private final Map<C, C> subclassReplacements;
/*     */   private ErrorHandler errorHandler;
/*     */   private boolean hadError;
/*     */   public boolean hasSwaRef;
/* 131 */   private final ErrorHandler proxyErrorHandler = new ErrorHandler() {
/*     */     public void error(IllegalAnnotationException e) {
/* 133 */       ModelBuilder.this.reportError(e);
/*     */     }
/* 131 */   };
/*     */   private boolean linked;
/*     */ 
/*     */   public ModelBuilder(AnnotationReader<T, C, F, M> reader, Navigator<T, C, F, M> navigator, Map<C, C> subclassReplacements, String defaultNamespaceRemap)
/*     */   {
/* 144 */     this.reader = reader;
/* 145 */     this.nav = navigator;
/* 146 */     this.subclassReplacements = subclassReplacements;
/* 147 */     if (defaultNamespaceRemap == null)
/* 148 */       defaultNamespaceRemap = "";
/* 149 */     this.defaultNsUri = defaultNamespaceRemap;
/* 150 */     reader.setErrorHandler(this.proxyErrorHandler);
/* 151 */     this.typeInfoSet = createTypeInfoSet();
/*     */   }
/*     */ 
/*     */   protected TypeInfoSetImpl<T, C, F, M> createTypeInfoSet()
/*     */   {
/* 180 */     return new TypeInfoSetImpl(this.nav, this.reader, BuiltinLeafInfoImpl.createLeaves(this.nav));
/*     */   }
/*     */ 
/*     */   public NonElement<T, C> getClassInfo(C clazz, Locatable upstream)
/*     */   {
/* 192 */     return getClassInfo(clazz, false, upstream);
/*     */   }
/*     */ 
/*     */   public NonElement<T, C> getClassInfo(C clazz, boolean searchForSuperClass, Locatable upstream)
/*     */   {
/* 201 */     assert (clazz != null);
/* 202 */     NonElement r = this.typeInfoSet.getClassInfo(clazz);
/* 203 */     if (r != null) {
/* 204 */       return r;
/*     */     }
/* 206 */     if (this.nav.isEnum(clazz)) {
/* 207 */       EnumLeafInfoImpl li = createEnumLeafInfo(clazz, upstream);
/* 208 */       this.typeInfoSet.add(li);
/* 209 */       r = li;
/* 210 */       addTypeName(r);
/*     */     } else {
/* 212 */       boolean isReplaced = this.subclassReplacements.containsKey(clazz);
/* 213 */       if ((isReplaced) && (!searchForSuperClass))
/*     */       {
/* 215 */         r = getClassInfo(this.subclassReplacements.get(clazz), upstream);
/*     */       }
/* 217 */       else if ((this.reader.hasClassAnnotation(clazz, XmlTransient.class)) || (isReplaced))
/*     */       {
/* 219 */         r = getClassInfo(this.nav.getSuperClass(clazz), searchForSuperClass, new ClassLocatable(upstream, clazz, this.nav));
/*     */       }
/*     */       else {
/* 222 */         ClassInfoImpl ci = createClassInfo(clazz, upstream);
/* 223 */         this.typeInfoSet.add(ci);
/*     */ 
/* 226 */         for (PropertyInfo p : ci.getProperties()) {
/* 227 */           if (p.kind() == PropertyKind.REFERENCE)
/*     */           {
/* 229 */             String pkg = this.nav.getPackageName(ci.getClazz());
/* 230 */             if (!this.registries.containsKey(pkg))
/*     */             {
/* 232 */               Object c = this.nav.findClass(pkg + ".ObjectFactory", ci.getClazz());
/* 233 */               if (c != null) {
/* 234 */                 addRegistry(c, (Locatable)p);
/*     */               }
/*     */             }
/*     */           }
/* 238 */           for (Iterator i$ = p.ref().iterator(); i$.hasNext(); t = (TypeInfo)i$.next());
/*     */         }
/*     */         TypeInfo t;
/* 241 */         ci.getBaseClass();
/*     */ 
/* 243 */         r = ci;
/* 244 */         addTypeName(r);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 250 */     XmlSeeAlso sa = (XmlSeeAlso)this.reader.getClassAnnotation(XmlSeeAlso.class, clazz, upstream);
/* 251 */     if (sa != null) {
/* 252 */       for (Object t : this.reader.getClassArrayValue(sa, "value")) {
/* 253 */         getTypeInfo(t, (Locatable)sa);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 258 */     return r;
/*     */   }
/*     */ 
/*     */   private void addTypeName(NonElement<T, C> r)
/*     */   {
/* 265 */     QName t = r.getTypeName();
/* 266 */     if (t == null) return;
/*     */ 
/* 268 */     TypeInfo old = (TypeInfo)this.typeNames.put(t, r);
/* 269 */     if (old != null)
/*     */     {
/* 271 */       reportError(new IllegalAnnotationException(Messages.CONFLICTING_XML_TYPE_MAPPING.format(new Object[] { r.getTypeName() }), old, r));
/*     */     }
/*     */   }
/*     */ 
/*     */   public NonElement<T, C> getTypeInfo(T t, Locatable upstream)
/*     */   {
/* 285 */     NonElement r = this.typeInfoSet.getTypeInfo(t);
/* 286 */     if (r != null) return r;
/*     */ 
/* 288 */     if (this.nav.isArray(t)) {
/* 289 */       ArrayInfoImpl ai = createArrayInfo(upstream, t);
/*     */ 
/* 291 */       addTypeName(ai);
/* 292 */       this.typeInfoSet.add(ai);
/* 293 */       return ai;
/*     */     }
/*     */ 
/* 296 */     Object c = this.nav.asDecl(t);
/* 297 */     assert (c != null) : (t.toString() + " must be a leaf, but we failed to recognize it.");
/* 298 */     return getClassInfo(c, upstream);
/*     */   }
/*     */ 
/*     */   public NonElement<T, C> getTypeInfo(Ref<T, C> ref)
/*     */   {
/* 306 */     assert (!ref.valueList);
/* 307 */     Object c = this.nav.asDecl(ref.type);
/* 308 */     if ((c != null) && (this.reader.getClassAnnotation(XmlRegistry.class, c, null) != null)) {
/* 309 */       if (!this.registries.containsKey(this.nav.getPackageName(c)))
/* 310 */         addRegistry(c, null);
/* 311 */       return null;
/*     */     }
/* 313 */     return getTypeInfo(ref.type, null);
/*     */   }
/*     */ 
/*     */   protected EnumLeafInfoImpl<T, C, F, M> createEnumLeafInfo(C clazz, Locatable upstream)
/*     */   {
/* 318 */     return new EnumLeafInfoImpl(this, upstream, clazz, this.nav.use(clazz));
/*     */   }
/*     */ 
/*     */   protected ClassInfoImpl<T, C, F, M> createClassInfo(C clazz, Locatable upstream) {
/* 322 */     return new ClassInfoImpl(this, upstream, clazz);
/*     */   }
/*     */ 
/*     */   protected ElementInfoImpl<T, C, F, M> createElementInfo(RegistryInfoImpl<T, C, F, M> registryInfo, M m) throws IllegalAnnotationException
/*     */   {
/* 327 */     return new ElementInfoImpl(this, registryInfo, m);
/*     */   }
/*     */ 
/*     */   protected ArrayInfoImpl<T, C, F, M> createArrayInfo(Locatable upstream, T arrayType) {
/* 331 */     return new ArrayInfoImpl(this, upstream, arrayType);
/*     */   }
/*     */ 
/*     */   public RegistryInfo<T, C> addRegistry(C registryClass, Locatable upstream)
/*     */   {
/* 340 */     return new RegistryInfoImpl(this, upstream, registryClass);
/*     */   }
/*     */ 
/*     */   public RegistryInfo<T, C> getRegistry(String packageName)
/*     */   {
/* 352 */     return (RegistryInfo)this.registries.get(packageName);
/*     */   }
/*     */ 
/*     */   public TypeInfoSet<T, C, F, M> link()
/*     */   {
/* 370 */     assert (!this.linked);
/* 371 */     this.linked = true;
/*     */ 
/* 373 */     for (ElementInfoImpl ei : this.typeInfoSet.getAllElements()) {
/* 374 */       ei.link();
/*     */     }
/* 376 */     for (ClassInfoImpl ci : this.typeInfoSet.beans().values()) {
/* 377 */       ci.link();
/*     */     }
/* 379 */     for (EnumLeafInfoImpl li : this.typeInfoSet.enums().values()) {
/* 380 */       li.link();
/*     */     }
/* 382 */     if (this.hadError) {
/* 383 */       return null;
/*     */     }
/* 385 */     return this.typeInfoSet;
/*     */   }
/*     */ 
/*     */   public void setErrorHandler(ErrorHandler errorHandler)
/*     */   {
/* 401 */     this.errorHandler = errorHandler;
/*     */   }
/*     */ 
/*     */   public final void reportError(IllegalAnnotationException e) {
/* 405 */     this.hadError = true;
/* 406 */     if (this.errorHandler != null)
/* 407 */       this.errorHandler.error(e);
/*     */   }
/*     */ 
/*     */   public boolean isReplaced(C sc) {
/* 411 */     return this.subclassReplacements.containsKey(sc);
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/* 160 */       XmlSchema s = null;
/* 161 */       s.location();
/*     */     }
/*     */     catch (NullPointerException e)
/*     */     {
/*     */     }
/*     */     catch (NoSuchMethodError e)
/*     */     {
/*     */       Messages res;
/*     */       Messages res;
/* 167 */       if (XmlSchema.class.getClassLoader() == null)
/* 168 */         res = Messages.INCOMPATIBLE_API_VERSION_MUSTANG;
/*     */       else {
/* 170 */         res = Messages.INCOMPATIBLE_API_VERSION;
/*     */       }
/* 172 */       throw new LinkageError(res.format(new Object[] { Which.which(XmlSchema.class), Which.which(ModelBuilder.class) }));
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.model.impl.ModelBuilder
 * JD-Core Version:    0.6.0
 */