/*    */ package com.sun.istack;
/*    */ 
/*    */ import java.util.concurrent.ConcurrentLinkedQueue;
/*    */ 
/*    */ public abstract interface Pool<T>
/*    */ {
/*    */   @NotNull
/*    */   public abstract T take();
/*    */ 
/*    */   public abstract void recycle(@NotNull T paramT);
/*    */ 
/*    */   public static abstract class Impl<T> extends ConcurrentLinkedQueue<T>
/*    */     implements Pool<T>
/*    */   {
/*    */     @NotNull
/*    */     public final T take()
/*    */     {
/* 45 */       Object t = super.poll();
/* 46 */       if (t == null)
/* 47 */         return create();
/* 48 */       return t;
/*    */     }
/*    */ 
/*    */     public final void recycle(T t)
/*    */     {
/* 55 */       super.offer(t);
/*    */     }
/*    */ 
/*    */     @NotNull
/*    */     protected abstract T create();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.istack.Pool
 * JD-Core Version:    0.6.0
 */