/*     */ package com.sun.activation.registries;
/*     */ 
/*     */ public class MailcapTokenizer
/*     */ {
/*     */   public static final int UNKNOWN_TOKEN = 0;
/*     */   public static final int START_TOKEN = 1;
/*     */   public static final int STRING_TOKEN = 2;
/*     */   public static final int EOI_TOKEN = 5;
/*     */   public static final int SLASH_TOKEN = 47;
/*     */   public static final int SEMICOLON_TOKEN = 59;
/*     */   public static final int EQUALS_TOKEN = 61;
/*     */   private String data;
/*     */   private int dataIndex;
/*     */   private int dataLength;
/*     */   private int currentToken;
/*     */   private String currentTokenValue;
/*     */   private boolean isAutoquoting;
/*     */   private char autoquoteChar;
/*     */ 
/*     */   public MailcapTokenizer(String inputString)
/*     */   {
/*  50 */     this.data = inputString;
/*  51 */     this.dataIndex = 0;
/*  52 */     this.dataLength = inputString.length();
/*     */ 
/*  54 */     this.currentToken = 1;
/*  55 */     this.currentTokenValue = "";
/*     */ 
/*  57 */     this.isAutoquoting = false;
/*  58 */     this.autoquoteChar = ';';
/*     */   }
/*     */ 
/*     */   public void setIsAutoquoting(boolean value)
/*     */   {
/*  72 */     this.isAutoquoting = value;
/*     */   }
/*     */ 
/*     */   public void setAutoquoteChar(char value)
/*     */   {
/*  79 */     this.autoquoteChar = value;
/*     */   }
/*     */ 
/*     */   public int getCurrentToken()
/*     */   {
/*  88 */     return this.currentToken;
/*     */   }
/*     */ 
/*     */   public static String nameForToken(int token)
/*     */   {
/*  95 */     String name = "really unknown";
/*     */ 
/*  97 */     switch (token) {
/*     */     case 0:
/*  99 */       name = "unknown";
/* 100 */       break;
/*     */     case 1:
/* 102 */       name = "start";
/* 103 */       break;
/*     */     case 2:
/* 105 */       name = "string";
/* 106 */       break;
/*     */     case 5:
/* 108 */       name = "EOI";
/* 109 */       break;
/*     */     case 47:
/* 111 */       name = "'/'";
/* 112 */       break;
/*     */     case 59:
/* 114 */       name = "';'";
/* 115 */       break;
/*     */     case 61:
/* 117 */       name = "'='";
/*     */     }
/*     */ 
/* 121 */     return name;
/*     */   }
/*     */ 
/*     */   public String getCurrentTokenValue()
/*     */   {
/* 130 */     return this.currentTokenValue;
/*     */   }
/*     */ 
/*     */   public int nextToken()
/*     */   {
/* 139 */     if (this.dataIndex < this.dataLength)
/*     */     {
/* 141 */       while ((this.dataIndex < this.dataLength) && (isWhiteSpaceChar(this.data.charAt(this.dataIndex))))
/*     */       {
/* 143 */         this.dataIndex += 1;
/*     */       }
/*     */ 
/* 146 */       if (this.dataIndex < this.dataLength)
/*     */       {
/* 148 */         char c = this.data.charAt(this.dataIndex);
/* 149 */         if (this.isAutoquoting) {
/* 150 */           if (!isAutoquoteSpecialChar(c)) {
/* 151 */             processAutoquoteToken();
/* 152 */           } else if ((c == ';') || (c == '=')) {
/* 153 */             this.currentToken = c;
/* 154 */             this.currentTokenValue = new Character(c).toString();
/* 155 */             this.dataIndex += 1;
/*     */           } else {
/* 157 */             this.currentToken = 0;
/* 158 */             this.currentTokenValue = new Character(c).toString();
/* 159 */             this.dataIndex += 1;
/*     */           }
/*     */         }
/* 162 */         else if (isStringTokenChar(c)) {
/* 163 */           processStringToken();
/* 164 */         } else if ((c == '/') || (c == ';') || (c == '=')) {
/* 165 */           this.currentToken = c;
/* 166 */           this.currentTokenValue = new Character(c).toString();
/* 167 */           this.dataIndex += 1;
/*     */         } else {
/* 169 */           this.currentToken = 0;
/* 170 */           this.currentTokenValue = new Character(c).toString();
/* 171 */           this.dataIndex += 1;
/*     */         }
/*     */       }
/*     */       else {
/* 175 */         this.currentToken = 5;
/* 176 */         this.currentTokenValue = null;
/*     */       }
/*     */     } else {
/* 179 */       this.currentToken = 5;
/* 180 */       this.currentTokenValue = null;
/*     */     }
/*     */ 
/* 183 */     return this.currentToken;
/*     */   }
/*     */ 
/*     */   private void processStringToken()
/*     */   {
/* 188 */     int initialIndex = this.dataIndex;
/*     */ 
/* 191 */     while ((this.dataIndex < this.dataLength) && (isStringTokenChar(this.data.charAt(this.dataIndex))))
/*     */     {
/* 193 */       this.dataIndex += 1;
/*     */     }
/*     */ 
/* 196 */     this.currentToken = 2;
/* 197 */     this.currentTokenValue = this.data.substring(initialIndex, this.dataIndex);
/*     */   }
/*     */ 
/*     */   private void processAutoquoteToken()
/*     */   {
/* 202 */     int initialIndex = this.dataIndex;
/*     */ 
/* 205 */     boolean foundTerminator = false;
/* 206 */     while ((this.dataIndex < this.dataLength) && (!foundTerminator)) {
/* 207 */       char c = this.data.charAt(this.dataIndex);
/* 208 */       if (c != this.autoquoteChar)
/* 209 */         this.dataIndex += 1;
/*     */       else {
/* 211 */         foundTerminator = true;
/*     */       }
/*     */     }
/*     */ 
/* 215 */     this.currentToken = 2;
/* 216 */     this.currentTokenValue = fixEscapeSequences(this.data.substring(initialIndex, this.dataIndex));
/*     */   }
/*     */ 
/*     */   public static boolean isSpecialChar(char c)
/*     */   {
/* 221 */     boolean lAnswer = false;
/*     */ 
/* 223 */     switch (c) {
/*     */     case '"':
/*     */     case '(':
/*     */     case ')':
/*     */     case ',':
/*     */     case '/':
/*     */     case ':':
/*     */     case ';':
/*     */     case '<':
/*     */     case '=':
/*     */     case '>':
/*     */     case '?':
/*     */     case '@':
/*     */     case '[':
/*     */     case '\\':
/*     */     case ']':
/* 239 */       lAnswer = true;
/*     */     case '#':
/*     */     case '$':
/*     */     case '%':
/*     */     case '&':
/*     */     case '\'':
/*     */     case '*':
/*     */     case '+':
/*     */     case '-':
/*     */     case '.':
/*     */     case '0':
/*     */     case '1':
/*     */     case '2':
/*     */     case '3':
/*     */     case '4':
/*     */     case '5':
/*     */     case '6':
/*     */     case '7':
/*     */     case '8':
/*     */     case '9':
/*     */     case 'A':
/*     */     case 'B':
/*     */     case 'C':
/*     */     case 'D':
/*     */     case 'E':
/*     */     case 'F':
/*     */     case 'G':
/*     */     case 'H':
/*     */     case 'I':
/*     */     case 'J':
/*     */     case 'K':
/*     */     case 'L':
/*     */     case 'M':
/*     */     case 'N':
/*     */     case 'O':
/*     */     case 'P':
/*     */     case 'Q':
/*     */     case 'R':
/*     */     case 'S':
/*     */     case 'T':
/*     */     case 'U':
/*     */     case 'V':
/*     */     case 'W':
/*     */     case 'X':
/*     */     case 'Y':
/* 243 */     case 'Z': } return lAnswer;
/*     */   }
/*     */ 
/*     */   public static boolean isAutoquoteSpecialChar(char c) {
/* 247 */     boolean lAnswer = false;
/*     */ 
/* 249 */     switch (c) {
/*     */     case ';':
/*     */     case '=':
/* 252 */       lAnswer = true;
/*     */     }
/*     */ 
/* 256 */     return lAnswer;
/*     */   }
/*     */ 
/*     */   public static boolean isControlChar(char c) {
/* 260 */     return Character.isISOControl(c);
/*     */   }
/*     */ 
/*     */   public static boolean isWhiteSpaceChar(char c) {
/* 264 */     return Character.isWhitespace(c);
/*     */   }
/*     */ 
/*     */   public static boolean isStringTokenChar(char c) {
/* 268 */     return (!isSpecialChar(c)) && (!isControlChar(c)) && (!isWhiteSpaceChar(c));
/*     */   }
/*     */ 
/*     */   private static String fixEscapeSequences(String inputString) {
/* 272 */     int inputLength = inputString.length();
/* 273 */     StringBuffer buffer = new StringBuffer();
/* 274 */     buffer.ensureCapacity(inputLength);
/*     */ 
/* 276 */     for (int i = 0; i < inputLength; i++) {
/* 277 */       char currentChar = inputString.charAt(i);
/* 278 */       if (currentChar != '\\') {
/* 279 */         buffer.append(currentChar);
/*     */       }
/* 281 */       else if (i < inputLength - 1) {
/* 282 */         char nextChar = inputString.charAt(i + 1);
/* 283 */         buffer.append(nextChar);
/*     */ 
/* 286 */         i++;
/*     */       } else {
/* 288 */         buffer.append(currentChar);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 293 */     return buffer.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.activation.registries.MailcapTokenizer
 * JD-Core Version:    0.6.0
 */