package antlr.preprocessor;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.Tool;
import antlr.collections.impl.BitSet;
import antlr.collections.impl.IndexedVector;

public class Preprocessor extends LLkParser
  implements PreprocessorTokenTypes
{
  private Tool antlrTool;
  public static final String[] _tokenNames = { "<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "\"tokens\"", "HEADER_ACTION", "SUBRULE_BLOCK", "ACTION", "\"class\"", "ID", "\"extends\"", "SEMI", "TOKENS_SPEC", "OPTIONS_START", "ASSIGN_RHS", "RCURLY", "\"protected\"", "\"private\"", "\"public\"", "BANG", "ARG_ACTION", "\"returns\"", "RULE_BLOCK", "\"throws\"", "COMMA", "\"exception\"", "\"catch\"", "ALT", "ELEMENT", "LPAREN", "RPAREN", "ID_OR_KEYWORD", "CURLY_BLOCK_SCARF", "WS", "NEWLINE", "COMMENT", "SL_COMMENT", "ML_COMMENT", "CHAR_LITERAL", "STRING_LITERAL", "ESC", "DIGIT", "XDIGIT" };
  public static final BitSet _tokenSet_0 = new BitSet(mk_tokenSet_0());
  public static final BitSet _tokenSet_1 = new BitSet(mk_tokenSet_1());
  public static final BitSet _tokenSet_2 = new BitSet(mk_tokenSet_2());
  public static final BitSet _tokenSet_3 = new BitSet(mk_tokenSet_3());
  public static final BitSet _tokenSet_4 = new BitSet(mk_tokenSet_4());
  public static final BitSet _tokenSet_5 = new BitSet(mk_tokenSet_5());
  public static final BitSet _tokenSet_6 = new BitSet(mk_tokenSet_6());
  public static final BitSet _tokenSet_7 = new BitSet(mk_tokenSet_7());
  public static final BitSet _tokenSet_8 = new BitSet(mk_tokenSet_8());

  public void setTool(Tool paramTool)
  {
    if (this.antlrTool == null)
      this.antlrTool = paramTool;
    else
      throw new IllegalStateException("antlr.Tool already registered");
  }

  protected Tool getTool()
  {
    return this.antlrTool;
  }

  public void reportError(String paramString)
  {
    if (getTool() != null)
      getTool().error(paramString, getFilename(), -1, -1);
    else
      super.reportError(paramString);
  }

  public void reportError(RecognitionException paramRecognitionException)
  {
    if (getTool() != null)
      getTool().error(paramRecognitionException.getErrorMessage(), paramRecognitionException.getFilename(), paramRecognitionException.getLine(), paramRecognitionException.getColumn());
    else
      super.reportError(paramRecognitionException);
  }

  public void reportWarning(String paramString)
  {
    if (getTool() != null)
      getTool().warning(paramString, getFilename(), -1, -1);
    else
      super.reportWarning(paramString);
  }

  protected Preprocessor(TokenBuffer paramTokenBuffer, int paramInt)
  {
    super(paramTokenBuffer, paramInt);
    this.tokenNames = _tokenNames;
  }

  public Preprocessor(TokenBuffer paramTokenBuffer)
  {
    this(paramTokenBuffer, 1);
  }

  protected Preprocessor(TokenStream paramTokenStream, int paramInt)
  {
    super(paramTokenStream, paramInt);
    this.tokenNames = _tokenNames;
  }

  public Preprocessor(TokenStream paramTokenStream)
  {
    this(paramTokenStream, 1);
  }

  public Preprocessor(ParserSharedInputState paramParserSharedInputState)
  {
    super(paramParserSharedInputState, 1);
    this.tokenNames = _tokenNames;
  }

  public final void grammarFile(Hierarchy paramHierarchy, String paramString)
    throws RecognitionException, TokenStreamException
  {
    Token localToken = null;
    IndexedVector localIndexedVector = null;
    try
    {
      while (LA(1) == 5)
      {
        localToken = LT(1);
        match(5);
        paramHierarchy.getFile(paramString).addHeaderAction(localToken.getText());
      }
      switch (LA(1))
      {
      case 13:
        localIndexedVector = optionSpec(null);
        break;
      case 1:
      case 7:
      case 8:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      while ((LA(1) == 7) || (LA(1) == 8))
      {
        Grammar localGrammar = class_def(paramString, paramHierarchy);
        if ((localGrammar != null) && (localIndexedVector != null))
          paramHierarchy.getFile(paramString).setOptions(localIndexedVector);
        if (localGrammar == null)
          continue;
        localGrammar.setFileName(paramString);
        paramHierarchy.addGrammar(localGrammar);
      }
      match(1);
    }
    catch (RecognitionException localRecognitionException)
    {
      reportError(localRecognitionException);
      consume();
      consumeUntil(_tokenSet_0);
    }
  }

  public final IndexedVector optionSpec(Grammar paramGrammar)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    IndexedVector localIndexedVector = new IndexedVector();
    try
    {
      match(13);
      while (LA(1) == 9)
      {
        localToken1 = LT(1);
        match(9);
        localToken2 = LT(1);
        match(14);
        Option localOption = new Option(localToken1.getText(), localToken2.getText(), paramGrammar);
        localIndexedVector.appendElement(localOption.getName(), localOption);
        if ((paramGrammar != null) && (localToken1.getText().equals("importVocab")))
        {
          paramGrammar.specifiedVocabulary = true;
          paramGrammar.importVocab = localToken2.getText();
          continue;
        }
        if ((paramGrammar == null) || (!localToken1.getText().equals("exportVocab")))
          continue;
        paramGrammar.exportVocab = localToken2.getText().substring(0, localToken2.getText().length() - 1);
        paramGrammar.exportVocab = paramGrammar.exportVocab.trim();
      }
      match(15);
    }
    catch (RecognitionException localRecognitionException)
    {
      reportError(localRecognitionException);
      consume();
      consumeUntil(_tokenSet_1);
    }
    return localIndexedVector;
  }

  public final Grammar class_def(String paramString, Hierarchy paramHierarchy)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    Token localToken5 = null;
    Grammar localGrammar = null;
    IndexedVector localIndexedVector1 = new IndexedVector(100);
    IndexedVector localIndexedVector2 = null;
    String str = null;
    try
    {
      switch (LA(1))
      {
      case 7:
        localToken1 = LT(1);
        match(7);
        break;
      case 8:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      match(8);
      localToken2 = LT(1);
      match(9);
      match(10);
      localToken3 = LT(1);
      match(9);
      switch (LA(1))
      {
      case 6:
        str = superClass();
        break;
      case 11:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      match(11);
      localGrammar = paramHierarchy.getGrammar(localToken2.getText());
      if (localGrammar != null)
      {
        localGrammar = null;
        throw new SemanticException("redefinition of grammar " + localToken2.getText(), paramString, localToken2.getLine(), localToken2.getColumn());
      }
      localGrammar = new Grammar(paramHierarchy.getTool(), localToken2.getText(), localToken3.getText(), localIndexedVector1);
      localGrammar.superClass = str;
      if (localToken1 != null)
        localGrammar.setPreambleAction(localToken1.getText());
      switch (LA(1))
      {
      case 13:
        localIndexedVector2 = optionSpec(localGrammar);
        break;
      case 7:
      case 9:
      case 12:
      case 16:
      case 17:
      case 18:
        break;
      case 8:
      case 10:
      case 11:
      case 14:
      case 15:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      if (localGrammar != null)
        localGrammar.setOptions(localIndexedVector2);
      switch (LA(1))
      {
      case 12:
        localToken4 = LT(1);
        match(12);
        localGrammar.setTokenSection(localToken4.getText());
        break;
      case 7:
      case 9:
      case 16:
      case 17:
      case 18:
        break;
      case 8:
      case 10:
      case 11:
      case 13:
      case 14:
      case 15:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      switch (LA(1))
      {
      case 7:
        localToken5 = LT(1);
        match(7);
        localGrammar.setMemberAction(localToken5.getText());
        break;
      case 9:
      case 16:
      case 17:
      case 18:
        break;
      case 8:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      for (int i = 0; ; i++)
        if (_tokenSet_2.member(LA(1)))
        {
          rule(localGrammar);
        }
        else
        {
          if (i >= 1)
            break;
          throw new NoViableAltException(LT(1), getFilename());
        }
    }
    catch (RecognitionException localRecognitionException)
    {
      reportError(localRecognitionException);
      consume();
      consumeUntil(_tokenSet_3);
    }
    return localGrammar;
  }

  public final String superClass()
    throws RecognitionException, TokenStreamException
  {
    String str = LT(1).getText();
    try
    {
      match(6);
    }
    catch (RecognitionException localRecognitionException)
    {
      reportError(localRecognitionException);
      consume();
      consumeUntil(_tokenSet_4);
    }
    return str;
  }

  public final void rule(Grammar paramGrammar)
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    Token localToken3 = null;
    Token localToken4 = null;
    Token localToken5 = null;
    IndexedVector localIndexedVector = null;
    String str1 = null;
    int i = 0;
    String str2 = null;
    String str3 = "";
    try
    {
      switch (LA(1))
      {
      case 16:
        match(16);
        str1 = "protected";
        break;
      case 17:
        match(17);
        str1 = "private";
        break;
      case 18:
        match(18);
        str1 = "public";
        break;
      case 9:
        break;
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      localToken1 = LT(1);
      match(9);
      switch (LA(1))
      {
      case 19:
        match(19);
        i = 1;
        break;
      case 7:
      case 13:
      case 20:
      case 21:
      case 22:
      case 23:
        break;
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      switch (LA(1))
      {
      case 20:
        localToken2 = LT(1);
        match(20);
        break;
      case 7:
      case 13:
      case 21:
      case 22:
      case 23:
        break;
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      switch (LA(1))
      {
      case 21:
        match(21);
        localToken3 = LT(1);
        match(20);
        break;
      case 7:
      case 13:
      case 22:
      case 23:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      switch (LA(1))
      {
      case 23:
        str3 = throwsSpec();
        break;
      case 7:
      case 13:
      case 22:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      switch (LA(1))
      {
      case 13:
        localIndexedVector = optionSpec(null);
        break;
      case 7:
      case 22:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      switch (LA(1))
      {
      case 7:
        localToken4 = LT(1);
        match(7);
        break;
      case 22:
        break;
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      localToken5 = LT(1);
      match(22);
      str2 = exceptionGroup();
      String str4 = localToken5.getText() + str2;
      Rule localRule = new Rule(localToken1.getText(), str4, localIndexedVector, paramGrammar);
      localRule.setThrowsSpec(str3);
      if (localToken2 != null)
        localRule.setArgs(localToken2.getText());
      if (localToken3 != null)
        localRule.setReturnValue(localToken3.getText());
      if (localToken4 != null)
        localRule.setInitAction(localToken4.getText());
      if (i != 0)
        localRule.setBang();
      localRule.setVisibility(str1);
      if (paramGrammar != null)
        paramGrammar.addRule(localRule);
    }
    catch (RecognitionException localRecognitionException)
    {
      reportError(localRecognitionException);
      consume();
      consumeUntil(_tokenSet_5);
    }
  }

  public final String throwsSpec()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    String str = "throws ";
    try
    {
      match(23);
      localToken1 = LT(1);
      match(9);
      for (str = str + localToken1.getText(); LA(1) == 24; str = str + "," + localToken2.getText())
      {
        match(24);
        localToken2 = LT(1);
        match(9);
      }
    }
    catch (RecognitionException localRecognitionException)
    {
      reportError(localRecognitionException);
      consume();
      consumeUntil(_tokenSet_6);
    }
    return str;
  }

  public final String exceptionGroup()
    throws RecognitionException, TokenStreamException
  {
    String str2 = null;
    String str1 = "";
    try
    {
      while (LA(1) == 25)
      {
        str2 = exceptionSpec();
        str1 = str1 + str2;
      }
    }
    catch (RecognitionException localRecognitionException)
    {
      reportError(localRecognitionException);
      consume();
      consumeUntil(_tokenSet_5);
    }
    return str1;
  }

  public final String exceptionSpec()
    throws RecognitionException, TokenStreamException
  {
    Token localToken = null;
    String str2 = null;
    String str1 = System.getProperty("line.separator") + "exception ";
    try
    {
      match(25);
      switch (LA(1))
      {
      case 20:
        localToken = LT(1);
        match(20);
        str1 = str1 + localToken.getText();
        break;
      case 1:
      case 7:
      case 8:
      case 9:
      case 16:
      case 17:
      case 18:
      case 25:
      case 26:
        break;
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 19:
      case 21:
      case 22:
      case 23:
      case 24:
      default:
        throw new NoViableAltException(LT(1), getFilename());
      }
      while (LA(1) == 26)
      {
        str2 = exceptionHandler();
        str1 = str1 + str2;
      }
    }
    catch (RecognitionException localRecognitionException)
    {
      reportError(localRecognitionException);
      consume();
      consumeUntil(_tokenSet_7);
    }
    return str1;
  }

  public final String exceptionHandler()
    throws RecognitionException, TokenStreamException
  {
    Token localToken1 = null;
    Token localToken2 = null;
    String str = null;
    try
    {
      match(26);
      localToken1 = LT(1);
      match(20);
      localToken2 = LT(1);
      match(7);
      str = System.getProperty("line.separator") + "catch " + localToken1.getText() + " " + localToken2.getText();
    }
    catch (RecognitionException localRecognitionException)
    {
      reportError(localRecognitionException);
      consume();
      consumeUntil(_tokenSet_8);
    }
    return str;
  }

  private static final long[] mk_tokenSet_0()
  {
    long[] arrayOfLong = { 2L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_1()
  {
    long[] arrayOfLong = { 4658050L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_2()
  {
    long[] arrayOfLong = { 459264L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_3()
  {
    long[] arrayOfLong = { 386L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_4()
  {
    long[] arrayOfLong = { 2048L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_5()
  {
    long[] arrayOfLong = { 459650L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_6()
  {
    long[] arrayOfLong = { 4202624L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_7()
  {
    long[] arrayOfLong = { 34014082L, 0L };
    return arrayOfLong;
  }

  private static final long[] mk_tokenSet_8()
  {
    long[] arrayOfLong = { 101122946L, 0L };
    return arrayOfLong;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.preprocessor.Preprocessor
 * JD-Core Version:    0.6.0
 */