package antlr.preprocessor;

import antlr.Tool;
import antlr.collections.impl.IndexedVector;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class GrammarFile
{
  protected String fileName;
  protected String headerAction = "";
  protected IndexedVector options;
  protected IndexedVector grammars;
  protected boolean expanded = false;
  protected Tool tool;

  public GrammarFile(Tool paramTool, String paramString)
  {
    this.fileName = paramString;
    this.grammars = new IndexedVector();
    this.tool = paramTool;
  }

  public void addGrammar(Grammar paramGrammar)
  {
    this.grammars.appendElement(paramGrammar.getName(), paramGrammar);
  }

  public void generateExpandedFile()
    throws IOException
  {
    if (!this.expanded)
      return;
    String str = nameForExpandedGrammarFile(getName());
    PrintWriter localPrintWriter = this.tool.openOutputFile(str);
    localPrintWriter.println(toString());
    localPrintWriter.close();
  }

  public IndexedVector getGrammars()
  {
    return this.grammars;
  }

  public String getName()
  {
    return this.fileName;
  }

  public String nameForExpandedGrammarFile(String paramString)
  {
    if (this.expanded)
      return "expanded" + this.tool.fileMinusPath(paramString);
    return paramString;
  }

  public void setExpanded(boolean paramBoolean)
  {
    this.expanded = paramBoolean;
  }

  public void addHeaderAction(String paramString)
  {
    this.headerAction = (this.headerAction + paramString + System.getProperty("line.separator"));
  }

  public void setOptions(IndexedVector paramIndexedVector)
  {
    this.options = paramIndexedVector;
  }

  public String toString()
  {
    String str1 = this.headerAction == null ? "" : this.headerAction;
    String str2 = this.options == null ? "" : Hierarchy.optionsToString(this.options);
    StringBuffer localStringBuffer = new StringBuffer(10000);
    localStringBuffer.append(str1);
    localStringBuffer.append(str2);
    Enumeration localEnumeration = this.grammars.elements();
    while (localEnumeration.hasMoreElements())
    {
      Grammar localGrammar = (Grammar)localEnumeration.nextElement();
      localStringBuffer.append(localGrammar.toString());
    }
    return localStringBuffer.toString();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.preprocessor.GrammarFile
 * JD-Core Version:    0.6.0
 */