package antlr.debug;

import antlr.collections.impl.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ParserEventSupport
{
  private Object source;
  private Hashtable doneListeners;
  private Vector matchListeners;
  private Vector messageListeners;
  private Vector tokenListeners;
  private Vector traceListeners;
  private Vector semPredListeners;
  private Vector synPredListeners;
  private Vector newLineListeners;
  private ParserMatchEvent matchEvent;
  private MessageEvent messageEvent;
  private ParserTokenEvent tokenEvent;
  private SemanticPredicateEvent semPredEvent;
  private SyntacticPredicateEvent synPredEvent;
  private TraceEvent traceEvent;
  private NewLineEvent newLineEvent;
  private ParserController controller;
  protected static final int CONSUME = 0;
  protected static final int ENTER_RULE = 1;
  protected static final int EXIT_RULE = 2;
  protected static final int LA = 3;
  protected static final int MATCH = 4;
  protected static final int MATCH_NOT = 5;
  protected static final int MISMATCH = 6;
  protected static final int MISMATCH_NOT = 7;
  protected static final int REPORT_ERROR = 8;
  protected static final int REPORT_WARNING = 9;
  protected static final int SEMPRED = 10;
  protected static final int SYNPRED_FAILED = 11;
  protected static final int SYNPRED_STARTED = 12;
  protected static final int SYNPRED_SUCCEEDED = 13;
  protected static final int NEW_LINE = 14;
  protected static final int DONE_PARSING = 15;
  private int ruleDepth = 0;

  public ParserEventSupport(Object paramObject)
  {
    this.matchEvent = new ParserMatchEvent(paramObject);
    this.messageEvent = new MessageEvent(paramObject);
    this.tokenEvent = new ParserTokenEvent(paramObject);
    this.traceEvent = new TraceEvent(paramObject);
    this.semPredEvent = new SemanticPredicateEvent(paramObject);
    this.synPredEvent = new SyntacticPredicateEvent(paramObject);
    this.newLineEvent = new NewLineEvent(paramObject);
    this.source = paramObject;
  }

  public void addDoneListener(ListenerBase paramListenerBase)
  {
    if (this.doneListeners == null)
      this.doneListeners = new Hashtable();
    Integer localInteger = (Integer)this.doneListeners.get(paramListenerBase);
    int i;
    if (localInteger != null)
      i = localInteger.intValue() + 1;
    else
      i = 1;
    this.doneListeners.put(paramListenerBase, new Integer(i));
  }

  public void addMessageListener(MessageListener paramMessageListener)
  {
    if (this.messageListeners == null)
      this.messageListeners = new Vector();
    this.messageListeners.addElement(paramMessageListener);
    addDoneListener(paramMessageListener);
  }

  public void addNewLineListener(NewLineListener paramNewLineListener)
  {
    if (this.newLineListeners == null)
      this.newLineListeners = new Vector();
    this.newLineListeners.addElement(paramNewLineListener);
    addDoneListener(paramNewLineListener);
  }

  public void addParserListener(ParserListener paramParserListener)
  {
    if ((paramParserListener instanceof ParserController))
    {
      ((ParserController)paramParserListener).setParserEventSupport(this);
      this.controller = ((ParserController)paramParserListener);
    }
    addParserMatchListener(paramParserListener);
    addParserTokenListener(paramParserListener);
    addMessageListener(paramParserListener);
    addTraceListener(paramParserListener);
    addSemanticPredicateListener(paramParserListener);
    addSyntacticPredicateListener(paramParserListener);
  }

  public void addParserMatchListener(ParserMatchListener paramParserMatchListener)
  {
    if (this.matchListeners == null)
      this.matchListeners = new Vector();
    this.matchListeners.addElement(paramParserMatchListener);
    addDoneListener(paramParserMatchListener);
  }

  public void addParserTokenListener(ParserTokenListener paramParserTokenListener)
  {
    if (this.tokenListeners == null)
      this.tokenListeners = new Vector();
    this.tokenListeners.addElement(paramParserTokenListener);
    addDoneListener(paramParserTokenListener);
  }

  public void addSemanticPredicateListener(SemanticPredicateListener paramSemanticPredicateListener)
  {
    if (this.semPredListeners == null)
      this.semPredListeners = new Vector();
    this.semPredListeners.addElement(paramSemanticPredicateListener);
    addDoneListener(paramSemanticPredicateListener);
  }

  public void addSyntacticPredicateListener(SyntacticPredicateListener paramSyntacticPredicateListener)
  {
    if (this.synPredListeners == null)
      this.synPredListeners = new Vector();
    this.synPredListeners.addElement(paramSyntacticPredicateListener);
    addDoneListener(paramSyntacticPredicateListener);
  }

  public void addTraceListener(TraceListener paramTraceListener)
  {
    if (this.traceListeners == null)
      this.traceListeners = new Vector();
    this.traceListeners.addElement(paramTraceListener);
    addDoneListener(paramTraceListener);
  }

  public void fireConsume(int paramInt)
  {
    this.tokenEvent.setValues(ParserTokenEvent.CONSUME, 1, paramInt);
    fireEvents(0, this.tokenListeners);
  }

  public void fireDoneParsing()
  {
    this.traceEvent.setValues(TraceEvent.DONE_PARSING, 0, 0, 0);
    Hashtable localHashtable = null;
    ListenerBase localListenerBase = null;
    synchronized (this)
    {
      if (this.doneListeners == null)
        return;
      localHashtable = (Hashtable)this.doneListeners.clone();
    }
    if (localHashtable != null)
    {
      ??? = localHashtable.keys();
      while (((Enumeration)???).hasMoreElements())
      {
        localListenerBase = (ListenerBase)((Enumeration)???).nextElement();
        fireEvent(15, localListenerBase);
      }
    }
    if (this.controller != null)
      this.controller.checkBreak();
  }

  public void fireEnterRule(int paramInt1, int paramInt2, int paramInt3)
  {
    this.ruleDepth += 1;
    this.traceEvent.setValues(TraceEvent.ENTER, paramInt1, paramInt2, paramInt3);
    fireEvents(1, this.traceListeners);
  }

  public void fireEvent(int paramInt, ListenerBase paramListenerBase)
  {
    switch (paramInt)
    {
    case 0:
      ((ParserTokenListener)paramListenerBase).parserConsume(this.tokenEvent);
      break;
    case 3:
      ((ParserTokenListener)paramListenerBase).parserLA(this.tokenEvent);
      break;
    case 1:
      ((TraceListener)paramListenerBase).enterRule(this.traceEvent);
      break;
    case 2:
      ((TraceListener)paramListenerBase).exitRule(this.traceEvent);
      break;
    case 4:
      ((ParserMatchListener)paramListenerBase).parserMatch(this.matchEvent);
      break;
    case 5:
      ((ParserMatchListener)paramListenerBase).parserMatchNot(this.matchEvent);
      break;
    case 6:
      ((ParserMatchListener)paramListenerBase).parserMismatch(this.matchEvent);
      break;
    case 7:
      ((ParserMatchListener)paramListenerBase).parserMismatchNot(this.matchEvent);
      break;
    case 10:
      ((SemanticPredicateListener)paramListenerBase).semanticPredicateEvaluated(this.semPredEvent);
      break;
    case 12:
      ((SyntacticPredicateListener)paramListenerBase).syntacticPredicateStarted(this.synPredEvent);
      break;
    case 11:
      ((SyntacticPredicateListener)paramListenerBase).syntacticPredicateFailed(this.synPredEvent);
      break;
    case 13:
      ((SyntacticPredicateListener)paramListenerBase).syntacticPredicateSucceeded(this.synPredEvent);
      break;
    case 8:
      ((MessageListener)paramListenerBase).reportError(this.messageEvent);
      break;
    case 9:
      ((MessageListener)paramListenerBase).reportWarning(this.messageEvent);
      break;
    case 15:
      paramListenerBase.doneParsing(this.traceEvent);
      break;
    case 14:
      ((NewLineListener)paramListenerBase).hitNewLine(this.newLineEvent);
      break;
    default:
      throw new IllegalArgumentException("bad type " + paramInt + " for fireEvent()");
    }
  }

  public void fireEvents(int paramInt, Vector paramVector)
  {
    ListenerBase localListenerBase = null;
    if (paramVector != null)
      for (int i = 0; i < paramVector.size(); i++)
      {
        localListenerBase = (ListenerBase)paramVector.elementAt(i);
        fireEvent(paramInt, localListenerBase);
      }
    if (this.controller != null)
      this.controller.checkBreak();
  }

  public void fireExitRule(int paramInt1, int paramInt2, int paramInt3)
  {
    this.traceEvent.setValues(TraceEvent.EXIT, paramInt1, paramInt2, paramInt3);
    fireEvents(2, this.traceListeners);
    this.ruleDepth -= 1;
    if (this.ruleDepth == 0)
      fireDoneParsing();
  }

  public void fireLA(int paramInt1, int paramInt2)
  {
    this.tokenEvent.setValues(ParserTokenEvent.LA, paramInt1, paramInt2);
    fireEvents(3, this.tokenListeners);
  }

  public void fireMatch(char paramChar, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.CHAR, paramChar, new Character(paramChar), null, paramInt, false, true);
    fireEvents(4, this.matchListeners);
  }

  public void fireMatch(char paramChar, BitSet paramBitSet, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.CHAR_BITSET, paramChar, paramBitSet, null, paramInt, false, true);
    fireEvents(4, this.matchListeners);
  }

  public void fireMatch(char paramChar, String paramString, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.CHAR_RANGE, paramChar, paramString, null, paramInt, false, true);
    fireEvents(4, this.matchListeners);
  }

  public void fireMatch(int paramInt1, BitSet paramBitSet, String paramString, int paramInt2)
  {
    this.matchEvent.setValues(ParserMatchEvent.BITSET, paramInt1, paramBitSet, paramString, paramInt2, false, true);
    fireEvents(4, this.matchListeners);
  }

  public void fireMatch(int paramInt1, String paramString, int paramInt2)
  {
    this.matchEvent.setValues(ParserMatchEvent.TOKEN, paramInt1, new Integer(paramInt1), paramString, paramInt2, false, true);
    fireEvents(4, this.matchListeners);
  }

  public void fireMatch(String paramString, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.STRING, 0, paramString, null, paramInt, false, true);
    fireEvents(4, this.matchListeners);
  }

  public void fireMatchNot(char paramChar1, char paramChar2, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.CHAR, paramChar1, new Character(paramChar2), null, paramInt, true, true);
    fireEvents(5, this.matchListeners);
  }

  public void fireMatchNot(int paramInt1, int paramInt2, String paramString, int paramInt3)
  {
    this.matchEvent.setValues(ParserMatchEvent.TOKEN, paramInt1, new Integer(paramInt2), paramString, paramInt3, true, true);
    fireEvents(5, this.matchListeners);
  }

  public void fireMismatch(char paramChar1, char paramChar2, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.CHAR, paramChar1, new Character(paramChar2), null, paramInt, false, false);
    fireEvents(6, this.matchListeners);
  }

  public void fireMismatch(char paramChar, BitSet paramBitSet, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.CHAR_BITSET, paramChar, paramBitSet, null, paramInt, false, true);
    fireEvents(6, this.matchListeners);
  }

  public void fireMismatch(char paramChar, String paramString, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.CHAR_RANGE, paramChar, paramString, null, paramInt, false, true);
    fireEvents(6, this.matchListeners);
  }

  public void fireMismatch(int paramInt1, int paramInt2, String paramString, int paramInt3)
  {
    this.matchEvent.setValues(ParserMatchEvent.TOKEN, paramInt1, new Integer(paramInt2), paramString, paramInt3, false, false);
    fireEvents(6, this.matchListeners);
  }

  public void fireMismatch(int paramInt1, BitSet paramBitSet, String paramString, int paramInt2)
  {
    this.matchEvent.setValues(ParserMatchEvent.BITSET, paramInt1, paramBitSet, paramString, paramInt2, false, true);
    fireEvents(6, this.matchListeners);
  }

  public void fireMismatch(String paramString1, String paramString2, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.STRING, 0, paramString2, paramString1, paramInt, false, true);
    fireEvents(6, this.matchListeners);
  }

  public void fireMismatchNot(char paramChar1, char paramChar2, int paramInt)
  {
    this.matchEvent.setValues(ParserMatchEvent.CHAR, paramChar1, new Character(paramChar2), null, paramInt, true, true);
    fireEvents(7, this.matchListeners);
  }

  public void fireMismatchNot(int paramInt1, int paramInt2, String paramString, int paramInt3)
  {
    this.matchEvent.setValues(ParserMatchEvent.TOKEN, paramInt1, new Integer(paramInt2), paramString, paramInt3, true, true);
    fireEvents(7, this.matchListeners);
  }

  public void fireNewLine(int paramInt)
  {
    this.newLineEvent.setValues(paramInt);
    fireEvents(14, this.newLineListeners);
  }

  public void fireReportError(Exception paramException)
  {
    this.messageEvent.setValues(MessageEvent.ERROR, paramException.toString());
    fireEvents(8, this.messageListeners);
  }

  public void fireReportError(String paramString)
  {
    this.messageEvent.setValues(MessageEvent.ERROR, paramString);
    fireEvents(8, this.messageListeners);
  }

  public void fireReportWarning(String paramString)
  {
    this.messageEvent.setValues(MessageEvent.WARNING, paramString);
    fireEvents(9, this.messageListeners);
  }

  public boolean fireSemanticPredicateEvaluated(int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3)
  {
    this.semPredEvent.setValues(paramInt1, paramInt2, paramBoolean, paramInt3);
    fireEvents(10, this.semPredListeners);
    return paramBoolean;
  }

  public void fireSyntacticPredicateFailed(int paramInt)
  {
    this.synPredEvent.setValues(0, paramInt);
    fireEvents(11, this.synPredListeners);
  }

  public void fireSyntacticPredicateStarted(int paramInt)
  {
    this.synPredEvent.setValues(0, paramInt);
    fireEvents(12, this.synPredListeners);
  }

  public void fireSyntacticPredicateSucceeded(int paramInt)
  {
    this.synPredEvent.setValues(0, paramInt);
    fireEvents(13, this.synPredListeners);
  }

  protected void refresh(Vector paramVector)
  {
    Vector localVector;
    synchronized (paramVector)
    {
      localVector = (Vector)paramVector.clone();
    }
    if (localVector != null)
      for (int i = 0; i < localVector.size(); i++)
        ((ListenerBase)localVector.elementAt(i)).refresh();
  }

  public void refreshListeners()
  {
    refresh(this.matchListeners);
    refresh(this.messageListeners);
    refresh(this.tokenListeners);
    refresh(this.traceListeners);
    refresh(this.semPredListeners);
    refresh(this.synPredListeners);
  }

  public void removeDoneListener(ListenerBase paramListenerBase)
  {
    if (this.doneListeners == null)
      return;
    Integer localInteger = (Integer)this.doneListeners.get(paramListenerBase);
    int i = 0;
    if (localInteger != null)
      i = localInteger.intValue() - 1;
    if (i == 0)
      this.doneListeners.remove(paramListenerBase);
    else
      this.doneListeners.put(paramListenerBase, new Integer(i));
  }

  public void removeMessageListener(MessageListener paramMessageListener)
  {
    if (this.messageListeners != null)
      this.messageListeners.removeElement(paramMessageListener);
    removeDoneListener(paramMessageListener);
  }

  public void removeNewLineListener(NewLineListener paramNewLineListener)
  {
    if (this.newLineListeners != null)
      this.newLineListeners.removeElement(paramNewLineListener);
    removeDoneListener(paramNewLineListener);
  }

  public void removeParserListener(ParserListener paramParserListener)
  {
    removeParserMatchListener(paramParserListener);
    removeMessageListener(paramParserListener);
    removeParserTokenListener(paramParserListener);
    removeTraceListener(paramParserListener);
    removeSemanticPredicateListener(paramParserListener);
    removeSyntacticPredicateListener(paramParserListener);
  }

  public void removeParserMatchListener(ParserMatchListener paramParserMatchListener)
  {
    if (this.matchListeners != null)
      this.matchListeners.removeElement(paramParserMatchListener);
    removeDoneListener(paramParserMatchListener);
  }

  public void removeParserTokenListener(ParserTokenListener paramParserTokenListener)
  {
    if (this.tokenListeners != null)
      this.tokenListeners.removeElement(paramParserTokenListener);
    removeDoneListener(paramParserTokenListener);
  }

  public void removeSemanticPredicateListener(SemanticPredicateListener paramSemanticPredicateListener)
  {
    if (this.semPredListeners != null)
      this.semPredListeners.removeElement(paramSemanticPredicateListener);
    removeDoneListener(paramSemanticPredicateListener);
  }

  public void removeSyntacticPredicateListener(SyntacticPredicateListener paramSyntacticPredicateListener)
  {
    if (this.synPredListeners != null)
      this.synPredListeners.removeElement(paramSyntacticPredicateListener);
    removeDoneListener(paramSyntacticPredicateListener);
  }

  public void removeTraceListener(TraceListener paramTraceListener)
  {
    if (this.traceListeners != null)
      this.traceListeners.removeElement(paramTraceListener);
    removeDoneListener(paramTraceListener);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.debug.ParserEventSupport
 * JD-Core Version:    0.6.0
 */